/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.RouterUtil;
import cerent.util.gui.AbstractPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PasswordPropertyEditor
extends AbstractPropertyEditor
implements DocumentListener {
    protected JPasswordField txtInput = new JPasswordField(10);
    protected JLabel prefixLabel;
    private boolean fromSetValue = false;
    private static final String DEFAULT_KEY = "dsafkhdaei.,43-l";
    private String key = "dsafkhdaei.,43-l";

    public PasswordPropertyEditor(String string) {
        this.init(string, "");
    }

    public PasswordPropertyEditor(String string, String string2) {
        this.init(string, string2);
    }

    public void setEncryptionKey(String string) {
        this.key = string == null || string.length() == 0 ? DEFAULT_KEY : string;
    }

    private void init(String string, String string2) {
        this.txtInput.getDocument().addDocumentListener(this);
        this.setLayout(new BorderLayout());
        if (string.length() > 0) {
            this.prefixLabel = new JLabel(string);
            this.add((Component)this.prefixLabel, "West");
        }
        this.add((Component)this.txtInput, "Center");
        if (string2.length() > 0) {
            JLabel jLabel = new JLabel(string2);
            this.add((Component)jLabel, "East");
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void requestEditorFocus() {
        this.txtInput.requestFocus();
    }

    private void setDirty() {
        if (!this.fromSetValue) {
            this.setDirty(true);
        }
        this.fromSetValue = false;
    }

    public void setEditorSize(int n) {
        if (n > 0) {
            this.txtInput.setColumns(n);
        }
    }

    public void setEditorPreferredSize(int n, int n2) {
        this.txtInput.setPreferredSize(new Dimension(n, n2));
    }

    public void setLabelPreferredSize(int n, int n2) {
        this.prefixLabel.setPreferredSize(new Dimension(n, n2));
    }

    public Object getValue() {
        String string = new String(this.txtInput.getPassword());
        if (string.length() > 0) {
            string = RouterUtil.encrypt(string, this.key);
        }
        return string;
    }

    public char[] getFieldText() {
        return this.txtInput.getPassword();
    }

    public void setValue(Object object) {
        if (object != null) {
            this.fromSetValue = true;
            String string = (String)object;
            if (string.length() > 0) {
                string = RouterUtil.decrypt(string, this.key);
            }
            this.txtInput.setText(string);
            this.fromSetValue = false;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.txtInput.setEnabled(bl);
    }
}

