/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.TransmitReceive;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

public class TransmitReceivePercentCellRenderer
extends JPanel
implements TableCellRenderer {
    private NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private JTextArea transmit;
    private JTextArea receive;
    Thread tablePainter;

    public TransmitReceivePercentCellRenderer(int n) {
        this.init(n);
    }

    public TransmitReceivePercentCellRenderer() {
        this.init(2);
    }

    private void init(int n) {
        this.percentFormat.setMinimumFractionDigits(n);
        this.setLayout(new BorderLayout());
        this.transmit = new LineTextArea().setLinePosition((short)1);
        this.receive = new LineTextArea().setLinePosition((short)0);
        this.transmit.setOpaque(true);
        this.transmit.setBackground(Color.white);
        this.receive.setOpaque(true);
        this.receive.setBackground(Color.white);
        this.add((Component)this.transmit, "North");
        this.add((Component)this.receive, "South");
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof TransmitReceive) {
            TransmitReceive transmitReceive = (TransmitReceive)object;
            double d = transmitReceive.getTransmit();
            double d2 = transmitReceive.getReceive();
            if (d < 0.0) {
                this.transmit.setText("Tx: N/A ");
            } else {
                this.transmit.setText("Tx: " + this.percentFormat.format(d / 100.0));
            }
            if (d2 < 0.0) {
                this.receive.setText("Rx: N/A");
            } else {
                this.receive.setText("Rx: " + this.percentFormat.format(d2 / 100.0));
            }
        } else if (object != null) {
            this.transmit.setText(object.toString());
            this.receive.setText("");
        } else {
            this.transmit.setText("");
            this.receive.setText("");
        }
        return this;
    }

    public String toString() {
        return this.transmit.getText() + "\n" + this.receive.getText();
    }

    private static class LineTextArea
    extends JTextArea {
        public static final short TOP = 0;
        public static final short BOTTOM = 1;
        private short linePosition = 1;
        Color lightGray = new Color(221, 221, 221);

        public LineTextArea() {
            super("");
        }

        LineTextArea setLinePosition(short s) {
            if (s == 0 || s == 1) {
                this.linePosition = s;
            }
            return this;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.drawLine(graphics, this.getSize());
        }

        private void drawLine(Graphics graphics, Dimension dimension) {
            Color color = graphics.getColor();
            graphics.setColor(this.lightGray);
            if (this.linePosition == 0) {
                graphics.drawLine(0, 0, dimension.width, 0);
            } else {
                graphics.drawLine(0, dimension.height, dimension.width, dimension.height);
            }
            graphics.setColor(color);
        }
    }
}

