/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.model.CmsObservable;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import cerent.util.tty.TTYSessionFactory;
import com.cisco.crs.model.CLICommandFailure;
import com.cisco.crs.model.PlatformNodeModel;
import java.io.IOException;

public class CLICommander
extends CmsObservable
implements IObserver {
    private static final String KEEP_ALIVE_CMD = "keep-alive";
    private static final int _HOST_UNREACHABLE = 2;
    public static final Integer HOST_UNREACHABLE = new Integer(2);
    private static final char ERROR_PROMPT = '^';
    private static final char NOT_AUTHORISED = '%';
    private static final String ERROR_STRING = "Error";
    private SDebug db;
    private PlatformNodeModel node;
    private CLICommandFailure lastException;

    public CLICommander(PlatformNodeModel platformNodeModel) {
        this.node = platformNodeModel;
        this.db = platformNodeModel.getChildDebug(CLICommander.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeepAlive() throws CLICommandFailure {
        ITTYSession iTTYSession = null;
        if (this.db.on()) {
            this.db.println("Sending keep-alive");
        }
        try {
            iTTYSession = TTYSessionFactory.instance().getSession((IObserver)this, this.node.getIpAddr(), TTYSessionFactory.SessionType.CLI);
            iTTYSession.sendKeepAlive();
            if (this.db.on()) {
                this.db.println("Node alive");
            }
        }
        catch (IOException iOException) {
            if (this.db.on()) {
                this.db.println("Node down");
            }
            String string = "IO error while executing \"keep-alive\": " + iOException.getMessage();
            this.sendErrorEvent(KEEP_ALIVE_CMD, string, iOException);
        }
        finally {
            if (iTTYSession != null) {
                iTTYSession.releaseMe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendCommand(String string) throws CLICommandFailure {
        if (this.db.on()) {
            this.db.println("Sending: \"" + string + "\"");
        }
        ITTYSession iTTYSession = null;
        boolean bl = string.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        try {
            iTTYSession = bl ? TTYSessionFactory.instance().getSession((IObserver)this, this.node.getIpAddr(), TTYSessionFactory.SessionType.XML) : TTYSessionFactory.instance().getSession((IObserver)this, this.node.getIpAddr(), TTYSessionFactory.SessionType.CLI);
            String string2 = iTTYSession.sendCommand(string);
            if (this.db.on()) {
                this.db.println("Received output: \"" + string2 + "\"");
            }
            String string3 = string2;
            return string3;
        }
        catch (TTYException tTYException) {
            String string4 = "CLI error while executing \"" + string + "\": " + tTYException.getMessage();
            String string5 = this.sendErrorEvent(string, string4, (Exception)((Object)tTYException));
            return string5;
        }
        catch (IOException iOException) {
            String string6 = "IO error while executing \"" + string + "\": " + iOException.getMessage();
            String string7 = this.sendErrorEvent(string, string6, iOException);
            return string7;
        }
        finally {
            if (iTTYSession != null) {
                iTTYSession.releaseMe();
            }
        }
    }

    public boolean isResponseErroneous(String string) {
        if (string == null) {
            return true;
        }
        return string.contains(ERROR_STRING) || string.indexOf(94) != -1 || string.indexOf(37) != -1;
    }

    private String sendErrorEvent(String string, String string2, Exception exception) throws CLICommandFailure {
        if (this.db.on()) {
            this.db.println(string2);
        }
        this.lastException = new CLICommandFailure(string, string2, exception);
        throw this.lastException;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void update(IObservable iObservable, Object object) {
        this.lastException = new CLICommandFailure("CreateTTYSession", "Remote Host Unreachable", new IOException("Remote Host Unreachable"));
        if (object instanceof String && object.equals("HOST_UNREACHABLE")) {
            this.setChanged();
            this.notifyObservers(HOST_UNREACHABLE);
        }
    }
}

