/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.cn;

import cerent.cms.model.IPoller;
import cerent.cms.model.IStateTransition;
import cerent.cms.model.NodePollerException;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.tty.TTYSessionsPool;
import com.cisco.crs.model.CLICommander;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.cn.FSM;

public class Poller
implements IPoller,
IObserver {
    private PlatformNodeModel node;
    private FSM fsm;
    private CLICommander commander;
    private SDebug db;
    private boolean lastsuccessfulka;

    public Poller(PlatformNodeModel platformNodeModel) {
        this.node = platformNodeModel;
        this.fsm = platformNodeModel.getFSM();
        this.commander = platformNodeModel.getCLICommander();
        this.commander.addObserver(this);
        this.db = platformNodeModel.getDebug();
    }

    public void dispose() {
        this.commander.deleteObserver(this);
        this.fsm.dispose();
    }

    public boolean poll() {
        Integer n = this.fsm.getCurrentState();
        final Thread thread = Thread.currentThread();
        Thread thread2 = new Thread(){

            public void run() {
                try {
                    Thread.sleep(TTYSessionsPool.KEEPALIVE_TIMEOUT);
                    thread.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread2.start();
        try {
            this.lastsuccessfulka = false;
            this.node.getCLICommander().sendKeepAlive();
            thread2.interrupt();
            this.lastsuccessfulka = true;
        }
        catch (Exception exception) {
            this.db.println("Keep alive failed: " + exception.getMessage());
        }
        if (this.lastsuccessfulka) {
            if (n != IStateTransition.INITED && !PlatformNodeModel.checkSwVersionCompatibility(this.node.getName(), this.node.getSwVersion())) {
                this.fsm.setState(IStateTransition.INCOMPATIBLE, IStateTransition.INCOMPATIBLE_SW_VERSION, new Exception("CTC software version " + this.node.getPeerNode().getSwVersion() + " is incompatible with IOS-XR " + " software version " + this.node.getSwVersion() + "."));
            } else {
                this.fsm.setState(IStateTransition.INITED, IStateTransition.SUCCESS, IStateTransition.NO_EXCEPTION);
            }
            return true;
        }
        this.db.println("Keep alive failed.");
        this.fsm.setState(IStateTransition.RETRY_INIT, IStateTransition.RUN_TIME_FAILURE, IStateTransition.NO_EXCEPTION);
        return false;
    }

    public void recover(int n) throws NodePollerException {
        int n2 = this.recoverWithStatus(n);
        this.db.fine("recover() called recoverWithStatus and it returned " + n2);
    }

    public int recoverWithStatus(int n) throws NodePollerException {
        return 0;
    }

    public void stoprecover() throws NodePollerException {
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof CLICommander && object == CLICommander.HOST_UNREACHABLE) {
            this.fsm.setState(IStateTransition.RETRY_INIT, IStateTransition.RUN_TIME_FAILURE, this.commander.getLastException());
        }
    }
}

