/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.model;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractSlotPolicy;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPluggableSlotModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SlotModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SlotPolicy
extends AbstractSlotPolicy {
    private NodeModelDelegate _node;

    public SlotPolicy(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
        this._node = nodeModelDelegate;
    }

    public Map getMapOfValidModules(SlotModel slotModel) {
        HashMap hashMap = new HashMap();
        switch (slotModel.getEqType()) {
            case 24: {
                this.addCardToMap(eEqType.AIC_CARD, hashMap);
                this.addCardToMap(eEqType.AICI_CARD, hashMap);
                break;
            }
            case 22: {
                this.addCardToMap(eEqType.TCC_CARD, hashMap);
                break;
            }
            case 21: {
                hashMap.putAll(this.getIoSlotEqMap(slotModel));
                break;
            }
            case 23: {
                if (this._node.isMultishelf()) {
                    this.addCardToMap(eEqType.OSCM_CARD, hashMap);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.XC_CARD)) {
                    this.addCardToMap(eEqType.XC_CARD, hashMap);
                    this.addCardToMap(eEqType.OSCM_CARD, hashMap);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.XCVT_CARD)) {
                    this.addCardToMap(eEqType.XCVT_CARD, hashMap);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.XC192_CARD)) {
                    this.addCardToMap(eEqType.XC192_CARD, hashMap);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.XCVXC_CARD)) {
                    this.addCardToMap(eEqType.XCVXC_CARD, hashMap);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.OC3_8_LINE_CARD) || this.hasEqType(slotModel, eEqType.STM1E_12_LINE_CARD) || this.hasEqType(slotModel, eEqType.L2SC_100_LINE_CARD) || this.hasEqType(slotModel, eEqType.L2SC_GIG_LINE_CARD) || this.hasEqType(slotModel, eEqType.ML_FX_100_LINE_CARD) || this.hasOc48As(slotModel)) {
                    this.addCardToMap(eEqType.XC192_CARD, hashMap);
                    this.addCardToMap(eEqType.XCVXC_CARD, hashMap);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.OC12_LINE_CARD) || this.hasEqType(slotModel, eEqType.OC48_LINE_CARD) || this.hasEqType(slotModel, eEqType.EPOS_100_LINE_CARD) || this.hasEqType(slotModel, eEqType.EPOS_1000_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS1_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS1_E1_56_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS1N_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3E_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3_EC1_48_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3I_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3IN_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3N_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3NE_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3XM_LINE_CARD) || this.hasEqType(slotModel, eEqType.EC1_LINE_CARD) || this.hasEqType(slotModel, eEqType.EC1N_LINE_CARD) || this.hasEqType(slotModel, eEqType.RAN_SVC_LINE_CARD) || this.hasEqType(slotModel, eEqType.L2SC_100_LINE_CARD) || this.hasEqType(slotModel, eEqType.ML_FX_100_LINE_CARD)) {
                    this.addCardToMap(eEqType.XC_CARD, hashMap);
                    this.addCardToMap(eEqType.XCVT_CARD, hashMap);
                    this.addCardToMap(eEqType.XC192_CARD, hashMap);
                    this.addCardToMap(eEqType.XCVXC_CARD, hashMap);
                    break;
                }
                this.addCardToMap(eEqType.XC_CARD, hashMap);
                this.addCardToMap(eEqType.XCVT_CARD, hashMap);
                this.addCardToMap(eEqType.XC192_CARD, hashMap);
                this.addCardToMap(eEqType.XCVXC_CARD, hashMap);
                this.addCardToMap(eEqType.OSCM_CARD, hashMap);
                break;
            }
            default: {
                this.addCardToMap(eEqType.INVALID, hashMap);
            }
        }
        if (db.on()) {
            this.showMap(hashMap);
        }
        return hashMap;
    }

    private Map getIoSlotEqMap(SlotModel slotModel) {
        int n = slotModel.getSlot();
        if (this.isLowSpeedSlot(n)) {
            return this.getLowSpeedSlotModuleMap(slotModel);
        }
        if (this.isLowSpeedProtectSlot(n)) {
            return this.getLowSpeedProtectSlotModuleMap(slotModel);
        }
        if (this.isHighSpeedSlot(n)) {
            return this.getHighSpeedSlotModuleMap(slotModel);
        }
        HashMap hashMap = new HashMap();
        this.addCardToMap(eEqType.INVALID, hashMap);
        return hashMap;
    }

    private Map getLowSpeedSlotModuleMap(SlotModel slotModel) {
        int n;
        Map map = this.deepCopyMap(this.slotMap);
        List list = this.checkHighDensityDSN(slotModel);
        if (list != null) {
            n = 0;
            int n2 = slotModel.getSlot();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                switch (n3) {
                    case 1: {
                        if (n2 != 5 && n2 != 6) break;
                        n = 1;
                        break;
                    }
                    case 2: {
                        if (n2 != 4 && n2 != 6) break;
                        n = 1;
                        break;
                    }
                    case 16: {
                        if (n2 != 14) break;
                        n = 1;
                        break;
                    }
                    case 17: {
                        if (n2 != 12 && n2 != 13) break;
                        n = 1;
                    }
                }
            }
            if (n != 0) {
                this.remFamilyFromMap(this.DSN_GROUP, map);
            }
        }
        if (this._node.isMultishelf()) {
            this.remCardFromMap(this.ETH_GROUP, eEqType.G1000_LINE_CARD, map);
            if (slotModel.getShelfId() != 1) {
                this.remCardFromMap(this.ETH_GROUP, eEqType.MS_ISC_100T_CARD, map);
            }
        } else {
            this.remCardFromMap(this.ETH_GROUP, eEqType.MS_ISC_100T_CARD, map);
        }
        if (this.IsXCProvisioned(slotModel.getChassis())) {
            n = slotModel.getSlot();
            if (this.isXc10gCapable(slotModel) || this.hasEqType(slotModel, eEqType.XCVT_CARD)) {
                String string = this.getFamilyMenu(this.OCN_GROUP, map);
                this.addCardToMap(string, this.OCN_GROUP, eEqType.MRC_12_LINE_CARD, map);
                this.addCardToMap(string, this.OCN_GROUP, eEqType.MRC25G_4_LINE_CARD, map);
            }
            if (this.isXc10gCapable(slotModel)) {
                if (n == 1 || n == 2 || n == 16 || n == 17) {
                    String string = this.getFamilyMenu(this.DSN_GROUP, map);
                    if (this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                        this.addCardToMap(string, this.DSN_GROUP, eEqType.DS1_E1_56_LINE_CARD, map);
                        this.addCardToMap(string, this.DSN_GROUP, eEqType.DS3_EC1_48_LINE_CARD, map);
                    }
                }
                String string = this.getFamilyMenu(this.OCN_GROUP, map);
                this.addCardToMap(string, this.OCN_GROUP, eEqType.OC3_8_LINE_CARD, map);
                this.addCardToMap(string, this.OCN_GROUP, eEqType.OC12_4_LINE_CARD, map);
                this.addCardToMap(string, this.OCN_GROUP, eEqType.OC48_LINE_CARD, map);
                string = this.getFamilyMenu(this.ETH_GROUP, map);
                this.addCardToMap(string, this.ETH_GROUP, eEqType.L2SC_100_LINE_CARD, map);
                this.addCardToMap(string, this.ETH_GROUP, eEqType.L2SC_GIG_LINE_CARD, map);
                this.addCardToMap(string, this.ETH_GROUP, eEqType.ML_FX_100_LINE_CARD, map);
                this.addCardToMap(string, this.ETH_GROUP, eEqType.CEMR_454_CARD, map);
                this.addCardToMap(string, this.ETH_GROUP, eEqType.MLMR_454_CARD, map);
                this.addCardToMap(eEqType.RAN_SVC_LINE_CARD, map);
                this.addCardToMap(eEqType.FCMR_LINE_CARD, map);
            } else if (this.hasEqType(slotModel, eEqType.XCVT_CARD)) {
                if (n == 1 || n == 2 || n == 16 || n == 17) {
                    String string = this.getFamilyMenu(this.DSN_GROUP, map);
                    this.addCardToMap(string, this.DSN_GROUP, eEqType.DS1_E1_56_LINE_CARD, map);
                }
                this.remCardFromMap(this.ETH_GROUP, eEqType.CE1000_4_CARD, map);
            }
        } else {
            this.remCardFromMap(TOP_LEVEL, eEqType.EC1_LINE_CARD, map);
            this.remFamilyFromMap(this.DSN_GROUP, map);
            this.remCardFromMap(this.ETH_GROUP, eEqType.EPOS_100_LINE_CARD, map);
            this.remCardFromMap(this.ETH_GROUP, eEqType.EPOS_1000_LINE_CARD, map);
            this.remCardFromMap(this.ETH_GROUP, eEqType.ML2_EXIGE_MAPPER_CARD, map);
            this.remCardFromMap(this.ETH_GROUP, eEqType.CE1000_4_CARD, map);
            this.remCardFromMap(this.ETH_GROUP, eEqType.CEMR_454_CARD, map);
            this.remCardFromMap(this.ETH_GROUP, eEqType.MLMR_454_CARD, map);
            this.remCardFromMap(TOP_LEVEL, eEqType.FCMR_LINE_CARD, map);
            this.remFamilyFromMap(this.OCN_GROUP, map);
        }
        if (this.hasEqType(slotModel, eEqType.XCVT_CARD) || this.hasEqType(slotModel, eEqType.XC_CARD)) {
            this.remCardFromMap(this.ETH_GROUP, eEqType.CEMR_454_CARD, map);
            this.remCardFromMap(this.ETH_GROUP, eEqType.MLMR_454_CARD, map);
        }
        if (!this.testEmptySlot(slotModel)) {
            this.remDoubleSlotCards(map);
        }
        if (!this.testThreeEmptySlot(slotModel)) {
            this.remThreeSlotCards(map);
        }
        this.remEmptyFamiliesFromMap(map);
        return map;
    }

    private Map getLowSpeedProtectSlotModuleMap(SlotModel slotModel) {
        Map map = this.getLowSpeedSlotModuleMap(slotModel);
        if (this.IsXCProvisioned(slotModel.getChassis())) {
            this.remCardFromMap(this.DSN_GROUP, eEqType.DS1_LINE_CARD, map);
            this.remCardFromMap(this.DSN_GROUP, eEqType.DS3_LINE_CARD, map);
            this.remCardFromMap(this.DSN_GROUP, eEqType.DS3E_LINE_CARD, map);
            this.remCardFromMap(this.DSN_GROUP, eEqType.DS3I_LINE_CARD, map);
            this.remCardFromMap(this.DSN_GROUP, eEqType.DS3XM_LINE_CARD, map);
            this.remCardFromMap(this.DSN_GROUP, eEqType.DS3XM12_LINE_CARD, map);
            String string = this.getFamilyMenu(this.DSN_GROUP, map);
            this.addCardToMap(string, this.DSN_GROUP, eEqType.DS1N_LINE_CARD, map);
            this.addCardToMap(string, this.DSN_GROUP, eEqType.DS3N_LINE_CARD, map);
            this.addCardToMap(string, this.DSN_GROUP, eEqType.DS3IN_LINE_CARD, map);
            this.addCardToMap(string, this.DSN_GROUP, eEqType.DS3NE_LINE_CARD, map);
            this.addCardToMap(string, this.DSN_GROUP, eEqType.DS1_LINE_CARD, map);
            this.addCardToMap(string, this.DSN_GROUP, eEqType.DS3_LINE_CARD, map);
            this.addCardToMap(string, this.DSN_GROUP, eEqType.DS3E_LINE_CARD, map);
            this.addCardToMap(string, this.DSN_GROUP, eEqType.DS3XM_LINE_CARD, map);
            this.addCardToMap(string, this.DSN_GROUP, eEqType.DS3XM12_LINE_CARD, map);
            if (this.isXc10gCapable(slotModel) && this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                this.addCardToMap(string, this.DSN_GROUP, eEqType.DS3_EC1_48_LINE_CARD, map);
            }
            if ((this.isXc10gCapable(slotModel) || this.hasEqType(slotModel, eEqType.XCVT_CARD)) && this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                this.addCardToMap(string, this.DSN_GROUP, eEqType.DS1_E1_56_LINE_CARD, map);
            }
        }
        return map;
    }

    private Map getHighSpeedSlotModuleMap(SlotModel slotModel) {
        Map map = this.getLowSpeedSlotModuleMap(slotModel);
        if (this.IsXCProvisioned(slotModel.getChassis())) {
            String string = this.getFamilyMenu(this.OCN_GROUP, map);
            this.remCardFromMap(this.OCN_GROUP, eEqType.OC12_4_LINE_CARD, map);
            this.remCardFromMap(this.OCN_GROUP, eEqType.OC3_8_LINE_CARD, map);
            if (this.isXc10gCapable(slotModel) || this.hasEqType(slotModel, eEqType.XCVT_CARD)) {
                this.addCardToMap(string, this.OCN_GROUP, eEqType.MRC_12_LINE_CARD, map);
                this.addCardToMap(string, this.OCN_GROUP, eEqType.MRC25G_4_LINE_CARD, map);
                this.addCardToMap(eEqType.FCMR_LINE_CARD, map);
                this.addCardToMap(string, this.ETH_GROUP, eEqType.L2SC_100_LINE_CARD, map);
                this.addCardToMap(string, this.ETH_GROUP, eEqType.L2SC_GIG_LINE_CARD, map);
                this.addCardToMap(string, this.ETH_GROUP, eEqType.ML_FX_100_LINE_CARD, map);
                this.addCardToMap(string, this.ETH_GROUP, eEqType.CE1000_4_CARD, map);
                if (this.isXc10gCapable(slotModel)) {
                    this.addCardToMap(string, this.OCN_GROUP, eEqType.OC192_LINE_CARD, map);
                    this.addCardToMap(string, this.OCN_GROUP, eEqType.OC192_XFP_LINE_CARD, map);
                }
            }
            this.addCardToMap(string, this.OCN_GROUP, eEqType.OC48_LINE_CARD, map);
        }
        return map;
    }

    private boolean isOkToCheckOC192(SlotModel slotModel) {
        EntityModel entityModel = (EntityModel)((Object)slotModel.getChassis());
        if (entityModel == null) {
            return false;
        }
        return entityModel.getDescendantsOfType(eEqType.XCVXL25G_CARD).size() <= 0;
    }

    public List getListOfValidUpgradeType(SlotModel slotModel, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Map map = this.getMapOfValidModules(slotModel);
        if (n == 10) {
            if (this.eqTypeInMap(map, eEqType.OC12_4_LINE_CARD)) {
                arrayList.add(new Integer(85));
            }
            if (this.eqTypeInMap(map, eEqType.OC48_LINE_CARD)) {
                arrayList.add(new Integer(11));
            }
            if (this.isOkToCheckOC192(slotModel)) {
                if (this.eqTypeInMap(map, eEqType.OC192_LINE_CARD)) {
                    arrayList.add(new Integer(60));
                }
                if (this.eqTypeInMap(map, eEqType.OC192_XFP_LINE_CARD)) {
                    arrayList.add(new Integer(220));
                }
            }
            if (this.eqTypeInMap(map, eEqType.MRC_12_LINE_CARD)) {
                arrayList.add(new Integer(219));
            }
            if (this.eqTypeInMap(map, eEqType.MRC25G_4_LINE_CARD)) {
                arrayList.add(new Integer(254));
            }
        } else if (n == 11) {
            if (this.isOkToCheckOC192(slotModel)) {
                if (this.eqTypeInMap(map, eEqType.OC192_LINE_CARD)) {
                    arrayList.add(new Integer(60));
                }
                if (this.eqTypeInMap(map, eEqType.OC192_XFP_LINE_CARD)) {
                    arrayList.add(new Integer(220));
                }
            }
            if (this.eqTypeInMap(map, eEqType.MRC_12_LINE_CARD)) {
                arrayList.add(new Integer(219));
            }
            if (this.eqTypeInMap(map, eEqType.MRC25G_4_LINE_CARD)) {
                arrayList.add(new Integer(254));
            }
        } else if (n == 60) {
            if (this.eqTypeInMap(map, eEqType.OC192_XFP_LINE_CARD)) {
                arrayList.add(new Integer(220));
            }
        } else if ((n == 253 || n == 254 || n == 219) && this.isOnlyFirstPortProvisioned(slotModel)) {
            if (this.eqTypeInMap(map, eEqType.OC12_LINE_CARD)) {
                arrayList.add(new Integer(10));
            }
            if (this.eqTypeInMap(map, eEqType.OC48_LINE_CARD)) {
                arrayList.add(new Integer(11));
            }
            if (this.isHighSpeedSlot(slotModel.getSlot()) && this.isOkToCheckOC192(slotModel)) {
                if (this.eqTypeInMap(map, eEqType.OC192_XFP_LINE_CARD)) {
                    arrayList.add(new Integer(220));
                }
                if (this.eqTypeInMap(map, eEqType.OC192_LINE_CARD)) {
                    arrayList.add(new Integer(60));
                }
            }
        }
        return arrayList;
    }

    private boolean isOnlyFirstPortProvisioned(SlotModel slotModel) {
        List list = new ArrayList();
        list = slotModel.getModuleModel() != null ? slotModel.getModuleModel().getChildren() : ((IModuleModel)slotModel.getChildren().get(0)).getChildren();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            IEntityModel iEntityModel = (IEntityModel)list.get(i);
            if (!(iEntityModel instanceof IPluggableSlotModel)) continue;
            if (((IPluggableSlotModel)iEntityModel).getHierarchyNums()[0] == 1 && iEntityModel.getChildren().size() > 0) {
                bl = true;
                continue;
            }
            if (iEntityModel.getChildren().size() <= 0) continue;
            bl = false;
        }
        return bl;
    }

    public List getListOfValidChangeType(SlotModel slotModel, eEqType eEqType2) {
        ArrayList arrayList = new ArrayList();
        if (eEqType2 == eEqType.OC12_LINE_CARD || eEqType2 == eEqType.OC12_4_LINE_CARD || eEqType2 == eEqType.OC3_8_LINE_CARD || eEqType2 == eEqType.OC3_LINE_CARD || eEqType2 == eEqType.OC48_LINE_CARD || eEqType2 == eEqType.OC192_LINE_CARD || eEqType2 == eEqType.OC192_XFP_LINE_CARD || eEqType2 == eEqType.MRC_12_LINE_CARD || eEqType2 == eEqType.MRC25G_4_LINE_CARD || eEqType2 == eEqType.DS3NE_LINE_CARD || eEqType2 == eEqType.DS3E_LINE_CARD || eEqType2 == eEqType.DS3N_LINE_CARD || eEqType2 == eEqType.DS3_LINE_CARD || eEqType2 == eEqType.DS3_EC1_48_LINE_CARD || eEqType2 == eEqType.EC1_LINE_CARD || eEqType2 == eEqType.DS3XM_LINE_CARD || eEqType2 == eEqType.DS3XM12_LINE_CARD || eEqType2 == eEqType.DS1_LINE_CARD || eEqType2 == eEqType.DS1N_LINE_CARD || eEqType2 == eEqType.DS1_E1_56_LINE_CARD) {
            Map map = this.getMapOfValidModules(slotModel);
            if (eEqType2 == eEqType.OC3_8_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC3_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC25G_12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC_12_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC3_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC3_8_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC25G_12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC25G_4_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC_12_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC12_4_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC25G_12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC25G_4_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC_12_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC12_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC12_4_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.OC48_LINE_CARD, eEqType2, arrayList);
                if (this.isOkToCheckOC192(slotModel)) {
                    this.addToChangeTypeList(map, eEqType.OC192_LINE_CARD, eEqType2, arrayList);
                    this.addToChangeTypeList(map, eEqType.OC192_XFP_LINE_CARD, eEqType2, arrayList);
                }
                this.addToChangeTypeList(map, eEqType.MRC_12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC25G_4_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC48_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC12_LINE_CARD, eEqType2, arrayList);
                if (this.isOkToCheckOC192(slotModel)) {
                    this.addToChangeTypeList(map, eEqType.OC192_LINE_CARD, eEqType2, arrayList);
                    this.addToChangeTypeList(map, eEqType.OC192_XFP_LINE_CARD, eEqType2, arrayList);
                }
                this.addToChangeTypeList(map, eEqType.MRC_12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC25G_4_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.DS3_LINE_CARD || eEqType2 == eEqType.DS3E_LINE_CARD || eEqType2 == eEqType.DS3N_LINE_CARD || eEqType2 == eEqType.DS3NE_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.DS3_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3E_LINE_CARD, eEqType2, arrayList);
                if (this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                    this.addToChangeTypeList(map, eEqType.DS3_EC1_48_LINE_CARD, eEqType2, arrayList);
                }
                this.addToChangeTypeList(map, eEqType.DS3N_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3NE_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.DS3_EC1_48_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.DS3_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3E_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3N_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3NE_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.EC1_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3_EC1_48_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.EC1_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.EC1_LINE_CARD, eEqType2, arrayList);
                if (this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                    this.addToChangeTypeList(map, eEqType.DS3_EC1_48_LINE_CARD, eEqType2, arrayList);
                }
            } else if (eEqType2 == eEqType.DS3XM_LINE_CARD || eEqType2 == eEqType.DS3XM12_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.DS3XM_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3XM12_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.DS1_LINE_CARD || eEqType2 == eEqType.DS1N_LINE_CARD || eEqType2 == eEqType.DS1_E1_56_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.DS1_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS1N_LINE_CARD, eEqType2, arrayList);
                if (this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                    this.addToChangeTypeList(map, eEqType.DS1_E1_56_LINE_CARD, eEqType2, arrayList);
                }
            } else if (eEqType2 == eEqType.MRC_12_LINE_CARD || eEqType2 == eEqType.MRC25G_4_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.OC48_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.OC192_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.OC192_XFP_LINE_CARD, eEqType2, arrayList);
            } else {
                this.addToChangeTypeList(map, eEqType.OC12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.OC48_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC_12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.MRC25G_4_LINE_CARD, eEqType2, arrayList);
                if (this.isOkToCheckOC192(slotModel)) {
                    this.addToChangeTypeList(map, eEqType.OC192_LINE_CARD, eEqType2, arrayList);
                    this.addToChangeTypeList(map, eEqType.OC192_XFP_LINE_CARD, eEqType2, arrayList);
                }
            }
        }
        return arrayList;
    }

    public List getListOfValidPortTypes(SlotModel slotModel, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n == 219 || n == 254) {
            if (!this.isHighSpeedSlot(slotModel.getSlot()) && this.hasEqType(slotModel, eEqType.XCVT_CARD)) {
                arrayList.add(new Integer(28));
                arrayList.add(new Integer(29));
            } else {
                arrayList.add(new Integer(28));
                arrayList.add(new Integer(29));
                arrayList.add(new Integer(30));
                arrayList.add(new Integer(61));
            }
        } else if (n == 220) {
            arrayList.add(new Integer(61));
        }
        return arrayList;
    }

    public boolean needDs1Ifs(int n) {
        return n == 4 || n == 5 || n == 218;
    }

    private boolean isXc10gCapable(SlotModel slotModel) {
        return this.hasEqType(slotModel, eEqType.XC192_CARD) || this.hasEqType(slotModel, eEqType.XCVXC_CARD) || !this.hasEqType(slotModel, eEqType.XCVT_CARD) && !this.hasEqType(slotModel, eEqType.XC_CARD);
    }

    public static boolean isComboPort(int n) {
        return false;
    }

    public boolean slotHasCardView(SlotModel slotModel) {
        int n = slotModel.getSlot();
        if (n >= 7 && n <= 11 && n != 9) {
            int n2 = slotModel.getEqType();
            if (!(this.hasEqType(slotModel, eEqType.OSCM_CARD) || n != 8 && n != 10)) {
                return false;
            }
        }
        return true;
    }

    protected void initSlotMap() {
        this.addCardToMap(TOP_LEVEL, eEqType.EC1_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS1_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3E_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3I_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3XM_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3XM12_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.EPOS_100_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.EPOS_1000_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.G1000_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.ML2_EXIGE_MAPPER_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.CEMR_454_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.MLMR_454_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.CE1000_4_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.MS_ISC_100T_CARD);
        this.addCardToMap(this.OCN_GROUP, eEqType.OC3_LINE_CARD);
        this.addCardToMap(this.OCN_GROUP, eEqType.OC12_LINE_CARD);
        super.initSlotMap();
    }
}

