/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.model;

import cerent.cms.model.IDatabaseManagementModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.util.ArrayList;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DatabaseManagementModel
extends Model
implements IDatabaseManagementModel {
    private NodeModelDelegate nodeModel = null;
    private static NodeSingletonFactory<DatabaseManagementModel> sfactory = new NodeSingletonFactory<DatabaseManagementModel>(DatabaseManagementModel.class);
    private ArrayList userChoice;
    private final int HEADER_SIZE = 128;
    public static final int BUF_SIZE = 1024;
    private final String DB_SIZE = "DB_SIZE";
    private boolean isOlderDb = false;
    private int firstDbStarts = 0;
    private String dbSwVersion;
    private String dbNodeName;
    private String dbDbVersion = "1";
    private int[] restoreInfoType = null;
    private int[] restoreInfoSize = null;
    private String dbNeType = null;

    private DatabaseManagementModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(DatabaseManagementModel.class));
        this.nodeModel = nodeModelDelegate;
        this.index = 0;
    }

    public static DatabaseManagementModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("Enter DatabaseManagementModel init()");
        }
        if (this.db.on()) {
            this.db.println("Leaving DatabaseManagementModel init()");
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("Enter DatabaseManagementModel dispose()");
        }
        if (this.db.on()) {
            this.db.println("Leaving DatabaseManagementModel dispose()");
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        if (this.userChoice != null) {
            this.userChoice.clear();
        }
        this.userChoice = null;
        this.dbDbVersion = null;
        this.dbNodeName = null;
        this.dbSwVersion = null;
        this.restoreInfoSize = null;
        this.restoreInfoType = null;
    }

    public void update(Observable observable, Object object) {
    }

    public void setUserSelection(int[] nArray) {
        if (this.userChoice == null) {
            this.userChoice = new ArrayList();
        } else {
            this.userChoice.clear();
        }
        if (this.db.on()) {
            this.db.finest("Adding " + nArray.length + " items as user selected.These are");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(String.valueOf(nArray[i]) + " ");
            }
            this.db.println(stringBuffer.toString());
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.userChoice.add(new Integer(nArray[i]));
        }
        this.prettyDebugPrint();
    }

    public int[] getUserSelection() {
        int[] nArray = new int[this.userChoice.size()];
        for (int i = 0; i < this.userChoice.size(); ++i) {
            nArray[i] = (Integer)this.userChoice.get(i);
        }
        this.prettyDebugPrint();
        return nArray;
    }

    private void prettyDebugPrint() {
        if (this.db.on()) {
            StringBuffer stringBuffer = new StringBuffer("DatabaseManagementModel info: ");
            for (int i = 0; i < this.userChoice.size(); ++i) {
                stringBuffer.append(String.valueOf((Integer)this.userChoice.get(i)) + " ");
            }
            this.db.println(stringBuffer.toString());
        }
    }

    public String getDbNeType() {
        return this.dbNeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] validateDbBackupFile(String string) throws Exception {
        FilterInputStream filterInputStream = null;
        byte[] byArray = new byte[128];
        this.dbNeType = "";
        try {
            filterInputStream = new DataInputStream(new FileInputStream(string));
            ((DataInputStream)filterInputStream).read(byArray);
            String string2 = new String(byArray);
            this.db.fine("DB Header = " + string2);
            int n = string2.indexOf(59);
            if (n == -1) {
                this.isOlderDb = true;
                filterInputStream.close();
                int[] nArray = this.processOldDb(string);
                return nArray;
            }
            string2 = string2.substring(0, n);
            this.firstDbStarts = n + 1;
            this.db.fine("DB Header after stripping of ==" + string2 + "$$");
            String string3 = "|";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            this.dbNodeName = stringTokenizer.nextToken();
            this.dbSwVersion = stringTokenizer.nextToken();
            this.dbDbVersion = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(this.dbDbVersion);
            String string4 = "";
            if (n2 >= 3 && !(string4 = stringTokenizer.nextToken()).equals(this.nodeModel.getNeType())) {
                this.dbNeType = string4;
                int[] nArray = null;
                return nArray;
            }
            String string5 = stringTokenizer.nextToken();
            this.dbNeType = string4;
            String string6 = ":,";
            stringTokenizer = new StringTokenizer(string5, string6);
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            this.restoreInfoType = new int[n3];
            this.restoreInfoSize = new int[n3];
            for (int i = 0; i < n3; ++i) {
                this.restoreInfoType[i] = Integer.parseInt(stringTokenizer.nextToken());
                this.restoreInfoSize[i] = Integer.parseInt(stringTokenizer.nextToken());
                this.db.fine("i = " + i + ", dbtype = " + this.restoreInfoType[i] + ", fileSize = " + this.restoreInfoSize[i]);
            }
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        return this.restoreInfoType;
    }

    public int getFirstDbStarts() {
        return this.firstDbStarts;
    }

    public boolean isFileFromOlderDB() {
        return this.isOlderDb;
    }

    public int[] getDbTypesFromFile() {
        return this.restoreInfoType;
    }

    public int[] getDbSizesFromFile() {
        return this.restoreInfoSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] processOldDb(String string) throws Exception {
        ZipEntry zipEntry = null;
        ZipInputStream zipInputStream = null;
        ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>();
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(string));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                arrayList.add(zipEntry);
                zipInputStream.closeEntry();
            }
            if (!arrayList.isEmpty()) {
                int n = arrayList.size();
                this.restoreInfoType = new int[n];
                this.restoreInfoSize = new int[n];
                zipEntry = (ZipEntry)arrayList.get(0);
                String string2 = this.getOldExtraInfo("NODE_ADDR", new String(zipEntry.getExtra()));
                this.dbNodeName = InetUtil.makeDottedString(Integer.parseInt(string2));
                this.dbSwVersion = this.getOldExtraInfo("SW_VERSION", new String(zipEntry.getExtra()));
                for (int i = 0; i < n; ++i) {
                    zipEntry = (ZipEntry)arrayList.get(i);
                    this.restoreInfoType[i] = Integer.parseInt(zipEntry.getName());
                    this.restoreInfoSize[i] = Integer.parseInt(this.getOldExtraInfo("DB_SIZE", new String(zipEntry.getExtra())));
                    this.db.fine("i = " + i + ", dbtype = " + this.restoreInfoType[i] + ", fileSize = " + this.restoreInfoSize[i]);
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
        return this.restoreInfoType;
    }

    public String getDbSwVersion() {
        return this.dbSwVersion;
    }

    public String getDbNodeName() {
        return this.dbNodeName;
    }

    public String getDbVersion() {
        return this.dbDbVersion;
    }

    String getOldExtraInfo(String string, String string2) {
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "=");
            if (!stringTokenizer2.nextToken().equals(string)) continue;
            string3 = stringTokenizer2.nextToken();
        }
        return string3;
    }
}

