/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.sAsapEtherLineAdminInfo;
import cerent.cms.idl.EtherMedia.sAsapEtherLineInfo;
import cerent.cms.model.AdminState;
import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.SoakTimePropertyEditor;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;

public class AsapEtherPortTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    private AsapModuleModel asapModuleModel = null;
    private AsapEtherLineModel[] etherLineModels = null;
    private boolean[][] rowDirty = null;
    private int numLines = 0;
    private sAsapEtherLineInfo[] asapEtherLineInfo = null;
    private sAsapEtherLineAdminInfo[] asapEtherLineAdminInfo = null;
    private String[] portName = null;
    private IServiceState[] serviceState = null;
    private AdminState[] adminState = null;
    private Attribute[] reach = null;
    private Attribute[] wavelength = null;
    private int[] soakTime = null;
    private IOpticsProvExtModel[] opticModels;
    protected static final int MAX_HI_WATER_MARK = 75;
    protected static final int MAX_LO_WATER_MARK = 74;
    protected static final int MIN_HI_WATER_MARK = 11;
    protected static final int MIN_LO_WATER_MARK = 10;
    protected String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "Link State", "Enable Flow Control", "Flow Control", "Enable Auto Negotiation", "Max. Size", "Flow Control Lo (Kbyte)", "Flow Control Hi (Kbyte)", "Reach", "Wavelength", "AINS Soak"};
    protected static final int PORT_NUMBER_INDEX = 0;
    protected static final int PORT_NAME_INDEX = 1;
    protected static final int ADMIN_STATE_INDEX = 2;
    protected static final int SERVICE_STATE_INDEX = 3;
    protected static final int LINK_STATE_INDEX = 4;
    protected static final int ENABLE_FLOW_CTRL_INDEX = 5;
    protected static final int FLOW_CTRL_INDEX = 6;
    protected static final int ENABLE_AUTO_NEGOTIATION_INDEX = 7;
    protected static final int FRAME_SIZE_INDEX = 8;
    protected static final int LOW_WATER_MARK_INDEX = 9;
    protected static final int HIGH_WATER_MARK_INDEX = 10;
    protected static final int REACH_INDEX = 11;
    protected static final int WAVELENGTH_INDEX = 12;
    protected static final int SOAK_TIME_INDEX = 13;
    private String[] maxFrameSizeStr = new String[]{"1548", "9600"};
    private LinkedList frameSizeList = null;
    private static final SDebug db = new SDebug("AsapEtherPortTableModel");

    public AsapEtherPortTableModel(AsapModuleModel asapModuleModel, AsapEtherLineModel[] asapEtherLineModelArray) {
        this.asapModuleModel = asapModuleModel;
        this.frameSizeList = new LinkedList();
        for (int i = 0; i < this.maxFrameSizeStr.length; ++i) {
            this.frameSizeList.add(new Integer(this.maxFrameSizeStr[i]));
        }
        this.etherLineModels = asapEtherLineModelArray;
        this.init();
        this.resetDirty();
    }

    private void init() {
        this.numLines = this.etherLineModels.length;
        this.opticModels = OpticsProvExtModel.getModels(this.etherLineModels);
        this.rowDirty = new boolean[this.numLines][this.getColumnCount()];
        this.asapEtherLineInfo = new sAsapEtherLineInfo[this.numLines];
        this.asapEtherLineAdminInfo = new sAsapEtherLineAdminInfo[this.numLines];
        this.portName = new String[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.reach = new Attribute[this.numLines];
        this.wavelength = new Attribute[this.numLines];
        this.soakTime = new int[this.numLines];
    }

    public boolean isAdminStateDirty(int n) {
        return this.rowDirty[n][2];
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1 || n2 == 2 || n2 == 7 || n2 == 13 || n2 == 5 || n2 == 8 || n2 == 10 || n2 == 9 || n2 == 11 || n2 == 12) {
            bl = AbstractPane.isUserAuthorized(this.asapModuleModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    protected boolean isRowDirty(int n) {
        for (int i = 0; i < this.rowDirty[n].length; ++i) {
            if (!this.rowDirty[n][i]) continue;
            return true;
        }
        return false;
    }

    private sAsapEtherLineInfo getAsapEtherLineInfo(int n) {
        try {
            if (this.asapEtherLineInfo[n] == null) {
                this.asapEtherLineInfo[n] = this.etherLineModels[n].getAsapEtherLineInfo();
            }
            db.finest("\ngetAsapEtherLineInfo(" + n + ") was called.");
            db.finest("   adminState:" + this.asapEtherLineInfo[n].adminState);
            db.finest("   linkUp:" + this.asapEtherLineInfo[n].linkUp);
            db.finest("   flowControl status:" + this.asapEtherLineInfo[n].flowControl.value());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            db.fine("Exception from getAsapEtherLineInfo on index = " + Integer.toHexString(this.etherLineModels[n].getIndex()));
            return null;
        }
        return this.asapEtherLineInfo[n];
    }

    private sAsapEtherLineAdminInfo getAsapEtherLineAdminInfo(int n) {
        try {
            if (this.asapEtherLineAdminInfo[n] == null) {
                this.asapEtherLineAdminInfo[n] = this.etherLineModels[n].getAsapEtherLineAdminInfo();
            }
            db.finest("\ngetAsapEtherLineAdminInfo(" + n + ") was called.");
            db.finest("   maxFramreSize:" + this.asapEtherLineAdminInfo[n].maxFrameSize);
            db.finest("   enable auto negotiation:" + this.asapEtherLineAdminInfo[n].autoNegotiate);
            db.finest("   enable flowControl:" + this.asapEtherLineAdminInfo[n].flowControl);
            db.finest("   loopback:" + this.asapEtherLineAdminInfo[n].loopback.value());
            db.finest("   high water mark:" + this.asapEtherLineAdminInfo[n].highWaterMark);
            db.finest("   low water mark:" + this.asapEtherLineAdminInfo[n].lowWaterMark);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            db.fine("Exception from getAsapEtherLineAdminInfo on index = " + Integer.toHexString(this.etherLineModels[n].getIndex()));
            return null;
        }
        return this.asapEtherLineAdminInfo[n];
    }

    protected String[] getFrameSizes() {
        String[] stringArray = new String[this.frameSizeList.size()];
        Iterator iterator = this.frameSizeList.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Integer)iterator.next()).toString();
        }
        return stringArray;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private String getLineNumberFor(int n) {
        try {
            return PortHelper.getPortNumString((IPortModel)this.etherLineModels[n].getPortModel());
        }
        catch (Exception exception) {
            if (AsapEtherPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: 
            case 9: 
            case 10: {
                return String.class;
            }
            case 5: 
            case 7: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    private String getPortName(int n) throws NoSuchInterface {
        if (this.portName[n] == null) {
            this.portName[n] = this.etherLineModels[n].getAlias();
        }
        return this.portName[n];
    }

    private void setPortName(int n, String string) {
        if (string != null) {
            this.portName[n] = string;
            this.rowDirty[n][1] = true;
        }
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            this.adminState[n] = AdminState.enumToAdminState(this.etherLineModels[n].getAdminStateEnum());
        }
        return this.adminState[n];
    }

    private String getLinkState(int n) {
        String string = "";
        try {
            this.getAsapEtherLineInfo(n);
            boolean bl = this.asapEtherLineInfo[n].linkUp;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (AsapEtherPortTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private Attribute getReach(int n) {
        if (this.reach[n] == null) {
            eReach eReach2 = null;
            Attribute attribute = null;
            try {
                eReach2 = this.opticModels[n].getLineReach();
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", eReach2.value());
            }
            catch (Exception exception) {
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", 0);
            }
        }
        return this.reach[n];
    }

    private Attribute getWavelength(int n) {
        if (this.wavelength[n] == null) {
            eWavelength eWavelength2 = null;
            Attribute attribute = null;
            try {
                eWavelength2 = this.opticModels[n].getLineWavelength();
                this.wavelength[n] = attribute = this.getAttributeMap().getAttributeForVal("declAllWavelength", eWavelength2.value());
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.wavelength[n] = attribute = this.getAttributeMap().getAttributeForVal("declAllWavelength", 174);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("AsapEtherPortTableModel: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.wavelength[n];
    }

    private Attribute getFlowControlStatus(int n) {
        this.getAsapEtherLineInfo(n);
        return EtherEnumStrings.get(eFlowControlNegotiated.class, this.asapEtherLineInfo[n].flowControl.value());
    }

    private String getFlowControlLowWaterMark(int n) {
        if (this.asapEtherLineAdminInfo[n] == null) {
            this.getAsapEtherLineAdminInfo(n);
        }
        return Short.toString(this.asapEtherLineAdminInfo[n].lowWaterMark);
    }

    private String getFlowControlHighWaterMark(int n) {
        if (this.asapEtherLineAdminInfo[n] == null) {
            this.getAsapEtherLineAdminInfo(n);
        }
        return Short.toString(this.asapEtherLineAdminInfo[n].highWaterMark);
    }

    private String getPortMaxSizeFor(int n) {
        if (this.asapEtherLineAdminInfo[n] == null) {
            this.getAsapEtherLineAdminInfo(n);
        }
        return Integer.toString(this.asapEtherLineAdminInfo[n].maxFrameSize);
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.etherLineModels[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private Boolean getFlowControlEnabled(int n) {
        if (this.asapEtherLineAdminInfo[n] == null) {
            this.getAsapEtherLineAdminInfo(n);
        }
        return new Boolean(this.asapEtherLineAdminInfo[n].flowControl);
    }

    private Boolean getAutoNegEnabled(int n) {
        if (this.asapEtherLineAdminInfo[n] == null) {
            this.getAsapEtherLineAdminInfo(n);
        }
        return new Boolean(this.asapEtherLineAdminInfo[n].autoNegotiate);
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        if (this.soakTime[n] < 0) {
            this.soakTime[n] = this.etherLineModels[n].getSoakTime();
        }
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    private TDMTerminology getTerms() {
        return this.asapModuleModel.getNodeModel().getTDMTerminology();
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block18: {
            string = "";
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 2: {
                        return this.getAdminState(n).toString(this.getTerms());
                    }
                    case 3: {
                        return this.getServiceState(n).toString(this.getTerms());
                    }
                    case 4: {
                        return this.getLinkState(n);
                    }
                    case 6: {
                        return this.getFlowControlStatus(n);
                    }
                    case 5: {
                        return this.getFlowControlEnabled(n);
                    }
                    case 7: {
                        return this.getAutoNegEnabled(n);
                    }
                    case 8: {
                        return this.getPortMaxSizeFor(n);
                    }
                    case 9: {
                        return this.getFlowControlLowWaterMark(n);
                    }
                    case 10: {
                        return this.getFlowControlHighWaterMark(n);
                    }
                    case 11: {
                        return this.getReach(n);
                    }
                    case 12: {
                        return this.getWavelength(n);
                    }
                    case 13: {
                        return this.getSoakTimeAsHHMM(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block18;
                db.println("Error in getValueAt(): " + exception);
                SDebug.printStackTrace((Throwable)exception);
                string = exception.toString();
            }
        }
        return string;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (!(object instanceof String)) break;
                String string = (String)object;
                this.setPortName(n, string);
                break;
            }
            case 2: {
                if (((AdminState)object).equals(this.adminState[n])) {
                    return;
                }
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 4: {
                this.asapEtherLineInfo[n].linkUp = (Boolean)object;
                return;
            }
            case 5: {
                this.asapEtherLineAdminInfo[n].flowControl = (Boolean)object;
                break;
            }
            case 6: {
                this.asapEtherLineInfo[n].flowControl = (eFlowControlNegotiated)object;
                return;
            }
            case 7: {
                this.asapEtherLineAdminInfo[n].autoNegotiate = (Boolean)object;
                break;
            }
            case 8: {
                this.asapEtherLineAdminInfo[n].maxFrameSize = Integer.parseInt((String)object);
                break;
            }
            case 9: {
                this.asapEtherLineAdminInfo[n].lowWaterMark = Short.parseShort((String)object);
                break;
            }
            case 10: {
                this.asapEtherLineAdminInfo[n].highWaterMark = Short.parseShort((String)object);
                break;
            }
            case 11: {
                this.reach[n] = (Attribute)object;
                break;
            }
            case 12: {
                this.wavelength[n] = (Attribute)object;
                break;
            }
            case 13: {
                int n3 = this.soakTime[n];
                try {
                    n3 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n3) {
                    return;
                }
                this.soakTime[n] = n3;
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    protected void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.rowDirty[i][j] = false;
            }
        }
    }

    protected void refreshLineFromModel(int n) {
        this.clearLineModel(n);
        this.fireTableRowsUpdated(n, n);
    }

    private void clearLineModel(int n) {
        this.asapEtherLineInfo[n] = null;
        this.asapEtherLineAdminInfo[n] = null;
        this.portName[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.reach[n] = null;
        this.wavelength[n] = null;
        this.soakTime[n] = -1;
    }

    protected void applyToModels() throws Exception {
        for (int i = 0; i < this.etherLineModels.length; ++i) {
            Attribute attribute;
            Object object;
            if (this.rowDirty[i][1]) {
                this.etherLineModels[i].setAlias(this.portName[i]);
            }
            if (this.rowDirty[i][13]) {
                if (db.on()) {
                    db.println("setting line soakTime " + this.soakTime[i]);
                }
                this.etherLineModels[i].setSoakTime(this.soakTime[i]);
            }
            if (this.rowDirty[i][2]) {
                this.etherLineModels[i].setAdminState(this.adminState[i].getAdminStateEnum());
            }
            if (this.rowDirty[i][8] || this.rowDirty[i][7] || this.rowDirty[i][5] || this.rowDirty[i][10] || this.rowDirty[i][9]) {
                this.etherLineModels[i].setAsapEtherLineAdminInfo(this.asapEtherLineAdminInfo[i]);
            }
            if (this.rowDirty[i][11] && ((eReach)(object = eReach.from_int((attribute = this.reach[i]).getValue()))).value() != 0) {
                this.opticModels[i].setLineReach((eReach)object);
            }
            if (!this.rowDirty[i][12] || ((eWavelength)(object = eWavelength.from_int((attribute = this.wavelength[i]).getValue()))).value() == 174) continue;
            this.opticModels[i].setLineWavelength((eWavelength)object);
        }
        this.resetDirty();
    }

    protected void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.clearLineModel(i);
        }
        this.fireTableDataChanged();
    }

    public void refreshMyLines(AsapEtherLineModel[] asapEtherLineModelArray) {
        this.etherLineModels = asapEtherLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.asapModuleModel);
    }
}

