/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.EtherMedia.eEncapCrcType;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.EtherMedia.sAsapPosPortAdminInfo;
import cerent.cms.idl.EtherMedia.sAsapPosPortInfo;
import cerent.cms.model.AdminState;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InvalidCardMode;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.SoakTimePropertyEditor;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class AsapPosPortTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    private AsapModuleModel asapModuleModel = null;
    private AsapPosLineModel[] posLineModels = null;
    private boolean[][] rowDirty = null;
    private int numLines = 0;
    private sAsapPosPortAdminInfo[] asapPosPortAdminInfo = null;
    private sAsapPosPortInfo[] asapPosPortInfo = null;
    private String[] portName = null;
    private AdminState[] adminState = null;
    private int[] soakTime = null;
    private TDMTerminology tdmTerm;
    protected String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "Link State", "Framing Type", "Encap CRC", "MTU", "Soak Time"};
    public static final int PORT_NUMBER_INDEX = 0;
    public static final int PORT_NAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int LINK_STATE_INDEX = 4;
    public static final int FRAMING_TYPE_INDEX = 5;
    public static final int CRC_TYPE_INDEX = 6;
    public static final int MTU_INDEX = 7;
    public static final int SOAK_TIME_INDEX = 8;
    private static final SDebug db = new SDebug("AsapPosPortTableModel");

    public AsapPosPortTableModel(AsapModuleModel asapModuleModel, AsapPosLineModel[] asapPosLineModelArray) {
        this.asapModuleModel = asapModuleModel;
        this.posLineModels = asapPosLineModelArray;
        this.tdmTerm = asapModuleModel.getNodeModel().getTDMTerminology();
        this.init();
        this.resetDirty();
    }

    private void init() {
        this.numLines = this.posLineModels.length;
        this.rowDirty = new boolean[this.numLines][this.getColumnCount()];
        this.asapPosPortAdminInfo = new sAsapPosPortAdminInfo[this.numLines];
        this.asapPosPortInfo = new sAsapPosPortInfo[this.numLines];
        this.portName = new String[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.soakTime = new int[this.numLines];
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1 || n2 == 2 || n2 == 5 || n2 == 8 || n2 == 6 && this.asapPosPortAdminInfo[n].posFraming != ePosFramingType.X86) {
            bl = AbstractPane.isUserAuthorized(this.asapModuleModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    private sAsapPosPortInfo getAsapPosPortInfo(int n) {
        try {
            if (this.asapPosPortInfo[n] == null) {
                this.asapPosPortInfo[n] = this.posLineModels[n].getAsapPosPortInfo();
            }
            db.finest("\ngetAsapPosPortInfo(" + n + ") was called.");
            db.finest("   adminState:" + this.asapPosPortInfo[n].adminState);
            db.finest("   linkUp:" + this.asapPosPortInfo[n].linkUp);
            db.finest("   mtu:" + this.asapPosPortInfo[n].maxFrameSize);
        }
        catch (Exception exception) {
            db.fine("Exception from getAsapPosPortInfo on index = " + Integer.toHexString(this.posLineModels[n].getIndex()));
            if (AsapPosPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
        return this.asapPosPortInfo[n];
    }

    private sAsapPosPortAdminInfo getAsapPosPortAdminInfo(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        if (this.asapPosPortAdminInfo[n] == null) {
            this.asapPosPortAdminInfo[n] = this.posLineModels[n].getAsapPosPortAdminInfo();
        }
        return this.asapPosPortAdminInfo[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private String getLineNumberFor(int n) {
        try {
            return PortHelper.getPortNumString((IPortModel)this.posLineModels[n].getPortModel());
        }
        catch (Exception exception) {
            if (AsapPosPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return String.class;
            }
        }
        return Object.class;
    }

    private String getPortName(int n) throws NoSuchInterface {
        if (this.portName[n] == null) {
            this.portName[n] = this.posLineModels[n].getAlias();
        }
        return this.portName[n];
    }

    public boolean isAdminStateDirty(int n) {
        return this.isRowDirty(n);
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            this.adminState[n] = AdminState.enumToAdminState(this.posLineModels[n].getAdminStateEnum());
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        return this.posLineModels[n].getServiceSt();
    }

    private String getLinkState(int n) {
        String string = "";
        try {
            this.getAsapPosPortInfo(n);
            boolean bl = this.asapPosPortInfo[n].linkUp;
            string = bl ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (AsapPosPortTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        if (this.soakTime[n] < 0) {
            this.soakTime[n] = this.posLineModels[n].getSoakTime();
        }
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    public Object getValueAt(int n, int n2) {
        String string = "";
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumberFor(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getAdminState(n).toString(this.tdmTerm);
                }
                case 3: {
                    return this.getServiceState(n).toString(this.tdmTerm);
                }
                case 4: {
                    return this.getLinkState(n);
                }
                case 5: {
                    return this.getFramingTypeFor(n);
                }
                case 6: {
                    return this.getEncapCrcTypeFor(n);
                }
                case 7: {
                    return new Integer(this.asapPosPortInfo[n].maxFrameSize);
                }
                case 8: {
                    return this.getSoakTimeAsHHMM(n);
                }
            }
        }
        catch (Exception exception) {
            db.fine("Error in getValueAt in ASAPPosPortTableModel " + exception);
            if (AsapPosPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            string = exception.toString();
        }
        return string;
    }

    private Attribute getFramingTypeFor(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        if (this.asapPosPortAdminInfo[n] == null) {
            this.getAsapPosPortAdminInfo(n);
        }
        return EtherEnumStrings.get(ePosFramingType.class, this.asapPosPortAdminInfo[n].posFraming.value());
    }

    private Attribute getEncapCrcTypeFor(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        if (this.asapPosPortAdminInfo[n] == null) {
            this.getAsapPosPortAdminInfo(n);
        }
        return EtherEnumStrings.get(eEncapCrcType.class, this.asapPosPortAdminInfo[n].payloadFCS.value());
    }

    protected Attribute getAttributeFor(TreeMap treeMap, int n) {
        return (Attribute)treeMap.get(new Integer(n));
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                String string;
                if (!(object instanceof String) || (string = (String)object) == null) break;
                this.portName[n] = string;
                break;
            }
            case 2: {
                if (((AdminState)object).equals(this.adminState[n])) {
                    return;
                }
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 5: {
                ePosFramingType ePosFramingType2;
                if (this.asapPosPortAdminInfo[n] == null) {
                    try {
                        this.getAsapPosPortAdminInfo(n);
                        ePosFramingType2 = this.asapPosPortAdminInfo[n].posFraming;
                    }
                    catch (Exception exception) {
                        ePosFramingType2 = null;
                    }
                } else {
                    ePosFramingType2 = this.asapPosPortAdminInfo[n].posFraming;
                }
                this.asapPosPortAdminInfo[n].posFraming = ePosFramingType.from_int(((Attribute)object).getIntValue());
                if (ePosFramingType2 != null && ePosFramingType2.value() == this.asapPosPortAdminInfo[n].posFraming.value()) break;
                this.asapPosPortAdminInfo[n].payloadFCS = eEncapCrcType.CRC_32;
                break;
            }
            case 6: {
                this.asapPosPortAdminInfo[n].payloadFCS = eEncapCrcType.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 8: {
                int n3 = this.soakTime[n];
                try {
                    n3 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n3) {
                    return;
                }
                this.soakTime[n] = n3;
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    protected boolean isRowDirty(int n) {
        for (int i = 0; i < this.rowDirty[n].length; ++i) {
            if (!this.rowDirty[n][i]) continue;
            return true;
        }
        return false;
    }

    private void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetRowDirty(i);
        }
    }

    protected void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            db.fine("Invalid lineNo for refresh " + n);
            return;
        }
        this.clearLineModel(n);
        this.resetRowDirty(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.clearLineModel(i);
        }
        this.resetDirty();
        this.fireTableDataChanged();
    }

    public void refreshMyLines(AsapPosLineModel[] asapPosLineModelArray) {
        this.posLineModels = asapPosLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    private void clearLineModel(int n) {
        this.asapPosPortAdminInfo[n] = null;
        this.asapPosPortInfo[n] = null;
        this.portName[n] = null;
        this.adminState[n] = null;
        this.soakTime[n] = -1;
    }

    private void resetRowDirty(int n) {
        for (int i = 0; i < this.rowDirty[n].length; ++i) {
            this.rowDirty[n][i] = false;
        }
    }

    protected void applyToModels() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.rowDirty[i][8]) {
                if (db.on()) {
                    db.println("setting line soakTime " + this.soakTime[i]);
                }
                this.posLineModels[i].setSoakTime(this.soakTime[i]);
            }
            if (this.rowDirty[i][1]) {
                this.posLineModels[i].setAlias(this.portName[i]);
            }
            if (this.rowDirty[i][2]) {
                this.posLineModels[i].setAdminState(this.adminState[i].getAdminStateEnum());
            }
            if (!this.rowDirty[i][5] && !this.rowDirty[i][6]) continue;
            this.posLineModels[i].setAsapPosPortAdminInfo(this.getAsapPosPortAdminInfo(i));
        }
        this.resetDirty();
    }

    protected Attribute[] getPosFramingTypeAttrs() {
        int[] nArray = new int[]{0, 1, 2};
        return EtherEnumStrings.get(ePosFramingType.class, nArray, true);
    }

    protected Attribute[] getEncapCrcTypeAttrs() {
        return EtherEnumStrings.get(eEncapCrcType.class);
    }
}

