/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.util;

import java.io.BufferedReader;
import java.io.FileReader;
import org.jacorb.imrutility.imr.Activator;
import org.jacorb.imrutility.imr.ActivatorHelper;
import org.jacorb.imrutility.imr.AlreadyRegistered;
import org.jacorb.imrutility.imr.CommandInfo;
import org.jacorb.imrutility.imr.NotFound;
import org.jacorb.imrutility.imr.ServerName;
import org.jacorb.imrutility.imr.StartupFailed;
import org.jacorb.imrutility.imr.UnknownServer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class ActivatorManager {
    private static ORB orb;
    private static Activator activator;

    private ActivatorManager() {
    }

    public static void main(String[] args) {
        orb = ORB.init(args, null);
        if (args.length > 0) {
            if (args[0].equals("-h") || args[0].equals("--help")) {
                ActivatorManager.usage();
            } else {
                ActivatorManager.getActivator();
                int i = 0;
                if (args[0].startsWith("-ORBInitRef")) {
                    i = 1;
                }
                if (args[i].equals("-l") || args[i].equals("--list")) {
                    ActivatorManager.list(args);
                } else if (i < args.length - 1) {
                    if (args[i].equals("-a") || args[i].equals("--add")) {
                        ActivatorManager.addCommand(args);
                    } else if (args[i].equals("-r") || args[i].equals("--remove")) {
                        ActivatorManager.removeCommand(args);
                    } else if (args[i].equals("-s") || args[i].equals("--start")) {
                        ActivatorManager.startServer(args);
                    } else {
                        ActivatorManager.usage();
                    }
                } else {
                    ActivatorManager.usage();
                }
            }
        } else {
            ActivatorManager.usage();
        }
    }

    private static void list(String[] args) {
        if (args.length <= 2) {
            ActivatorManager.listAll();
        }
    }

    private static void listAll() {
        CommandInfo[] infoArray = null;
        CommandInfo cinfo = null;
        try {
            infoArray = activator.listCommands();
            if (infoArray.length > 0) {
                for (int i = 0; i < infoArray.length; ++i) {
                    cinfo = infoArray[i];
                    String name = ActivatorManager.getName(cinfo.name);
                    System.out.println("Name            : " + name + "\n");
                    System.out.println("Command         : " + cinfo.cmd + "\n");
                }
            } else {
                System.out.println("No commands registered");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception listing commands\n");
            ex.printStackTrace();
        }
    }

    private static void addCommand(String[] args) {
        String name = null;
        CommandInfo cinfo = null;
        StringBuffer sb = new StringBuffer();
        String cmd = "";
        String command = null;
        for (int i = 1; i < args.length; ++i) {
            if (i >= args.length - 1 && (!cmd.equals("c") || i != args.length - 1)) continue;
            if (args[i].equals("-n") || args[i].equals("--name")) {
                cmd = "n";
                name = args[++i];
            }
            if (args[i].equals("-p") || args[i].equals("--poa")) {
                System.out.println("Addition of POAs is not yet implemented");
                System.exit(0);
                continue;
            }
            if (args[i].equals("-c") || args[i].equals("--command")) {
                cmd = "c";
                sb.append(args[++i]);
                sb.append(' ');
                continue;
            }
            if (cmd.equals("c")) {
                sb.append(args[i]);
                if (i >= args.length - 1) continue;
                sb.append(' ');
                continue;
            }
            if (!args[i].equals("-f") && (!args[i].equals("--comm_file") || cmd.equals("c"))) continue;
            try {
                cmd = "f";
                BufferedReader br = new BufferedReader(new FileReader(args[++i]));
                command = br.readLine();
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception reading file");
                System.exit(0);
            }
        }
        if (sb.length() > 0) {
            command = sb.toString();
        }
        if (command == null || command.length() == 0) {
            System.out.println("You must provide the start up command");
            System.exit(0);
        }
        if (name == null) {
            System.out.println("You must provide the server name");
            System.exit(0);
        }
        ServerName sname = new ServerName();
        sname.impl(name);
        cinfo = new CommandInfo(sname, command);
        try {
            activator.addCommand(cinfo);
            System.out.println("Command added");
        }
        catch (AlreadyRegistered ar) {
            System.out.println("Command already registered for " + name);
        }
        catch (Exception ex) {
            System.out.println("Exception adding command \n");
            ex.printStackTrace();
        }
    }

    private static void removeCommand(String[] args) {
        String name = null;
        if (args.length == 0) {
            ActivatorManager.usage();
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-n") || args[i].equals("--name")) {
                    if (i >= args.length - 1) continue;
                    name = args[++i];
                    continue;
                }
                if (!args[i].equals("-p") && !args[i].equals("--poa")) continue;
                System.out.println("Removal of POAs is not yet implemented");
                System.exit(0);
            }
        }
        if (name == null) {
            System.out.println("You must provide the Server name");
            System.exit(0);
        }
        try {
            ServerName sname = new ServerName();
            sname.impl(name);
            activator.removeCommand(sname);
            System.out.println("Command " + name + " removed");
        }
        catch (NotFound nf) {
            System.out.println(name + " :: Command not found");
        }
        catch (Exception ex) {
            System.out.println("Exception removing command \n");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startServer(String[] args) {
        String name = null;
        ServerName sname = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-n") || args[i].equals("--name")) {
                if (i >= args.length - 1) continue;
                name = args[++i];
                continue;
            }
            if (!args[1].equals("-p") && !args[1].equals("--poa")) continue;
            System.out.println("Starting of POA is not yet implemented");
            System.exit(0);
        }
        if (name == null) {
            System.out.println("You must provide the Server name");
            System.exit(0);
        }
        try {
            sname = new ServerName();
            sname.impl(name);
            activator.startServer(sname, true);
            System.out.println("Server " + name + " started");
        }
        catch (UnknownServer us) {
            System.out.println(name + " :: Server startup command not registered");
        }
        catch (StartupFailed sf) {
            System.out.println(sf.reason);
        }
        catch (Exception ex) {
            System.out.println("Exception starting server \n");
            ex.printStackTrace();
        }
        finally {
            try {
                activator.serverStarted(sname);
            }
            catch (UnknownServer us) {
                System.out.println("UnknownServer exception starting server " + sname);
            }
            catch (Exception ex) {
                System.out.println("Exception from serverStarted " + sname + ex);
            }
        }
    }

    private static String getName(ServerName sname) {
        String name = null;
        String[][] names = null;
        java.lang.Object pnames = null;
        if (sname.discriminator()) {
            name = sname.impl();
        } else {
            names = sname.poas();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    for (int j = 0; j < names[i].length; ++j) {
                        name = name + "/";
                        name = name + names[i][j];
                    }
                }
            }
        }
        return name;
    }

    private static void usage() {
        String separator = "--------------------------------------------------------------";
        System.out.println("Usage");
        System.out.println(separator);
        System.out.println(" [ -l | --list ]        : lists all commands registered with  ");
        System.out.println("                          the activator                       ");
        System.out.println();
        System.out.println(separator);
        System.out.println(" [ -a | --add ]         : adds a command for a server using   ");
        System.out.println("                          the following options:-             ");
        System.out.println();
        System.out.println("   [ -n | --name ] <name> the name of the server              ");
        System.out.println();
        System.out.println("   [ -p  | --poa ] <poa name> Not yet implemented             ");
        System.out.println();
        System.out.println("   [ -c | --command ] <command>                               ");
        System.out.println("                          the command to be used to start the ");
        System.out.println("                          the server                          ");
        System.out.println("                                                              ");
        System.out.println("   [ -f | --comm_file ] <filename>                            ");
        System.out.println("                          the name of the file containing the ");
        System.out.println("                          start up command.  This option is   ");
        System.out.println("                          required for Windows NT and Win2K   ");
        System.out.println("                          in place of the -c option where the ");
        System.out.println("                          input exceeds the maximum command   ");
        System.out.println("                          line length.                        ");
        System.out.println(separator);
        System.out.println(" [ -r | -- remove ]     : removes the command registered for  ");
        System.out.println("                          the given name/poa name uses the    ");
        System.out.println("                          following options                   ");
        System.out.println("   [-n, | --name] <name>                                      ");
        System.out.println();
        System.out.println("   [ -p  | --poa ] <poa name> Not yet implemented             ");
        System.out.println(separator);
        System.out.println(" [ -s | --start ]       : starts the server using the command ");
        System.out.println("                          previously registered for the given ");
        System.out.println("                          name/poa name, uses the following   ");
        System.out.println("                          options:                            ");
        System.out.println("   [-n, --name] <name>                                        ");
        System.out.println();
        System.out.println("   [ -p  | --poa ] <poa name> Not yet implemented             ");
        System.out.println(separator);
        System.out.println(" [ -h | --help ]          displays this help                  ");
        System.out.println(separator);
        System.exit(0);
    }

    private static void getActivator() {
        try {
            Object obj = orb.resolve_initial_references("IMRActivator");
            activator = ActivatorHelper.narrow(obj);
            if (activator == null) {
                System.out.println("Unable to locate the Activator");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception locating Activator");
            System.out.println(ex.getMessage());
        }
        if (activator == null) {
            System.exit(0);
        }
    }

    static {
        activator = null;
    }
}

