/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ClientInterceptorHandler;
import org.jacorb.orb.LocateReplyReceiver;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.Reference;
import org.jacorb.orb.ReplyReceiver;
import org.jacorb.orb.SpecificProfileSelector;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.LocateRequestOutputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.poa.LocalInvocationContext;
import org.jacorb.poa.POA;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.Time;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyHelper;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.Messaging.RelativeRequestTimeoutPolicy;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.ReplyEndTimePolicy;
import org.omg.Messaging.ReplyHandler;
import org.omg.Messaging.ReplyStartTimePolicy;
import org.omg.Messaging.RequestEndTimePolicy;
import org.omg.Messaging.RequestStartTimePolicy;
import org.omg.Messaging.SyncScopePolicy;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;
import org.omg.RTCORBA.ClientProtocolPolicy;
import org.omg.RTCORBA.Protocol;
import org.omg.TimeBase.UtcT;

public final class Delegate
extends org.omg.CORBA_2_3.portable.Delegate {
    private ParsedIOR _pior;
    private IOR ior;
    private ClientConnection connection;
    private ParsedIOR piorOriginal;
    private ParsedIOR piorLastFailed;
    private boolean isImR;
    private boolean bound;
    private POA poa;
    private ORB orb;
    private static Logger logger = Debug.getNamedLogger("jacorb.orb");
    private boolean resolved_locality;
    private Set pending_replies;
    private Barrier pending_replies_sync;
    private byte[] bind_sync = new byte[0];
    private boolean locate_on_bind_performed;
    private ClientConnectionManager conn_mg;
    private Map policy_overrides;
    private CookieHolder cookie;
    private String invokedOperation;
    private byte[] svcObjectID;
    private boolean ctxNegotiated;
    private int socketHash = -1;
    private static boolean disableClientOrbPolicies = Environment.disableClientOrbPolicies();
    private ThreadLocal localInterceptors;
    private static boolean compliantPolicyOverrides = Environment.compliantPolicyOverrides();

    public Delegate(ORB orb, ParsedIOR pior) {
        this.orb = orb;
        this._pior = pior;
        this.checkIfImR(this._pior.getTypeId());
        this.conn_mg = orb.getClientConnectionManager();
    }

    public Delegate(ORB orb, IOR _ior, boolean lazy) {
        this.orb = orb;
        if (lazy) {
            this.ior = _ior;
        } else {
            this._pior = new ParsedIOR(_ior, orb);
        }
        this.checkIfImR(_ior.type_id);
        this.conn_mg = orb.getClientConnectionManager();
    }

    public Delegate(ORB orb, IOR _ior) {
        this(orb, _ior, false);
    }

    private ThreadLocal getLocalInterceptors() {
        if (this.localInterceptors == null && this.orb.hasRequestInterceptors()) {
            this.localInterceptors = new ThreadLocal();
        }
        return this.localInterceptors;
    }

    private void checkIfImR(String typeId) {
        if (typeId.equals("IDL:imr/ImplementationRepository:1.0") || typeId.equals("IDL:imr/Repository:1.0") || typeId.equals("IDL:imr/RepositoryAdmin:1.0")) {
            this.isImR = true;
        }
    }

    public int _get_TCKind() {
        return 14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() {
        if (this.bound) {
            return;
        }
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            Profile p;
            Protocol[] protocols = this.getClientProtocols();
            if (protocols != null) {
                this.getParsedIOR().setProfileSelector(new SpecificProfileSelector(protocols));
            }
            if ((p = this.getParsedIOR().getEffectiveProfile()) == null) {
                throw new COMM_FAILURE("no effective profile");
            }
            this.connection = this.conn_mg.getConnection(p);
            this.bound = true;
            if (!this.locate_on_bind_performed && Environment.locateOnBind()) {
                this.locate_on_bind_performed = true;
                try {
                    LocateRequestOutputStream lros = new LocateRequestOutputStream(this.getParsedIOR().get_object_key(), this.connection.getId(), this.getParsedIOR().getEffectiveProfile().version().minor);
                    LocateReplyReceiver receiver = new LocateReplyReceiver();
                    this.connection.sendRequest(lros, receiver, lros.getRequestId(), true);
                    LocateReplyInputStream lris = receiver.getReply();
                    switch (lris.rep_hdr.locate_status.value()) {
                        case 0: {
                            throw new UNKNOWN("Could not bind to object, server does not know it!");
                        }
                        case 1: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.rebind(lris.read_Object());
                            break;
                        }
                        case 4: {
                            throw SystemExceptionHelper.read(lris);
                        }
                        case 5: {
                            throw new NO_IMPLEMENT("Server responded to LocateRequest with a status of LOC_NEEDS_ADDRESSING_MODE, but this isn't yet implemented by JacORB");
                        }
                        default: {
                            throw new RuntimeException("Unknown reply status for LOCATE_REQUEST: " + lris.rep_hdr.locate_status.value());
                        }
                    }
                }
                catch (SystemException se) {
                    throw se;
                }
                catch (Exception e) {
                    Debug.output(1, e);
                }
            }
            this.bind_sync.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void rebind(Object o) {
        String object_reference = this.orb.object_to_string(o);
        if (object_reference.indexOf("IOR:") != 0) {
            throw new INV_OBJREF("Not an IOR: " + object_reference);
        }
        this.rebind(new ParsedIOR(object_reference, this.orb));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebind(ParsedIOR p) {
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            boolean originalMatch = this.getParsedIOR().equals(p);
            Protocol[] protocols = this.getClientProtocols();
            if (protocols != null) {
                this.getParsedIOR().setProfileSelector(new SpecificProfileSelector(protocols));
            }
            if (originalMatch && p.equals(this.getParsedIOR())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.piorLastFailed != null && this.piorLastFailed.equals(p)) {
                throw new TRANSIENT();
            }
            if (this.piorOriginal == null) {
                this.piorOriginal = this.getParsedIOR();
            }
            this._pior = p;
            if (this.connection != null) {
                this.conn_mg.releaseConnection(this.connection);
                this.connection = null;
            }
            this.bound = false;
            this.bind();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList args, NamedValue result) {
        this.checkORB();
        this.bind();
        return new Request(self, this.orb, this.connection, this.getParsedIOR().get_object_key(), operation, args, ctx, result);
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        throw new NO_IMPLEMENT();
    }

    public synchronized Object duplicate(Object self) {
        return this.orb._getDelegate(new ParsedIOR(this.toString(), this.orb));
    }

    public boolean equals(java.lang.Object obj) {
        return obj instanceof Object && this.toString().equals(obj.toString());
    }

    public boolean equals(Object self, java.lang.Object obj) {
        return this.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.release(null);
        }
        finally {
            super.finalize();
        }
    }

    public DomainManager[] get_domain_managers(Object self) {
        return null;
    }

    public Policy get_policy(Object self, int policy_type) {
        Policy result = this.get_client_policy(policy_type);
        if (result != null) {
            return result;
        }
        return this.get_policy(self, policy_type, this.request(self, "_get_policy", true));
    }

    public Policy get_client_policy(int policy_type) {
        Policy result = null;
        if (!disableClientOrbPolicies) {
            Policy[] orbPolicies;
            Integer key = new Integer(policy_type);
            if (this.policy_overrides != null) {
                result = (Policy)this.policy_overrides.get(key);
            }
            if (result == null && (orbPolicies = this.orb.getPolicyManager().get_policy_overrides(new int[]{policy_type})) != null && orbPolicies.length == 1) {
                result = orbPolicies[0];
            }
        }
        return result;
    }

    public Policy get_policy(Object self, int policy_type, OutputStream os) {
        while (true) {
            try {
                os.write_Object(self);
                os.write_long(policy_type);
                InputStream is = this.invoke(self, os);
                return PolicyHelper.narrow(is.read_Object());
            }
            catch (RemarshalException r) {
                continue;
            }
            catch (ApplicationException _ax) {
                String _id = _ax.getId();
                throw new RuntimeException("Unexpected exception " + _id);
            }
            break;
        }
    }

    public UtcT getRequestEndTime() {
        Policy p = this.get_client_policy(28);
        if (p != null) {
            return ((RequestEndTimePolicy)p).end_time();
        }
        return null;
    }

    public UtcT getReplyEndTime() {
        Policy p = this.get_client_policy(30);
        if (p != null) {
            return ((ReplyEndTimePolicy)p).end_time();
        }
        return null;
    }

    public UtcT getRequestStartTime() {
        Policy p = this.get_client_policy(27);
        if (p != null) {
            return ((RequestStartTimePolicy)p).start_time();
        }
        return null;
    }

    public UtcT getReplyStartTime() {
        Policy p = this.get_client_policy(29);
        if (p != null) {
            return ((ReplyStartTimePolicy)p).start_time();
        }
        return null;
    }

    public long getRelativeRoundtripTimeout() {
        Policy p = this.get_client_policy(32);
        if (p != null) {
            return ((RelativeRoundtripTimeoutPolicy)p).relative_expiry();
        }
        return -1L;
    }

    public long getRelativeRequestTimeout() {
        Policy p = this.get_client_policy(31);
        if (p != null) {
            return ((RelativeRequestTimeoutPolicy)p).relative_expiry();
        }
        return -1L;
    }

    public short getSyncScope() {
        Policy p = this.get_client_policy(24);
        if (p != null) {
            return ((SyncScopePolicy)p).synchronization();
        }
        return 1;
    }

    public Protocol[] getClientProtocols() {
        Policy p = this.get_client_policy(43);
        if (p != null) {
            return ((ClientProtocolPolicy)p).protocols();
        }
        return null;
    }

    public InterfaceDef get_interface(Object self) {
        return InterfaceDefHelper.narrow(this.get_interface_def(self));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object get_interface_def(Object self) {
        this.checkORB();
        if (this.is_really_local(self)) {
            ServantObject so = this.servant_preinvoke(self, "_interface", java.lang.Object.class);
            if (so == null) {
                throw new OBJ_ADAPTER("Servant from pre_invoke was null");
            }
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                Object object = servant._get_interface_def();
                return object;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_interface", true);
                InputStream is = this.invoke(self, os);
                return is.read_Object();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnection getConnection() {
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            this.bind();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOR getIOR() {
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            if (this.piorOriginal != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.piorOriginal.getIOR();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getParsedIOR().getIOR();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectId() {
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            this.bind();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return POAUtil.extractOID(this.getParsedIOR().get_object_key());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectKey() {
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            this.bind();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getParsedIOR().get_object_key();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedIOR getParsedIOR() {
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            if (this._pior == null) {
                if (this.ior == null) {
                    throw new INTERNAL("Internal error - unable to initialise ParsedIOR as IOR is null");
                }
                this._pior = new ParsedIOR(this.ior, this.orb);
                this.ior = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._pior;
        }
    }

    public void resolvePOA(Object self) {
        if (!this.resolved_locality) {
            this.resolved_locality = true;
            POA local_poa = this.orb.findPOA(this, self);
            if (local_poa != null) {
                this.poa = local_poa;
            }
        }
    }

    public POA getPOA() {
        return this.poa;
    }

    public ObjectImpl getReference(POA _poa) {
        if (_poa != null) {
            this.poa = _poa;
        }
        Reference o = new Reference(this.typeId());
        ((ObjectImpl)((java.lang.Object)o))._set_delegate(this);
        return o;
    }

    public int hash(Object self, int x) {
        this.checkORB();
        return this.hashCode();
    }

    public int hashCode() {
        return this.getIDString().hashCode();
    }

    public int hashCode(Object self) {
        return this.hashCode();
    }

    public void invoke(Object self, OutputStream os, ReplyHandler replyHandler) throws ApplicationException, RemarshalException {
        this.invoke_internal(self, os, replyHandler, true);
    }

    public InputStream invoke(Object self, OutputStream os) throws ApplicationException, RemarshalException {
        return this.invoke_internal(self, os, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private InputStream invoke_internal(Object self, OutputStream os, ReplyHandler replyHandler, boolean async) throws ApplicationException, RemarshalException {
        ReplyReceiver receiver;
        block21: {
            this.checkORB();
            RequestOutputStream ros = (RequestOutputStream)os;
            receiver = null;
            ClientInterceptorHandler interceptors = null;
            interceptors = new ClientInterceptorHandler(this.getLocalInterceptors() == null ? null : (ClientInterceptorHandler)this.localInterceptors.get(), this.orb, ros, self, this, this.piorOriginal, this.connection);
            if (this.orb.hasRequestInterceptors()) {
                this.localInterceptors.set(interceptors);
                try {
                    interceptors.handle_send_request();
                }
                catch (RuntimeException e) {
                    this.localInterceptors.set(null);
                    throw e;
                }
            } else {
                interceptors.handle_send_request();
            }
            try {
                if (!ros.response_expected()) {
                    this.invoke_oneway(ros, interceptors);
                    break block21;
                }
                receiver = new ReplyReceiver(this, ros.operation(), ros.getReplyEndTime(), interceptors, replyHandler);
                java.lang.Object e = this.get_pending_replies();
                // MONITORENTER : e
                this.pending_replies.add(receiver);
                // MONITOREXIT : e
                e = this.bind_sync;
                // MONITORENTER : this.bind_sync
                if (ros.getConnection() == this.connection) {
                    this.connection.sendRequest(ros, receiver, ros.requestId(), true);
                    // MONITOREXIT : e
                    break block21;
                }
                if (!logger.isDebugEnabled()) throw new RemarshalException();
                logger.debug("invoke: RemarshalException");
                throw new RemarshalException();
            }
            catch (SystemException cfe) {
                if (logger.isDebugEnabled()) {
                    logger.debug("invoke: SystemException");
                }
                if (!async) {
                    Set set = this.get_pending_replies();
                    // MONITORENTER : set
                    this.pending_replies.remove(receiver);
                    // MONITOREXIT : set
                }
                interceptors.handle_receive_exception(cfe);
                if (!(cfe instanceof TRANSIENT)) throw cfe;
                if (!this.try_rebind()) throw cfe;
                throw new RemarshalException();
            }
            finally {
                if (ros.syncScope() != 0) {
                    ros.close();
                }
                if (this.orb.hasRequestInterceptors()) {
                    this.localInterceptors.set(null);
                }
            }
        }
        if (async) return null;
        if (receiver == null) return null;
        ReplyInputStream is = receiver.getReply();
        ((CDRInputStream)is).updateMutatorConnection(this.connection.getGIOPConnection());
        return is;
    }

    private void invoke_oneway(RequestOutputStream ros, ClientInterceptorHandler interceptors) throws RemarshalException, ApplicationException {
        switch (ros.syncScope()) {
            case 0: {
                RequestOutputStream copy = new RequestOutputStream(ros);
                this.passToTransport(copy);
                interceptors.handle_receive_other((short)0);
                break;
            }
            case 1: {
                this.connection.sendRequest(ros, false);
                interceptors.handle_receive_other((short)0);
                break;
            }
            case 2: 
            case 3: {
                ReplyReceiver rcv = new ReplyReceiver(this, ros.operation(), ros.getReplyEndTime(), interceptors, null);
                this.connection.sendRequest(ros, rcv, ros.requestId(), true);
                ReplyInputStream in = rcv.getReply();
                interceptors.handle_receive_reply(in);
                break;
            }
            default: {
                throw new MARSHAL("Illegal SYNC_SCOPE: " + ros.syncScope(), 0, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    private void passToTransport(final RequestOutputStream ros) {
        new Thread(new Runnable(){

            public void run() {
                Delegate.this.connection.sendRequest(ros, false);
                ros.close();
            }
        }, "PassToTransport").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean try_rebind() {
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            if (logger.isDebugEnabled()) {
                logger.debug("Delegate.try_rebind");
            }
            if (this.piorOriginal != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Delegate: falling back to original IOR");
                }
                this.piorLastFailed = this.getParsedIOR();
                this.rebind(this.piorOriginal);
                this.piorOriginal = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            if (Environment.useImR() && !this.isImR) {
                ParsedIOR imrIOR;
                Integer orbTypeId = this.getParsedIOR().getORBTypeId();
                if (orbTypeId == null || orbTypeId != 1245790976) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Delegate: foreign IOR detected");
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Delegate: JacORB IOR detected");
                }
                byte[] object_key = this.getParsedIOR().get_object_key();
                if (logger.isDebugEnabled()) {
                    logger.debug("Delegate: attempting to contact ImR");
                }
                Repository imr = null;
                while (true) {
                    try {
                        imr = this.orb.getImR();
                        long serverID = -1L;
                        if (this.orb.getImRServerImpl() != null) {
                            serverID = this.orb.getImRServerImpl().id();
                        }
                        imr.ping(serverID);
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Delegate: failed to contact ImR");
                        if (this.orb.imrDead(imr = null)) continue;
                    }
                    break;
                }
                if (imr == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                try {
                    imrIOR = ((Delegate)((ObjectImpl)((java.lang.Object)imr))._get_delegate()).getParsedIOR();
                }
                catch (ClassCastException cce) {
                    Environment.getLogger().debug("Delegate: Unexpected IMR Stub format", cce);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                List imrProfiles = imrIOR.getProfiles();
                TaggedProfile[] newTaggedProfiles = new TaggedProfile[imrProfiles.size()];
                TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder();
                for (int i = 0; i < imrProfiles.size(); ++i) {
                    Profile etfProfile = ((Profile)imrProfiles.get(i)).copy();
                    etfProfile.set_object_key(object_key);
                    etfProfile.marshal(taggedProfileHolder, null);
                    newTaggedProfiles[i] = taggedProfileHolder.value;
                }
                this.rebind(new ParsedIOR(new IOR(this.getParsedIOR().getTypeId(), newTaggedProfiles), this.orb));
                this.piorOriginal = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    public void invokeInterceptors(ClientRequestInfoImpl info, short op) throws RemarshalException {
        ClientInterceptorIterator intercept_iter = this.orb.getInterceptorManager().getClientIterator();
        try {
            intercept_iter.iterate(info, op);
        }
        catch (ForwardRequest fwd) {
            this.rebind(fwd.forward);
            throw new RemarshalException();
        }
        catch (UserException ue) {
            Debug.output(3, ue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean is_a(Object self, String logical_type_id) {
        block15: {
            ParsedIOR pior = this.getParsedIOR();
            if (pior.getTypeId().equals(logical_type_id)) {
                return true;
            }
            String[] ids = ((ObjectImpl)self)._ids();
            for (int i = 0; i < ids.length - 1; ++i) {
                if (!ids[i].equals(logical_type_id)) continue;
                return true;
            }
            if (this.is_really_local(self)) {
                ServantObject so;
                if (logger.isDebugEnabled()) {
                    logger.debug("Located " + self + " on local POA; assuming local.");
                }
                if ((so = this.servant_preinvoke(self, "_is_a", java.lang.Object.class)) == null) {
                    throw new OBJ_ADAPTER("Servant from pre_invoke was null");
                }
                try {
                    Servant servant = (Servant)so.servant;
                    this.orb.set_delegate(servant);
                    boolean bl = servant._is_a(logical_type_id);
                    return bl;
                }
                finally {
                    this.servant_postinvoke(self, so);
                }
            }
            try {
                String classname = RepositoryID.className(ids[0], "Stub");
                int lastDot = classname.lastIndexOf(46);
                StringBuffer scn = new StringBuffer(classname.substring(0, lastDot + 1));
                scn.append('_');
                scn.append(classname.substring(lastDot + 1));
                Class stub = Environment.classForName(scn.toString());
                Method idm = stub.getMethod("_ids", null);
                String[] newids = (String[])idm.invoke(stub.newInstance(), (java.lang.Object[])new Object[0]);
                for (int i = 0; i < newids.length; ++i) {
                    if (!newids[i].equals(logical_type_id)) continue;
                    return true;
                }
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) break block15;
                logger.debug("trying is_a remotely");
            }
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_is_a", true);
                os.write_string(logical_type_id);
                InputStream is = this.invoke(self, os);
                return is.read_boolean();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (ApplicationException ax) {
            throw new RuntimeException("Unexpected exception " + ax.getId());
        }
    }

    public boolean is_equivalent(Object self, Object obj) {
        this.checkORB();
        boolean result = true;
        if (self != obj) {
            ParsedIOR pior1 = new ParsedIOR(obj.toString(), this.orb);
            ParsedIOR pior2 = new ParsedIOR(self.toString(), this.orb);
            result = pior2.getIDString().equals(pior1.getIDString());
        }
        return result;
    }

    public String getIDString() {
        return this.getParsedIOR().getIDString();
    }

    public boolean is_local(Object self) {
        if (this.orb.hasRequestInterceptors() && this.getLocalInterceptors().get() == null) {
            return false;
        }
        return this.is_really_local(self);
    }

    private boolean is_really_local(Object self) {
        if (this.poa == null) {
            this.resolvePOA(self);
        }
        return this.poa != null;
    }

    public boolean is_nil() {
        ParsedIOR pior = this.getParsedIOR();
        return pior.getIOR().type_id.equals("") && pior.getIOR().profiles.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean non_existent(Object self) {
        if (this.is_really_local(self)) {
            ServantObject so = this.servant_preinvoke(self, "_non_existent", java.lang.Object.class);
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                boolean bl = servant._non_existent();
                return bl;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_non_existent", true);
                InputStream is = this.invoke(self, os);
                return is.read_boolean();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (Exception ex) {
            return true;
        }
    }

    public org.omg.CORBA.ORB orb(Object self) {
        return this.orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(Object self) {
        if (!this.bound) {
            return;
        }
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            if (this.connection != null) {
                this.conn_mg.releaseConnection(this.connection);
                this.connection = null;
            }
            this.bound = false;
            this.orb._release(this.getParsedIOR().getIORString());
            if (logger.isDebugEnabled()) {
                logger.debug("Delegate released!");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void releaseReply(Object self, InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Time.waitFor(this.getReplyStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized org.omg.CORBA.Request request(Object self, String operation) {
        this.orb.perform_work();
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            this.bind();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new Request(self, this.orb, this.connection, this.getParsedIOR().get_object_key(), operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OutputStream request(Object self, String operation, boolean responseExpected) {
        this.orb.perform_work();
        UtcT requestEndTime = this.getRequestEndTime();
        long requestTimeout = this.getRelativeRequestTimeout();
        if ((requestTimeout != 0L || requestEndTime != null) && Time.hasPassed(requestEndTime = Time.earliest(Time.corbaFuture(requestTimeout), requestEndTime))) {
            throw new TIMEOUT("Request End Time exceeded prior to invocation", 0, CompletionStatus.COMPLETED_NO);
        }
        UtcT replyEndTime = this.getReplyEndTime();
        long roundtripTimeout = this.getRelativeRoundtripTimeout();
        if ((roundtripTimeout != 0L || replyEndTime != null) && Time.hasPassed(replyEndTime = Time.earliest(Time.corbaFuture(roundtripTimeout), replyEndTime))) {
            throw new TIMEOUT("Reply End Time exceeded prior to invocation", 0, CompletionStatus.COMPLETED_NO);
        }
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            ServiceContext ctx;
            this.bind();
            ParsedIOR p = this.getParsedIOR();
            if (this.getCtxNegotiated() && !this.connection.getGIOPConnection().getTransport().is_connected()) {
                this.setSvcObjectID(null);
                this.setCtxNegotiated(false);
            } else if (this.getCtxNegotiated() && this.connection.getGIOPConnection().getTransport().hashCode() != this.socketHash) {
                this.setSvcObjectID(null);
                this.setCtxNegotiated(false);
            }
            RequestOutputStream ros = new RequestOutputStream(this.connection, this.connection.getId(), operation, responseExpected, this.getSyncScope(), this.getRequestStartTime(), requestEndTime, replyEndTime, this.svcObjectID == null ? p.get_object_key() : this.svcObjectID, p.getEffectiveProfile().version().minor);
            if (!this.connection.isTCSNegotiated() && (ctx = this.connection.setCodeSet(p)) != null) {
                ros.addServiceContext(ctx);
            }
            if (!this.getCtxNegotiated() && !Environment.getCometInteropFix()) {
                ros.addServiceContext(new ServiceContext(1245904912, new byte[0]));
            }
            ros.setCodeSet(this.connection.getTCS(), this.connection.getTCSW());
            ros.updateMutatorConnection(this.connection.getGIOPConnection());
            // ** MonitorExit[var10_8] (shouldn't be in output)
            return ros;
        }
    }

    public void servant_postinvoke(Object self, ServantObject servant) {
        if (this.poa != null) {
            if (this.poa.isUseServantManager() && !this.poa.isRetain() && this.cookie != null && this.invokedOperation != null) {
                try {
                    byte[] oid = POAUtil.extractOID(this.getParsedIOR().get_object_key());
                    ServantLocator sl = (ServantLocator)this.poa.get_servant_manager();
                    sl.postinvoke(oid, this.poa, this.invokedOperation, this.cookie.value, (Servant)servant.servant);
                    this.cookie = null;
                    this.invokedOperation = null;
                }
                catch (Throwable e) {
                    Debug.output(2, e);
                }
            }
            this.poa.removeLocalRequest();
        }
        this.orb.getPOACurrent()._removeContext(Thread.currentThread());
    }

    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        if (this.poa == null) {
            this.resolvePOA(self);
        }
        if (this.poa != null) {
            ServantObject so;
            block17: {
                this.poa.addLocalRequest();
                so = new ServantObject();
                try {
                    if (this.poa.isRetain() && !this.poa.isUseServantManager() || this.poa.useDefaultServant()) {
                        try {
                            so.servant = this.poa.reference_to_servant(self);
                            break block17;
                        }
                        catch (WrongAdapter e) {
                            this.poa.removeLocalRequest();
                            throw new OBJ_ADAPTER("WrongAdapter caught when converting servant to reference. " + e);
                        }
                        catch (WrongPolicy e) {
                            this.poa.removeLocalRequest();
                            throw new OBJ_ADAPTER("WrongPolicy caught" + e);
                        }
                        catch (ObjectNotActive e) {
                            this.poa.removeLocalRequest();
                            throw new OBJECT_NOT_EXIST();
                        }
                    }
                    if (this.poa.isUseServantManager()) {
                        byte[] oid = POAUtil.extractOID(this.getParsedIOR().get_object_key());
                        ServantManager sm = this.poa.get_servant_manager();
                        if (this.poa.isRetain()) {
                            so.servant = this.poa._incarnateServant(oid, (ServantActivator)sm);
                        } else {
                            ServantLocator sl = (ServantLocator)sm;
                            this.cookie = new CookieHolder();
                            this.invokedOperation = operation;
                            so.servant = sl.preinvoke(oid, this.poa, operation, this.cookie);
                        }
                        break block17;
                    }
                    throw new INTERNAL("Internal error: we should not have gotten to this piece of code!");
                }
                catch (WrongPolicy e) {
                    this.poa.removeLocalRequest();
                    throw new OBJ_ADAPTER("WrongPolicy caught" + e);
                }
                catch (org.omg.PortableServer.ForwardRequest e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Caught forwardrequest to " + e.forward_reference + " from " + self);
                    }
                    return this.servant_preinvoke(e.forward_reference, operation, expectedType);
                }
            }
            if (!expectedType.isInstance(so.servant)) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Expected " + expectedType + " got " + so.servant.getClass());
                }
                this.poa.removeLocalRequest();
                return null;
            }
            this.orb.getPOACurrent()._addContext(Thread.currentThread(), new LocalInvocationContext(this.orb, this.poa, this.getObjectId(), (Servant)so.servant));
            return so;
        }
        if (logger.isWarnEnabled()) {
            logger.warn("No POA! servant_preinvoke returns null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        byte[] byArray = this.bind_sync;
        synchronized (this.bind_sync) {
            if (this.piorOriginal != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.piorOriginal.getIORString();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getParsedIOR().getIORString();
        }
    }

    public String toString(Object self) {
        return this.toString();
    }

    public String typeId() {
        if (this.ior != null) {
            return this.ior.type_id;
        }
        return this.getParsedIOR().getIOR().type_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set_policy_override(Object self, Policy[] policies, SetOverrideType set_add) {
        if (compliantPolicyOverrides) {
            Object result = this.duplicate(self);
            Delegate delResult = (Delegate)((ObjectImpl)result)._get_delegate();
            if (this.policy_overrides == null) {
                this.policy_overrides = new HashMap();
            }
            if (delResult.policy_overrides == null) {
                delResult.policy_overrides = new HashMap();
            }
            Map map = this.policy_overrides;
            synchronized (map) {
                if (set_add == SetOverrideType.ADD_OVERRIDE) {
                    delResult.policy_overrides.putAll(this.policy_overrides);
                }
            }
            for (int i = 0; i < policies.length; ++i) {
                delResult.policy_overrides.put(new Integer(policies[i].policy_type()), policies[i]);
            }
            return result;
        }
        if (this.policy_overrides == null) {
            this.policy_overrides = new HashMap();
        }
        if (set_add == SetOverrideType.SET_OVERRIDE) {
            this.policy_overrides.clear();
        }
        for (int i = 0; i < policies.length; ++i) {
            this.policy_overrides.put(new Integer(policies[i].policy_type()), policies[i]);
        }
        return self;
    }

    public String get_codebase(Object self) {
        return this.getParsedIOR().getCodebaseComponent();
    }

    public Set get_pending_replies() {
        if (this.pending_replies == null) {
            this.pending_replies = new HashSet();
        }
        return this.pending_replies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyDone(ReplyPlaceholder placeholder) {
        Set set = this.get_pending_replies();
        synchronized (set) {
            this.pending_replies.remove(placeholder);
        }
    }

    void lockBarrier() {
        if (this.pending_replies_sync == null) {
            this.pending_replies_sync = new Barrier();
        }
        this.pending_replies_sync.lockBarrier();
    }

    void waitOnBarrier() {
        if (this.pending_replies_sync == null) {
            this.pending_replies_sync = new Barrier();
        }
        this.pending_replies_sync.waitOnBarrier();
    }

    void openBarrier() {
        if (this.pending_replies_sync == null) {
            this.pending_replies_sync = new Barrier();
        }
        this.pending_replies_sync.openBarrier();
    }

    boolean getCtxNegotiated() {
        return this.ctxNegotiated;
    }

    void setCtxNegotiated(boolean type) {
        this.ctxNegotiated = type;
    }

    void setSvcObjectID(byte[] id) {
        if (id == null) {
            this.svcObjectID = id;
        } else {
            CDRInputStream is = new CDRInputStream(this.orb, id);
            if (is.available() < 8) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Internal error - received JAC context key with " + is.available());
                }
                throw new INTERNAL("Internal error - JAC service context key has " + is.available());
            }
            this.svcObjectID = new byte[7];
            is.openEncapsulatedArray();
            is.read_octet_array(this.svcObjectID, 0, 7);
            this.socketHash = this.connection.getGIOPConnection().getTransport().hashCode();
        }
    }

    private void checkORB() {
        this.orb.work_pending();
    }

    private static final class Barrier {
        private boolean is_open = true;

        private Barrier() {
        }

        public synchronized void waitOnBarrier() {
            while (!this.is_open) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void lockBarrier() {
            this.is_open = false;
        }

        public synchronized void openBarrier() {
            this.is_open = true;
            this.notifyAll();
        }
    }
}

