/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ObjectUtil;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public class ParsedIOR {
    private static final char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private Profile effectiveProfile = null;
    private final List profiles = new ArrayList();
    private TaggedComponentList components = new TaggedComponentList();
    private ProfileSelector selector = null;
    protected boolean endianness = false;
    private String ior_str = null;
    private IOR ior = null;
    private final ORB orb;
    private CodeSetComponentInfo cs_info = null;
    private Integer orbTypeId = null;
    private static Logger logger = Debug.getNamedLogger("jacorb.orb");

    public static IOR createObjectIOR(Profile profile) {
        String repId = "IDL:omg.org/CORBA/Object:1.0";
        TaggedComponentList components = new TaggedComponentList();
        CDROutputStream orbIDComponentDataStream = new CDROutputStream();
        orbIDComponentDataStream.beginEncapsulatedArray();
        orbIDComponentDataStream.write_long(1245790976);
        components.addComponent(new TaggedComponent(0, orbIDComponentDataStream.getBufferCopy()));
        ArrayList<TaggedProfile> taggedProfileList = new ArrayList<TaggedProfile>();
        TaggedProfileHolder tp = new TaggedProfileHolder();
        TaggedComponentSeqHolder tcs = new TaggedComponentSeqHolder();
        tcs.value = components.asArray();
        profile.marshal(tp, tcs);
        taggedProfileList.add(tp.value);
        TaggedProfile[] tps = new TaggedProfile[taggedProfileList.size()];
        taggedProfileList.toArray(tps);
        return new IOR(repId, tps);
    }

    public static byte[] extractObjectKey(TargetAddress addr, ORB orb) {
        TaggedProfile tp = null;
        switch (addr.discriminator()) {
            case 0: {
                return addr.object_key();
            }
            case 1: {
                tp = new TaggedProfile(addr.profile().tag, addr.profile().profile_data);
                break;
            }
            case 2: {
                IORAddressingInfo info = addr.ior();
                tp = new TaggedProfile(info.ior.profiles[info.selected_profile_index].tag, info.ior.profiles[info.selected_profile_index].profile_data);
            }
        }
        TaggedProfileHolder profile = new TaggedProfileHolder(tp);
        Factories profileFactory = orb.getTransportManager().getFactories(tp.tag);
        if (profileFactory != null) {
            return profileFactory.demarshal_profile(profile, null).get_object_key();
        }
        return null;
    }

    public ParsedIOR(String object_reference, org.omg.CORBA.ORB orb) throws IllegalArgumentException {
        if (!(orb instanceof ORB)) {
            throw new IllegalArgumentException("Construct ParsedIOR with full ORB not Singleton");
        }
        this.orb = (ORB)orb;
        this.parse(object_reference);
    }

    public ParsedIOR(String object_reference, ORB orb) throws IllegalArgumentException {
        this.orb = orb;
        this.parse(object_reference);
    }

    public ParsedIOR(IOR _ior, ORB orb) {
        this.orb = orb;
        this.decode(_ior);
    }

    public boolean equals(java.lang.Object o) {
        return o instanceof ParsedIOR && ((ParsedIOR)o).getIORString().equals(this.getIORString()) && this.effectiveProfile != null && this.effectiveProfile.is_match(((ParsedIOR)o).effectiveProfile);
    }

    public String getCodebaseComponent() {
        return this.getStringComponent(25);
    }

    public void decode(IOR _ior) {
        block3: for (int i = 0; i < _ior.profiles.length; ++i) {
            int tag = _ior.profiles[i].tag;
            switch (tag) {
                case 1: {
                    this.components = new TaggedComponentList(_ior.profiles[i].profile_data);
                    continue block3;
                }
                default: {
                    Factories f = this.orb.getTransportManager().getFactories(tag);
                    if (f != null) {
                        TaggedProfileHolder tp = new TaggedProfileHolder(_ior.profiles[i]);
                        this.profiles.add(f.demarshal_profile(tp, new TaggedComponentSeqHolder()));
                        continue block3;
                    }
                    if (!logger.isDebugEnabled()) continue block3;
                    logger.debug("No transport available for profile tag " + tag);
                    continue block3;
                }
            }
        }
        this.ior = _ior;
        this.setEffectiveProfile();
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs_info;
    }

    public Integer getORBTypeId() {
        return this.orbTypeId;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public String getIORString() {
        if (this.ior_str == null) {
            this.ior_str = ParsedIOR.getIORString(this.orb, this.ior);
        }
        return this.ior_str;
    }

    public static String getIORString(ORB orb, IOR ior) {
        try {
            CDROutputStream out = new CDROutputStream(orb);
            out.beginEncapsulatedArray();
            IORHelper.write(out, ior);
            byte[] bytes = out.getBufferCopy();
            out.close();
            StringBuffer sb = new StringBuffer("IOR:");
            for (int j = 0; j < bytes.length; ++j) {
                sb.append(lookup[bytes[j] >> 4 & 0xF]);
                sb.append(lookup[bytes[j] & 0xF]);
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error("Error constructing IOR string", e);
            throw new UNKNOWN("Error in building IIOP-IOR");
        }
    }

    public byte[] get_object_key() {
        return this.effectiveProfile.get_object_key();
    }

    public List getProfiles() {
        return this.profiles;
    }

    public Profile getEffectiveProfile() {
        return this.effectiveProfile;
    }

    private void setEffectiveProfile() {
        this.effectiveProfile = this.getProfileSelector().selectProfile(this.profiles, this.orb.getClientConnectionManager());
        if (this.effectiveProfile != null) {
            this.cs_info = (CodeSetComponentInfo)this.getComponent(1, CodeSetComponentInfoHelper.class);
            this.orbTypeId = this.getLongComponent(0);
        }
    }

    public String getTypeId() {
        return this.ior.type_id;
    }

    public String getIDString() {
        StringBuffer buff = new StringBuffer(this.getTypeId());
        buff.append(":");
        byte[] key = this.get_object_key();
        for (int j = 0; j < key.length; ++j) {
            buff.append(lookup[key[j] >> 4 & 0xF]);
            buff.append(lookup[key[j] & 0xF]);
        }
        return buff.toString();
    }

    public TaggedComponentList getMultipleComponents() {
        return this.components;
    }

    public boolean isNull() {
        return this.ior.type_id.equals("") && this.ior.profiles.length == 0;
    }

    protected void parse(String object_reference) throws IllegalArgumentException {
        if (object_reference == null) {
            throw new IllegalArgumentException("Null object reference");
        }
        if (object_reference.startsWith("IOR:")) {
            this.parse_stringified_ior(object_reference);
        } else if (object_reference.startsWith("corbaloc:")) {
            this.parse_corbaloc(object_reference);
        } else if (object_reference.startsWith("corbaname:")) {
            this.parse_corbaname(object_reference);
        } else if (object_reference.startsWith("resource:")) {
            this.parse_resource(object_reference.substring(9));
        } else if (object_reference.startsWith("jndi:")) {
            this.parse_jndi(object_reference.substring(5));
        } else {
            String content;
            if (logger.isInfoEnabled()) {
                logger.info("Trying to resolve URL/IOR from: " + object_reference);
            }
            if ((content = ObjectUtil.readURL(object_reference)) == null) {
                throw new BAD_PARAM("Invalid or unreadable URL/IOR: " + object_reference);
            }
            this.parse(content);
        }
        this.ior_str = this.getIORString();
    }

    private void parse_stringified_ior(String object_reference) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int length = object_reference.length();
        int cnt = (length - 4) / 2;
        if (length % 2 != 0) {
            throw new BAD_PARAM("Odd number of characters within object reference");
        }
        for (int j = 0; j < cnt; ++j) {
            int i1;
            char c1 = object_reference.charAt(j * 2 + 4);
            char c2 = object_reference.charAt(j * 2 + 5);
            int n = c1 >= 'a' ? 10 + c1 - 97 : (i1 = c1 >= 'A' ? 10 + c1 - 65 : c1 - 48);
            int i2 = c2 >= 'a' ? 10 + c2 - 97 : (c2 >= 'A' ? 10 + c2 - 65 : c2 - 48);
            bos.write(i1 * 16 + i2);
        }
        CDRInputStream in_ = null;
        in_ = this.orb == null ? new CDRInputStream(org.omg.CORBA.ORB.init(), bos.toByteArray()) : new CDRInputStream(this.orb, bos.toByteArray());
        this.endianness = in_.read_boolean();
        if (this.endianness) {
            in_.setLittleEndian(true);
        }
        try {
            IOR _ior = IORHelper.read(in_);
            this.decode(_ior);
        }
        catch (MARSHAL e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Caught ", e);
            }
            throw new BAD_PARAM("Invalid IOR " + e, 10, CompletionStatus.COMPLETED_NO);
        }
    }

    private void parse_corbaloc(String object_reference) {
        CorbaLoc corbaLoc = new CorbaLoc(this.orb, object_reference);
        IOR ior = null;
        if (corbaLoc.rir()) {
            try {
                Object obj = this.orb.resolve_initial_references(corbaLoc.getKeyString());
                if (obj == null) {
                    throw new IllegalArgumentException("Unable to resolve reference for " + corbaLoc.getKeyString());
                }
                ior = ((Delegate)((ObjectImpl)obj)._get_delegate()).getIOR();
            }
            catch (Exception e) {
                logger.error("Invalid corbaloc URL", e);
                throw new IllegalArgumentException("Invalid corbaloc: URL");
            }
        } else {
            Profile profile = corbaLoc.profileList[0];
            if (profile == null) {
                return;
            }
            profile.set_object_key(this.orb.mapObjectKey(corbaLoc.getKey()));
            ior = ParsedIOR.createObjectIOR(profile);
        }
        this.decode(ior);
    }

    private void parse_corbaname(String object_reference) {
        String corbaloc = "corbaloc:";
        String name = "";
        int colon = object_reference.indexOf(58);
        int pound = object_reference.indexOf(35);
        if (pound == -1) {
            corbaloc = corbaloc + object_reference.substring(colon + 1);
        } else {
            corbaloc = corbaloc + object_reference.substring(colon + 1, pound);
            name = object_reference.substring(pound + 1);
        }
        if (corbaloc.indexOf(47) == -1) {
            corbaloc = corbaloc + "/NameService";
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parsing corbaloc " + corbaloc);
        }
        try {
            NamingContextExt n = NamingContextExtHelper.narrow(this.orb.string_to_object(corbaloc));
            IOR ior = null;
            if (name.length() > 0) {
                Object target = n.resolve_str(name);
                ior = ((Delegate)((ObjectImpl)target)._get_delegate()).getIOR();
            } else {
                ior = ((Delegate)((ObjectImpl)((java.lang.Object)n))._get_delegate()).getIOR();
            }
            this.decode(ior);
        }
        catch (Exception e) {
            logger.error("Invalid corbaname URL", e);
            throw new IllegalArgumentException("Invalid object reference: " + object_reference);
        }
    }

    private void parse_resource(String resourceName) {
        URL url;
        ClassLoader cl;
        if (logger.isInfoEnabled()) {
            logger.info("Trying to resolve URL/IOR from resource: " + resourceName);
        }
        if ((cl = this.getClass().getClassLoader()) == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((url = cl.getResource(resourceName)) == null) {
            throw new IllegalArgumentException("Failed to get resource: " + resourceName);
        }
        String content = ObjectUtil.readURL(url.toString());
        if (content == null) {
            throw new IllegalArgumentException("Failed to read resource: " + resourceName);
        }
        this.parse(content);
    }

    private void parse_jndi(String jndiName) {
        if (logger.isInfoEnabled()) {
            logger.info("Trying to resolve JNDI/IOR from name: " + jndiName);
        }
        java.lang.Object obj = null;
        try {
            Class[] types = new Class[1];
            java.lang.Object[] params = new java.lang.Object[1];
            Class cls = Environment.classForName("javax.naming.InitialContext");
            java.lang.Object initialContext = cls.newInstance();
            types[0] = String.class;
            params[0] = jndiName;
            Method method = cls.getMethod("lookup", types);
            obj = method.invoke(initialContext, params);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to lookup JNDI/IOR: " + ex);
        }
        if (obj == null) {
            throw new IllegalArgumentException("Null JNDI/IOR: " + jndiName);
        }
        this.parse(obj.toString());
    }

    private java.lang.Object getComponent(int tag, Class helper) {
        java.lang.Object result = null;
        if (this.effectiveProfile instanceof IIOPProfile) {
            result = ((IIOPProfile)this.effectiveProfile).getComponent(tag, helper);
        }
        if (result != null) {
            return result;
        }
        return this.components.getComponent(tag, helper);
    }

    private Integer getLongComponent(int tag) {
        return (Integer)this.getComponent(tag, LongHelper.class);
    }

    private String getStringComponent(int tag) {
        return (String)this.getComponent(tag, StringHelper.class);
    }

    public static boolean isParsableProtocol(String check) {
        return check.startsWith("IOR:") || check.startsWith("corbaloc:") || check.startsWith("corbaname:") || check.startsWith("resource:") || check.startsWith("jndi:") || check.startsWith("file:") || check.startsWith("http:");
    }

    public void setProfileSelector(ProfileSelector sel) {
        this.selector = sel;
        this.setEffectiveProfile();
    }

    private ProfileSelector getProfileSelector() {
        if (this.selector == null) {
            return this.orb.getTransportManager().getProfileSelector();
        }
        return this.selector;
    }

    static class LongHelper {
        LongHelper() {
        }

        public static Integer read(InputStream in) {
            return new Integer(in.read_long());
        }
    }

    static class StringHelper {
        StringHelper() {
        }

        public static String read(InputStream in) {
            return in.read_string();
        }
    }
}

