/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.util.Environment;

public class FixedAddressSocketFactory
extends AbstractSocketFactory {
    protected InetAddress localEndpoint;
    protected String oaiAddr;

    public FixedAddressSocketFactory() {
        block4: {
            this.oaiAddr = Environment.getProperty("OAIAddr");
            if (this.oaiAddr != null && this.oaiAddr.length() > 0) {
                int slash = this.oaiAddr.indexOf(47);
                if (slash > 0) {
                    this.oaiAddr = this.oaiAddr.substring(0, slash);
                }
                try {
                    this.localEndpoint = InetAddress.getByName(this.oaiAddr);
                }
                catch (UnknownHostException uhe) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error("Failed to create InetAddress from property OAIAddr >" + this.oaiAddr + "<", uhe);
                }
            }
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        if (this.localEndpoint != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Will create client socket bound to endpoint " + this.localEndpoint);
            }
            return new Socket(host, port, this.localEndpoint, 0);
        }
        return new Socket(host, port);
    }

    public boolean isSSL(Socket socket) {
        return false;
    }
}

