/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ConnectionListener;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;
import org.omg.GIOP.ReplyStatusType_1_2;

public abstract class GIOPConnection
extends OutputStream {
    protected Profile profile = null;
    protected Connection transport = null;
    private RequestListener request_listener = null;
    private ReplyListener reply_listener = null;
    protected ConnectionListener connection_listener = null;
    protected byte[] connect_sync = new byte[0];
    private boolean writer_active = false;
    private final byte[] write_sync = new byte[0];
    private final Logger logger = Debug.getNamedLogger("jacorb.giop.conn");
    private int TCS = 65537;
    private int TCSW = 65801;
    private boolean tcs_negotiated = false;
    private final Hashtable fragments;
    private final BufferManager buf_mg;
    private final boolean dump_incoming;
    private final BufferHolder msg_header = new BufferHolder(new byte[12]);
    private final BufferHolder inbuf = new BufferHolder();
    private static int cubby_count = 0;
    private Object[] cubbyholes = null;
    private int pending_messages = 0;
    protected boolean discard_messages = false;
    protected byte[] pendingUndecidedSync = new byte[0];
    protected boolean do_close = false;
    protected StatisticsProvider statistics_provider = null;

    public GIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener, StatisticsProvider statistics_provider) {
        this.profile = profile;
        this.transport = transport;
        this.request_listener = request_listener;
        this.reply_listener = reply_listener;
        this.statistics_provider = statistics_provider;
        this.fragments = new Hashtable();
        this.buf_mg = BufferManager.getInstance();
        String dump_incoming_str = Environment.getProperty("jacorb.debug.dump_incoming_messages", "off");
        this.dump_incoming = "on".equals(dump_incoming_str);
        this.cubbyholes = new Object[cubby_count];
    }

    public final void setCodeSets(int TCS, int TCSW) {
        this.TCS = TCS;
        this.TCSW = TCSW;
        this.tcs_negotiated = true;
    }

    public final int getTCS() {
        return this.TCS;
    }

    public final int getTCSW() {
        return this.TCSW;
    }

    void markTCSNegotiated() {
        this.tcs_negotiated = true;
    }

    public final boolean isTCSNegotiated() {
        return this.tcs_negotiated;
    }

    protected final synchronized RequestListener getRequestListener() {
        return this.request_listener;
    }

    public final synchronized void setRequestListener(RequestListener v) {
        this.request_listener = v;
    }

    private final synchronized ReplyListener getReplyListener() {
        return this.reply_listener;
    }

    public final synchronized void setReplyListener(ReplyListener v) {
        this.reply_listener = v;
    }

    public final void setConnectionListener(ConnectionListener connection_listener) {
        this.connection_listener = connection_listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getTransport() {
        byte[] byArray = this.connect_sync;
        synchronized (this.connect_sync) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.transport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitUntilConnected() {
        byte[] byArray = this.connect_sync;
        synchronized (this.connect_sync) {
            while (!this.transport.is_connected() && !this.do_close) {
                try {
                    this.connect_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !this.do_close;
        }
    }

    protected abstract void readTimedOut();

    protected abstract void streamClosed();

    public abstract byte[] addContextKey(byte[] var1, byte[] var2, List var3);

    public abstract GIOPConnectionManager.ContextKey getContextKey(byte[] var1);

    private byte[] getMessage() throws IOException {
        if (!this.waitUntilConnected()) {
            return null;
        }
        try {
            this.transport.read(this.msg_header, 0, 12, 12, 0L);
        }
        catch (TRANSIENT ex) {
            return null;
        }
        catch (COMM_FAILURE ex) {
            this.streamClosed();
            return null;
        }
        catch (TIMEOUT ex) {
            this.readTimedOut();
            return null;
        }
        byte[] header = this.msg_header.value;
        if ((char)header[0] == 'G' && (char)header[1] == 'I' && (char)header[2] == 'O' && (char)header[3] == 'P') {
            int msg_size = Messages.getMsgSize(header);
            if (msg_size < 0) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Negative GIOP message size: " + msg_size);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("TCP_IP_GIOPTransport.getMessage() with header: \n" + header + "\nsize : " + 12);
                }
                return null;
            }
            this.inbuf.value = this.buf_mg.getBuffer(msg_size + 12);
            System.arraycopy(header, 0, this.inbuf.value, 0, 12);
            try {
                this.transport.read(this.inbuf, 12, msg_size, msg_size, 0L);
            }
            catch (COMM_FAILURE ex) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Failed to read GIOP message", ex);
                }
                return null;
            }
            if (this.dump_incoming) {
                Debug.output(1, "getMessage()", this.inbuf.value, 0, msg_size + 12);
            }
            if (this.statistics_provider != null) {
                this.statistics_provider.messageReceived(msg_size + 12);
            }
            return this.inbuf.value;
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Failed to read GIOP message, incorrect magic number");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnection.getMessage()" + this.msg_header.value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void receiveMessages() throws IOException {
        while (true) {
            ByteArrayOutputStream b_out;
            byte[] message;
            if ((message = this.getMessage()) == null) {
                if (!this.do_close) continue;
                return;
            }
            byte[] byArray = this.pendingUndecidedSync;
            // MONITORENTER : this.pendingUndecidedSync
            if (this.discard_messages) {
                this.buf_mg.returnBuffer(message);
                // MONITOREXIT : byArray
                continue;
            }
            if (Messages.getGIOPMajor(message) != 1) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Invalid GIOP major version encountered: " + Messages.getGIOPMajor(message));
                }
                Debug.output(3, "GIOPConnection.receiveMessages()", message);
                this.buf_mg.returnBuffer(message);
                // MONITOREXIT : byArray
                continue;
            }
            int msg_type = Messages.getMsgType(message);
            if (msg_type == 7) {
                if (Messages.getGIOPMinor(message) == 0) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Received a GIOP 1.0 message of type Fragment");
                    }
                    MessageOutputStream out = new MessageOutputStream();
                    out.writeGIOPMsgHeader(6, 0);
                    out.insertMsgSize();
                    this.sendMessage(out);
                    this.buf_mg.returnBuffer(message);
                    // MONITOREXIT : byArray
                    continue;
                }
                if (Messages.getGIOPMinor(message) == 1) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Received a GIOP 1.1 Fragment message");
                    }
                    this.buf_mg.returnBuffer(message);
                    // MONITOREXIT : byArray
                    continue;
                }
                Integer request_id = new Integer(Messages.getRequestId(message));
                if (!this.fragments.containsKey(request_id)) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("No previous Fragment to this one");
                    }
                    this.buf_mg.returnBuffer(message);
                    // MONITOREXIT : byArray
                    continue;
                }
                b_out = (ByteArrayOutputStream)this.fragments.get(request_id);
                b_out.write(message, 16, Messages.getMsgSize(message) - 4);
                if (Messages.moreFragmentsFollow(message)) {
                    this.buf_mg.returnBuffer(message);
                    // MONITOREXIT : byArray
                    continue;
                }
                this.buf_mg.returnBuffer(message);
                message = b_out.toByteArray();
                msg_type = Messages.getMsgType(message);
                this.fragments.remove(request_id);
            } else if (Messages.moreFragmentsFollow(message)) {
                if (Messages.getGIOPMinor(message) == 0) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Received a GIOP 1.0 message with the \"more fragments follow\" bits set");
                    }
                    MessageOutputStream out = new MessageOutputStream();
                    out.writeGIOPMsgHeader(6, 0);
                    out.insertMsgSize();
                    this.sendMessage(out);
                    this.buf_mg.returnBuffer(message);
                    // MONITOREXIT : byArray
                    continue;
                }
                if (Messages.getGIOPMinor(message) == 1) {
                    if (msg_type != 0 && msg_type != 1) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.1 message of type " + msg_type + " with the \"more fragments follow\" bits set");
                        }
                        MessageOutputStream out = new MessageOutputStream();
                        out.writeGIOPMsgHeader(6, 1);
                        out.insertMsgSize();
                        this.sendMessage(out);
                        this.buf_mg.returnBuffer(message);
                        // MONITOREXIT : byArray
                        continue;
                    }
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Received a fragmented GIOP 1.1 message");
                    }
                    int giop_minor = Messages.getGIOPMinor(message);
                    ReplyOutputStream out = new ReplyOutputStream(Messages.getRequestId(message), ReplyStatusType_1_2.SYSTEM_EXCEPTION, giop_minor, false);
                    SystemExceptionHelper.write(out, new NO_IMPLEMENT(0, CompletionStatus.COMPLETED_NO));
                    this.sendMessage(out);
                    this.buf_mg.returnBuffer(message);
                    // MONITOREXIT : byArray
                    continue;
                }
                if (msg_type == 2 || msg_type == 5 || msg_type == 2) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Received a GIOP message of type " + msg_type + " with the \"more fragments follow\" bits set, but this " + "message type isn't allowed to be fragmented");
                    }
                    MessageOutputStream out = new MessageOutputStream();
                    out.writeGIOPMsgHeader(6, 1);
                    out.insertMsgSize();
                    this.sendMessage(out);
                    this.buf_mg.returnBuffer(message);
                    // MONITOREXIT : byArray
                    continue;
                }
                Integer request_id = new Integer(Messages.getRequestId(message));
                if (this.fragments.containsKey(request_id)) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Received a message of type " + msg_type + " with the more fragments follow bit set, but there is already an fragmented, incomplete message with the same request id " + request_id + "!");
                    }
                    this.buf_mg.returnBuffer(message);
                    // MONITOREXIT : byArray
                    continue;
                }
                b_out = new ByteArrayOutputStream();
                this.fragments.put(request_id, b_out);
                b_out.write(message, 0, 12 + Messages.getMsgSize(message));
                this.buf_mg.returnBuffer(message);
                // MONITOREXIT : byArray
                continue;
            }
            switch (msg_type) {
                case 0: {
                    this.getRequestListener().requestReceived(message, this);
                    break;
                }
                case 1: {
                    this.getReplyListener().replyReceived(message, this);
                    break;
                }
                case 2: {
                    this.getRequestListener().cancelRequestReceived(message, this);
                    break;
                }
                case 3: {
                    this.getRequestListener().locateRequestReceived(message, this);
                    break;
                }
                case 4: {
                    this.getReplyListener().locateReplyReceived(message, this);
                    break;
                }
                case 5: {
                    this.getReplyListener().closeConnectionReceived(message, this);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("received message with unknown message type " + msg_type);
                    }
                    Debug.output(3, "GIOPConnection.receiveMessages()", message);
                    this.buf_mg.returnBuffer(message);
                }
            }
            // MONITOREXIT : byArray
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void getWriteLock() {
        byte[] byArray = this.write_sync;
        synchronized (this.write_sync) {
            while (this.writer_active) {
                try {
                    this.write_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.writer_active = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseWriteLock() {
        byte[] byArray = this.write_sync;
        synchronized (this.write_sync) {
            this.writer_active = false;
            this.write_sync.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final synchronized void incPendingMessages() {
        ++this.pending_messages;
    }

    public final synchronized void decPendingMessages() {
        --this.pending_messages;
    }

    public final synchronized boolean hasPendingMessages() {
        return this.pending_messages != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void write(byte[] fragment, int start, int size) {
        if (!this.transport.is_connected()) {
            byte[] byArray = this.connect_sync;
            // MONITORENTER : this.connect_sync
            this.transport.connect(this.profile, Environment.getIntPropertyWithDefault("jacorb.connection.client.connect_timeout", 0));
            this.connect_sync.notifyAll();
            // MONITOREXIT : byArray
        }
        this.transport.write(false, false, fragment, start, size, 0L);
        if (this.getStatisticsProvider() == null) return;
        this.getStatisticsProvider().messageChunkSent(size);
    }

    public final void write(int i) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void write(byte[] b) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void flush() throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void sendRequest(MessageOutputStream out, boolean expect_reply) throws IOException {
        if (expect_reply) {
            this.incPendingMessages();
        }
        this.sendMessage(out);
    }

    public final void sendReply(MessageOutputStream out) throws IOException {
        this.decPendingMessages();
        this.sendMessage(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendMessage(MessageOutputStream out) throws IOException {
        try {
            this.getWriteLock();
            out.write_to(this);
            this.transport.flush();
            if (this.getStatisticsProvider() != null) {
                this.getStatisticsProvider().flushed();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public final boolean isSSL() {
        if (this.transport instanceof IIOPConnection) {
            return ((IIOPConnection)this.transport).isSSL();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        byte[] byArray = this.connect_sync;
        synchronized (this.connect_sync) {
            if (this.connection_listener != null) {
                this.connection_listener.connectionClosed();
            }
            this.transport.close();
            this.do_close = true;
            this.connect_sync.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GIOPConnection closed (terminated).");
            }
            return;
        }
    }

    public final StatisticsProvider getStatisticsProvider() {
        return this.statistics_provider;
    }

    public static int allocate_cubby_id() {
        return cubby_count++;
    }

    public Object get_cubby(int id) {
        if (id < 0 || id >= cubby_count) {
            Debug.output(1, "Get bad cubby id " + id + " (max=" + cubby_count + ")");
            return null;
        }
        return this.cubbyholes[id];
    }

    public void set_cubby(int id, Object obj) {
        if (id < 0 || id >= cubby_count) {
            Debug.output(1, "Set bad cubby id " + id + " (max=" + cubby_count + ")");
            return;
        }
        this.cubbyholes[id] = obj;
    }
}

