/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.listener.SSLHandshakeListener;
import org.jacorb.orb.listener.SSLSessionEvent;
import org.jacorb.util.Debug;

public class SSLListenerUtil {
    public static void addListener(Socket s) {
        if (s instanceof SSLSocket && SocketFactoryManager.getSSLListener() != null) {
            ((SSLSocket)s).addHandshakeCompletedListener(new SSLHandshakeListener());
        }
    }

    public static void processException(IIOPConnection iiop, Socket socket, IOException ex) {
        if (SocketFactoryManager.getSSLListener() != null) {
            String localhost;
            try {
                socket.getInetAddress();
                localhost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                if (Debug.isDebugEnabled()) {
                    Debug.output("Unable to resolve local IP address - using default");
                }
                localhost = "127.0.0.1";
            }
            if (ex instanceof SSLHandshakeException) {
                SocketFactoryManager.getSSLListener().handshakeException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
            } else if (ex instanceof SSLKeyException) {
                SocketFactoryManager.getSSLListener().keyException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
            } else if (ex instanceof SSLPeerUnverifiedException) {
                SocketFactoryManager.getSSLListener().peerUnverifiedException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
            } else if (ex instanceof SSLProtocolException) {
                SocketFactoryManager.getSSLListener().protocolException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
            } else if (ex instanceof SSLException) {
                SocketFactoryManager.getSSLListener().sslException(new SSLSessionEvent(iiop, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), localhost, ex));
            } else if (Debug.isDebugEnabled()) {
                Debug.output("Unknown exception type " + ex.getClass().getName() + " with exception " + ex);
            }
        }
    }
}

