/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.Encoding;

public class CodecImpl
extends LocalObject
implements Codec {
    private final ORB orb;
    int giopMinor = 0;

    public CodecImpl(ORB orb, Encoding enc) throws UnknownEncoding {
        if (enc.format != 0) {
            throw new UnknownEncoding();
        }
        if (enc.major_version != 1 || enc.minor_version > 2) {
            throw new UnknownEncoding();
        }
        this.orb = orb;
        this.giopMinor = enc.minor_version;
    }

    public Any decode(byte[] data) throws FormatMismatch {
        CDRInputStream in = new CDRInputStream(this.orb, data);
        in.setGIOPMinor(this.giopMinor);
        in.openEncapsulatedArray();
        Any result = in.read_any();
        return result;
    }

    public Any decode_value(byte[] data, TypeCode tc) throws FormatMismatch, TypeMismatch {
        CDRInputStream in = new CDRInputStream(this.orb, data);
        in.setGIOPMinor(this.giopMinor);
        in.openEncapsulatedArray();
        Any result = this.orb.create_any();
        result.read_value(in, tc);
        return result;
    }

    public byte[] encode(Any data) throws InvalidTypeForEncoding {
        CDROutputStream out = new CDROutputStream(this.orb);
        out.setGIOPMinor(this.giopMinor);
        out.beginEncapsulatedArray();
        out.write_any(data);
        byte[] result = out.getBufferCopy();
        out.close();
        return result;
    }

    public byte[] encode_value(Any data) throws InvalidTypeForEncoding {
        CDROutputStream out = new CDROutputStream(this.orb);
        out.setGIOPMinor(this.giopMinor);
        out.beginEncapsulatedArray();
        data.write_value(out);
        byte[] result = out.getBufferCopy();
        out.close();
        return result;
    }
}

