/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.Debug;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class PrintIOR {
    static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        org.omg.CORBA.ORB orb;
        block12: {
            orb = org.omg.CORBA.ORB.init(args, null);
            ORB jorb = (ORB)orb;
            Logger logger = Debug.getNamedLogger("jacorb.print_ior");
            boolean urlForm = false;
            String iorString = null;
            String file = null;
            if (args.length < 2 || args.length > 3) {
                PrintIOR.usage();
            }
            for (int i = 0; i < args.length; ++i) {
                if ("-u".equals(args[i])) {
                    urlForm = true;
                    continue;
                }
                if ("-i".equals(args[i])) {
                    iorString = args[i + 1];
                    ++i;
                    continue;
                }
                if ("-f".equals(args[i])) {
                    file = args[i + 1];
                    ++i;
                    continue;
                }
                PrintIOR.usage();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Under " + System.getProperty("os.name") + " the encoding name is " + System.getProperty("file.encoding") + " and the canonical encoding name is " + new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
            }
            PrintWriter out = new PrintWriter(System.out, true);
            if (iorString != null) {
                PrintIOR.printIOR(jorb, urlForm, iorString, out);
            } else {
                if (file != null) {
                    LineNumberReader in = new LineNumberReader(new BufferedReader(new FileReader(file)));
                    try {
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            PrintIOR.printIOR(jorb, urlForm, line, out);
                        }
                        Object var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                    {
                        break block12;
                    }
                }
                throw new RuntimeException("should never happen");
            }
        }
        orb.shutdown(true);
    }

    private static void usage() {
        System.err.println("Usage: java PrintIOR [ -i ior_str ] [ -f filename] [-u]\n\tior_str\t IOR as String\n\t-f\t reads one or more IOR's from the file <filename>\n\t-u\t extract object key in URL-Form instead of HEX ");
        System.exit(1);
    }

    private static void printIOR(ORB jorb, boolean urlForm, String iorString, PrintWriter out) {
        if (iorString.startsWith("IOR:")) {
            ParsedIOR pior = new ParsedIOR(iorString, jorb);
            if (urlForm) {
                out.println(CorbaLoc.parseKey(pior.get_object_key()));
            } else {
                PrintIOR.printIOR(pior, out);
            }
        } else {
            out.println("Sorry, we only unparse IORs in the standard IOR URL scheme");
        }
    }

    public static void printIOR(ParsedIOR pior) {
        PrintStream out = System.out;
        PrintIOR.printIOR(pior, new PrintWriter(out, true));
    }

    public static void printIOR(ParsedIOR pior, PrintWriter out) {
        IOR ior = pior.getIOR();
        out.println("------IOR components-----");
        out.println("TypeId\t:\t" + ior.type_id);
        List profiles = pior.getProfiles();
        if (ior.profiles != null && ior.profiles.length > 0) {
            if (ior.profiles[0].tag == 1413566212) {
                out.println("TAO_DIOP Profiles:");
            } else {
                out.println("TAG_INTERNET_IOP Profiles:");
            }
        } else {
            out.println("Unable to determine tag profile type");
        }
        for (int i = 0; i < profiles.size(); ++i) {
            out.println("\tProfile Id:\t\t" + i);
            IIOPProfile p = (IIOPProfile)profiles.get(i);
            out.println("\tIIOP Version:\t\t" + p.version().major + "." + p.version().minor);
            out.println("\tHost:\t\t\t" + p.getAddress().getHostname());
            int port = p.getAddress().getPort();
            if (port < 0) {
                port += 65536;
            }
            out.println("\tPort:\t\t\t" + port);
            try {
                out.println("\tObject key (URL):\t" + CorbaLoc.parseKey(pior.get_object_key()));
            }
            catch (Exception e) {
                // empty catch block
            }
            out.print("\tObject key (hex):\t0x");
            PrintIOR.dumpHex(pior.get_object_key(), out);
            out.println();
            if (p.version().minor >= 1) {
                if (p.getComponents().size() > 0) {
                    out.println("\t-- Found " + p.getComponents().size() + " Tagged Components--");
                }
                PrintIOR.printTaggedComponents(p.getComponents().asArray(), out);
            }
            out.print("\n");
        }
        TaggedComponentList multiple_components = pior.getMultipleComponents();
        if (multiple_components.size() > 0) {
            out.println("Components in MULTIPLE_COMPONENTS profile: " + multiple_components.size());
            PrintIOR.printTaggedComponents(multiple_components.asArray(), out);
        }
    }

    private static void printTaggedComponents(TaggedComponent[] taggedComponents, PrintWriter out) {
        block11: for (int i = 0; i < taggedComponents.length; ++i) {
            switch (taggedComponents[i].tag) {
                case 20: {
                    out.println("\t#" + i + ": TAG_SSL_SEC_TRANS");
                    PrintIOR.printSSLTaggedComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 33: {
                    out.println("\t#" + i + ": TAG_CSI_SEC_MECH_LIST");
                    PrintIOR.printCSIMechComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 35: {
                    out.println("\t#" + i + ": TAG_SECIOP_SEC_TRANS");
                    continue block11;
                }
                case 3: {
                    out.println("\t#" + i + ": TAG_ALTERNATE_IIOP_ADDRESS");
                    PrintIOR.printAlternateAddress(taggedComponents[i], out);
                    continue block11;
                }
                case 1: {
                    out.println("\t#" + i + ": TAG_CODE_SETS");
                    PrintIOR.printCodeSetComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 25: {
                    out.println("\t#" + i + ": TAG_JAVA_CODEBASE");
                    PrintIOR.printJavaCodebaseComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 0: {
                    out.println("\t#" + i + ": TAG_ORB_TYPE");
                    PrintIOR.printOrbTypeComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 2: {
                    out.println("\t#" + i + ": TAG_POLICIES");
                    PrintIOR.printPolicyComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 34: {
                    out.println("\t#" + i + ": TAG_NULL_TAG");
                    continue block11;
                }
                default: {
                    out.println("\t#" + i + ": Unknown (" + taggedComponents[i].tag + ")");
                }
            }
        }
    }

    private static void printCSIMechComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(null, taggedComponent.component_data);
        is.openEncapsulatedArray();
        CompoundSecMechList csmList = CompoundSecMechListHelper.read(is);
        if (csmList != null) {
            out.println("\t\tis stateful: " + csmList.stateful);
            for (int i = 0; i < csmList.mechanism_list.length; ++i) {
                out.println("\t\tCompoundSecMech #" + i);
                out.println("\t\t\ttarget_requires: " + csmList.mechanism_list[i].target_requires);
                out.print("\t\t\ttransport mechanism tag: ");
                switch (csmList.mechanism_list[i].transport_mech.tag) {
                    case 36: {
                        out.println("TAG_TLS_SEC_TRANS");
                        PrintIOR.printTlsSecTrans(csmList.mechanism_list[i].transport_mech.component_data, out);
                        break;
                    }
                    case 34: {
                        out.println("TAG_NULL_TAG");
                        break;
                    }
                    default: {
                        out.println("Unknown tag : " + csmList.mechanism_list[i].transport_mech.tag);
                    }
                }
                out.println("\t\t\tAS_ContextSec target_supports: " + csmList.mechanism_list[i].as_context_mech.target_supports);
                out.println("\t\t\tAS_ContextSec target_requires: " + csmList.mechanism_list[i].as_context_mech.target_requires);
                out.print("\t\t\tAS_ContextSec mech: ");
                PrintIOR.printNTExportedName(csmList.mechanism_list[i].as_context_mech.target_name, out);
                out.print("\t\t\tAS_ContextSec target_name: ");
                PrintIOR.dumpHex(csmList.mechanism_list[i].as_context_mech.target_name, out);
                out.println();
                out.println("\t\t\tSAS_ContextSec target_supports: " + csmList.mechanism_list[i].sas_context_mech.target_supports);
                out.println("\t\t\tSAS_ContextSec target_requires: " + csmList.mechanism_list[i].sas_context_mech.target_requires);
                for (int j = 0; j < csmList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms.length; ++j) {
                    out.print("\t\t\tSAS_ContextSec Naming mech: ");
                    PrintIOR.dumpHex(csmList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms[j], out);
                    out.println();
                }
                out.println("\t\t\tSAS_ContextSec Naming types: " + csmList.mechanism_list[i].sas_context_mech.supported_identity_types);
                out.println();
            }
        }
    }

    private static void printNTExportedName(byte[] nameData, PrintWriter out) {
        int mechLen;
        if (nameData[0] != 4 || nameData[0] != 1) {
            // empty if block
        }
        if ((mechLen = (nameData[2] << 8) + nameData[3]) > nameData.length - 8) {
            PrintIOR.dumpHex(nameData, out);
            out.println();
            return;
        }
        int nameLen = (nameData[mechLen + 4] << 24) + (nameData[mechLen + 5] << 16) + (nameData[mechLen + 6] << 8) + nameData[mechLen + 7];
        if (mechLen + nameLen > nameData.length - 8) {
            PrintIOR.dumpHex(nameData, out);
            out.println();
            return;
        }
        byte[] name = new byte[nameLen];
        System.arraycopy(nameData, mechLen + 8, name, 0, nameLen);
        out.println(new String(name));
    }

    private static void printTlsSecTrans(byte[] tagData, PrintWriter out) {
        CDRInputStream in = new CDRInputStream(null, tagData);
        try {
            in.openEncapsulatedArray();
            TLS_SEC_TRANS tls = TLS_SEC_TRANSHelper.read(in);
            out.println("\t\t\tTLS SEC TRANS target requires: " + tls.target_requires);
            out.println("\t\t\tTLS SEC TRANS target supports: " + tls.target_supports);
            for (int i = 0; i < tls.addresses.length; ++i) {
                int ssl_port = tls.addresses[i].port;
                if (ssl_port < 0) {
                    ssl_port += 65536;
                }
                out.println("\t\t\tTLS SEC TRANS address: " + tls.addresses[i].host_name + ":" + ssl_port);
            }
        }
        catch (Exception ex) {
            out.print("\t\t\tTLS SEC TRANS: ");
            PrintIOR.dumpHex(tagData, out);
            out.println();
        }
    }

    private static void printCodeSetComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(null, taggedComponent.component_data);
        is.openEncapsulatedArray();
        CodeSetComponentInfo codeSet = CodeSetComponentInfoHelper.read(is);
        if (codeSet != null) {
            int ji;
            out.println("\t\tForChar native code set Id: " + CodeSet.csName(codeSet.ForCharData.native_code_set));
            out.print("\t\tChar Conversion Code Sets: ");
            for (ji = 0; ji < codeSet.ForCharData.conversion_code_sets.length; ++ji) {
                out.println(CodeSet.csName(codeSet.ForCharData.conversion_code_sets[ji]));
                if (ji >= codeSet.ForCharData.conversion_code_sets.length - 1) continue;
                out.print(", ");
            }
            if (codeSet.ForCharData.conversion_code_sets.length == 0) {
                out.print("\n");
            }
            out.println("\t\tForWChar native code set Id: " + CodeSet.csName(codeSet.ForWcharData.native_code_set));
            out.print("\t\tWChar Conversion Code Sets: ");
            for (ji = 0; ji < codeSet.ForWcharData.conversion_code_sets.length; ++ji) {
                out.println(CodeSet.csName(codeSet.ForWcharData.conversion_code_sets[ji]));
                if (ji >= codeSet.ForWcharData.conversion_code_sets.length - 1) continue;
                out.print(", ");
            }
            if (codeSet.ForCharData.conversion_code_sets.length == 0) {
                out.print("\n");
            }
        }
    }

    private static void printSSLTaggedComponent(TaggedComponent taggedComponent, PrintWriter out) {
        SSL ssl = null;
        if (taggedComponent.tag == 20) {
            CDRInputStream in = new CDRInputStream(null, taggedComponent.component_data);
            try {
                in.openEncapsulatedArray();
                ssl = SSLHelper.read(in);
            }
            catch (Exception ex) {
                return;
            }
            int ssl_port = ssl.port;
            if (ssl_port < 0) {
                ssl_port += 65536;
            }
            out.print("\t\ttarget_supports\t:\t");
            PrintIOR.decodeAssociationOption(ssl.target_supports, out);
            out.println();
            out.print("\t\ttarget_requires\t:\t");
            PrintIOR.decodeAssociationOption(ssl.target_requires, out);
            out.println();
            out.println("\t\tSSL Port\t:\t" + ssl_port);
        }
    }

    private static void decodeAssociationOption(int option, PrintWriter out) {
        boolean first = true;
        if ((option & 1) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("NoProtection");
            first = false;
        }
        if ((option & 2) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("Integrity");
            first = false;
        }
        if ((option & 4) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("Confidentiality");
            first = false;
        }
        if ((option & 8) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("DetectReplay");
            first = false;
        }
        if ((option & 0x10) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("DetectMisordering");
            first = false;
        }
        if ((option & 0x20) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("EstablishTrustInTarget");
            first = false;
        }
        if ((option & 0x40) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("EstablishTrustInClient");
            first = false;
        }
        if ((option & 0x80) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("NoDelegation");
            first = false;
        }
        if ((option & 0x100) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("SimpleDelegation");
            first = false;
        }
        if ((option & 0x200) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("CompositeDelegation");
            first = false;
        }
    }

    private static void printJavaCodebaseComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(null, taggedComponent.component_data);
        is.openEncapsulatedArray();
        String codebase = is.read_string();
        out.println("\t\tCodebase: " + codebase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printOrbTypeComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(null, taggedComponent.component_data);
        try {
            is.openEncapsulatedArray();
            int type = is.read_long();
            out.print("\t\tType: " + type);
            if (type == 1245790976) {
                out.println(" (JacORB)");
            } else if (type == 1230266177) {
                out.println(" (Orbix)");
            } else if (type == 1447645952) {
                out.println(" (Visibroker)");
            } else if (type == 1096045568) {
                out.println(" (omniORB)");
            } else if (type == 1413566208) {
                out.println(" (TAO)");
            } else {
                out.println(" (Foreign)");
            }
            Object var5_4 = null;
            is.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
    }

    private static void printPolicyComponent(TaggedComponent tc, PrintWriter out) {
        int count = 0;
        CDRInputStream is = new CDRInputStream(null, tc.component_data);
        is.openEncapsulatedArray();
        int len = is.read_long();
        while (len-- != 0) {
            int val = is.read_long();
            out.print("\t\t#" + count++ + ": ");
            is.openEncapsulation();
            switch (val) {
                case 45: {
                    out.println("RTCORBA::PRIORITY_BANDED_CONNECTION");
                    val = is.read_long();
                    for (long i = 0L; i < (long)val; ++i) {
                        short low = is.read_short();
                        short high = is.read_short();
                        out.println("\t\t\tBand " + i + ": " + low + "-" + high);
                    }
                    break;
                }
                case 40: {
                    out.print("RTCORBA::PRIORITY_MODEL");
                    val = is.read_long();
                    switch (val) {
                        case 0: {
                            out.print(" (CLIENT_PROPAGATED, ");
                            break;
                        }
                        case 1: {
                            out.print(" (SERVER_DECLARED, ");
                            break;
                        }
                        default: {
                            out.print(" (Unknown, ");
                        }
                    }
                    short prio = is.read_short();
                    out.println(prio + ")");
                    break;
                }
                default: {
                    out.println("Unknown (" + val + ")");
                }
            }
            is.closeEncapsulation();
        }
    }

    private static void printAlternateAddress(TaggedComponent tc, PrintWriter out) {
        CDRInputStream is = new CDRInputStream(null, tc.component_data);
        is.openEncapsulatedArray();
        out.print("\t\tAddress: " + IIOPAddress.read(is));
    }

    private static void dumpHex(byte[] bs, PrintWriter out) {
        for (int i = 0; i < bs.length; ++i) {
            int n1 = (bs[i] & 0xFF) / 16;
            int n2 = (bs[i] & 0xFF) % 16;
            char c1 = (char)(n1 > 9 ? 65 + (n1 - 10) : 48 + n1);
            char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
            out.print("" + c1 + c2 + " ");
        }
    }
}

