/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.EndpointProfile;
import org.jacorb.imrutility.imr.EndpointProfileSeqHolder;
import org.jacorb.imrutility.imr.ImplActive;
import org.jacorb.imrutility.imr.NotFound;
import org.jacorb.imrutility.imr.Registration;
import org.jacorb.imrutility.imr.RegistrationInfo;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.imrutility.imr.Server;
import org.jacorb.orb.ImRReadyProfile;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.BiDirPolicy;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.AOM;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.POAManager;
import org.jacorb.poa.POAMonitor;
import org.jacorb.poa.POAMonitorLightImpl;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ApplicationError;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.policy.IdAssignmentPolicy;
import org.jacorb.poa.policy.IdUniquenessPolicy;
import org.jacorb.poa.policy.ImplicitActivationPolicy;
import org.jacorb.poa.policy.LifespanPolicy;
import org.jacorb.poa.policy.RequestProcessingPolicy;
import org.jacorb.poa.policy.ServantRetentionPolicy;
import org.jacorb.poa.policy.ThreadPolicy;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.IdUtil;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;
import org.omg.PortableServer._POALocalBase;

public class POA
extends _POALocalBase {
    private ORB orb;
    private Logger logger = Debug.getNamedLogger("jacorb.poa");
    private String logPrefix = "<unset>";
    private POAListener poaListener;
    private POAMonitor monitor;
    private POAManager poaManager;
    private POA parent;
    private String name;
    private String qualifiedName;
    private Hashtable childs = new Hashtable();
    Servant defaultServant;
    ServantManager servantManager;
    private AdapterActivator adapterActivator;
    private AOM aom;
    private RequestController requestController;
    private byte[] poaId;
    private byte[] watermark;
    private long objectIdCount;
    protected org.omg.PortableServer.ThreadPolicy threadPolicy;
    protected org.omg.PortableServer.LifespanPolicy lifespanPolicy;
    protected org.omg.PortableServer.IdUniquenessPolicy idUniquenessPolicy;
    protected org.omg.PortableServer.IdAssignmentPolicy idAssignmentPolicy;
    protected org.omg.PortableServer.ServantRetentionPolicy servantRetentionPolicy;
    protected org.omg.PortableServer.RequestProcessingPolicy requestProcessingPolicy;
    protected org.omg.PortableServer.ImplicitActivationPolicy implicitActivationPolicy;
    protected BidirectionalPolicy bidirectionalPolicy;
    private Hashtable all_policies = null;
    private Hashtable createdReferences;
    private boolean etherealize;
    private int shutdownState = 0;
    private java.lang.Object poaCreationLog = new java.lang.Object();
    private java.lang.Object poaDestructionLog = new java.lang.Object();
    private java.lang.Object unknownAdapterLog = new java.lang.Object();
    private boolean unknownAdapterCalled;
    protected EndpointProfile[] imrEndpoints = null;

    private POA() {
    }

    private POA(ORB _orb, String _name, POA _parent, POAManager _poaManager, Policy[] policies) {
        BiDirPolicy bdp;
        this.orb = _orb;
        this.name = _name;
        this.parent = _parent;
        this.poaManager = _poaManager;
        this.logPrefix = "POA " + this.name;
        this.all_policies = new Hashtable();
        this.createdReferences = new Hashtable();
        if (policies != null) {
            block10: for (int i = 0; i < policies.length; ++i) {
                this.all_policies.put(new Integer(policies[i].policy_type()), policies[i]);
                switch (policies[i].policy_type()) {
                    case 16: {
                        this.threadPolicy = (org.omg.PortableServer.ThreadPolicy)policies[i];
                        continue block10;
                    }
                    case 17: {
                        this.lifespanPolicy = (org.omg.PortableServer.LifespanPolicy)policies[i];
                        continue block10;
                    }
                    case 18: {
                        this.idUniquenessPolicy = (org.omg.PortableServer.IdUniquenessPolicy)policies[i];
                        continue block10;
                    }
                    case 19: {
                        this.idAssignmentPolicy = (org.omg.PortableServer.IdAssignmentPolicy)policies[i];
                        continue block10;
                    }
                    case 21: {
                        this.servantRetentionPolicy = (org.omg.PortableServer.ServantRetentionPolicy)policies[i];
                        continue block10;
                    }
                    case 22: {
                        this.requestProcessingPolicy = (org.omg.PortableServer.RequestProcessingPolicy)policies[i];
                        continue block10;
                    }
                    case 20: {
                        this.implicitActivationPolicy = (org.omg.PortableServer.ImplicitActivationPolicy)policies[i];
                        continue block10;
                    }
                    case 37: {
                        this.bidirectionalPolicy = (BidirectionalPolicy)policies[i];
                    }
                }
            }
        }
        if (this.bidirectionalPolicy != null && (bdp = (BiDirPolicy)this.bidirectionalPolicy).useBiDirGIOP()) {
            _orb.turnOnBiDirGIOP();
        }
        this.watermark = this.generateWatermark();
        this.aom = this.isRetain() ? new AOM(this.isUniqueId(), this.isSingleThreadModel(), this.logger) : null;
        this.requestController = new RequestController(this, this.orb, this.aom, this.logger);
        this.poaManager.registerPOA(this);
        this.monitor = new POAMonitorLightImpl();
        this.monitor.init(this, this.aom, this.requestController.getRequestQueue(), this.requestController.getPoolManager(), "POA " + this.name, this.logger);
        this.monitor.openMonitor();
        if (this.poaListener != null) {
            this.poaListener.poaCreated(this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("POA " + this.name + " ready");
        }
    }

    public void _addPOAEventListener(EventListener listener) {
        if (listener instanceof POAListener) {
            this.addPOAListener((POAListener)listener);
        }
        if (listener instanceof AOMListener && this.aom != null) {
            this.aom.addAOMListener((AOMListener)listener);
        }
        if (listener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().addRequestQueueListener((RequestQueueListener)listener);
        }
        if (listener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().addRPPoolManagerListener((RPPoolManagerListener)listener);
        }
    }

    public Servant _incarnateServant(byte[] oid, ServantActivator sa) throws ForwardRequest {
        return this.aom.incarnate(oid, sa, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA _getChildPOA(String adapter_name) throws ParentIsHolding {
        this.checkDestructionApparent();
        POA child = (POA)this.childs.get(adapter_name);
        if (child == null || child.isDestructionApparent()) {
            if (this.adapterActivator == null) {
                throw new OBJECT_NOT_EXIST("no adapter activator exists for " + adapter_name);
            }
            if (POAUtil.isHolding(this.poaManager.get_state())) {
                throw new ParentIsHolding();
            }
            if (POAUtil.isDiscarding(this.poaManager.get_state())) {
                throw new TRANSIENT("a parent poa is in discarding state");
            }
            if (POAUtil.isInactive(this.poaManager.get_state())) {
                throw new OBJ_ADAPTER("a parent poa is in inactive state");
            }
            boolean successful = false;
            if (this.isSingleThreadModel()) {
                java.lang.Object object = this.unknownAdapterLog;
                synchronized (object) {
                    while (this.unknownAdapterCalled) {
                        try {
                            this.unknownAdapterLog.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                    this.unknownAdapterCalled = true;
                    try {
                        successful = this.the_activator().unknown_adapter(this, POAUtil.unmaskStr(adapter_name));
                    }
                    finally {
                        this.unknownAdapterCalled = false;
                        this.unknownAdapterLog.notifyAll();
                    }
                }
            }
            successful = this.the_activator().unknown_adapter(this, POAUtil.unmaskStr(adapter_name));
            if (successful) {
                child = (POA)this.childs.get(adapter_name);
                if (child == null) {
                    throw new POAInternalError("error: unknown_adapter returns true, but the child poa doesn't extist");
                }
            } else {
                throw new OBJECT_NOT_EXIST("poa activation is failed");
            }
        }
        return child;
    }

    public String _getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.parent == null ? "" : (this.parent.the_parent() == null ? this.name : this.parent._getQualifiedName() + '/' + this.name);
        }
        return this.qualifiedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _invoke(ServerRequest request) throws WrongAdapter {
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            this.checkDestructionApparent();
            if (request.remainingPOAName() == null && this.isSystemId() && !this.previouslyGeneratedObjectId(request.objectId())) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn(this.logPrefix + " rid: " + request.requestId() + " opname: " + request.operation() + " _invoke: object id not previously generated!");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(this.logPrefix + " ObjectId : " + CorbaLoc.parseKey(request.objectId()) + " to POA watermark : " + CorbaLoc.parseKey(this.watermark) + " mismatch.");
                    }
                }
                throw new WrongAdapter();
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + " rid: " + request.requestId() + " opname: " + request.operation() + " _invoke: queuing request");
                }
                this.requestController.queueRequest(request);
            }
            catch (ResourceLimitReachedException e) {
                if (Debug.isDebugEnabled()) {
                    Debug.output("Caught " + e + " when queueing " + request.operation());
                }
                throw new TRANSIENT("resource limit reached");
            }
        }
    }

    public static POA _POA_init(ORB orb) {
        POAManager poaMgr = new POAManager(orb);
        Policy[] policies = null;
        policies = new Policy[]{new ImplicitActivationPolicy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)};
        POA rootPOA = new POA(orb, "RootPOA", null, poaMgr, policies);
        return rootPOA;
    }

    public void _removePOAEventListener(EventListener listener) {
        if (listener instanceof POAListener) {
            this.removePOAListener((POAListener)listener);
        }
        if (listener instanceof AOMListener && this.aom != null) {
            this.aom.removeAOMListener((AOMListener)listener);
        }
        if (listener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().removeRequestQueueListener((RequestQueueListener)listener);
        }
        if (listener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().removeRPPoolManagerListener((RPPoolManagerListener)listener);
        }
    }

    public byte[] activate_object(Servant servant) throws ServantAlreadyActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain() || !this.isSystemId()) {
            throw new WrongPolicy();
        }
        byte[] objectId = this.generateObjectId();
        try {
            this.aom.add(objectId, servant);
            this.orb.set_delegate(servant);
        }
        catch (ObjectAlreadyActive e) {
            throw new POAInternalError("error: object already active (activate_object)");
        }
        return objectId;
    }

    public void activate_object_with_id(byte[] oid, Servant servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        this.checkDestructionApparent();
        if (oid == null) {
            throw new BAD_PARAM("Cannot activate_object_with_id with null ID.");
        }
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(oid)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(oid) + " - activate_object_with_id: oid not previously generated!");
            }
            throw new BAD_PARAM();
        }
        this.aom.add(oid, servant);
        this.orb.set_delegate(servant);
    }

    protected synchronized void addPOAListener(POAListener listener) {
        this.poaListener = EventMulticaster.add(this.poaListener, listener);
    }

    protected void changeToActive() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 0);
        }
        this.monitor.changeState("changed to active...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.monitor.changeState("active");
    }

    protected void changeToDiscarding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 2);
        }
        this.monitor.changeState("changed to discarding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        this.monitor.changeState("discarding");
    }

    protected void changeToHolding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 1);
        }
        this.monitor.changeState("changed to holding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.waitForCompletion();
        this.monitor.changeState("holding");
    }

    protected void changeToInactive(boolean etherealize_objects) {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 3);
        }
        this.monitor.changeState("changed to inactive ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        if (this.etherealize && this.isRetain() && this.useServantManager()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logPrefix + "etherialize all servants ...");
            }
            this.aom.removeAll((ServantActivator)this.servantManager, this, true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logPrefix + "etherialize all servants ...");
            }
            if (this.monitor != null) {
                this.monitor.changeState("inactive (etherialization completed)");
            }
        } else if (this.monitor != null) {
            this.monitor.changeState("inactive (no etherialization)");
        }
    }

    public org.omg.PortableServer.IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue value) {
        this.checkDestructionApparent();
        return new IdAssignmentPolicy(value);
    }

    public org.omg.PortableServer.IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue value) {
        this.checkDestructionApparent();
        return new IdUniquenessPolicy(value);
    }

    public org.omg.PortableServer.ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue value) {
        this.checkDestructionApparent();
        return new ImplicitActivationPolicy(value);
    }

    public org.omg.PortableServer.LifespanPolicy create_lifespan_policy(LifespanPolicyValue value) {
        this.checkDestructionApparent();
        return new LifespanPolicy(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA create_POA(String adapter_name, org.omg.PortableServer.POAManager a_POAManager, Policy[] policies) throws AdapterAlreadyExists, InvalidPolicy {
        POA child;
        this.checkDestructionApparent();
        String poa_name = POAUtil.maskStr(adapter_name);
        if (a_POAManager != null && !(a_POAManager instanceof POAManager)) {
            throw new ApplicationError("error: the POAManager is incompatible with type \"jacorb.poa.POAManager\"!");
        }
        Policy[] policyList = null;
        if (policies != null) {
            short index = this.verifyPolicyList(policies);
            if (index != -1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Policy list invalid at index " + index);
                }
                throw new InvalidPolicy(index);
            }
            policyList = new Policy[policies.length];
            for (int i = 0; i < policies.length; ++i) {
                policyList[i] = policies[i].copy();
            }
        }
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            child = (POA)this.childs.get(poa_name);
            if (child != null && !child.isDestructionApparent()) {
                throw new AdapterAlreadyExists();
            }
            if (child != null) {
                POA aChild;
                while ((aChild = (POA)this.childs.get(poa_name)) != null) {
                    try {
                        this.poaCreationLog.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (child == aChild) continue;
                    throw new AdapterAlreadyExists();
                }
            }
            if (this.isShutdownInProgress()) {
                throw new BAD_INV_ORDER();
            }
            POAManager aPOAManager = a_POAManager == null ? new POAManager(this.orb) : (POAManager)a_POAManager;
            child = new POA(this.orb, poa_name, this, aPOAManager, policyList);
            try {
                if (this.poaListener != null) {
                    this.poaListener.poaCreated(child);
                }
            }
            catch (INTERNAL e) {
                aPOAManager.poaCreationFailed = true;
                throw e;
            }
            this.childs.put(poa_name, child);
            if (child.isPersistent() && Environment.useImR()) {
                try {
                    child.registerWithImR();
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Failed to register POA", e);
                    }
                    throw new INTERNAL("Failed to register POA " + child.the_name() + " with the ImR");
                }
            }
        }
        return child;
    }

    public Object create_reference(String intf_rep_id) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isSystemId()) {
            throw new WrongPolicy();
        }
        return this.getReference(this.generateObjectId(), intf_rep_id, false);
    }

    public Object create_reference_with_id(byte[] oid, String intf_rep_id) throws WrongPolicy {
        this.checkDestructionApparent();
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(oid)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(oid) + "create_reference_with_id : object key not previously generated!");
            }
            throw new BAD_PARAM();
        }
        return this.getReference(oid, intf_rep_id, false);
    }

    public org.omg.PortableServer.RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue value) {
        this.checkDestructionApparent();
        return new RequestProcessingPolicy(value);
    }

    public org.omg.PortableServer.ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue value) {
        this.checkDestructionApparent();
        return new ServantRetentionPolicy(value);
    }

    public org.omg.PortableServer.ThreadPolicy create_thread_policy(ThreadPolicyValue value) {
        this.checkDestructionApparent();
        return new ThreadPolicy(value);
    }

    public synchronized void deactivate_object(byte[] oid) throws ObjectNotActive, WrongPolicy {
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        this.aom.remove(oid, this.requestController, this.useServantManager() ? (ServantActivator)this.servantManager : null, this, false);
        this.createdReferences.remove(new ByteArrayKey(oid));
    }

    public void destroy(boolean etherealize_objects, boolean wait_for_completion) {
        if (wait_for_completion && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        this.makeShutdownInProgress(etherealize_objects);
        Enumeration en = this.childs.elements();
        while (en.hasMoreElements()) {
            POA child = (POA)en.nextElement();
            child.destroy(this.etherealize, wait_for_completion);
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                POA.this.requestController.waitForShutdown();
                POA.this.makeDestructionApparent();
                POA.this.makeDestructionComplete();
            }
        }, "POADestructor");
        thread.start();
        if (wait_for_completion) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private byte[] extractWatermark(byte[] id) {
        if (id.length < this.watermark.length) {
            return new byte[0];
        }
        return IdUtil.extract(id, id.length - this.watermark.length, this.watermark.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA find_POA(String adapter_name, boolean activate_it) throws AdapterNonExistent {
        this.checkDestructionApparent();
        String poa_name = POAUtil.maskStr(adapter_name);
        POA child = (POA)this.childs.get(poa_name);
        if (child == null || child.isDestructionApparent()) {
            boolean successful = false;
            if (activate_it && this.the_activator() != null) {
                if (this.isSingleThreadModel()) {
                    java.lang.Object object = this.unknownAdapterLog;
                    synchronized (object) {
                        while (this.unknownAdapterCalled) {
                            try {
                                this.unknownAdapterLog.wait();
                            }
                            catch (InterruptedException e) {}
                        }
                        this.unknownAdapterCalled = true;
                        try {
                            successful = this.the_activator().unknown_adapter(this, adapter_name);
                        }
                        finally {
                            this.unknownAdapterCalled = false;
                            this.unknownAdapterLog.notifyAll();
                        }
                    }
                }
                successful = this.the_activator().unknown_adapter(this, adapter_name);
            }
            if (successful) {
                child = (POA)this.childs.get(poa_name);
                if (child == null) {
                    throw new POAInternalError("error: unknown_adapter returns true, but the child poa does'n extist");
                }
            } else {
                throw new AdapterNonExistent();
            }
        }
        return child;
    }

    private synchronized byte[] generateObjectId() {
        if (this.isPersistent()) {
            return IdUtil.concat(IdUtil.createId(4), this.watermark);
        }
        return IdUtil.concat(IdUtil.toId(this.objectIdCount++), this.watermark);
    }

    private byte[] generateWatermark() {
        if (this.watermark == null) {
            this.watermark = this.isPersistent() ? IdUtil.toId(new String(this.getPOAId()).hashCode()) : IdUtil.createId(4);
        }
        return this.watermark;
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        if (this.defaultServant == null) {
            throw new NoServant();
        }
        return this.defaultServant;
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        return this.servantManager;
    }

    protected POAMonitor getMonitor() {
        return this.monitor;
    }

    protected ORB getORB() {
        return this.orb;
    }

    public byte[] getPOAId() {
        if (this.poaId == null) {
            byte[] impl;
            if (!this.isPersistent() || Environment.implName() == null) {
                impl = Environment.serverId();
                if (this.logger.isInfoEnabled()) {
                    if (this.isPersistent()) {
                        this.logger.info("Impl name not set; using server ID: " + new String(impl));
                    } else {
                        this.logger.info("Using server ID (" + new String(impl) + ") for transient POA");
                    }
                }
            } else {
                impl = Environment.implName();
            }
            byte[] impl_name = POAUtil.maskId(impl);
            int in_length = impl_name.length;
            byte[] poa_name = this._getQualifiedName().getBytes();
            int pn_length = poa_name.length;
            int offset = 0;
            if (pn_length == 0) {
                this.poaId = new byte[in_length];
                System.arraycopy(impl_name, 0, this.poaId, 0, in_length);
            } else {
                this.poaId = new byte[in_length + pn_length + 1];
                System.arraycopy(impl_name, 0, this.poaId, 0, in_length);
                this.poaId[offset += in_length] = 47;
                System.arraycopy(poa_name, 0, this.poaId, ++offset, pn_length);
            }
        }
        return this.poaId;
    }

    protected Object getReference(byte[] oid, String intf_rep_id, boolean cache) {
        byte[] object_id = POAUtil.maskId(oid);
        int pid_length = this.getPOAId().length;
        int oid_length = object_id.length;
        byte[] object_key = new byte[pid_length + oid_length + 1];
        int offset = 0;
        System.arraycopy(this.getPOAId(), 0, object_key, offset, pid_length);
        object_key[offset += pid_length] = 47;
        System.arraycopy(object_id, 0, object_key, ++offset, oid_length);
        ByteArrayKey key = new ByteArrayKey(oid);
        Object result = (Object)this.createdReferences.get(key);
        if (result == null) {
            result = this.orb.getReference(this, object_key, intf_rep_id, !this.isPersistent());
            if (cache) {
                this.createdReferences.put(key, result);
            }
            if (this.poaListener != null) {
                this.poaListener.referenceCreated(result);
            }
        }
        return result;
    }

    protected RequestController getRequestController() {
        return this.requestController;
    }

    public Object id_to_reference(byte[] oid) throws ObjectNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        Servant servant = null;
        servant = this.aom.getServant(oid);
        if (servant == null) {
            throw new ObjectNotActive();
        }
        return this.getReference(oid, servant._all_interfaces(this, oid)[0], true);
    }

    public Servant id_to_servant(byte[] oid) throws ObjectNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        Servant servant = null;
        if (this.isRetain() && (servant = this.aom.getServant(oid)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected void checkDestructionApparent() {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("POA destroyed");
        }
    }

    protected static void checkNotLocal(Object obj) throws WrongAdapter {
        if (obj instanceof LocalObject) {
            throw new WrongAdapter("Local object");
        }
    }

    protected boolean isDestructionApparent() {
        return this.shutdownState >= 2;
    }

    public boolean isDestructionComplete() {
        return this.shutdownState >= 3;
    }

    protected boolean isImplicitActivation() {
        return this.implicitActivationPolicy != null && this.implicitActivationPolicy.value() == ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION;
    }

    private boolean isInInvocationContext() {
        try {
            if (this.orb.getPOACurrent().getORB() == this.orb) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    private boolean isInInvocationContext(Servant servant) {
        try {
            if (this.orb.getPOACurrent().get_POA() == this && (servant == null || this.orb.getPOACurrent().getServant() == servant)) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    protected boolean isMultipleId() {
        return this.idUniquenessPolicy != null && this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.MULTIPLE_ID;
    }

    public boolean isPersistent() {
        return this.lifespanPolicy != null && this.lifespanPolicy.value() == LifespanPolicyValue.PERSISTENT;
    }

    public boolean isRetain() {
        return this.servantRetentionPolicy == null || this.servantRetentionPolicy.value() == ServantRetentionPolicyValue.RETAIN;
    }

    protected boolean isShutdownInProgress() {
        return this.shutdownState >= 1;
    }

    protected boolean isSingleThreadModel() {
        return this.threadPolicy != null && this.threadPolicy.value() == ThreadPolicyValue.SINGLE_THREAD_MODEL;
    }

    public boolean isSystemId() {
        return this.idAssignmentPolicy == null || this.idAssignmentPolicy.value() == IdAssignmentPolicyValue.SYSTEM_ID;
    }

    protected boolean isUniqueId() {
        return this.idUniquenessPolicy == null || this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.UNIQUE_ID;
    }

    protected boolean isUseDefaultServant() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT;
    }

    public boolean isUseServantManager() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDestructionApparent() {
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            if (this.shutdownState < 2) {
                this.poaManager.unregisterPOA(this);
                this.shutdownState = 2;
                if (this.poaListener != null) {
                    this.poaListener.poaStateChanged(this, 4);
                }
                if (this.isPersistent() && Environment.useImR() && this.orb.getImRServerImpl() != null) {
                    ArrayList temp = new ArrayList();
                    this.getPOAName(temp);
                    String[] poa = temp.toArray(new String[0]);
                    Repository imr = this.orb.getImR();
                    try {
                        imr.deregisterPOA(this.orb.getImRServerImpl().id(), poa);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "destruction is apparent");
                }
                this.monitor.changeState("destruction is apparent ...");
            }
        }
    }

    private void makeDestructionComplete() {
        if (this.shutdownState < 3) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "clear up the queue ...");
            }
            this.requestController.clearUpQueue(new OBJECT_NOT_EXIST("adapter destroyed"));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "... done");
            }
            if (this.etherealize && this.isRetain() && this.useServantManager()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "etherialize all servants ...");
                }
                this.aom.removeAll((ServantActivator)this.servantManager, this, true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "... done");
                }
            }
            if (!Environment.threadPoolShared()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "remove all processors from the pool ...");
                }
                this.requestController.clearUpPool();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "... done");
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "stop the request controller ...");
            }
            this.requestController.end();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "... done");
            }
            this.shutdownState = 3;
            if (this.parent != null) {
                this.parent.unregisterChild(this.name);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logPrefix + " destroyed");
            }
            this.monitor.changeState("destroyed");
            this.createdReferences.clear();
            this.all_policies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeShutdownInProgress(boolean etherealize_objects) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            if (this.shutdownState < 1) {
                this.etherealize = etherealize_objects;
                this.shutdownState = 1;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "shutdown is in progress");
                }
                this.monitor.changeState("shutdown is in progress ...");
            }
        }
    }

    public boolean previouslyGeneratedObjectId(byte[] oid) {
        return IdUtil.equals(this.watermark, this.extractWatermark(oid));
    }

    public boolean previouslyGeneratedObjectKey(byte[] object_key) {
        return IdUtil.equals(object_key, this.getPOAId(), this.getPOAId().length);
    }

    public byte[] reference_to_id(Object reference) throws WrongAdapter, WrongPolicy {
        this.checkDestructionApparent();
        POA.checkNotLocal(reference);
        byte[] objectId = POAUtil.extractOID(reference);
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(objectId)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(objectId) + "reference_to_id: oid not previously generated!");
            }
            throw new WrongAdapter();
        }
        return objectId;
    }

    public Servant reference_to_servant(Object reference) throws ObjectNotActive, WrongAdapter, WrongPolicy {
        if (reference == null) {
            throw new BAD_PARAM("reference may not be null");
        }
        this.checkDestructionApparent();
        POA.checkNotLocal(reference);
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        byte[] objectId = POAUtil.extractOID(reference);
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(objectId)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(objectId) + "reference_to_servant: oid not previously generated!");
            }
            throw new WrongAdapter();
        }
        ByteArrayKey oid = new ByteArrayKey(objectId);
        if (this.aom != null && this.aom.isDeactivating(oid) || this.requestController.isDeactivating(oid)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(objectId) + "cannot process request, because object is already in the deactivation process");
            }
            throw new OBJECT_NOT_EXIST();
        }
        Servant servant = null;
        if (this.isRetain() && (servant = this.aom.getServant(objectId)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected synchronized void removePOAListener(POAListener listener) {
        this.poaListener = EventMulticaster.remove(this.poaListener, listener);
    }

    public byte[] servant_to_id(Servant servant) throws ServantNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!(this.isUseDefaultServant() || this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation())) {
            throw new WrongPolicy();
        }
        byte[] objectId = null;
        if (this.isRetain()) {
            if (this.isUniqueId() && (objectId = this.aom.getObjectId(servant)) != null) {
                return objectId;
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                objectId = this.generateObjectId();
                try {
                    this.aom.add(objectId, servant);
                    this.orb.set_delegate(servant);
                }
                catch (ObjectAlreadyActive e) {
                    throw new POAInternalError("error: object already active (servant_to_id)");
                }
                catch (ServantAlreadyActive e) {
                    objectId = this.aom.getObjectId(servant);
                }
                return objectId;
            }
        }
        if (this.isUseDefaultServant() && servant == this.defaultServant && this.isInInvocationContext(servant)) {
            try {
                objectId = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext e) {
                throw new POAInternalError("error: not in invocation context (servant_to_id)");
            }
            return objectId;
        }
        throw new ServantNotActive();
    }

    public Object servant_to_reference(Servant servant) throws ServantNotActive, WrongPolicy {
        this.checkDestructionApparent();
        boolean isInInvocationContext = this.isInInvocationContext(servant);
        if (!(this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation() || isInInvocationContext)) {
            throw new WrongPolicy();
        }
        byte[] objectId = null;
        if (isInInvocationContext) {
            try {
                objectId = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext e) {
                throw new POAInternalError("error: not in invocation context (servant_to_reference)");
            }
            return this.getReference(objectId, servant._all_interfaces(this, objectId)[0], true);
        }
        if (this.isRetain()) {
            if (this.isUniqueId() && (objectId = this.aom.getObjectId(servant)) != null) {
                return this.getReference(objectId, servant._all_interfaces(this, objectId)[0], true);
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                objectId = this.generateObjectId();
                try {
                    this.aom.add(objectId, servant);
                    this.orb.set_delegate(servant);
                }
                catch (ObjectAlreadyActive e) {
                    throw new POAInternalError("error: object already active (servant_to_reference)");
                }
                catch (ServantAlreadyActive e) {
                    objectId = this.aom.getObjectId(servant);
                }
                return this.getReference(objectId, servant._all_interfaces(this, objectId)[0], true);
            }
        }
        throw new ServantNotActive();
    }

    public void set_servant(Servant _defaultServant) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        this.defaultServant = _defaultServant;
        if (this.defaultServant != null) {
            this.orb.set_delegate(this.defaultServant);
        }
    }

    public void set_servant_manager(ServantManager servant_manager) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        if (this.servantManager != null) {
            throw new BAD_INV_ORDER();
        }
        if (this.isRetain() && !(servant_manager instanceof ServantActivator)) {
            throw new WrongPolicy();
        }
        if (!this.isRetain() && !(servant_manager instanceof ServantLocator)) {
            throw new WrongPolicy();
        }
        this.servantManager = servant_manager;
    }

    protected void setMonitor(POAMonitor _monitor) {
        this.monitor = _monitor;
    }

    public AdapterActivator the_activator() {
        this.checkDestructionApparent();
        return this.adapterActivator;
    }

    public void the_activator(AdapterActivator adapter_activator) {
        this.checkDestructionApparent();
        this.adapterActivator = adapter_activator;
    }

    public String the_name() {
        this.checkDestructionApparent();
        return POAUtil.unmaskStr(this.name);
    }

    public org.omg.PortableServer.POA the_parent() {
        this.checkDestructionApparent();
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA[] the_children() {
        org.omg.PortableServer.POA[] children;
        this.checkDestructionApparent();
        int i = 0;
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            children = new org.omg.PortableServer.POA[this.childs.size()];
            Enumeration enm = this.childs.elements();
            while (enm.hasMoreElements()) {
                children[i] = (org.omg.PortableServer.POA)enm.nextElement();
                ++i;
            }
        }
        return children;
    }

    public org.omg.PortableServer.POAManager the_POAManager() {
        this.checkDestructionApparent();
        return this.poaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterChild(String name) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            this.childs.remove(name);
            this.poaCreationLog.notifyAll();
        }
    }

    public boolean useDefaultServant() {
        return this.isUseDefaultServant() && this.defaultServant != null;
    }

    protected boolean useServantManager() {
        return this.isUseServantManager() && this.servantManager != null;
    }

    private short verifyPolicyList(Policy[] policies) {
        block9: for (short i = 0; i < policies.length; i = (short)((short)(i + 1))) {
            switch (policies[i].policy_type()) {
                case 16: {
                    continue block9;
                }
                case 17: {
                    if (((org.omg.PortableServer.LifespanPolicy)policies[i]).value() != LifespanPolicyValue.PERSISTENT || Environment.implName() != null) continue block9;
                    this.logger.fatalError("Cannot create a persistent poa. The implname property has not been set.");
                    return i;
                }
                case 18: {
                    continue block9;
                }
                case 19: {
                    continue block9;
                }
                case 21: {
                    if (((org.omg.PortableServer.ServantRetentionPolicy)policies[i]).value() != ServantRetentionPolicyValue.NON_RETAIN) continue block9;
                    Policy policy = POAUtil.getPolicy(policies, 22);
                    if (policy != null) {
                        if (((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT || ((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) continue block9;
                        return i;
                    }
                    return i;
                }
                case 22: {
                    Policy policy;
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policies[i]).value() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
                        policy = POAUtil.getPolicy(policies, 21);
                        if (policy == null || ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() == ServantRetentionPolicyValue.RETAIN) continue block9;
                        return i;
                    }
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policies[i]).value() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) continue block9;
                    policy = POAUtil.getPolicy(policies, 18);
                    Policy policy2 = POAUtil.getPolicy(policies, 21);
                    if (policy == null && policy2 == null) {
                        return i;
                    }
                    if (!(policy != null && policy2 == null ? ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID : (policy == null && policy2 != null ? ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN : policy != null && policy2 != null && ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID && ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN))) continue block9;
                    return i;
                }
                case 20: {
                    if (((org.omg.PortableServer.ImplicitActivationPolicy)policies[i]).value() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) continue block9;
                    Policy policy = POAUtil.getPolicy(policies, 21);
                    if (policy != null && ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() != ServantRetentionPolicyValue.RETAIN) {
                        return i;
                    }
                    policy = POAUtil.getPolicy(policies, 19);
                    if (policy == null || ((org.omg.PortableServer.IdAssignmentPolicy)policy).value() == IdAssignmentPolicyValue.SYSTEM_ID) continue block9;
                    return i;
                }
            }
        }
        return -1;
    }

    public Policy getPolicy(int type) {
        return (Policy)this.all_policies.get(new Integer(type));
    }

    public void addLocalRequest() {
        this.requestController.addLocalRequest();
    }

    public void removeLocalRequest() {
        this.requestController.removeLocalRequest();
    }

    public int getNumberOfObjects() {
        return this.aom.size();
    }

    public EndpointProfile[] getEndpoints() {
        ArrayList profiles = new ArrayList();
        HashMap componentMap = new HashMap();
        this.orb.getProfiles(this, null, componentMap, profiles);
        EndpointProfile[] myEndpoints = new EndpointProfile[profiles.size()];
        for (int i = 0; i < profiles.size(); ++i) {
            if (!(profiles.get(i) instanceof ImRReadyProfile)) continue;
            ImRReadyProfile nextProfile = (ImRReadyProfile)profiles.get(i);
            myEndpoints[i] = new EndpointProfile(nextProfile.tag(), nextProfile.encapsulation(), nextProfile.getAddressProfile(), ((TaggedComponentList)componentMap.get(new Integer(nextProfile.tag()))).asArray());
        }
        return myEndpoints;
    }

    public EndpointProfile[] getImREndpoints() {
        return this.imrEndpoints;
    }

    public void setImREndpoints(EndpointProfile[] endpoints) {
        this.imrEndpoints = endpoints;
    }

    protected void checkImREndpoints(EndpointProfile[] endpoints) {
        ArrayList<EndpointProfile> endpointList = new ArrayList<EndpointProfile>(Arrays.asList(endpoints));
        block3: for (int i = endpoints.length - 1; i >= 0; --i) {
            switch (((EndpointProfile)endpointList.get((int)i)).encapsulation) {
                case 0: 
                case 2: {
                    continue block3;
                }
                default: {
                    endpointList.remove(i);
                }
            }
        }
        endpoints = endpointList.toArray(endpoints);
    }

    public void registerWithImR() throws Exception {
        if (this.isPersistent() && Environment.useImR() && !this.isShutdownInProgress()) {
            ArrayList temp = new ArrayList();
            this.getPOAName(temp);
            String[] poa = temp.toArray(new String[0]);
            if (poa.length == 0) {
                return;
            }
            EndpointProfileSeqHolder imrEndpoints = new EndpointProfileSeqHolder();
            Registration reg = new Registration();
            String impl = Environment.getProperty("jacorb.implname", "");
            EndpointProfile[] myEndpoints = this.getEndpoints();
            Server srv = this.orb.getActiveServerHandler();
            RegistrationInfo regInfo = new RegistrationInfo(impl, myEndpoints, srv);
            reg.reg(regInfo);
            long oldId = this.orb.getImRServerImpl().id();
            LongHolder id = new LongHolder(oldId);
            Repository imr = this.orb.getImR();
            try {
                imr.registerPOA(id, poa, reg, imrEndpoints);
            }
            catch (ImplActive ia) {
                Debug.output(2, ia);
                throw ia;
            }
            catch (NotFound nf) {
                Debug.output(2, nf);
                throw nf;
            }
            catch (Exception unexpected) {
                if (this.orb.imrDead(imr)) {
                    return;
                }
                Debug.output(1, "Couldn't find an ImR to register POA " + this.the_name());
                throw new NotFound();
            }
            this.orb.getImRServerImpl().id(id.value);
            this.checkImREndpoints(imrEndpoints.value);
            this.setImREndpoints(imrEndpoints.value);
        }
    }

    public void reRegisterWithImR() throws Exception {
        try {
            this.registerWithImR();
        }
        catch (ImplActive ia) {
            Debug.output(2, ia);
            Debug.output(1, "Could not re-register POA " + this.the_name() + " with new ImR (Reason: ImplActive)");
        }
        catch (NotFound nf) {
            Debug.output(2, nf);
            Debug.output(1, "Could not re-register POA " + this.the_name() + " with new ImR (Reason: NotFound)");
        }
        Enumeration kids = this.childs.elements();
        while (kids.hasMoreElements()) {
            ((POA)kids.nextElement()).reRegisterWithImR();
        }
    }

    protected void getPOAName(ArrayList name) {
        if (this.parent == null) {
            return;
        }
        if (this.parent.the_parent() == null) {
            name.add(this.name);
        } else {
            this.parent.getPOAName(name);
            name.add(this.name);
        }
    }
}

