/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.Debug;
import org.omg.CSI.IdentityToken;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class JsseContext
implements ISASContext {
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS");
    private X509Certificate client_cert = null;

    public boolean validate(ServerRequestInfo ri, byte[] contextToken) {
        this.client_cert = this.getClientCert(ri);
        return this.client_cert != null;
    }

    public String getPrincipalName() {
        if (this.client_cert == null) {
            return null;
        }
        return this.client_cert.getSubjectDN().getName();
    }

    private X509Certificate getClientCert(ServerRequestInfo ri) {
        ServerRequest request = ((ServerRequestInfoImpl)ri).request;
        GIOPConnection connection = request.getConnection();
        if (connection == null) {
            logger.warn("target has no connection!");
            return null;
        }
        if (!connection.isSSL()) {
            return null;
        }
        ServerIIOPConnection transport = (ServerIIOPConnection)connection.getTransport();
        SSLSocket sslSocket = (SSLSocket)transport.getSocket();
        try {
            return (X509Certificate)sslSocket.getSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException pue) {
            Debug.output(2, pue);
            return null;
        }
    }

    public byte[] createClientContext(ClientRequestInfo ri, CompoundSecMechList csmList) {
        return null;
    }

    public String getClientPrincipal() {
        return null;
    }

    public boolean validateContext(ServerRequestInfo ri, byte[] contextToken) {
        return false;
    }

    public String getValidatedPrincipal() {
        return null;
    }

    public void initClient() {
    }

    public void initTarget() {
    }

    public String getMechOID() {
        return "";
    }

    public IdentityToken createIdentityToken(ClientRequestInfo ri, CompoundSecMechList csmList) {
        return null;
    }
}

