/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.security.SecureRandom;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.security.ssl.sun_jsse.JSRandom;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class SSLRandom {
    private static JSRandom randomImpl;
    private static String randomClassName;
    protected Logger logger = Debug.getNamedLogger("jacorb.security.jsse");

    SSLRandom() {
        Class rndClass = null;
        if (randomClassName != null && randomClassName.length() > 0) {
            try {
                rndClass = Environment.classForName(randomClassName);
                if (JSRandom.class.isAssignableFrom(rndClass)) {
                    randomImpl = (JSRandom)rndClass.newInstance();
                } else {
                    this.logger.warn("Random class '" + randomClassName + "' is not an implementation of JSRandom interface");
                }
            }
            catch (ClassNotFoundException ex) {
                this.logger.warn("Failed to find class '" + randomClassName + "'");
            }
            catch (InstantiationException ex) {
                this.logger.warn("Failed to instantiate an instance of '" + randomClassName + "'", ex);
            }
            catch (IllegalAccessException ex) {
                this.logger.warn("Failed to instantiate an instance of '" + randomClassName + "'", ex);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using JSRandom " + randomClassName + " implemented by " + randomImpl);
            }
        }
    }

    protected SecureRandom getSecureRandom() {
        SecureRandom result = null;
        if (randomImpl != null) {
            result = randomImpl.getSecureRandom();
        }
        return result;
    }

    static {
        randomClassName = Environment.getProperty("jacorb.security.randomClassPlugin");
    }
}

