/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.GridBagPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class FileInstallDialog
extends JDialog
implements ActionListener {
    private static final String DIALOG_TITLE = "CWI Installer";
    public static final int UNKNOWN = -1;
    public static final int OVERWRITE_FILE = 0;
    public static final int BACKUP_FILE = 1;
    public static final int SKIP_FILE = 2;
    public static final int OVERWRITE_ALL = 3;
    public static final int BACKUP_ALL = 4;
    public static final int SKIP_ALL = 5;
    private Component mParent = null;
    private JButton mOverwriteButton = null;
    private JButton mBackupButton = null;
    private JButton mSkipButton = null;
    private String mDisplayText = null;
    private JCheckBox mApplyAllCheckBox = null;
    private int mActionCode = -1;

    public static int showDialog(JFrame frame, Component parent, String displayText) {
        FileInstallDialog dialog = new FileInstallDialog((Frame)frame, parent, displayText);
        dialog.setVisible(true);
        return dialog.getActionCode();
    }

    public FileInstallDialog(Frame frame, String displayText) {
        this(frame, null, displayText);
    }

    public FileInstallDialog(Frame frame, Component parent, String displayText) {
        super(frame, DIALOG_TITLE, true);
        this.mParent = parent;
        this.mDisplayText = displayText;
        this.initializeUI();
        this.toFront();
        this.requestFocus();
    }

    private void initializeUI() {
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.setBackground(Color.lightGray);
        cp.add(this.createPanel(), "Center");
    }

    protected int getActionCode() {
        return this.mActionCode;
    }

    private void closeDialog() {
        this.dispose();
    }

    private Component createPanel() {
        int y = 0;
        GridBagPanel p = new GridBagPanel();
        this.mApplyAllCheckBox = new JCheckBox("Apply Selection to All Files");
        this.mApplyAllCheckBox.setBackground(Color.lightGray);
        this.mApplyAllCheckBox.setSelected(false);
        this.mApplyAllCheckBox.setRequestFocusEnabled(true);
        this.mApplyAllCheckBox.requestFocus();
        this.mOverwriteButton = new JButton(" Overwrite ");
        Dimension buttonSize = this.mOverwriteButton.getPreferredSize();
        this.mOverwriteButton.addActionListener(this);
        this.mBackupButton = new JButton(" Backup ");
        this.mBackupButton.setPreferredSize(buttonSize);
        this.mBackupButton.addActionListener(this);
        this.mSkipButton = new JButton(" Skip ");
        this.mSkipButton.setPreferredSize(buttonSize);
        this.mSkipButton.addActionListener(this);
        p.inset(4, 2);
        p.fillBoth();
        p.anchorWest();
        JTextArea textArea = new JTextArea();
        textArea.setBackground(Color.lightGray);
        textArea.setEditable(false);
        Font font = new Font("Arial", 1, 12);
        textArea.setFont(font);
        textArea.append(this.mDisplayText);
        p.add((Component)textArea, 0, y);
        p.anchorWest();
        p.add((Component)this.mApplyAllCheckBox, 0, y += 2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 3, 3));
        buttonPanel.add(this.mOverwriteButton);
        buttonPanel.add(this.mBackupButton);
        buttonPanel.add(this.mSkipButton);
        this.mOverwriteButton.setEnabled(true);
        buttonPanel.setBackground(Color.lightGray);
        p.anchorWest();
        p.add((Component)buttonPanel, 0, ++y);
        p.setBackground(Color.lightGray);
        return p;
    }

    public void show() {
        this.displayAtCenter();
        super.show();
    }

    private boolean isApplyAll() {
        return this.mApplyAllCheckBox.isSelected();
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.isVisible()) {
            Object source = ae.getSource();
            if (source == this.mOverwriteButton) {
                this.mActionCode = this.isApplyAll() ? 3 : 0;
                this.closeDialog();
            } else if (source == this.mBackupButton) {
                this.mActionCode = this.isApplyAll() ? 4 : 1;
                this.closeDialog();
            } else if (source == this.mSkipButton) {
                this.mActionCode = this.isApplyAll() ? 5 : 2;
                this.closeDialog();
            }
        }
    }

    public void displayAtCenter() {
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension appSize = this.getSize();
        int x = (screenSize.width - appSize.width) / 2;
        int y = (screenSize.height - appSize.height) / 2;
        this.setLocation(x, y);
        this.setResizable(false);
        this.setModal(true);
    }
}

