/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.InstallerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstallOptionsDialog
extends JDialog {
    private static final String DEFAULT_CWI_DIR = System.getProperty("user.home") + File.separator;
    private Log mLog = LogFactory.getLog(InstallOptionsDialog.class);
    private JLabel mDirLabel = new JLabel();
    private JTextField mDirTextField = new JTextField();
    private JButton mBrowseButton = new JButton();
    private JPanel mMainPanel = new JPanel();
    private JPanel mButtonPanel = new JPanel();
    private JButton mInstallButton = new JButton();
    private JButton mCancelButton = new JButton();
    private JFileChooser mDirChooser = new JFileChooser();
    private boolean mOKSelected = false;
    private Component mParent = null;

    public InstallOptionsDialog(JFrame frame, Component parent) {
        super(frame, "Installation Options", true);
        this.mParent = parent;
        this.initializeUI();
    }

    private void initializeUI() {
        this.setSize(new Dimension(400, 150));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.mDirChooser.setFileSelectionMode(1);
        this.mButtonPanel.setLayout(new FlowLayout(2, 10, 10));
        this.mInstallButton.setText("Install");
        this.mInstallButton.setEnabled(true);
        this.mInstallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallOptionsDialog.this.installCWI();
            }
        });
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallOptionsDialog.this.closeInstallOptionsDialog();
            }
        });
        this.mButtonPanel.add((Component)this.mInstallButton, null);
        this.mButtonPanel.add((Component)this.mCancelButton, null);
        this.mDirLabel.setText("Install Directory:");
        this.mDirLabel.setBounds(new Rectangle(10, 10, 100, 25));
        this.mDirTextField.setBounds(new Rectangle(10, 35, 275, 30));
        this.mDirTextField.setText(DEFAULT_CWI_DIR);
        this.mDirTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                InstallOptionsDialog.this.enableInstallButton();
            }

            public void removeUpdate(DocumentEvent e) {
                InstallOptionsDialog.this.enableInstallButton();
            }

            public void changedUpdate(DocumentEvent e) {
                InstallOptionsDialog.this.enableInstallButton();
            }
        });
        this.mBrowseButton.setText("Browse...");
        this.mBrowseButton.setBounds(new Rectangle(295, 35, 90, 30));
        this.mBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallOptionsDialog.this.browseInstallDir();
            }
        });
        this.mMainPanel.setLayout(null);
        this.mMainPanel.add((Component)this.mDirLabel, null);
        this.mMainPanel.add((Component)this.mDirTextField, null);
        this.mMainPanel.add((Component)this.mBrowseButton, null);
        this.getContentPane().add((Component)this.mMainPanel, "Center");
        this.getContentPane().add((Component)this.mButtonPanel, "South");
        this.setLocationRelativeTo(this.mParent);
    }

    private void installCWI() {
        String dir = this.mDirTextField.getText();
        File installDir = new File(dir);
        if (installDir.exists() && !installDir.isDirectory()) {
            InstallerUtil.showErrorDialog(this, "Invalid Directory: " + dir);
            return;
        }
        this.mOKSelected = true;
        this.dispose();
    }

    private void closeInstallOptionsDialog() {
        this.mOKSelected = false;
        this.dispose();
    }

    private void browseInstallDir() {
        String currentDir = this.mDirTextField.getText();
        if (currentDir != null && currentDir.length() > 0) {
            try {
                File selectedDir = new File(currentDir);
                this.mDirChooser.setSelectedFile(selectedDir);
            }
            catch (Exception ex) {
                this.mLog.warn("Exception occurred while Browsing", ex);
            }
        } else {
            this.mDirChooser.setSelectedFile(new File(System.getProperty("user.home") + File.separator));
        }
        this.mDirChooser.resetChoosableFileFilters();
        this.mDirChooser.addChoosableFileFilter(this.createFileFilter());
        int returnVal = this.mDirChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.mDirChooser.getSelectedFile();
            try {
                String filePath = selectedFile.getCanonicalPath();
            }
            catch (Exception ex) {
                String filePath = selectedFile.getAbsolutePath();
                this.mLog.warn("Exception occurred while getting canonical path of " + selectedFile.getPath(), ex);
            }
            this.mDirTextField.setText(selectedFile.getAbsolutePath());
        }
    }

    private void enableInstallButton() {
        this.mInstallButton.setEnabled(this.mDirTextField.getText().length() != 0);
    }

    private FileFilter createFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return "Installation Directory";
            }
        };
    }

    public String getInstallDirectory() {
        return this.mDirTextField.getText();
    }

    public boolean isOKSelected() {
        return this.mOKSelected;
    }
}

