/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.ColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicIconFactory;

public class ColorComboBox
extends JComboBox {
    public ColorComboBox() {
        this((Color)null);
    }

    public ColorComboBox(Color color) {
        super(new ColorComboModel());
        this.setColor(color);
        this.setRenderer(new ColorRenderer());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ColorComboBox.this.getSelectedItem() == null) {
                    ColorComboBox.this.chooseCustomColor();
                } else {
                    ColorComboBox.this.fireChangeEvent();
                }
            }
        });
    }

    protected void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        ChangeListener[] l = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].stateChanged(evt);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    private void chooseCustomColor() {
        Color c = JColorChooser.showDialog(this, "Custom Color", Color.black);
        if (c != null) {
            this.setColor(c);
            this.fireChangeEvent();
        }
    }

    public void setColor(Color c) {
        for (int i = 0; i < this.getModel().getSize() - 1; ++i) {
            Color z = (Color)this.getModel().getElementAt(i);
            if (!z.equals(c)) continue;
            this.setSelectedIndex(i);
            return;
        }
        if (c != null) {
            ((ColorComboModel)this.getModel()).addColor(c);
        }
    }

    public Color getColor() {
        return (Color)this.getSelectedItem();
    }

    class ColorRenderer
    extends DefaultListCellRenderer {
        private ColorIcon icon = new ColorIcon(Color.black, new Dimension(10, 10), Color.black);

        ColorRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Color c = (Color)value;
            if (c == null) {
                this.setIcon(BasicIconFactory.getCheckBoxIcon());
                this.setText("Custom ....");
            } else {
                this.icon.setColor(c);
                this.setIcon(this.icon);
                String s = "#" + c.getRed() + "," + c.getGreen() + "," + c.getBlue();
                if (c.equals(Color.black)) {
                    s = "Black";
                } else if (c.equals(Color.white)) {
                    s = "White";
                } else if (c.equals(Color.red)) {
                    s = "Red";
                } else if (c.equals(Color.orange)) {
                    s = "Orange";
                } else if (c.equals(Color.yellow)) {
                    s = "Yellow";
                } else if (c.equals(Color.green)) {
                    s = "Green";
                } else if (c.equals(Color.blue)) {
                    s = "Blue";
                } else if (c.equals(Color.cyan)) {
                    s = "Cyan";
                } else if (c.equals(Color.magenta)) {
                    s = "Magenta";
                } else if (c.equals(Color.pink)) {
                    s = "Pink";
                } else if (c.equals(Color.lightGray)) {
                    s = "Light Gray";
                } else if (c.equals(Color.gray)) {
                    s = "Gray";
                } else if (c.equals(Color.darkGray)) {
                    s = "Dark Gray";
                }
                this.setText(s);
            }
            return this;
        }
    }

    static class ColorComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Vector colors = new Vector();
        private Object selected;

        ColorComboModel() {
            this.colors.addElement(Color.black);
            this.colors.addElement(Color.white);
            this.colors.addElement(Color.red.darker());
            this.colors.addElement(Color.red);
            this.colors.addElement(Color.orange.darker());
            this.colors.addElement(Color.orange);
            this.colors.addElement(Color.yellow.darker());
            this.colors.addElement(Color.yellow);
            this.colors.addElement(Color.green.darker());
            this.colors.addElement(Color.green);
            this.colors.addElement(Color.blue.darker());
            this.colors.addElement(Color.blue);
            this.colors.addElement(Color.cyan.darker());
            this.colors.addElement(Color.cyan);
            this.colors.addElement(Color.magenta.darker());
            this.colors.addElement(Color.magenta);
            this.colors.addElement(Color.pink.darker());
            this.colors.addElement(Color.pink);
            this.colors.addElement(Color.lightGray);
            this.colors.addElement(Color.gray);
            this.colors.addElement(Color.darkGray);
            this.selected = this.colors.elementAt(0);
        }

        public int getSize() {
            return this.colors.size() + 1;
        }

        public Object getElementAt(int i) {
            if (i == this.colors.size()) {
                return null;
            }
            return this.colors.elementAt(i);
        }

        public void setSelectedItem(Object sel) {
            this.selected = sel;
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void addColor(Color c) {
            int idx = this.colors.size();
            this.colors.addElement(c);
            this.selected = c;
            this.fireIntervalAdded(this, idx, idx);
        }
    }
}

