/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

import com.sshtools.daemon.terminal.BufferOverflowException;
import com.sshtools.daemon.terminal.CharBuffer;
import com.sshtools.daemon.terminal.TerminalIO;
import java.io.IOException;
import java.io.OutputStream;

public class UserInput
implements Runnable {
    private Buffer buf;
    private TerminalIO myIO;
    private int Cursor = 0;
    private boolean InsertMode = true;
    private int lastSize = 0;
    private boolean hardwrapped = false;
    private char lastread;
    private int lastcurspos = 0;
    private boolean maskInput = false;
    private char mask = (char)42;
    private OutputStream pout;

    public UserInput(TerminalIO io, OutputStream pout) {
        this.myIO = io;
        this.pout = pout;
        this.buf = new Buffer(this.myIO.getColumns() - 1);
        this.Cursor = 0;
        this.InsertMode = true;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public int size() {
        return this.buf.size();
    }

    public String getValue() {
        return this.buf.toString();
    }

    public void setValue(String str) throws BufferOverflowException, IOException {
        this.storeSize();
        this.buf.clear();
        this.Cursor = 0;
        this.myIO.moveLeft(this.lastSize);
        this.myIO.eraseToEndOfLine();
        this.append(str);
    }

    public void maskInput(boolean maskInput) {
        this.maskInput = maskInput;
    }

    public void setMask(char mask) {
        this.mask = mask;
    }

    public void clear() throws IOException {
        this.storeSize();
        this.buf.clear();
        this.Cursor = 0;
        this.draw();
    }

    public String getSoftwrap() throws IndexOutOfBoundsException, IOException {
        String content = this.buf.toString();
        int idx = content.lastIndexOf(" ");
        if (idx == -1) {
            content = "";
        } else {
            content = content.substring(idx + 1, content.length());
            this.Cursor = this.size();
            this.Cursor -= content.length();
            for (int i = 0; i < content.length(); ++i) {
                this.buf.removeCharAt(this.Cursor);
            }
            this.myIO.moveLeft(content.length());
            this.myIO.eraseToEndOfLine();
        }
        return content + this.getLastRead();
    }

    public String getHardwrap() throws IndexOutOfBoundsException, IOException {
        String content = this.buf.toString();
        content = content.substring(this.Cursor, content.length());
        int lastsize = this.buf.size();
        for (int i = this.Cursor; i < lastsize; ++i) {
            this.buf.removeCharAt(this.Cursor);
        }
        this.myIO.eraseToEndOfLine();
        return content;
    }

    private void setCharAt(int pos, char ch) throws IndexOutOfBoundsException, IOException {
        this.buf.setCharAt(pos, ch);
        this.draw();
    }

    private void insertCharAt(int pos, char ch) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.buf.ensureSpace(1);
        this.buf.insertCharAt(pos, ch);
        if (this.Cursor >= pos) {
            ++this.Cursor;
        }
        this.draw();
    }

    private void removeCharAt(int pos) throws IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.buf.removeCharAt(pos);
        if (this.Cursor > pos) {
            --this.Cursor;
        }
        this.draw();
    }

    private void insertStringAt(int pos, String str) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.buf.ensureSpace(str.length());
        for (int i = 0; i < str.length(); ++i) {
            this.buf.insertCharAt(pos, str.charAt(i));
            ++this.Cursor;
        }
        this.draw();
    }

    public void append(char ch) throws BufferOverflowException, IOException {
        this.storeSize();
        this.buf.ensureSpace(1);
        this.buf.append(ch);
        ++this.Cursor;
        if (!this.maskInput) {
            this.myIO.write(ch);
        } else {
            this.myIO.write(this.mask);
        }
    }

    public void append(String str) throws BufferOverflowException, IOException {
        int i;
        this.storeSize();
        this.buf.ensureSpace(str.length());
        for (i = 0; i < str.length(); ++i) {
            this.buf.append(str.charAt(i));
            ++this.Cursor;
        }
        if (!this.maskInput) {
            this.myIO.write(str);
        } else {
            for (i = 0; i < str.length(); ++i) {
                this.myIO.write(this.mask);
            }
        }
    }

    public int getCursorPosition() {
        return this.Cursor;
    }

    public void setCursorPosition(int pos) {
        this.Cursor = this.buf.size() < pos ? this.buf.size() : pos;
    }

    private char getLastRead() {
        return this.lastread;
    }

    private void setLastRead(char ch) {
        this.lastread = ch;
    }

    public boolean isInInsertMode() {
        return this.InsertMode;
    }

    public void setInsertMode(boolean b) {
        this.InsertMode = b;
    }

    public boolean isHardwrapped() {
        return this.hardwrapped;
    }

    public void setHardwrapped(boolean b) {
        this.hardwrapped = b;
    }

    public void run() {
        try {
            int in = 0;
            while (true) {
                in = this.myIO.read();
                this.lastcurspos = this.Cursor;
                switch (in) {
                    case 1004: {
                        this.moveLeft();
                        break;
                    }
                    case 1003: {
                        this.moveRight();
                        break;
                    }
                    case 1303: {
                        try {
                            if (this.Cursor == 0) break;
                            this.removeCharAt(this.Cursor - 1);
                        }
                        catch (IndexOutOfBoundsException ioobex) {
                            this.myIO.bell();
                        }
                        break;
                    }
                    case 1302: {
                        try {
                            this.removeCharAt(this.Cursor);
                        }
                        catch (IndexOutOfBoundsException ioobex) {
                            this.myIO.bell();
                        }
                        break;
                    }
                    case 10: {
                        this.myIO.write(this.myIO.getEOLString());
                        if (this.buf.size() > 0) {
                            this.pout.write(this.buf.toString().getBytes());
                        }
                        this.buf.clear();
                        this.Cursor = 0;
                        this.pout.write("\r\n".getBytes());
                        break;
                    }
                    default: {
                        try {
                            this.handleCharInput(in);
                            break;
                        }
                        catch (BufferOverflowException boex) {
                            this.setLastRead((char)in);
                        }
                    }
                }
                this.myIO.flush();
            }
        }
        catch (IOException ioe) {
            return;
        }
    }

    public void draw() throws IOException {
        this.myIO.moveLeft(this.lastcurspos);
        this.myIO.eraseToEndOfLine();
        if (!this.maskInput) {
            this.myIO.write(this.buf.toString());
        } else {
            for (int i = 0; i < this.buf.size(); ++i) {
                this.myIO.write(this.mask);
            }
        }
        if (this.Cursor < this.buf.size()) {
            this.myIO.moveLeft(this.buf.size() - this.Cursor);
        }
    }

    private boolean moveRight() throws IOException {
        if (this.Cursor < this.buf.size()) {
            ++this.Cursor;
            this.myIO.moveRight(1);
            return true;
        }
        return false;
    }

    private boolean moveLeft() throws IOException {
        if (this.Cursor > 0) {
            --this.Cursor;
            this.myIO.moveLeft(1);
            return true;
        }
        return false;
    }

    private boolean isCursorAtEnd() {
        return this.Cursor == this.buf.size();
    }

    private void handleCharInput(int ch) throws BufferOverflowException, IOException {
        if (this.isCursorAtEnd()) {
            this.append((char)ch);
        } else if (this.isInInsertMode()) {
            try {
                this.insertCharAt(this.Cursor, (char)ch);
            }
            catch (BufferOverflowException ex) {
                this.myIO.bell();
            }
        } else {
            this.setCharAt(this.Cursor, (char)ch);
        }
    }

    private void storeSize() {
        this.lastSize = this.buf.size();
    }

    class Buffer
    extends CharBuffer {
        public Buffer(int size) {
            super(size);
        }
    }
}

