/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.transport;

import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.AlgorithmNotAgreedException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.MessageAlreadyRegisteredException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageListener;
import com.sshtools.j2ssh.transport.SshMsgKexInit;
import com.sshtools.j2ssh.transport.SshMsgServiceRequest;
import com.sshtools.j2ssh.transport.TransportProtocolCommon;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportProtocolServer
extends TransportProtocolCommon
implements SshMessageListener {
    private static Log log = LogFactory.getLog(TransportProtocolServer.class);
    private Map acceptServices = new HashMap();
    private ServerConfiguration config;
    private boolean refuse = false;
    private Vector services = new Vector();

    public TransportProtocolServer() throws IOException {
        this.config = (ServerConfiguration)ConfigurationLoader.getConfiguration(ServerConfiguration.class);
    }

    public TransportProtocolServer(boolean refuse) throws IOException {
        this();
        this.refuse = refuse;
    }

    protected void onDisconnect() {
        this.acceptServices.clear();
        Iterator it = this.services.iterator();
        while (it.hasNext()) {
            ((Service)it.next()).stop();
        }
        this.services.clear();
    }

    public void acceptService(Service service) throws IOException {
        this.acceptServices.put(service.getServiceName(), service);
    }

    public void refuseConnection() throws IOException {
        log.info("Refusing connection");
        this.sendDisconnect(12, "Too many connections");
    }

    public void registerTransportMessages() throws MessageAlreadyRegisteredException {
        this.messageStore.registerMessage(5, SshMsgServiceRequest.class, this);
    }

    protected void startBinaryPacketProtocol() throws IOException {
        if (this.refuse) {
            this.sendKeyExchangeInit();
            this.refuseConnection();
        } else {
            super.startBinaryPacketProtocol();
        }
    }

    protected String getDecryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSEncryption(), this.serverKexInit.getSupportedCSEncryption());
    }

    protected String getEncryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCEncryption(), this.serverKexInit.getSupportedSCEncryption());
    }

    protected String getInputStreamCompAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSComp(), this.serverKexInit.getSupportedCSComp());
    }

    protected String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSMac(), this.serverKexInit.getSupportedCSMac());
    }

    protected void setLocalIdent() {
        this.serverIdent = "SSH-2.0-" + SOFTWARE_VERSION_COMMENTS + " [SERVER]";
    }

    public String getLocalId() {
        return this.serverIdent;
    }

    protected void setLocalKexInit(SshMsgKexInit msg) {
        log.debug(msg.toString());
        this.serverKexInit = msg;
    }

    protected SshMsgKexInit getLocalKexInit() {
        return this.serverKexInit;
    }

    protected String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCComp(), this.serverKexInit.getSupportedSCComp());
    }

    protected String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCMac(), this.serverKexInit.getSupportedSCMac());
    }

    protected void setRemoteIdent(String ident) {
        this.clientIdent = ident;
    }

    public String getRemoteId() {
        return this.clientIdent;
    }

    protected void setRemoteKexInit(SshMsgKexInit msg) {
        log.debug(msg.toString());
        this.clientKexInit = msg;
    }

    protected SshMsgKexInit getRemoteKexInit() {
        return this.clientKexInit;
    }

    protected SshMsgKexInit createLocalKexInit() throws IOException {
        ArrayList available;
        SshMsgKexInit msg = new SshMsgKexInit(this.properties);
        Map keys = this.config.getServerHostKeys();
        if (keys.size() > 0) {
            Iterator it = keys.entrySet().iterator();
            available = new ArrayList();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (SshKeyPairFactory.supportsKey(entry.getKey().toString())) {
                    available.add(entry.getKey());
                    continue;
                }
                log.warn("Server host key algorithm '" + entry.getKey().toString() + "' not supported");
            }
            if (available.size() <= 0) {
                throw new TransportProtocolException("No server host keys available");
            }
        } else {
            throw new TransportProtocolException("There are no server host keys available");
        }
        msg.setSupportedPK(available);
        return msg;
    }

    protected void onStartTransportProtocol() throws IOException {
    }

    protected void performKeyExchange(SshKeyExchange kex, boolean firstPacketFollows, boolean useFirstPacket) throws IOException {
        String keyType = this.determineAlgorithm(this.clientKexInit.getSupportedPublicKeys(), this.serverKexInit.getSupportedPublicKeys());
        Map keys = this.config.getServerHostKeys();
        for (Map.Entry entry : keys.entrySet()) {
            if (!entry.getKey().equals(keyType)) continue;
            SshPrivateKey pk = (SshPrivateKey)entry.getValue();
            kex.performServerExchange(this.clientIdent, this.serverIdent, this.clientKexInit.toByteArray(), this.serverKexInit.toByteArray(), pk, firstPacketFollows, useFirstPacket);
            return;
        }
        throw new KeyExchangeException("No host key available for the determined public key algorithm");
    }

    public void onMessageReceived(SshMessage msg) throws IOException {
        switch (msg.getMessageId()) {
            case 5: {
                this.onMsgServiceRequest((SshMsgServiceRequest)msg);
            }
        }
    }

    protected void setupNewKeys(byte[] encryptCSKey, byte[] encryptCSIV, byte[] encryptSCKey, byte[] encryptSCIV, byte[] macCSKey, byte[] macSCKey) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException {
        SshCipher sshCipher = SshCipherFactory.newInstance(this.encryptionInUse);
        sshCipher.init(0, encryptSCIV, encryptSCKey);
        this.algorithmsOut.setCipher(sshCipher);
        sshCipher = SshCipherFactory.newInstance(this.decryptionInUse);
        sshCipher.init(1, encryptCSIV, encryptCSKey);
        this.algorithmsIn.setCipher(sshCipher);
        SshHmac hmac = SshHmacFactory.newInstance(this.outgoingMacInUse);
        hmac.init(macSCKey);
        this.algorithmsOut.setHmac(hmac);
        hmac = SshHmacFactory.newInstance(this.incomingMacInUse);
        hmac.init(macCSKey);
        this.algorithmsIn.setHmac(hmac);
        SshCompression compression = SshCompressionFactory.newInstance(this.incomingCompInUse);
        if (compression != null) {
            compression.init(0, 1);
            this.algorithmsIn.setCompression(compression);
        }
        if ((compression = SshCompressionFactory.newInstance(this.outgoingCompInUse)) != null) {
            compression.init(1, 1);
            this.algorithmsIn.setCompression(compression);
        }
    }

    private void onMsgServiceRequest(SshMsgServiceRequest msg) throws IOException {
        if (this.acceptServices.containsKey(msg.getServiceName())) {
            Service service = (Service)this.acceptServices.get(msg.getServiceName());
            service.init(2, this);
            service.start();
            this.services.add(service);
        } else {
            this.sendDisconnect(7, msg.getServiceName() + " is not available");
        }
    }
}

