/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.compression;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshCompressionFactory {
    public static final String COMP_NONE = "none";
    private static String defaultAlgorithm;
    private static Map comps;
    private static Log log;

    protected SshCompressionFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultCompression() {
        return defaultAlgorithm;
    }

    public static List getSupportedCompression() {
        return new ArrayList(comps.keySet());
    }

    public static SshCompression newInstance(String algorithmName) throws AlgorithmNotSupportedException {
        try {
            if (algorithmName.equals(COMP_NONE)) {
                return null;
            }
            return (SshCompression)((Class)comps.get(algorithmName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog(SshCompressionFactory.class);
        comps = new HashMap();
        log.info("Loading compression methods");
        comps.put(COMP_NONE, "");
        defaultAlgorithm = COMP_NONE;
        try {
            Enumeration<URL> enumer = ConfigurationLoader.getExtensionClassLoader().getResources("j2ssh.compression");
            Properties properties = new Properties();
            while (enumer != null && enumer.hasMoreElements()) {
                URL url = enumer.nextElement();
                InputStream in = url.openStream();
                properties.load(in);
                IOUtil.closeStream(in);
                int num = 1;
                String name = "";
                while (properties.getProperty("compression.name." + String.valueOf(num)) != null) {
                    try {
                        name = properties.getProperty("compression.name." + String.valueOf(num));
                        Class<?> cls = ConfigurationLoader.getExtensionClassLoader().loadClass(properties.getProperty("compression.class." + String.valueOf(num)));
                        cls.newInstance();
                        comps.put(name, cls);
                        log.info("Installed " + name + " compression");
                    }
                    catch (Throwable ex) {
                        log.info("Could not install cipher class for " + name, ex);
                    }
                    ++num;
                }
            }
        }
        catch (Throwable t) {
            log.info("Failed to load compression algorithms", t);
        }
    }
}

