/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.sshtools.j2ssh.util.Base64;

public class OpenSSHPublicKeyFormat
implements SshPublicKeyFormat {
    String comment = null;

    public OpenSSHPublicKeyFormat(String comment) {
        this.setComment(comment);
    }

    public OpenSSHPublicKeyFormat() {
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public String getFormatType() {
        return "OpenSSH-PublicKey";
    }

    public byte[] getKeyBlob(byte[] formattedKey) throws InvalidSshKeyException {
        int i2;
        String algorithm;
        String temp = new String(formattedKey);
        int i = temp.indexOf(" ");
        if (i > 0 && this.supportsAlgorithm(algorithm = temp.substring(0, i)) && (i2 = temp.indexOf(" ", i + 1)) > i) {
            String encoded = temp.substring(i + 1, i2);
            if (temp.length() > i2) {
                this.comment = temp.substring(i2 + 1).trim();
            }
            return Base64.decode(encoded);
        }
        throw new InvalidSshKeyException("Failed to read OpenSSH key format");
    }

    public byte[] formatKey(byte[] keyblob) {
        String algorithm = ByteArrayReader.readString(keyblob, 0);
        String formatted = algorithm + " " + Base64.encodeBytes(keyblob, true);
        if (this.comment != null) {
            formatted = formatted + " " + this.comment;
        }
        return formatted.getBytes();
    }

    public boolean isFormatted(byte[] formattedKey) {
        String test = new String(formattedKey).trim();
        return test.startsWith("ssh-dss") || test.startsWith("ssh-rsa");
    }

    public boolean supportsAlgorithm(String algorithm) {
        return algorithm.equals("ssh-dss") || algorithm.equals("ssh-rsa");
    }
}

