/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.ChannelInputStream;
import com.sshtools.j2ssh.connection.ChannelOutputStream;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import de.mud.jta.HostUnreachableException;
import de.mud.jta.ICliSessionDelegatee;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSHv2Session
implements ICliSessionDelegatee {
    private Log log = LogFactory.getLog(SSHv2Session.class);
    private static final int MAX_LINE_LENGTH = 1024;
    private boolean mIsTimeoutAcceptable = false;
    private SshClient mSSHClient = new SshClient();
    private SessionChannelClient mSession = null;
    private ChannelOutputStream mOutStream = null;
    private ChannelInputStream mInStream = null;
    private int mTimeout = 0;

    public void connect(String host, int port) throws IOException {
        SshConnectionProperties properties = new SshConnectionProperties();
        properties.setHost(host);
        properties.setPort(port);
        properties.setPrefPublicKey("ssh-dss");
        this.mSSHClient.setSocketTimeout(5000);
        this.mSSHClient.connect(properties, new HostKeyVerification(){

            public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
                return true;
            }
        });
        this.mSSHClient.addEventHandler(new SshEventListener());
        this.mSSHClient.setSocketTimeout(0);
    }

    public void login(String username, String password) throws IOException {
        int result;
        block6: {
            PasswordAuthenticationClient pwd = new PasswordAuthenticationClient();
            pwd.setUsername(username);
            pwd.setPassword(password);
            result = 0;
            try {
                result = this.mSSHClient.authenticate(pwd);
            }
            catch (IOException e) {
                if (!(e instanceof AuthenticationProtocolException)) break block6;
                this.log.debug("Authentication failed. Wrong username.");
                throw new HostUnreachableException("Wrong UserName/Password combination.", "Login with correct UserName and Password.");
            }
        }
        if (result == 4) {
            this.mSession = this.mSSHClient.openSessionChannel();
        }
        if (result == 2) {
            this.log.debug("Authentication failed. Wrong password.");
            throw new HostUnreachableException("Wrong UserName/Password combination.", "Login with correct UserName and Password.");
        }
        if (!this.mSession.requestPseudoTerminal("vt100", 80, 24, 0, 0, "")) {
            this.log.debug("Failed to allocate a pseudo terminal");
        }
        if (!this.mSession.startShell()) {
            throw new IOException("Unable to start SSH shell");
        }
        this.mOutStream = this.mSession.getOutputStream();
        this.mInStream = this.mSession.getInputStream();
        this.log.debug("Setting inStream timeout to " + this.mTimeout);
        this.mInStream.setBlockInterrupt(this.mTimeout);
    }

    public void disconnect() throws IOException {
        this.mSSHClient.disconnect();
    }

    public void setReadTimeout(int milisecs) {
        this.log.debug("Setting SSH Client socket timeout to " + milisecs);
        this.mSSHClient.setSocketTimeout(milisecs);
        this.mTimeout = milisecs;
        if (this.mInStream != null) {
            this.log.debug("Setting inStream timeout to " + this.mTimeout);
            this.mInStream.setBlockInterrupt(milisecs);
        }
    }

    public boolean isClosed() {
        return !this.mSSHClient.isConnected();
    }

    public int read(byte[] b) throws IOException {
        byte[] originalBytes = new byte[b.length];
        int n = -1;
        boolean validSocketTimeout = false;
        try {
            n = this.mInStream.read(originalBytes, 0, b.length);
        }
        catch (SocketTimeoutException ste) {
            if (!this.mIsTimeoutAcceptable) {
                throw ste;
            }
            validSocketTimeout = true;
            this.log.debug("SocketTimeOutException: " + ste);
        }
        if (n > 0) {
            int counter = 0;
            int j = 0;
            for (int i = 0; i < n; ++i) {
                if (originalBytes[i] == 27) {
                    counter += 3;
                    i += 2;
                    continue;
                }
                b[j++] = originalBytes[i];
            }
            n -= counter;
        } else if (n < 0 && !validSocketTimeout) {
            this.log.error("read() returned -1 - connection closed by foreign host");
            throw new HostUnreachableException("Connection closed by foreign host.", "Please verify device connectivity and configuration.");
        }
        return n;
    }

    public void write(byte[] bytes) throws IOException {
        this.mOutStream.write(bytes);
    }

    public void setTimeoutAcceptable(boolean isTimeoutAcceptable) {
        this.mIsTimeoutAcceptable = isTimeoutAcceptable;
    }

    static {
        try {
            ConfigurationLoader.initialize(false);
        }
        catch (Exception ex) {
            LogFactory.getLog(SSHv2Session.class).error("Error while initializing SSHv2", ex);
        }
    }

    class SshEventListener
    extends SshEventAdapter {
        SshEventListener() {
        }

        public void onDisconnect(TransportProtocol transport) {
            try {
                if (SSHv2Session.this.mSession != null) {
                    SSHv2Session.this.log.warn("Disconnect event received - closing SSH session");
                    SSHv2Session.this.mSession.close();
                }
            }
            catch (IOException ioe) {
                SSHv2Session.this.log.error("Exception closing SSH session", ioe);
            }
        }
    }
}

