/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.ScriptHandler;
import java.util.ArrayList;

public class Utilities {
    public static String createPreamble(String cliCommand) {
        String preamble = cliCommand;
        if (Utilities.isBackspacesAndControlChars(preamble)) {
            preamble = null;
        }
        if (preamble != null && preamble.endsWith("\t")) {
            preamble = preamble.substring(0, preamble.length() - 1);
        }
        return preamble;
    }

    public static boolean isBackspacesAndControlChars(String testString) {
        boolean isSpecialChar = true;
        if (testString != null) {
            for (int ii = 0; ii < testString.length(); ++ii) {
                char testChar = testString.charAt(ii);
                if (Character.isWhitespace(testChar) || Character.isISOControl(testChar)) continue;
                isSpecialChar = false;
                break;
            }
        }
        return isSpecialChar;
    }

    public static byte[] dataAfterPreamble(String data, String preamble) {
        int preambleOffset;
        String extraData;
        byte[] dataAfterPreamble = null;
        int preamLen = preamble.length();
        int dataLen = data.length();
        if (dataLen > preamLen && (extraData = data.substring((preambleOffset = data.indexOf(preamble)) + preamLen)).length() > 0) {
            dataAfterPreamble = extraData.getBytes();
        }
        return dataAfterPreamble;
    }

    public static ScriptHandler[] getScriptHandlers(String[] searchElements) {
        ArrayList<ScriptHandler> handlers = new ArrayList<ScriptHandler>();
        for (int i = 0; i < searchElements.length; ++i) {
            ScriptHandler handler = new ScriptHandler();
            handler.setup(searchElements[i]);
            handlers.add(handler);
            String substituted = Utilities.substituteNewLines(searchElements[i]);
            if (substituted == null) continue;
            handler = new ScriptHandler();
            handler.setup(substituted);
            handlers.add(handler);
        }
        ScriptHandler[] handlerArray = handlers.toArray(new ScriptHandler[handlers.size()]);
        return handlerArray;
    }

    public static String substituteNewLines(String originalString) {
        String substituted = null;
        int newlineIndex = originalString.indexOf("\n");
        StringBuffer tempBuffer = new StringBuffer();
        int start = 0;
        while (newlineIndex != -1) {
            tempBuffer.append(originalString.substring(start, newlineIndex));
            tempBuffer.append("\r\n");
            newlineIndex = originalString.indexOf("\n", newlineIndex + 1);
        }
        if (tempBuffer.length() > 0) {
            substituted = tempBuffer.toString();
        }
        return substituted;
    }
}

