/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CircuitType;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.LoPathWidth;
import cerent.util.AbstractEnumBehavior;
import cerent.util.KDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class CircuitSize
extends AbstractEnumBehavior
implements ICircuitSize,
Comparable {
    static ICircuitSize[] ICircuitSizeArrayTemplate = new ICircuitSize[0];
    protected static AbstractEnumBehavior.EnumRange Range = new AbstractEnumBehavior.EnumRange(CircuitSize.class);
    protected static final short UNDEFINED_HO_WIDTH = 0;
    protected static final short UNDEFINED_LO_WIDTH = -1;
    public static int UNDEFINED_TYPE = -1;
    public static int UNDEFINED_SIZE = -1;
    protected static int IS_SONET = 1;
    protected static int IS_SDH = 2;
    protected static int UNDEFINED_GROUP_SIZE = -1;
    protected static int IS_OCHNC = 3;
    protected static int IS_OCH_TRAIL = 4;
    protected static ICircuitSize[] LoPathWidth2CircuitSize = new ICircuitSize[1 + LoPathWidth.LoPathWidthHiEnum - LoPathWidth.LoPathWidthLoEnum];
    static final int NUM_TYPES = Range.getNumTypes();
    protected static CircuitSize[] CircuitSizes = new CircuitSize[NUM_TYPES];
    protected static int[] SortedHOPathWidths = new int[NUM_TYPES];
    protected static CircuitSize[] BySonetHOPathWidth = new CircuitSize[NUM_TYPES];
    protected static CircuitSize[] BySdhHOPathWidth = new CircuitSize[NUM_TYPES];
    static final int VT15_IN_GROUP = 4;
    public static final CircuitSize SIZE_VT_1_5 = new CircuitSize(0, "VT1.5", 0, 0, IS_SONET, 4, 1.728f);
    static final int VT2_IN_GROUP = 3;
    public static final CircuitSize SIZE_VT_2 = new CircuitSize(30, "VT2", 0, 1, IS_SONET, 3, 2.304f);
    public static final CircuitSize SIZE_STS_1 = new CircuitSize(1, "STS-1", 1, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 51.84f);
    public static final CircuitSize SIZE_STS_3C = new CircuitSize(2, "STS-3c", 3, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 155.52f);
    public static final CircuitSize SIZE_STS_6C = new CircuitSize(3, "STS-6c", 6, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 311.04f);
    public static final CircuitSize SIZE_STS_12C = new CircuitSize(4, "STS-12c", 12, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 622.08f);
    public static final CircuitSize SIZE_STS_48C = new CircuitSize(5, "STS-48c", 48, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 2488.32f);
    public static final CircuitSize SIZE_STS_192C = new CircuitSize(6, "STS-192c", 192, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 9953.28f);
    public static final CircuitSize SIZE_STS_9C = new CircuitSize(7, "STS-9c", 9, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 466.56f);
    public static final CircuitSize SIZE_STS_24C = new CircuitSize(8, "STS-24c", 24, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 1244.16f);
    public static final CircuitSize SIZE_STS_96C = new CircuitSize(32, "STS-96c", 96, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 4976.64f);
    public static final CircuitSize SIZE_VC_4_32C = new CircuitSize(33, "VC4-32c", 96, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 4976.64f);
    static final int VC11_IN_TUG2 = 4;
    static final int VC12_IN_TUG2 = 3;
    public static final CircuitSize SIZE_VC_11 = new CircuitSize(9, "VC11", 0, 5, IS_SDH, 4, 1.728f);
    public static final CircuitSize SIZE_VC_12 = new CircuitSize(10, "VC12", 0, 6, IS_SDH, 3, 2.304f);
    public static final CircuitSize SIZE_VC_3 = new CircuitSize(11, "VC3", 1, 7, IS_SDH, 1, 51.84f);
    public static final CircuitSize SIZE_VC_4 = new CircuitSize(12, "VC4", 3, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 155.52f);
    public static final CircuitSize SIZE_VC_4_2C = new CircuitSize(13, "VC4-2c", 6, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 311.04f);
    public static final CircuitSize SIZE_VC_4_3C = new CircuitSize(14, "VC4-3c", 9, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 466.56f);
    public static final CircuitSize SIZE_VC_4_4C = new CircuitSize(15, "VC4-4c", 12, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 622.08f);
    public static final CircuitSize SIZE_VC_4_8C = new CircuitSize(16, "VC4-8c", 24, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 1244.16f);
    public static final CircuitSize SIZE_VC_4_16C = new CircuitSize(17, "VC4-16c", 48, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 2488.32f);
    public static final CircuitSize SIZE_VC_4_64C = new CircuitSize(18, "VC4-64c", 192, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 9953.28f);
    public static final CircuitSize SIZE_STS_36C = new CircuitSize(25, "STS-36c", 36, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 1866.24f);
    public static final CircuitSize SIZE_VC_4_12C = new CircuitSize(26, "VC4-12c", 36, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 1866.24f);
    public static final CircuitSize SIZE_STS_18C = new CircuitSize(27, "STS-18c", 18, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 933.12f);
    public static final CircuitSize SIZE_VC_4_6C = new CircuitSize(28, "VC4-6c", 18, -1, IS_SDH, UNDEFINED_GROUP_SIZE, 933.12f);
    public static final CircuitSize SIZE_OCHNC_ENS = new CircuitSize(19, "Equipped non-specific", 0, -1, IS_OCHNC, UNDEFINED_GROUP_SIZE, 0.0f);
    public static final CircuitSize SIZE_OCHNC_MR = new CircuitSize(20, "Multi-rate", 0, -1, IS_OCHNC, UNDEFINED_GROUP_SIZE, 0.0f);
    public static final CircuitSize SIZE_OCHNC_2_5G = new CircuitSize(21, "2.5 Gb/s No FEC", 0, -1, IS_OCHNC, UNDEFINED_GROUP_SIZE, 0.0f);
    public static final CircuitSize SIZE_OCHNC_2_5G_FEC = new CircuitSize(22, "2.5 Gb/s FEC", 0, -1, IS_OCHNC, UNDEFINED_GROUP_SIZE, 0.0f);
    public static final CircuitSize SIZE_OCHNC_10G = new CircuitSize(23, "10 Gb/s No FEC", 0, -1, IS_OCHNC, UNDEFINED_GROUP_SIZE, 0.0f);
    public static final CircuitSize SIZE_OCHNC_10G_FEC = new CircuitSize(24, "10 Gb/s FEC", 0, -1, IS_OCHNC, UNDEFINED_GROUP_SIZE, 0.0f);
    public static final CircuitSize SIZE_OCHCC = new CircuitSize(31, "OCHCC", 0, -1, IS_OCH_TRAIL, UNDEFINED_GROUP_SIZE, 0.0f);
    public static final CircuitSize SIZE_NULL = new CircuitSize(29, "No Size specified", 0, -1, IS_SONET, UNDEFINED_GROUP_SIZE, 0.0f);
    private static boolean _DidFinishEnumProcessing = CircuitSize._FinishEnumProcessing();
    protected final short hoPathWidth;
    protected final short loPathWidth;
    protected final String cktSizeStr;
    protected int protocolType;
    protected int loGroupSize;
    protected float bandwidth;
    private static final HashMap portEqTypeMap = new HashMap();
    private static final KDebug db;

    private static boolean _FinishEnumProcessing() {
        Arrays.sort(SortedHOPathWidths);
        block0: for (int i = 0; i < NUM_TYPES; ++i) {
            CircuitSize circuitSize;
            int n;
            int n2 = SortedHOPathWidths[i];
            if (n2 == Integer.MAX_VALUE) continue;
            for (n = 0; n < NUM_TYPES; ++n) {
                circuitSize = CircuitSizes[n];
                if (circuitSize.protocolType != IS_SONET || circuitSize.hoPathWidth != n2) continue;
                CircuitSize.BySonetHOPathWidth[i] = circuitSize;
                break;
            }
            for (n = 0; n < NUM_TYPES; ++n) {
                circuitSize = CircuitSizes[n];
                if (circuitSize.protocolType != IS_SDH || circuitSize.hoPathWidth != n2) continue;
                CircuitSize.BySdhHOPathWidth[i] = circuitSize;
                continue block0;
            }
        }
        return true;
    }

    protected CircuitSize(int n, String string, short s, short s2, int n2, int n3, float f) {
        super(CircuitSizes, n);
        this.cktSizeStr = string;
        this.hoPathWidth = s;
        this.loPathWidth = s2;
        CircuitSize.SortedHOPathWidths[n] = Integer.MAX_VALUE;
        if (s2 != -1) {
            CircuitSize.LoPathWidth2CircuitSize[s2] = this;
        } else if (s != 0) {
            CircuitSize.SortedHOPathWidths[n] = s;
        }
        this.protocolType = n2;
        this.loGroupSize = n3;
        this.bandwidth = f;
        CircuitSize.CircuitSizes[n] = this;
    }

    public static ICircuitSize getCircuitSize(int n) {
        return CircuitSizes[n];
    }

    public static ICircuitSize[] getAllCircuitSizes() {
        return CircuitSizes;
    }

    public String toString() {
        return this.cktSizeStr;
    }

    public boolean isLo(int n) {
        boolean bl = this.getEnum() == 11;
        boolean bl2 = bl && n == 1 || !bl && this.loPathWidth != -1;
        return bl2;
    }

    public boolean isOchnc() {
        return this.protocolType == IS_OCHNC;
    }

    public String getCircuitSizeString() {
        return this.cktSizeStr;
    }

    public short size2widthOfLoCircuit() {
        if (this.loPathWidth == -1) {
            throw new IllegalArgumentException("The circuit size is invalid for a VT or VC circuit.");
        }
        return this.loPathWidth;
    }

    public short size2widthOfHoCircuit() {
        if (this.hoPathWidth == 0) {
            throw new IllegalArgumentException("The HO circuit size " + this.enumeration + " is invalid.");
        }
        return this.hoPathWidth;
    }

    public static ICircuitSize width2sizeOfLoCircuit(int n) {
        ICircuitSize iCircuitSize = null;
        if (0 <= n && n <= 7) {
            iCircuitSize = LoPathWidth2CircuitSize[n];
        }
        if (iCircuitSize == null) {
            throw new IllegalArgumentException("The width is invalid for a VT or VC circuit.");
        }
        return iCircuitSize;
    }

    public static ICircuitSize width2sizeOfHoCircuit(int n, int n2) {
        return CircuitSize.width2sizeOfHoCircuit(n, FramingType.getFramingType(n2).getTdmProtocolType());
    }

    public static ICircuitSize width2sizeOfHoCircuit(int n, ITdmProtocolType iTdmProtocolType) {
        int n2;
        CircuitSize circuitSize = null;
        boolean bl = iTdmProtocolType.isSonet();
        if (n != 0 && n != Integer.MAX_VALUE && (n2 = Arrays.binarySearch(SortedHOPathWidths, n)) >= 0) {
            int n3 = SortedHOPathWidths[n2];
            circuitSize = bl ? BySonetHOPathWidth[n2] : BySdhHOPathWidth[n2];
        }
        if (circuitSize == null) {
            throw new IllegalArgumentException("The width " + n + " is invalid for an HO circuit.");
        }
        return circuitSize;
    }

    private static HashSet getOchncCircuitSizes() {
        HashSet<CircuitSize> hashSet = new HashSet<CircuitSize>();
        for (int i = 0; i < CircuitSizes.length; ++i) {
            CircuitSize circuitSize = CircuitSizes[i];
            if (circuitSize.protocolType != IS_OCHNC) continue;
            hashSet.add(circuitSize);
        }
        return hashSet;
    }

    private static HashSet getOchccCircuitSizes() {
        HashSet<CircuitSize> hashSet = new HashSet<CircuitSize>();
        CircuitSize circuitSize = SIZE_OCHCC;
        hashSet.add(circuitSize);
        return hashSet;
    }

    private static HashSet getOchtrailCircuitSizes() {
        HashSet<CircuitSize> hashSet = new HashSet<CircuitSize>();
        CircuitSize circuitSize = SIZE_OCHNC_ENS;
        hashSet.add(circuitSize);
        return hashSet;
    }

    private static HashSet getLoCircuitSizes() {
        HashSet<CircuitSize> hashSet = new HashSet<CircuitSize>();
        for (int i = 0; i < CircuitSizes.length; ++i) {
            CircuitSize circuitSize = CircuitSizes[i];
            if (circuitSize.loPathWidth == -1) continue;
            hashSet.add(circuitSize);
        }
        return hashSet;
    }

    private static HashSet getHoCircuitSizes() {
        HashSet<CircuitSize> hashSet = new HashSet<CircuitSize>();
        for (int i = 0; i < CircuitSizes.length; ++i) {
            CircuitSize circuitSize = CircuitSizes[i];
            if (circuitSize.hoPathWidth == 0) continue;
            hashSet.add(circuitSize);
        }
        return hashSet;
    }

    private static HashSet getHoVcatCircuitSizes() {
        HashSet<CircuitSize> hashSet = new HashSet<CircuitSize>();
        for (int i = 0; i < CircuitSizes.length; ++i) {
            CircuitSize circuitSize = CircuitSizes[i];
            if (circuitSize.hoPathWidth == 0 || circuitSize != SIZE_STS_1 && circuitSize != SIZE_STS_3C && circuitSize != SIZE_STS_12C && circuitSize != SIZE_VC_4 && circuitSize != SIZE_VC_4_4C && circuitSize != SIZE_VC_3) continue;
            hashSet.add(circuitSize);
        }
        return hashSet;
    }

    private static HashSet getLoVcatCircuitSizes() {
        HashSet<CircuitSize> hashSet = new HashSet<CircuitSize>();
        for (int i = 0; i < CircuitSizes.length; ++i) {
            CircuitSize circuitSize = CircuitSizes[i];
            if (circuitSize.loPathWidth == -1 || circuitSize != SIZE_VC_3 && circuitSize != SIZE_VC_12 && circuitSize != SIZE_VT_1_5) continue;
            hashSet.add(circuitSize);
        }
        return hashSet;
    }

    private static HashSet getTunnelCircuitSizes() {
        HashSet<ICircuitSize> hashSet = new HashSet<ICircuitSize>();
        ICircuitSize iCircuitSize = CircuitSize.getLoTunnelSize(0);
        ICircuitSize iCircuitSize2 = CircuitSize.getLoTunnelSize(1);
        ICircuitSize iCircuitSize3 = CircuitSize.getLoTunnelSize(2);
        hashSet.add(iCircuitSize);
        hashSet.add(iCircuitSize3);
        hashSet.add(iCircuitSize2);
        return hashSet;
    }

    protected static HashSet getCircuitSizesByCategory(ICircuitType iCircuitType) {
        if (iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType()) {
            return CircuitSize.getTunnelCircuitSizes();
        }
        if (iCircuitType.isLoCircuitType()) {
            return CircuitSize.getLoCircuitSizes();
        }
        if (iCircuitType.isHoCircuitType()) {
            return CircuitSize.getHoCircuitSizes();
        }
        if (iCircuitType.isOchncType()) {
            return CircuitSize.getOchncCircuitSizes();
        }
        if (iCircuitType.isOchccCircuitType()) {
            return CircuitSize.getOchccCircuitSizes();
        }
        if (iCircuitType.isOchTrailTunnelCircuitType()) {
            return CircuitSize.getOchtrailCircuitSizes();
        }
        if (iCircuitType.isHoVcatCircuitType()) {
            return CircuitSize.getHoVcatCircuitSizes();
        }
        if (iCircuitType.isLoVcatCircuitType()) {
            return CircuitSize.getLoVcatCircuitSizes();
        }
        return new HashSet();
    }

    protected static HashSet getCircuitSizesByProtocol(ICircuitType iCircuitType) {
        HashSet<CircuitSize> hashSet = new HashSet<CircuitSize>();
        if (iCircuitType.isSonetType()) {
            for (int i = 0; i < CircuitSizes.length; ++i) {
                CircuitSize circuitSize = CircuitSizes[i];
                if (circuitSize.protocolType != IS_SONET) continue;
                hashSet.add(circuitSize);
            }
        } else if (iCircuitType.isOchncType()) {
            for (int i = 0; i < CircuitSizes.length; ++i) {
                CircuitSize circuitSize = CircuitSizes[i];
                if (circuitSize.protocolType != IS_OCHNC) continue;
                hashSet.add(circuitSize);
            }
        } else if (iCircuitType.isOchccCircuitType()) {
            CircuitSize circuitSize = SIZE_OCHCC;
            hashSet.add(circuitSize);
        } else if (iCircuitType.isOchTrailTunnelCircuitType()) {
            CircuitSize circuitSize = SIZE_OCHNC_ENS;
            hashSet.add(circuitSize);
        } else {
            for (int i = 0; i < CircuitSizes.length; ++i) {
                CircuitSize circuitSize = CircuitSizes[i];
                if (circuitSize.protocolType != IS_SDH) continue;
                hashSet.add(circuitSize);
            }
        }
        return hashSet;
    }

    protected static HashSet getCircuitSizesByFrameType(int n, ICircuitType iCircuitType) {
        HashSet hashSet = CircuitSize.getCircuitSizesByProtocol(iCircuitType);
        if (n == 1 && iCircuitType.isHoCircuitType()) {
            hashSet.remove(SIZE_VC_3);
        }
        return hashSet;
    }

    public static ICircuitSize[] getCircuitSizes(int n, FramingType[] framingTypeArray) {
        ICircuitType iCircuitType = CircuitType.getCircuitType(n);
        boolean bl = false;
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            bl = true;
        }
        HashSet hashSet = CircuitSize.getCircuitSizesByCategory(iCircuitType);
        HashSet hashSet2 = new HashSet();
        for (int i = 0; i < framingTypeArray.length; ++i) {
            hashSet2.addAll(CircuitSize.getCircuitSizesByFrameType(framingTypeArray[i].getEnum(), iCircuitType));
        }
        hashSet.retainAll(hashSet2);
        return hashSet.toArray(ICircuitSizeArrayTemplate);
    }

    public static ICircuitSize[] getCircuitSizes(FramingType[] framingTypeArray) {
        ArrayList<CircuitSize> arrayList = new ArrayList<CircuitSize>();
        for (int i = 0; i < framingTypeArray.length; ++i) {
            CircuitSize circuitSize;
            int n;
            FramingType framingType = framingTypeArray[i];
            if (framingType.isSonet()) {
                for (n = 0; n < CircuitSizes.length; ++n) {
                    circuitSize = CircuitSizes[n];
                    if (circuitSize.protocolType != IS_SONET) continue;
                    arrayList.add(circuitSize);
                }
                continue;
            }
            for (n = 0; n < CircuitSizes.length; ++n) {
                circuitSize = CircuitSizes[n];
                if (circuitSize.protocolType != IS_SDH) continue;
                arrayList.add(circuitSize);
            }
        }
        ICircuitSize[] iCircuitSizeArray = arrayList.toArray(ICircuitSizeArrayTemplate);
        return iCircuitSizeArray;
    }

    public static ICircuitSize getLoTunnelSize(int n) {
        IFramingType iFramingType = FramingType.getFramingType(n);
        return CircuitSize.getCircuitSize(iFramingType.getLoTunnelSize());
    }

    public static ICircuitSize getLoAggSize(int n) {
        return CircuitSize.getLoTunnelSize(n);
    }

    public static final float mapCircuitSizeToBW(int n) {
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize(n);
        return iCircuitSize == null ? 0.0f : iCircuitSize.getBandwidth();
    }

    public float getBandwidth() {
        return this.bandwidth;
    }

    public static final int mapCircuitSizeToSTS(int n) {
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize(n);
        return iCircuitSize == null ? -1 : iCircuitSize.getHoPathWidth();
    }

    public int getHoPathWidth() {
        return this.hoPathWidth;
    }

    public int getFramingTypeHoPathWidth(int n) {
        return FramingType.getFramingType(n).getFramingTypeHoPathWidth(this.getHoPathWidth());
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        CircuitSize circuitSize = (CircuitSize)object;
        int n = 0;
        if (this.isOchnc() && !circuitSize.isOchnc()) {
            n = -1;
        } else if (!this.isOchnc() && circuitSize.isOchnc()) {
            n = 1;
        } else if (this.isOchnc() && circuitSize.isOchnc()) {
            n = this.getEnum() - circuitSize.getEnum();
        } else if (!this.isOchnc() && !circuitSize.isOchnc()) {
            n = this.compareBandWidth(circuitSize);
        }
        return n;
    }

    public int compareBandWidth(ICircuitSize iCircuitSize) {
        float f = this.getBandwidth() - iCircuitSize.getBandwidth();
        int n = 0;
        if ((double)f < 0.0) {
            n = -1;
        } else if ((double)f > 0.0) {
            n = 1;
        }
        return n;
    }

    public boolean isSonetTerminationSize() {
        return this.protocolType == IS_SONET;
    }

    public static final int mapPortEqTypeToCircuitSize(int n) {
        Integer n2 = (Integer)portEqTypeMap.get(new Integer(n));
        return n2 != null ? n2 : -1;
    }

    public static int comparePortCapacityToCircuitSize(int n, int n2) {
        Float f = new Float(CircuitSize.mapCircuitSizeToBW(CircuitSize.mapPortEqTypeToCircuitSize(n)));
        Float f2 = new Float(CircuitSize.mapCircuitSizeToBW(n2));
        return f.compareTo(f2);
    }

    public static ICircuitSize getCircuitSizeWithSameCapacity(int n, int n2) {
        if (n2 == 0) {
            return CircuitSize.getSonetCircuitSizeWithSameCapacity(n);
        }
        return CircuitSize.getSdhCircuitSizeWithSameCapacity(n);
    }

    private static ICircuitSize getSonetCircuitSizeWithSameCapacity(int n) {
        switch (n) {
            case 28: {
                return SIZE_STS_3C;
            }
            case 29: {
                return SIZE_STS_12C;
            }
            case 30: {
                return SIZE_STS_48C;
            }
            case 61: {
                return SIZE_STS_192C;
            }
            case 34: {
                return SIZE_VT_1_5;
            }
            case 32: {
                return SIZE_STS_1;
            }
            case 33: {
                return SIZE_STS_1;
            }
            case 31: {
                return SIZE_STS_1;
            }
        }
        return null;
    }

    private static ICircuitSize getSdhCircuitSizeWithSameCapacity(int n) {
        switch (n) {
            case 28: {
                return SIZE_VC_4;
            }
            case 29: {
                return SIZE_VC_4_4C;
            }
            case 30: {
                return SIZE_VC_4_16C;
            }
            case 61: {
                return SIZE_VC_4_64C;
            }
            case 34: {
                return SIZE_VC_11;
            }
            case 68: {
                return SIZE_VC_12;
            }
            case 69: {
                return SIZE_VC_3;
            }
            case 70: {
                return SIZE_VC_3;
            }
            case 114: {
                return SIZE_VC_4;
            }
        }
        return null;
    }

    static {
        portEqTypeMap.put(new Integer(34), new Integer(0));
        portEqTypeMap.put(new Integer(32), new Integer(1));
        portEqTypeMap.put(new Integer(33), new Integer(1));
        portEqTypeMap.put(new Integer(31), new Integer(1));
        portEqTypeMap.put(new Integer(28), new Integer(2));
        portEqTypeMap.put(new Integer(29), new Integer(4));
        portEqTypeMap.put(new Integer(30), new Integer(5));
        portEqTypeMap.put(new Integer(61), new Integer(6));
        portEqTypeMap.put(new Integer(70), new Integer(1));
        portEqTypeMap.put(new Integer(68), new Integer(10));
        portEqTypeMap.put(new Integer(69), new Integer(11));
        db = new KDebug("CircuitSize");
    }
}

