/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.util.KDebug;
import java.util.Arrays;

public class ViewName {
    public static final ViewName ROOT_VIEW = new ViewName();
    public static final int DEFAULT_SKIN = 0;
    public static final int SONET_SKIN = 0;
    public static final int ATM_SKIN = 1;
    public static final int DEFAULT_TAB = 0;
    public static final int ALARMS_TAB = 1;
    public static final int HISTORY_TAB = 2;
    public static final int CIRCUITS_TAB = 3;
    public static final int OHCIRCUITS_TAB = 4;
    public static final int PROVISIONING_TAB = 5;
    public static final int INVENTORY_TAB = 6;
    public static final int MAINTENANCE_TAB = 7;
    public static final int PERFORMANCE_TAB = 8;
    private static final String[] tabs = new String[]{"DEFAULT_TAB", "Alarms", "History", "Circuits", "Overhead Circuits", "Provisioning", "Inventory", "Maintenance", "Performance"};
    private final int[] viewInfo;
    protected static final int NODE_INDEX = 0;
    protected static final int SHELF_INDEX = 1;
    protected static final int SLOT_INDEX = 2;
    protected static final int PORT_INDEX = 3;
    protected static final int SKIN_INDEX = 4;
    protected static final int TAB_INDEX = 5;
    protected static final int MAX_INDEX = 6;
    private String[] subTabs = new String[0];
    private String name = null;
    protected String label = null;
    private static final KDebug db = new KDebug("ViewName");

    public ViewName(ViewName viewName) {
        this(new int[]{viewName.getNodeId(), viewName.getShelfId(), viewName.getSlotId(), viewName.getPortId(), viewName.getSkinId(), viewName.getTabId()});
        this.label = viewName.getLabel();
        this.subTabs = new String[viewName.getSubTabs().length];
        System.arraycopy(viewName.getSubTabs(), 0, this.subTabs, 0, viewName.getSubTabs().length);
    }

    public ViewName() {
        this(new int[]{0, 0, 0, 0, 0, 0});
    }

    public ViewName(int n) {
        this(new int[]{n, 0, 0, 0, 0, 0});
    }

    public ViewName(int n, int n2) {
        this(new int[]{n, 0, n2, 0, 0, 0});
    }

    public ViewName(int n, int n2, int n3) {
        this(new int[]{n, 0, n2, n3, 0, 0});
    }

    public ViewName(int n, int n2, int n3, int n4, int n5) {
        this(new int[]{n, 0, n2, n3, n4, n5});
    }

    public ViewName(int n, int n2, int n3, String[] stringArray) {
        this(new int[]{n, 0, n2, n3, 0, 0}, stringArray);
    }

    public ViewName(String string) {
        this(new int[]{0, 0, 0, 0, 0, 0});
        this.label = string;
    }

    public ViewName(int[] nArray) {
        this(nArray, null);
    }

    public ViewName(int[] nArray, String[] stringArray) {
        if (nArray.length < 6 || nArray.length > 6) {
            db.severe("ERROR: ViewName constructed with incorrect viewInfo: " + nArray);
            this.viewInfo = new int[6];
            for (int i = 0; i < nArray.length && i < this.viewInfo.length; ++i) {
                this.viewInfo[i] = nArray[i];
            }
        } else {
            this.viewInfo = nArray;
        }
        if (stringArray != null && stringArray.length != 0) {
            try {
                nArray[5] = ViewName.tabIdOf(stringArray[0]);
            }
            catch (Exception exception) {
                nArray[5] = 0;
            }
            this.subTabs = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.subTabs, 0, stringArray.length);
        }
    }

    public boolean equals(ViewName viewName) {
        return this == viewName || viewName.getNodeId() == this.getNodeId() && viewName.getShelfId() == this.getShelfId() && viewName.getSlotId() == this.getSlotId() && viewName.getPortId() == this.getPortId() && (viewName.getLabel() == this.getLabel() || viewName.getLabel() != null && this.getLabel() != null && viewName.getLabel().compareTo(this.getLabel()) == 0);
    }

    public int hashCode() {
        int n = this.getShelfId() << 16 & 0xFFFF | this.getSlotId() & 0xFFFF;
        return this.getNodeId() ^ n;
    }

    public boolean strictlyEquals(ViewName viewName) {
        return this.equals(viewName) && viewName.getSkinId() == this.getSkinId() && viewName.getTabId() == this.getTabId() && Arrays.equals(viewName.getSubTabs(), this.getSubTabs());
    }

    public boolean contains(ViewName viewName) {
        if (this.isRootView()) {
            return true;
        }
        if (this.isDomainView()) {
            return viewName.isDomainView() && this.label.equals(viewName.getLabel());
        }
        if (this.getNodeId() == viewName.getNodeId()) {
            if (this.isNodeView() || this.isShelfView()) {
                return true;
            }
            if (this.getShelfId() == viewName.getShelfId()) {
                if (this.isMsShelfView()) {
                    return true;
                }
                if (this.getSlotId() == viewName.getSlotId()) {
                    if (this.isCardView()) {
                        return true;
                    }
                    return this.getPortId() == viewName.getPortId();
                }
            }
        }
        return false;
    }

    public ViewName getParentView() {
        ViewName viewName = null;
        viewName = this.isRootView() ? null : (this.isNodeView() || this.isShelfView() ? ROOT_VIEW : (this.isMsShelfView() ? new ViewName(new int[]{this.getNodeId(), 0, 0, 0, 0, 0}) : (this.isCardView() ? new ViewName(new int[]{this.getNodeId(), this.getShelfId(), 0, 0, 0, 0}) : new ViewName(new int[]{this.getNodeId(), this.getShelfId(), this.getSlotId(), 0, 0, 0}))));
        return viewName;
    }

    public String toString() {
        if (this.name == null) {
            this.name = this.isRootView() ? "ROOT" : (this.getShelfId() == 0 && this.getSlotId() == 0 ? "Node " + Integer.toHexString(this.getNodeId()) : (this.getSlotId() == 0 ? "Shelf " + Integer.toHexString(this.getNodeId()) + ":" + this.getShelfId() : (this.getPortId() == 0 ? "Slot " + Integer.toHexString(this.getNodeId()) + ":" + this.getShelfId() + ":" + this.getSlotId() : "Port " + Integer.toHexString(this.getNodeId()) + ":" + this.getShelfId() + ":" + this.getSlotId() + ":" + this.getPortId())));
            if (this.getLabel() != null) {
                this.name = this.name + "/label=" + this.getLabel();
            }
            if (this.getSkinId() != 0) {
                this.name = this.name + "/skin=" + this.getSkinId();
            }
            if (this.getTabId() != 0) {
                this.name = this.name + "/tab=" + this.getTabId();
            }
            if (this.subTabs.length != 0) {
                this.name = this.name + "/subTabs=\\";
                for (int i = 0; i < this.subTabs.length; ++i) {
                    this.name = this.name + this.subTabs[i] + "\\";
                }
            }
        }
        return this.name;
    }

    public String typeString() {
        if (this.isNetworkView()) {
            return "Network View";
        }
        if (this.isDomainView()) {
            return "Domain View";
        }
        if (this.isNodeView() || this.isShelfView()) {
            return "Node View";
        }
        if (this.isMsShelfView()) {
            return "Shelf View";
        }
        if (this.isCardView()) {
            return "Card View";
        }
        if (this.isPortView()) {
            return "Port View";
        }
        return "Unknown View";
    }

    public boolean isRootView() {
        return this.equals(ROOT_VIEW);
    }

    public boolean isNetworkView() {
        return this.isRootView();
    }

    public boolean isDomainView() {
        return this.getNodeId() == 0 && this.getShelfId() == 0 && this.getSlotId() == 0 && this.getPortId() == 0 && this.getLabel() != null;
    }

    public boolean isNodeView() {
        return this.getNodeId() != 0 && this.getShelfId() == 0 && this.getSlotId() == 0 && this.getPortId() == 0;
    }

    public boolean isShelfView() {
        return this.getNodeId() != 0 && this.getShelfId() == 0 && this.getSlotId() == 0 && this.getPortId() == 0;
    }

    public boolean isMsShelfView() {
        return this.getNodeId() != 0 && this.getShelfId() != 0 && this.getSlotId() == 0 && this.getPortId() == 0;
    }

    public boolean isCardView() {
        return this.getSlotId() != 0 && this.getPortId() == 0;
    }

    public boolean isPortView() {
        return this.getPortId() != 0;
    }

    public int getNodeId() {
        return this.viewInfo[0];
    }

    public int getShelfId() {
        return this.viewInfo[1];
    }

    public int getSlotId() {
        return this.viewInfo[2];
    }

    public int getPortId() {
        return this.viewInfo[3];
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getSubTabs() {
        return this.subTabs;
    }

    public void setLabel(String string) {
        this.label = string;
        this.name = null;
    }

    public int getSkinId() {
        return this.viewInfo[4];
    }

    public int getTabId() {
        return this.viewInfo[5];
    }

    private static int tabIdOf(String string) throws Exception {
        for (int i = 0; i < tabs.length; ++i) {
            if (!string.equals(tabs[i])) continue;
            return i;
        }
        throw new Exception("No such tab name exists.");
    }
}

