/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IReachabilityAdapter;
import cerent.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachabilityNavigator {
    private IReachabilityAdapter ra;
    private IdentityHashMap<Object, Object> idmap;
    private Set<Pair<? extends Object, ? extends Object>> nodeAdjacencies;
    private HashMap westEastNeighbors;

    public ReachabilityNavigator(IReachabilityAdapter iReachabilityAdapter) {
        this.ra = iReachabilityAdapter;
        this.idmap = new IdentityHashMap();
        this.nodeAdjacencies = new HashSet<Pair<? extends Object, ? extends Object>>();
        this.westEastNeighbors = new HashMap();
    }

    public ReachabilityNavigator init() {
        this.navigate(this.ra.getRootNode());
        return this;
    }

    private void navigate(Object object) {
        if (object == null || this.idmap.containsKey(object)) {
            return;
        }
        this.idmap.put(object, object);
        Collection<? extends Object> collection = this.ra.getReachableNeighbors(object);
        Object object2 = null;
        for (Object object3 : collection) {
            if (object2 != null && !this.westEastNeighbors.containsKey(object2)) {
                this.westEastNeighbors.put(object2, object3);
            }
            object2 = object3;
        }
        this.westEastNeighbors.put(object2, null);
        for (Object object3 : collection) {
            Pair<Object, Object> pair;
            if (object == object3 || this.nodeAdjacencies.contains((pair = new Pair<Object, Object>(object, object3)).reverse())) continue;
            this.nodeAdjacencies.add(pair);
            this.navigate(object3);
        }
    }

    public Set<? extends Object> getNodes() {
        return this.idmap.keySet();
    }

    public Set<Pair<? extends Object, ? extends Object>> getNodeAdajencies() {
        return this.nodeAdjacencies;
    }

    public Map<? extends Object, ? extends Object> getWestEastNeighbors() {
        return this.westEastNeighbors;
    }
}

