/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AbstractLoNum;
import cerent.util.ILoNum;
import java.util.ArrayList;
import java.util.List;

public class SdhAu3LoNum
extends AbstractLoNum {
    private int tug2 = 0;
    private int vc11 = 0;
    private int vc12 = 0;

    public SdhAu3LoNum(int n, int n2, int n3) {
        super(n3);
        int n4 = 0;
        int n5 = 0;
        if (n3 == 2) {
            n4 = n2;
        } else if (n3 == 3) {
            n5 = n2;
        }
        this.init(n, n4, n5);
    }

    private void init(int n, int n2, int n3) {
        this.tug2 = n;
        this.vc11 = n2;
        this.vc12 = n3;
        this.validate();
    }

    public static int GetGroupNum(int n) {
        return SdhAu3LoNum.GetGroupNum(n, SdhAu3LoNum.NumOfGroups());
    }

    public static int GetNumInGroup(int n) {
        return SdhAu3LoNum.GetNumInGroup(n, SdhAu3LoNum.NumOfGroups());
    }

    public int getFramingType() {
        return 2;
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0) {
            SdhAu3LoNum sdhAu3LoNum = (SdhAu3LoNum)object;
            if (this.tug2 != sdhAu3LoNum.tug2) {
                return this.tug2 - sdhAu3LoNum.tug2;
            }
            if (this.vc12 != sdhAu3LoNum.vc12) {
                return this.vc12 - sdhAu3LoNum.vc12;
            }
            return this.vc11 - sdhAu3LoNum.vc11;
        }
        return n;
    }

    public String prettyString() {
        return "SDH AU3 Number (" + SdhAu3LoNum.GetTypeString(this.getType()) + "): tug2=" + this.tug2 + ",vc11=" + this.vc11 + ",vc12=" + this.vc12;
    }

    public static boolean isValid(int n, int n2, int n3, int n4) {
        switch (n4) {
            case 2: {
                return n > 0 && n <= 7 && n2 > 0 && n2 <= 4 && n3 == 0;
            }
            case 3: {
                return n > 0 && n <= 7 && n2 == 0 && n3 > 0 && n3 <= 3;
            }
        }
        return false;
    }

    private void validate() {
        if (!SdhAu3LoNum.isValid(this.tug2, this.vc11, this.vc12, this.type)) {
            throw new IllegalStateException("This SDH-AU3 number is invalid " + this.prettyString() + ".");
        }
    }

    public int getGroupNum() {
        return SdhAu3LoNum._GetGroupNum(this.tug2);
    }

    public static int _GetGroupNum(int n) {
        return n;
    }

    public int getNumInGroup() {
        return SdhAu3LoNum._GetNumInGroup(this.type, this.vc11, this.vc12);
    }

    public static int _GetNumInGroup(int n, int n2, int n3) {
        switch (n) {
            case 2: {
                return n2;
            }
            case 3: {
                return n3;
            }
        }
        throw new IllegalStateException("The circuit type is invalid.");
    }

    public int getLoVal() {
        return SdhAu3LoNum.GetLoVal(this.getGroupNum(), this.getNumInGroup(), this.numOfGroups());
    }

    public static int NumOfGroups() {
        return 7;
    }

    public static int numOfGroups(int n) {
        return SdhAu3LoNum.NumOfGroups();
    }

    public int numOfGroups() {
        return SdhAu3LoNum.numOfGroups(this.type);
    }

    public int groupSize() {
        return SdhAu3LoNum.GroupSize(this.type);
    }

    public static int GroupSize(int n) {
        switch (n) {
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        throw new IllegalStateException("The circuit type is invalid.");
    }

    public boolean isVc11Num() {
        return this.type == 2;
    }

    public boolean isVc12Num() {
        return this.type == 3;
    }

    public int getVc11() {
        return this.vc11;
    }

    public int getVc12() {
        return this.vc12;
    }

    public int getVc11_12() {
        return this.isVc11Num() ? this.getVc11() : this.getVc12();
    }

    public int getTug2() {
        return this.tug2;
    }

    public static SdhAu3LoNum buildSdhAu3LoNum(int n, int n2) {
        return SdhAu3LoNum.buildSdhAu3LoNum(SdhAu3LoNum.GetGroupNum(n, SdhAu3LoNum.numOfGroups(n2)), SdhAu3LoNum.GetNumInGroup(n, SdhAu3LoNum.numOfGroups(n2)), n2);
    }

    public static SdhAu3LoNum buildSdhAu3LoNum(int n, int n2, int n3) {
        return new SdhAu3LoNum(n, n2, n3);
    }

    public static List getAllLoNumsByCircuitSize(ILoNum iLoNum, int n) {
        int n2 = -1;
        switch (n) {
            case 9: {
                n2 = 2;
                break;
            }
            case 10: {
                n2 = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("The circuit size is invalid.");
            }
        }
        return SdhAu3LoNum.getAllLoNums(iLoNum, n2);
    }

    public static List getAllLoNums(ILoNum iLoNum, int n) {
        if (iLoNum != null && iLoNum.getFramingType() != 2) {
            throw new IllegalArgumentException("The LO number constraint is invalid.");
        }
        ArrayList<SdhAu3LoNum> arrayList = new ArrayList<SdhAu3LoNum>();
        AbstractLoNum abstractLoNum = (AbstractLoNum)iLoNum;
        int n2 = abstractLoNum == null ? 7 : abstractLoNum.getGroupNum();
        int n3 = n == 2 ? 4 : 3;
        int n4 = abstractLoNum == null ? n3 : abstractLoNum.getNumInGroup();
        switch (n) {
            case 2: {
                for (int i = 1; i <= n2; ++i) {
                    for (int j = 1; j <= n4; ++j) {
                        arrayList.add(new SdhAu3LoNum(i, j, 2));
                    }
                }
                break;
            }
            case 3: {
                for (int i = 1; i <= n2; ++i) {
                    for (int j = 1; j <= n4; ++j) {
                        arrayList.add(new SdhAu3LoNum(i, j, 3));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The circuit type is invalid.");
            }
        }
        return arrayList;
    }

    public static ILoNum getFirstLoNum(int n) {
        switch (n) {
            case 2: {
                return new SdhAu3LoNum(1, 1, 2);
            }
            case 3: {
                return new SdhAu3LoNum(1, 1, 3);
            }
        }
        throw new IllegalArgumentException("The circuit type is invalid.");
    }
}

