/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IntHolder;
import cerent.util.KDebug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.StringTokenizer;

public class UTF8Utils {
    private UTF8Utils() {
    }

    public static byte[] encode(char[] cArray) throws IOException {
        byte[] byArray;
        ByteBuffer byteBuffer;
        CharBuffer charBuffer;
        if (cArray == null) {
            return new byte[0];
        }
        Charset charset = Charset.forName("UTF-8");
        CharsetEncoder charsetEncoder = charset.newEncoder();
        CoderResult coderResult = charsetEncoder.encode(charBuffer = CharBuffer.wrap(cArray), byteBuffer = ByteBuffer.wrap(byArray = new byte[cArray.length * 3]), true);
        if (coderResult.isError()) {
            throw new IOException("UTF-8 encode error: '" + coderResult.toString() + " at 0-based position: " + charBuffer.position() + "'");
        }
        return byteBuffer.array();
    }

    public static char[] decode(byte[] byArray) throws IOException {
        char[] cArray;
        CharBuffer charBuffer;
        ByteBuffer byteBuffer;
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CoderResult coderResult = charsetDecoder.decode(byteBuffer = ByteBuffer.wrap(byArray), charBuffer = CharBuffer.wrap(cArray = new char[byArray.length]), true);
        if (coderResult.isError()) {
            throw new IOException("UTF-8 decode error: '" + coderResult.toString() + " at 0-based position: " + byteBuffer.position() + "'");
        }
        return charBuffer.array();
    }

    public static String decode2String(byte[] byArray) throws IOException {
        char c;
        int n;
        char[] cArray = UTF8Utils.decode(byArray);
        int n2 = cArray == null ? 0 : cArray.length;
        for (n = 0; n < n2 && (c = cArray[n]) != '\u0000'; ++n) {
        }
        return new String(cArray, 0, n);
    }

    public static String encode(String string) throws IOException {
        if (string == null) {
            return "";
        }
        byte[] byArray = UTF8Utils.encode(string.toCharArray());
        return new String(byArray, "ISO-8859-1");
    }

    public static String decode(String string) throws IOException {
        if (string == null) {
            return "";
        }
        byte[] byArray = UTF8Utils.decodeOctet(string);
        UTF8Utils.println("utf8 bytes as a hex dump (" + byArray.length + "):");
        StringWriter stringWriter = new StringWriter();
        UTF8Utils.writeHexDump(byArray, stringWriter);
        String string2 = stringWriter.getBuffer().toString();
        UTF8Utils.println(string2);
        stringWriter.close();
        return UTF8Utils.decode2String(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decodeOctet(String string) throws IOException {
        byte[] byArray;
        block7: {
            int n = string == null ? 0 : string.length();
            byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '\\') {
                        if (i + 4 > n) {
                            throw new IOException("insufficient # of octet chars in string starting at position: " + i);
                        }
                        String string2 = string.substring(i + 1, i + 4);
                        int n2 = UTF8Utils.fromOctet(string2);
                        if (n2 < -128 || n2 > 127) {
                            throw new IOException("octet: " + string2 + " at position: " + i + " not in 8 bit range");
                        }
                        i += 3;
                        byteArrayOutputStream.write(n2);
                        continue;
                    }
                    byteArrayOutputStream.write(c);
                }
                Object var9_8 = null;
                if (byteArrayOutputStream == null) break block7;
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (byteArrayOutputStream != null) {
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
                throw throwable;
            }
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            {
            }
        }
        return byArray;
    }

    public static String uriEncode(byte[] byArray) throws IOException {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = byArray[i];
            if (n2 > 127 || n2 <= -127) {
                String string;
                if (n3 < 0) {
                    n3 += 256;
                }
                if ((string = Integer.toHexString(n3).toUpperCase().trim()).length() == 1) {
                    string = "0" + string;
                }
                stringBuffer.append("%" + string);
                continue;
            }
            stringBuffer.append(Integer.toString(n3));
        }
        return stringBuffer.toString();
    }

    private static int fromOctet(String string) {
        return Integer.parseInt(string, 8);
    }

    private static String toOctet(int n) {
        return Integer.toString(n, 8);
    }

    public static String readHexDump2UCS2(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        return UTF8Utils.readHexDump2UCS2(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readHexDump2UCS2(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        char c = '\u0000';
        BufferedReader bufferedReader = null;
        boolean bl = true;
        try {
            String string;
            BufferedReader bufferedReader2 = bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n2 = Integer.parseInt(string2, 16);
                    if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
                        throw new NumberFormatException("value: " + n2 + " out of char range");
                    }
                    if (bl) {
                        bl = false;
                        n = n2;
                        continue;
                    }
                    bl = true;
                    int n3 = n * 256 + n2;
                    if (c >= '\u8000') {
                        n3 -= 65536;
                    }
                    c = (char)n3;
                    stringBuffer.append(c);
                }
            }
            Object var12_11 = null;
            if (bufferedReader == null) return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            bufferedReader = null;
            throw throwable;
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readHexDump(Reader reader) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        block8: {
            if (reader == null) {
                return new byte[0];
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            byArray = null;
            BufferedReader bufferedReader = null;
            try {
                String string;
                BufferedReader bufferedReader2 = bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        int n = Integer.parseInt(string2, 16);
                        if (n > 255) {
                            throw new NumberFormatException("value: " + n + " out of ubyte range");
                        }
                        if (n > 127) {
                            n -= 256;
                        }
                        byteArrayOutputStream.write(n);
                    }
                }
                Object var9_8 = null;
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                throw throwable;
            }
            bufferedReader.close();
            bufferedReader = null;
        }
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static String fromHexDump2UCS2(String string) throws IOException {
        return UTF8Utils.readHexDump2UCS2(new StringReader(string));
    }

    public static byte[] fromHexDump(String string) throws IOException {
        return UTF8Utils.readHexDump(new StringReader(string));
    }

    private static void writeHexDump(String string, OutputStream outputStream, boolean bl) throws IOException {
        UTF8Utils.writeHexDump(string, new OutputStreamWriter(outputStream), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeHexDump(String string, Writer writer, boolean bl) throws IOException {
        block18: {
            block17: {
                int n = 0;
                int n2 = string == null ? 0 : string.length();
                BufferedWriter bufferedWriter = null;
                try {
                    bufferedWriter = new BufferedWriter(writer);
                    for (int i = 0; i < n2; ++i) {
                        String string2;
                        int n3;
                        if (n == 16) {
                            bufferedWriter.newLine();
                            n = 0;
                        } else if (n > 0) {
                            bufferedWriter.write(32);
                        }
                        int n4 = n3 = string.charAt(i);
                        if (n4 < 0) {
                            n4 = bl ? (n4 += 65536) : (n4 += 256);
                        }
                        if ((string2 = Integer.toString(n4, 16)).length() == 1) {
                            string2 = bl ? "000" + string2 : "0" + string2;
                        } else if (string2.length() == 2) {
                            if (bl) {
                                string2 = "00" + string2;
                            }
                        } else if (string2.length() == 3) {
                            string2 = "0" + string2;
                        }
                        bufferedWriter.write(string2);
                        ++n;
                    }
                    Object var11_10 = null;
                    if (bufferedWriter == null) break block17;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                        bufferedWriter = null;
                    } else if (writer != null) {
                        writer.close();
                    }
                    throw throwable;
                }
                bufferedWriter.close();
                bufferedWriter = null;
                break block18;
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static String toHexDump(String string) {
        String string2 = "";
        try {
            StringWriter stringWriter = new StringWriter();
            UTF8Utils.writeHexDump(string, stringWriter, true);
            string2 = stringWriter.getBuffer().toString();
        }
        catch (IOException iOException) {
            KDebug.printStackTrace((Throwable)iOException);
        }
        return string2;
    }

    public static String toByteHexDump(String string) {
        String string2 = "";
        try {
            StringWriter stringWriter = new StringWriter();
            UTF8Utils.writeHexDump(string, stringWriter, false);
            string2 = stringWriter.getBuffer().toString();
        }
        catch (IOException iOException) {
            KDebug.printStackTrace((Throwable)iOException);
        }
        return string2;
    }

    public static String toHexDump(byte[] byArray) {
        String string = "";
        try {
            StringWriter stringWriter = new StringWriter();
            UTF8Utils.writeHexDump(byArray, stringWriter);
            string = stringWriter.getBuffer().toString();
        }
        catch (IOException iOException) {
            KDebug.printStackTrace((Throwable)iOException);
        }
        return string;
    }

    public static String toHexDump(Object object) {
        return object == null ? "" : UTF8Utils.toHexDump(object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeHexDump(byte[] byArray, Writer writer) throws IOException {
        int n = 0;
        int n2 = byArray == null ? 0 : byArray.length;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(writer);
            for (int i = 0; i < n2; ++i) {
                String string;
                if (n == 16) {
                    bufferedWriter.newLine();
                    n = 0;
                } else if (n > 0) {
                    bufferedWriter.write(32);
                }
                int n3 = byArray[i];
                if (n3 < 0) {
                    n3 += 256;
                }
                if ((string = Integer.toString(n3, 16)).length() == 1) {
                    string = "0" + string;
                }
                bufferedWriter.write(string);
                ++n;
            }
            Object var10_8 = null;
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (bufferedWriter == null) throw throwable;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private static void println(char c) {
        System.out.println(c);
    }

    private static void print(String string) {
        System.out.print(string);
    }

    private static void print(char c) {
        System.out.print(c);
    }

    private static void printStackTrace(Throwable throwable) {
        throwable.printStackTrace(System.out);
    }

    static String consumeArgs(String[] stringArray, IntHolder intHolder) {
        if (intHolder == null || stringArray == null) {
            return "";
        }
        int n = intHolder.intValue();
        if (n >= stringArray.length) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) continue;
            if (i > n) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string);
        }
        intHolder.setValue(n);
        return stringBuffer.toString();
    }

    private static void usage() {
        UTF8Utils.println("usage: java -cp... " + UTF8Utils.class.getName() + " [-hi] [-u string] [-o string] [-n string] [-h]");
        UTF8Utils.println("  -hi: input string is hex dump fmt");
        UTF8Utils.println("   -u: UTF-8 decode request");
        UTF8Utils.println("   -o: octet-decode request");
        UTF8Utils.println("   -n: UTF-8 (->UCS-2) encode request");
        UTF8Utils.println("   -h: printout this usage message");
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            String string2;
            String string3;
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            byte[] byArray = null;
            IntHolder intHolder = new IntHolder();
            int n2 = 0;
            if (stringArray.length == 0) {
                UTF8Utils.usage();
                return;
            }
            for (n = 0; n < stringArray.length; ++n) {
                String string7 = stringArray[n];
                if (string7.equals("-p")) {
                    n2 = Integer.parseInt(stringArray[++n]);
                    continue;
                }
                if (string7.equals("-u")) {
                    intHolder.setValue(++n);
                    string4 = UTF8Utils.consumeArgs(stringArray, intHolder);
                    n = intHolder.intValue();
                    bl = true;
                    continue;
                }
                if (string7.equals("-o")) {
                    intHolder.setValue(++n);
                    string5 = UTF8Utils.consumeArgs(stringArray, intHolder);
                    n = intHolder.intValue();
                    bl3 = true;
                    continue;
                }
                if (string7.equals("-hi")) {
                    bl4 = true;
                    continue;
                }
                if (string7.equals("-n")) {
                    intHolder.setValue(++n);
                    string6 = UTF8Utils.consumeArgs(stringArray, intHolder);
                    n = intHolder.intValue();
                    bl2 = true;
                    continue;
                }
                if (!string7.equals("-h")) continue;
                UTF8Utils.usage();
                return;
            }
            if (bl) {
                if (bl4) {
                    byArray = UTF8Utils.fromHexDump(string4);
                }
                if (byArray == null) {
                    UTF8Utils.println("raw input(" + string4.length() + "):");
                    UTF8Utils.println("\"" + string4 + "\"");
                    if (n2 > 0) {
                        for (n = 0; n < n2; ++n) {
                            UTF8Utils.print(' ');
                        }
                        UTF8Utils.println('^');
                    }
                    string3 = n2 > 0 ? string4.substring(0, n2) : string4;
                } else {
                    string3 = null;
                    UTF8Utils.println("raw input(" + byArray.length + "):");
                    UTF8Utils.println(UTF8Utils.toHexDump(byArray));
                }
                string2 = byArray == null ? UTF8Utils.decode(string3) : UTF8Utils.decode2String(byArray);
                UTF8Utils.println("");
                UTF8Utils.println("decoded utf8 output(" + string2.length() + "):");
                string = UTF8Utils.toHexDump(string2);
                UTF8Utils.println(string);
            }
            if (bl3) {
                if (bl4) {
                    string4 = UTF8Utils.fromHexDump2UCS2(string4);
                }
                UTF8Utils.println("raw input(" + string4.length() + "):");
                UTF8Utils.println("\"" + string4 + "\"");
                if (n2 > 0) {
                    for (n = 0; n < n2; ++n) {
                        UTF8Utils.print(' ');
                    }
                    UTF8Utils.println('^');
                }
                string3 = n2 > 0 ? string4.substring(0, n2) : string4;
                string2 = UTF8Utils.uriEncode(UTF8Utils.decodeOctet(string3));
                string = UTF8Utils.toHexDump(string2);
                UTF8Utils.println("");
                UTF8Utils.println("decoded utf8 output):");
                UTF8Utils.println(string);
            }
            if (bl2) {
                if (bl4) {
                    string6 = UTF8Utils.fromHexDump2UCS2(string6);
                }
                UTF8Utils.println("raw input(" + string6.length() + "):");
                UTF8Utils.println("\"" + string6 + "\"");
                string3 = string6;
                string2 = UTF8Utils.encode(string3);
                string = UTF8Utils.toHexDump(string2);
                UTF8Utils.println("");
                UTF8Utils.println("encoded utf8 output (" + string.length() + "):");
                UTF8Utils.println(string);
            }
        }
        catch (Throwable throwable) {
            UTF8Utils.printStackTrace(throwable);
        }
    }
}

