/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.gui.DetailedLogDialog;
import cerent.util.gui.PasswordDialog;
import cerent.util.view.fv.IFunctDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class CerentDialog
implements IFunctDialog {
    private static final LinkedList _visibleDialogs = new LinkedList();
    private static final String INFO_ICON_STR = "/images/icons/informational32.gif";
    private static final String QUESTION_ICON_STR = "/images/icons/question32.gif";
    private static final String WARNING_ICON_STR = "/images/icons/warning32.gif";
    private static final String FATAL_ICON_STR = "/images/icons/fatal_error32.gif";
    public static ImageIcon INFO_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/informational32.gif"));
    public static ImageIcon QUESTION_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/question32.gif"));
    public static ImageIcon WARNING_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/warning32.gif"));
    public static ImageIcon FATAL_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/fatal_error32.gif"));
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private static final String YES = "Yes";
    private static final String NO = "No";
    private static final String CANCEL = "Cancel";
    private static Object[] yesNoOptions = new Object[]{"Yes", "No"};
    private static Object[] yesNoCancelOptions = new Object[]{"Yes", "No", "Cancel"};
    private static final KDebug db = new KDebug("CerentDialog");

    public static final void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVisibleDialog(JDialog jDialog) {
        LinkedList linkedList = _visibleDialogs;
        synchronized (linkedList) {
            PanelessDialog panelessDialog = new PanelessDialog(jDialog);
            _visibleDialogs.addLast(panelessDialog);
            jDialog.addWindowListener(panelessDialog);
        }
    }

    public static void toFront() {
        new Thread(new Runnable(){

            public void run() {
                block2: {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!db.on()) break block2;
                        db.println("toFront interrupted");
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        LinkedList linkedList = _visibleDialogs;
                        synchronized (linkedList) {
                            Iterator iterator = _visibleDialogs.iterator();
                            while (iterator.hasNext()) {
                                ((BaseDialog)iterator.next()).toFront();
                            }
                        }
                    }
                });
            }
        }).start();
    }

    public static boolean yesNoDialog(Component component, String string, String string2) {
        return CerentDialog.questionDialog(component, string, string2) == 0;
    }

    public static boolean yesNoDialog(Component component, String string, String string2, int n) {
        return CerentDialog.questionDialog(component, string, string2, n) == 0;
    }

    public static boolean yesNoDialog(String string, String string2) {
        return CerentDialog.yesNoDialog(null, string, string2);
    }

    public static boolean yesNoWarningDialog(Component component, String string, String string2) {
        return CerentDialog.showConfirmDialog(component, string, string2, 0, 2, WARNING_ICON, yesNoOptions, 1) == 0;
    }

    public static boolean yesNoWarningDialog(Component component, String string, String string2, int n) {
        return CerentDialog.showConfirmDialog(component, string, string2, 0, 2, WARNING_ICON, yesNoOptions, n) == 0;
    }

    public static boolean yesNoWarningDialog(String string, String string2) {
        return CerentDialog.yesNoWarningDialog(null, string, string2);
    }

    public static int questionDialog(Component component, String string, String string2) {
        return CerentDialog.showConfirmDialog(component, string, string2, 0, 3, QUESTION_ICON, yesNoOptions, 2);
    }

    public static int questionDialog(Component component, String string, String string2, int n) {
        return CerentDialog.showConfirmDialog(component, string, string2, 0, 3, QUESTION_ICON, yesNoOptions, n);
    }

    public static int cancelableQuestionDialog(Component component, String string, String string2) {
        return CerentDialog.showConfirmDialog(component, string, string2, 1, 3, QUESTION_ICON, yesNoCancelOptions, 2);
    }

    public static int cancelableQuestionDialog(Component component, String string, String string2, int n) {
        return CerentDialog.showConfirmDialog(component, string, string2, 1, 3, QUESTION_ICON, yesNoCancelOptions, n);
    }

    public static int optionDialog(Component component, String string, String string2, Object[] objectArray, Object object) {
        return CerentDialog.showOptionDialog(component, string, string2, -1, 3, QUESTION_ICON, objectArray, object);
    }

    public static Object inputDialog(Component component, String string, String string2, Object[] objectArray, Object object) {
        return CerentDialog.showInputDialog(component, string, string2, 3, QUESTION_ICON, objectArray, object);
    }

    public static Object inputPasswordDialog(Component component, String string, String string2) {
        return CerentDialog.showInputPasswordDialog(component, string, string2);
    }

    public static void errorDialog(Component component, String string) {
        CerentDialog.errorDialog(component, string, "Error");
    }

    public static void errorDialog(String string) {
        CerentDialog.errorDialog(null, string, "Error");
    }

    public static void errorDialog(Component component, String string, String string2) {
        CerentDialog.showMessageDialog(component, string, string2, 0, (Icon)FATAL_ICON, true);
    }

    public static void errorDialog(Component component, Exception exception, String string) {
        if (db.isFineEnabled()) {
            KDebug.printStackTrace((Throwable)exception);
        }
        String string2 = AnnotatedException.getString(exception);
        CerentDialog.errorDialog(component, string2, string);
    }

    public static int errorDialog(Component component, String string, String string2, Object[] objectArray, Object object) {
        return CerentDialog.showOptionDialog(component, string, string2, -1, 0, FATAL_ICON, objectArray, object);
    }

    public static void errorDialog(Component component, String string, String string2, DetailedLog detailedLog, boolean bl) {
        String string3 = IPAddressTranslator.instance().translateIPsVirtualToActual(string);
        if (component instanceof Frame) {
            new DetailedLogDialog((Frame)component, string2, (Icon)FATAL_ICON, string3, detailedLog, bl).show();
        } else if (component instanceof Dialog) {
            new DetailedLogDialog((Dialog)component, string2, (Icon)FATAL_ICON, string3, detailedLog, bl).show();
        } else {
            new DetailedLogDialog(JOptionPane.getFrameForComponent(component), string2, (Icon)FATAL_ICON, string3, detailedLog, bl).show();
        }
    }

    public static void warningDialog(Component component, String string) {
        CerentDialog.warningDialog(component, string, "Warning");
    }

    public static void warningDialog(String string) {
        CerentDialog.warningDialog(null, string, "Warning");
    }

    public static void warningDialog(Component component, String string, String string2) {
        CerentDialog.warningDialog(component, string, string2, true);
    }

    public static void warningDialog(Component component, String string, String string2, boolean bl) {
        CerentDialog.showMessageDialog(component, string, string2, 2, (Icon)WARNING_ICON, bl);
    }

    public static boolean warningDialog(Component component, JLabel jLabel, String string, boolean bl) {
        return CerentDialog.showMessageDialog(component, jLabel, string, 2, WARNING_ICON, bl);
    }

    private static boolean showMessageDialog(Component component, JLabel jLabel, String string, int n, ImageIcon imageIcon, boolean bl) {
        MsgDialog msgDialog = new MsgDialog(component, jLabel, string, 2, WARNING_ICON, bl);
        msgDialog.show();
        int n2 = msgDialog.getResult();
        return n2 != 2 && n2 != -1;
    }

    public static void infoDialog(Component component, String string, String string2) {
        CerentDialog.showMessageDialog(component, string, string2, 1, (Icon)INFO_ICON, true);
    }

    private static synchronized int showConfirmDialog(Component component, String string, String string2, int n, int n2, Icon icon, Object[] objectArray, int n3) {
        if (n3 >= 0 && n3 < objectArray.length) {
            return CerentDialog.showOptionDialog(component, string, string2, n, n2, icon, objectArray, objectArray[n3]);
        }
        return CerentDialog.showOptionDialog(component, string, string2, n, n2, icon, objectArray, objectArray[objectArray.length - 1]);
    }

    private static synchronized int showOptionDialog(Component component, String string, String string2, int n, int n2, Icon icon, Object[] objectArray, Object object) {
        String string3 = IPAddressTranslator.instance().translateIPsVirtualToActual(string);
        OptionDialog optionDialog = new OptionDialog(component, string3, string2, n, n2, icon, objectArray, object);
        optionDialog.show();
        return optionDialog.getResult();
    }

    private static synchronized Object showInputDialog(Component component, String string, String string2, int n, Icon icon, Object[] objectArray, Object object) {
        String string3 = IPAddressTranslator.instance().translateIPsVirtualToActual(string);
        InputDialog inputDialog = new InputDialog(component, string3, string2, n, icon, objectArray, object);
        inputDialog.show();
        return inputDialog.getResult();
    }

    private static void showMessageDialog(Component component, String string, String string2, int n, Icon icon, boolean bl) {
        new MsgDialog(component, string, string2, n, icon, bl).show();
    }

    public static String showFileDialog(Component component, String string, String string2, boolean bl, boolean bl2, String string3, String string4, int n) {
        String string5 = null;
        return string5;
    }

    private static synchronized Object showInputPasswordDialog(Component component, String string, String string2) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        PasswordDialog passwordDialog = new PasswordDialog(frame, string, string2);
        passwordDialog.show();
        if (passwordDialog.ok()) {
            return passwordDialog.getPassword();
        }
        return null;
    }

    private static void execute(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                if (db.on()) {
                    db.println("NOTE: This InterruptedException is expected due to the the implementation of Sun's JOptionPane.");
                    KDebug.printStackTrace((Throwable)interruptedException);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                db.finest("CerentDialog: " + invocationTargetException);
            }
        }
    }

    public int questionFvDialog(Component component, String string, String string2) {
        return CerentDialog.questionDialog(component, string, string2);
    }

    public void warningFvDialog(Component component, String string, String string2) {
        CerentDialog.warningDialog(component, string, string2);
    }

    public boolean yesNoFvDialog(Component component, String string, String string2) {
        return CerentDialog.yesNoDialog(component, string, string2);
    }

    static class InputDialog
    extends BaseDialog {
        private Object _result = null;

        InputDialog(Component component, String string, String string2, int n, Icon icon, Object[] objectArray, Object object) {
            super(component, string, string2, n, icon, objectArray, object);
        }

        protected void doShow() {
            this.showDialog();
            Object object = this.getPaneInputValue();
            this._result = object == JOptionPane.UNINITIALIZED_VALUE ? null : object;
        }

        Object getResult() {
            return this._result;
        }
    }

    static class MsgDialog
    extends OptionDialog {
        private boolean _modal;

        MsgDialog(Component component, String string, String string2, int n, Icon icon, boolean bl) {
            super(component, string, string2, -1, n, icon, null, null);
            this._modal = bl;
        }

        public MsgDialog(Component component, JLabel jLabel, String string, int n, ImageIcon imageIcon, boolean bl) {
            super(component, jLabel, string, 2, n, imageIcon, null, null);
            this._modal = bl;
        }

        protected void doShow() {
            if (this._modal) {
                super.doShow();
            } else {
                this.displayDialog();
            }
        }
    }

    static class OptionDialog
    extends BaseDialog {
        private int _result = -1;
        private Object[] _options;

        OptionDialog(Component component, String string, String string2, int n, int n2, Icon icon, Object[] objectArray, Object object) {
            super(component, string, string2, n, n2, icon, objectArray, object);
            this._options = objectArray;
        }

        public OptionDialog(Component component, JLabel jLabel, String string, int n, int n2, ImageIcon imageIcon, Object[] objectArray, Object object) {
            super(component, jLabel, string, n, n2, imageIcon, objectArray, object);
            this._options = objectArray;
        }

        protected void doShow() {
            block1: {
                Object object;
                block2: {
                    this.showDialog();
                    object = this.getPaneValue();
                    this._result = -1;
                    if (object == null) break block1;
                    if (this._options != null) break block2;
                    if (!(object instanceof Integer)) break block1;
                    this._result = (Integer)object;
                    break block1;
                }
                for (int i = 0; i < this._options.length; ++i) {
                    if (!this._options[i].equals(object)) continue;
                    this._result = i;
                    break;
                }
            }
        }

        int getResult() {
            return this._result;
        }
    }

    static class PanelessDialog
    extends BaseDialog {
        PanelessDialog(JDialog jDialog) {
            this._dialog = jDialog;
        }

        protected Object getPaneValue() {
            return null;
        }

        protected Object getPaneInputValue() {
            return null;
        }
    }

    static class BaseDialog
    extends WindowAdapter {
        private JOptionPane _pane;
        protected JDialog _dialog;

        BaseDialog() {
        }

        BaseDialog(Component component, String string, String string2, int n, int n2, Icon icon, Object[] objectArray, Object object) {
            int n3 = 0;
            int n4 = 0;
            while ((n3 = string.indexOf(10, n3)) != -1) {
                ++n3;
                ++n4;
            }
            int n5 = string.length();
            if (n4 > 10 || n4 == 0 && n5 >= 80) {
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setEditable(false);
                jTextArea.setText(string);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jScrollPane.setVerticalScrollBarPolicy(22);
                jScrollPane.setPreferredSize(new Dimension(200, 150));
                this._pane = new JOptionPane(jScrollPane, n2, n, icon, objectArray, object);
            } else {
                this._pane = new JOptionPane(string, n2, n, icon, objectArray, object);
            }
            this._pane.setInitialValue(object);
            this._dialog = this._pane.createDialog(component, string2);
            this._pane.selectInitialValue();
        }

        BaseDialog(Component component, String string, String string2, int n, Icon icon, Object[] objectArray, Object object) {
            this._pane = new JOptionPane(string, n, 2, icon, null, null);
            this._pane.setWantsInput(true);
            this._pane.setSelectionValues(objectArray);
            this._pane.setInitialSelectionValue(object);
            this._dialog = this._pane.createDialog(component, string2);
            this._pane.selectInitialValue();
        }

        public BaseDialog(Component component, JLabel jLabel, String string, int n, int n2, ImageIcon imageIcon, Object[] objectArray, Object object) {
            this._pane = new JOptionPane(jLabel, n2, n, imageIcon, objectArray, object);
            this._pane.setInitialValue(object);
            this._dialog = this._pane.createDialog(component, string);
            this._pane.selectInitialValue();
        }

        void show() {
            CerentDialog.execute(new Runnable(){

                public void run() {
                    BaseDialog.this.doShow();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void showDialog() {
            LinkedList linkedList = _visibleDialogs;
            synchronized (linkedList) {
                if (db.on()) {
                    db.println("showDialog(" + this._dialog.getTitle() + ")");
                }
                _visibleDialogs.addLast(this);
                this._dialog.addWindowListener(this);
                this._dialog.show();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void displayDialog() {
            LinkedList linkedList = _visibleDialogs;
            synchronized (linkedList) {
                if (db.on()) {
                    db.println("displayDialog(" + this._dialog.getTitle() + ")");
                }
                _visibleDialogs.addLast(this);
                this._dialog.addWindowListener(this);
                this._dialog.pack();
                this._dialog.setModal(false);
                this._dialog.setVisible(true);
            }
        }

        protected Object getPaneValue() {
            return this._pane.getValue();
        }

        protected Object getPaneInputValue() {
            return this._pane.getInputValue();
        }

        protected void doShow() {
            this.showDialog();
        }

        protected void toFront() {
            if (db.on()) {
                db.println("toFront(" + this._dialog.getTitle() + ")");
            }
            this._dialog.toFront();
        }

        public void windowOpened(WindowEvent windowEvent) {
            CerentDialog.toFront();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosed(WindowEvent windowEvent) {
            LinkedList linkedList = _visibleDialogs;
            synchronized (linkedList) {
                this._dialog.removeWindowListener(this);
                _visibleDialogs.remove(this);
            }
        }
    }
}

