/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.PCLIConsoleDisabledException;
import cerent.util.EID;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IOSTelnetFrame;
import cerent.util.terminal.IReaderThread;
import cerent.util.terminal.PCLISshReaderThread;
import cerent.util.terminal.TelnetReaderThread;
import java.io.IOException;

public class PCLITelnetFrame
extends IOSTelnetFrame {
    private static final int MAX_NODE_INSTANCES = 16;
    private static int numberOfNodeInstances = 0;
    private INodeModel nodeModel = null;
    private boolean disposed = false;

    private PCLITelnetFrame(INodeModel iNodeModel, boolean bl) {
        this.nodeName = iNodeModel.getName();
        this.nodeModel = iNodeModel;
        this.port = bl ? iNodeModel.getSecurityModel().getPCLISecurePort() : iNodeModel.getSecurityModel().getPCLIPort();
        this.initFrame(iNodeModel.getHostName(), bl);
        db = new KDebug("PCLITelnetFrame");
        if (db.on()) {
            db.println("Node model is: " + iNodeModel);
            db.println("Node name is: " + this.nodeName);
        }
    }

    public static PCLITelnetFrame instance(INodeModel iNodeModel) throws PCLIConsoleDisabledException {
        PCLITelnetFrame pCLITelnetFrame = null;
        boolean bl = false;
        if (Feature.provides(iNodeModel, Feature.PSEUDO_CLI)) {
            if (!iNodeModel.getSecurityModel().isPCLIConsoleEnabled()) {
                throw new PCLIConsoleDisabledException();
            }
            bl = iNodeModel.getSecurityModel().isPCLIConsoleSecure();
            if (numberOfNodeInstances < 16) {
                pCLITelnetFrame = new PCLITelnetFrame(iNodeModel, bl);
                ++numberOfNodeInstances;
            } else {
                CerentDialog.errorDialog(null, KErrorMsg.getString((EID)KEMC.EID_TOO_MANY_SESSIONS));
            }
        }
        return pCLITelnetFrame;
    }

    protected void attemptToConnect() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            if (db.on()) {
                db.println("IOException caught trying to connect: " + iOException);
            }
            String string = KErrorMsg.getString((EID)KEMC.EID_PCLI_TELNET_CONNECT_FAILURE);
            CerentDialog.errorDialog(this, string);
            this.closing = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    protected String getFrameTitle() {
        return this.nodeName + ", port " + Integer.toString(this.port);
    }

    public void dispose() {
        if (!this.disposed && this.nodeModel != null && numberOfNodeInstances > 0) {
            --numberOfNodeInstances;
        }
        this.disposed = true;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void terminated(Object object) {
        if (db.on()) {
            db.println("terminated called");
        }
        this.dispose();
        if (!this.closing) {
            CerentDialog.errorDialog(this, KErrorMsg.getString((EID)KEMC.EID_PCLI_TELNET_SESSION_TERMINATED));
        }
    }

    protected IReaderThread createReaderThread() {
        if (this.secure) {
            return new PCLISshReaderThread();
        }
        return new TelnetReaderThread();
    }

    protected String retrieveUserName() {
        String string = "";
        if (this.nodeModel != null) {
            string = this.nodeModel.getUserName();
        }
        return string;
    }

    protected String getIOSConnectionType() {
        return "Pseudo IOS";
    }
}

