/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.orb;

import cerent.launcher.CtcHttpRetriever;
import cerent.util.IIPAddressTranslator;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.orb.ICtcORB;
import cerent.util.orb.IIorRewriter;
import cerent.util.orb.IOngORB;
import cerent.util.orb.IorRewriter;
import cerent.util.orb.ProtocolSelectionInterceptor;
import cerent.util.orb.SecurityTicketInterceptor;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.omg.CORBA.Any;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.Current;
import org.omg.CORBA.Environment;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.Request;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.WrongTransaction;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.PortableServer.POAHelper;

class CtcJacORB
implements IOngORB,
ICtcORB {
    private static IIPAddressTranslator addrTrans = IPAddressTranslator.instance();
    private static final String ORB_SINGLETON_CLASS = "org.jacorb.orb.ORBSingleton";
    private static final String ORB_CLASS = "org.jacorb.orb.ORB";
    private static final String DEFAULT_ORB_CLASS_NAME = "org.omg.CORBA.ORBClass";
    private static final String DEFAULT_SINGLETON_ORB_CLASS_NAME = "org.omg.CORBA.ORBSingletonClass";
    private static final String SERVER_SOCKET_FACTORY_PROP = "jacorb.net.server_socket_factory";
    private static final String CLIENT_SOCKET_FACTORY_PROP = "jacorb.net.socket_factory";
    private static final String SSL_SERVER_SOCKET_FACTORY_PROP = "jacorb.ssl.server_socket_factory";
    private static final String SSL_CLIENT_SOCKET_FACTORY_PROP = "jacorb.ssl.socket_factory";
    private static final String ORB_INTERCEPTOR_INIT_PREFIX = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private static final String CTC_INTERCEPTOR_INIT_CLASS = "cerent.util.orb.CtcInterceptorInitializer";
    private static final String JACORB_DEFAULT_INTERCEPTOR = "standard_init";
    private static final String PENDING_REPLY_TIMEOUT_PROP = "jacorb.connection.client.pending_reply_timeout";
    private static final String SSL_CLIENT_SUPPORTED_OPTS = "jacorb.security.ssl.client.supported_options";
    private static final String SSL_CLIENT_REQUIRED_OPTS = "jacorb.security.ssl.client.required_options";
    private static final String SSL_SERVER_SUPPORTED_OPTS = "jacorb.security.ssl.server.supported_options";
    private static final String SSL_SERVER_REQUIRED_OPTS = "jacorb.security.ssl.server.required_options";
    private static final String CTC_IOR_MUTATOR_CLASS = "cerent.util.orb.CtcIorMutator";
    private static final String SSL_SUPPORTED_OPTS = "32";
    private static final String SSL_REQUIRED_OPTS = "1";
    private static ORB orb = null;
    protected static final CtcJacORBDebug db = new CtcJacORBDebug("CtcJacORB");
    private static int originalIiopPort = -1;
    private static int originalSsliopPort = -1;

    private void setProp(Properties properties, String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            properties.setProperty(string, string2);
        } else {
            properties.setProperty(string, string3);
        }
        CtcJacORB.db.addLocalPropInfo(string, string2, string3);
    }

    private void setSysProp(String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            System.setProperty(string, string2);
        }
        CtcJacORB.db.addSystemPropInfo(string, string2, string3);
    }

    private void setSysAndLocalProp(Properties properties, String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            properties.setProperty(string, string2);
            System.setProperty(string, string2);
        } else {
            properties.setProperty(string, string3);
        }
        CtcJacORB.db.addBothPropInfo(string, string2, string3);
    }

    public synchronized IOngORB initialize(String[] stringArray, Properties properties) {
        int n;
        java.lang.Object object;
        int n2 = this.getIiopPort();
        int n3 = this.getSsliopPort();
        String string = "120000";
        String string2 = "125000";
        String string3 = "0";
        try {
            object = Preferences.instance().getProperty("ctc.orb", "timeoutInSeconds", "120");
            n = Integer.parseInt((String)object);
            String string4 = Preferences.instance().getProperty("ctc.orb", "idleTimeoutInSeconds", Integer.toString(n + 5));
            int n4 = Integer.parseInt(string4);
            string = Integer.toString(n * 1000);
            string2 = Integer.toString(n4 * 1000);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing the timeout values for the ORB" + numberFormatException);
            string = "120000";
            string2 = "125000";
        }
        try {
            object = Preferences.instance().getProperty("ctc.orb", "numberOfRetries", "0");
            string3 = object;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing the retries value for the ORB" + numberFormatException);
            string3 = "0";
        }
        if (this.isPortAvailable(n2)) {
            this.setSysAndLocalProp(properties, DEFAULT_ORB_CLASS_NAME, ORB_CLASS);
            this.setSysAndLocalProp(properties, DEFAULT_SINGLETON_ORB_CLASS_NAME, ORB_SINGLETON_CLASS);
            this.setProp(properties, "jacorb.log.loggerFactory", "cerent.util.orb.JdkLoggerFactory");
            this.setProp(properties, "jacorb.interop.lax_boolean_encoding", "on");
            this.setProp(properties, "org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
            this.setProp(properties, "org.omg.PortableInterceptor.ORBInitializerClass.cerent.util.orb.CtcInterceptorInitializer", "");
            this.setProp(properties, "jacorb.dns.enable", "false");
            this.setProp(properties, "jacorb.suppress_no_props_warning", "on");
            this.setProp(properties, "jacorb.log.default.verbosity", "ERROR");
            this.setProp(properties, "jacorb.poa.thread_pool_max", "100");
            this.setProp(properties, "jacorb.poa.thread_pool_min", SSL_REQUIRED_OPTS);
            this.setProp(properties, "jacorb.poa.thread_priority", Integer.toString(10));
            this.setProp(properties, "jacorb.poa.queue_wait", "on");
            this.setProp(properties, "jacorb.poa.queue_max", "1000");
            this.setProp(properties, "jacorb.poa.queue_min", "500");
            this.setProp(properties, PENDING_REPLY_TIMEOUT_PROP, string);
            this.setProp(properties, "jacorb.connection.client.idle_timeout", string2);
            this.setProp(properties, "jacorb.connection.client.timeout_ignores_pending_messages", "on");
            this.setProp(properties, "jacorb.retries", string3);
            this.setProp(properties, "jacorb.retry_interval", "500");
            if (db.on()) {
                db.println("ORB client pending_reply_timeout is set to: " + string);
                db.println("ORB number of retries is set to: " + string3);
            }
            this.setProp(properties, "jacorb.iormutator", CTC_IOR_MUTATOR_CLASS);
            this.setProp(properties, SERVER_SOCKET_FACTORY_PROP, "cerent.util.orb.sckfwd.ServerSocketFactory");
            this.setProp(properties, CLIENT_SOCKET_FACTORY_PROP, "cerent.util.orb.sckfwd.SocketFactory");
            this.setProp(properties, "jacorb.net.socket_factory.port.min", "1024");
            this.setProp(properties, "jacorb.net.socket_factory.port.max", "65535");
            this.setProp(properties, SSL_SERVER_SOCKET_FACTORY_PROP, "cerent.util.orb.sckfwd.SslServerSocketFactory");
            this.setProp(properties, SSL_CLIENT_SOCKET_FACTORY_PROP, "cerent.util.orb.sckfwd.SslSocketFactory");
            this.setProp(properties, "jacorb.security.support_ssl", "on");
            this.setProp(properties, SSL_CLIENT_SUPPORTED_OPTS, SSL_SUPPORTED_OPTS);
            this.setProp(properties, SSL_CLIENT_REQUIRED_OPTS, SSL_REQUIRED_OPTS);
            this.setProp(properties, SSL_SERVER_SUPPORTED_OPTS, SSL_SUPPORTED_OPTS);
            this.setProp(properties, SSL_SERVER_REQUIRED_OPTS, SSL_REQUIRED_OPTS);
            this.setProp(properties, "jacorb.dns.eager_resolve", "off");
            if (n2 != 0) {
                this.setProp(properties, "OAPort", Integer.toString(n2));
                System.out.println("Jacorb ORB loaded...IIOP port number is fixed at " + n2);
            } else {
                System.out.println("Jacorb ORB loaded...IIOP port number is dynamic");
            }
            if (n3 != 0) {
                this.setProp(properties, "OASSLPort", Integer.toString(n3));
                System.out.println("Jacorb ORB loaded...SSLIOP port number is fixed at " + n3);
            } else {
                System.out.println("Jacorb ORB loaded...SSLIOP port number is dynamic");
            }
            if (db.isFinestEnabled()) {
                this.setSysAndLocalProp(properties, "jacorb.log.default.verbosity", "DEBUG");
                this.setSysAndLocalProp(properties, "jacorb.poa.monitoring", "on");
            }
            if (db.isFinerEnabled()) {
                this.setSysAndLocalProp(properties, "jacorb.log.default.verbosity", "INFO");
                this.setProp(properties, "jacorb.debug.dump_outgoing_messages", "on");
                this.setProp(properties, "jacorb.debug.dump_incoming_messages", "on");
            }
            if (db.isFineEnabled()) {
                this.setSysAndLocalProp(properties, "jacorb.log.default.verbosity", "WARN");
            }
            try {
                if (db.isFinestEnabled()) {
                    System.out.println("Properties:");
                    properties.list(System.out);
                    System.out.println("End Properties");
                }
                orb = (ORB)org.omg.CORBA.ORB.init((String[])stringArray, (Properties)properties);
                ProtocolSelectionInterceptor.instance().init((org.omg.CORBA.ORB)orb);
                SecurityTicketInterceptor.instance().init((org.omg.CORBA.ORB)orb);
                POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
                System.out.println("orb.jar (Jacorb) version: 2.1.3.7");
                originalIiopPort = n2;
                originalSsliopPort = n3;
            }
            catch (Throwable throwable) {
                System.err.println("toString: " + throwable.toString());
                System.err.println("Stack trace:");
                throwable.printStackTrace(System.err);
                System.err.println("Message: " + throwable.getMessage());
                System.err.println("Args:");
                for (n = 0; n < stringArray.length; ++n) {
                    System.err.println("    " + stringArray[n]);
                }
                System.err.println("Properties:");
                properties.list(System.err);
                System.err.println("System Properties:");
                System.getProperties().list(System.err);
                throw new INITIALIZE("Error initializing ORB: org.jacorb.orb.ORB...suggest checking the spelling of the class name");
            }
            if (orb == null) {
                throw new INITIALIZE("ORB error: org.omg.CORBA.ORB.init() returned null");
            }
        } else {
            if (n2 < 0 || n2 > 65535) {
                throw new INITIALIZE("Error initializing ORB: invalid port configured.\n\nCTC has been configured to use the fixed port " + n2 + " for CORBA,\nbut that " + "port is not in the valid range 0..65535." + "\n\nCTC will now exit.\n\n");
            }
            throw new INITIALIZE("Error initializing ORB: port already in use.\n\nCTC has been configured to use the fixed port " + n2 + " for CORBA,\nbut that " + "port is already being used, possibly by " + "another CTC running\non this workstation." + "\n\nCTC will now exit.\n\n");
        }
        org.omg.CORBA.ORB.init();
        CtcHttpRetriever.setIorRewriter((IIorRewriter)new IorRewriter());
        object = new Thread(new Runnable(){

            public void run() {
                orb.run();
            }
        });
        ((Thread)object).start();
        return this;
    }

    public boolean addServiceContext(int n, byte[] byArray, java.lang.Object object) {
        return SecurityTicketInterceptor.addServiceContext((int)n, (byte[])byArray, (java.lang.Object)object);
    }

    public boolean removeServiceContext(int n, byte[] byArray, java.lang.Object object) {
        return SecurityTicketInterceptor.removeServiceContext((int)n, (byte[])byArray, (java.lang.Object)object);
    }

    public InputStream create_input_stream(byte[] byArray) {
        return new CDRInputStream((org.omg.CORBA.ORB)orb, byArray);
    }

    public int getIiopPort() {
        return Preferences.instance().getInt("ong.orb", "iioplistenerport", 0);
    }

    public int getSsliopPort() {
        return Preferences.instance().getInt("ong.orb", "sslioplistenerport", 0);
    }

    public boolean isPortAvailable(int n) {
        boolean bl = true;
        if (n < 0 || n > 65535) {
            bl = false;
        } else if (n != 0 && (originalIiopPort == -1 && originalSsliopPort == -1 || n != originalIiopPort && n != originalSsliopPort)) {
            try {
                ServerSocket serverSocket = new ServerSocket(n);
                serverSocket.close();
            }
            catch (SecurityException securityException) {
                bl = false;
                CtcJacORBDebug.printStackTrace((Throwable)securityException);
            }
            catch (IOException iOException) {
                bl = false;
                CtcJacORBDebug.printStackTrace((Throwable)iOException);
            }
        }
        return bl;
    }

    public void connect(Object object) {
        orb.connect(object);
    }

    public void disconnect(Object object) {
        orb.disconnect(object);
    }

    public String[] list_initial_services() {
        return orb.list_initial_services();
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        return orb.resolve_initial_references(string);
    }

    public String object_to_string(Object object) {
        return orb.object_to_string(object);
    }

    public Object string_to_object(String string) {
        if (string != null && string.startsWith("IOR:")) {
            return orb.string_to_object(string);
        }
        return null;
    }

    public NVList create_list(int n) {
        return orb.create_list(n);
    }

    public NVList create_operation_list(Object object) {
        return orb.create_operation_list(object);
    }

    public NamedValue create_named_value(String string, Any any, int n) {
        return orb.create_named_value(string, any, n);
    }

    public ExceptionList create_exception_list() {
        return orb.create_exception_list();
    }

    public ContextList create_context_list() {
        return orb.create_context_list();
    }

    public Context get_default_context() {
        return orb.get_default_context();
    }

    public Environment create_environment() {
        return orb.create_environment();
    }

    public OutputStream create_output_stream() {
        return orb.create_output_stream();
    }

    public void send_multiple_requests_oneway(Request[] requestArray) {
        orb.send_multiple_requests_oneway(requestArray);
    }

    public void send_multiple_requests_deferred(Request[] requestArray) {
        orb.send_multiple_requests_deferred(requestArray);
    }

    public boolean poll_next_response() {
        return orb.poll_next_response();
    }

    public Request get_next_response() throws WrongTransaction {
        return orb.get_next_response();
    }

    public TypeCode get_primitive_tc(TCKind tCKind) {
        return orb.get_primitive_tc(tCKind);
    }

    public TypeCode create_struct_tc(String string, String string2, StructMember[] structMemberArray) {
        return orb.create_struct_tc(string, string2, structMemberArray);
    }

    public TypeCode create_union_tc(String string, String string2, TypeCode typeCode, UnionMember[] unionMemberArray) {
        return orb.create_union_tc(string, string2, typeCode, unionMemberArray);
    }

    public TypeCode create_enum_tc(String string, String string2, String[] stringArray) {
        return orb.create_enum_tc(string, string2, stringArray);
    }

    public TypeCode create_alias_tc(String string, String string2, TypeCode typeCode) {
        return orb.create_alias_tc(string, string2, typeCode);
    }

    public TypeCode create_exception_tc(String string, String string2, StructMember[] structMemberArray) {
        return orb.create_exception_tc(string, string2, structMemberArray);
    }

    public TypeCode create_interface_tc(String string, String string2) {
        return orb.create_interface_tc(string, string2);
    }

    public TypeCode create_string_tc(int n) {
        return orb.create_string_tc(n);
    }

    public TypeCode create_wstring_tc(int n) {
        return orb.create_wstring_tc(n);
    }

    public TypeCode create_sequence_tc(int n, TypeCode typeCode) {
        return orb.create_sequence_tc(n, typeCode);
    }

    public TypeCode create_recursive_sequence_tc(int n, int n2) {
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_array_tc(int n, TypeCode typeCode) {
        return orb.create_array_tc(n, typeCode);
    }

    public TypeCode create_native_tc(String string, String string2) {
        return orb.create_native_tc(string, string2);
    }

    public TypeCode create_abstract_interface_tc(String string, String string2) {
        return orb.create_abstract_interface_tc(string, string2);
    }

    public TypeCode create_fixed_tc(short s, short s2) {
        return orb.create_fixed_tc(s, s2);
    }

    public TypeCode create_value_tc(String string, String string2, short s, TypeCode typeCode, ValueMember[] valueMemberArray) {
        return orb.create_value_tc(string, string2, s, typeCode, valueMemberArray);
    }

    public TypeCode create_recursive_tc(String string) {
        return orb.create_recursive_tc(string);
    }

    public TypeCode create_value_box_tc(String string, String string2, TypeCode typeCode) {
        return orb.create_value_box_tc(string, string2, typeCode);
    }

    public Any create_any() {
        return orb.create_any();
    }

    public Current get_current() {
        throw new NO_IMPLEMENT();
    }

    public void run() {
        orb.run();
    }

    public void shutdown(boolean bl) {
        orb.shutdown(bl);
    }

    public boolean work_pending() {
        return orb.work_pending();
    }

    public void perform_work() {
        orb.perform_work();
    }

    public boolean get_service_information(short s, ServiceInformationHolder serviceInformationHolder) {
        return orb.get_service_information(s, serviceInformationHolder);
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        return orb.create_policy(n, any);
    }

    public ValueFactory register_value_factory(String string, ValueFactory valueFactory) {
        return orb.register_value_factory(string, valueFactory);
    }

    public void unregister_value_factory(String string) {
        orb.unregister_value_factory(string);
    }

    public ValueFactory lookup_value_factory(String string) {
        return orb.lookup_value_factory(string);
    }

    public void set_delegate(java.lang.Object object) {
        orb.set_delegate(object);
    }

    public static class CtcJacORBDebug
    extends KDebug {
        private ArrayList<String> propList = new ArrayList();

        public CtcJacORBDebug(String string) {
            super(string);
        }

        public final void listInitialServices() {
            String[] stringArray = orb.list_initial_services();
            for (int i = 0; i < stringArray.length; ++i) {
                db.println(stringArray[i]);
            }
        }

        private final void addLocalPropInfo(String string, String string2, String string3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("local:  ");
            stringBuffer.append(string);
            stringBuffer.append(" = \"");
            if (string3 != null) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append("\" ");
            if (string3 != null) {
                stringBuffer.append("(System prop overrides requested value \"");
                stringBuffer.append(string2);
                stringBuffer.append("\")");
            }
            this.propList.add(stringBuffer.toString());
        }

        private final void addSystemPropInfo(String string, String string2, String string3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("system: ");
            stringBuffer.append(string);
            stringBuffer.append(" = \"");
            if (string3 != null) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append("\" ");
            if (string3 != null) {
                stringBuffer.append("(System prop overrides requested value \"");
                stringBuffer.append(string2);
                stringBuffer.append("\")");
            }
            this.propList.add(stringBuffer.toString());
        }

        private final void addBothPropInfo(String string, String string2, String string3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("both:   ");
            stringBuffer.append(string);
            stringBuffer.append(" = \"");
            if (string3 != null) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append("\" ");
            if (string3 != null) {
                stringBuffer.append("(System prop overrides requested value \"");
                stringBuffer.append(string2);
                stringBuffer.append("\")");
            }
            this.propList.add(stringBuffer.toString());
        }

        public final void dumpOrbProps() {
            this.println("ORB properties:");
            for (String string : this.propList) {
                this.println("  " + string);
            }
            this.println("System properties (may include ORB props not listed above)");
            Enumeration<?> enumeration = System.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                String string;
                string = (String)enumeration.nextElement();
                this.println("  " + string + " = \"" + System.getProperty(string) + "\"");
            }
        }

        public final void setLoggerLevel(String string, String string2) {
            Level level;
            LogManager logManager = LogManager.getLogManager();
            Logger logger = logManager.getLogger(string);
            try {
                level = Level.parse(string2);
            }
            catch (NullPointerException nullPointerException) {
                this.println("Level string is null, setting level to null");
                level = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.println("Level \"" + string2 + "\" is invalid, not changing log level");
                return;
            }
            if (logger != null) {
                logger.setLevel(level);
            } else {
                this.println("Cannot find logger with name = \"" + string + "\"");
            }
        }

        public final void listLoggers() {
            LogManager logManager = LogManager.getLogManager();
            Enumeration<String> enumeration = logManager.getLoggerNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Logger logger = logManager.getLogger(string);
                this.println(string + " -- " + (logger.getLevel() != null ? logger.getLevel().toString() : "null"));
            }
        }

        public final void dumpLoggers() {
            LogManager logManager = LogManager.getLogManager();
            Enumeration<String> enumeration = logManager.getLoggerNames();
            boolean bl = true;
            this.println("====================");
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Logger logger = logManager.getLogger(string);
                Logger logger2 = logger.getParent();
                if (!bl) {
                    this.println("--------------------");
                } else {
                    bl = false;
                }
                this.println("Logger: " + string);
                this.println("Parent: " + (logger2 != null ? logger2.getName() : "none"));
                this.println("Level:  " + (logger.getLevel() != null ? logger.getLevel().toString() : "null"));
                this.println("Filter: " + (logger.getFilter() != null ? logger.getFilter().getClass().getName() : "none"));
                this.println("Using parent handlers: " + logger.getUseParentHandlers());
                this.printHandlerInfo(logger.getHandlers());
            }
            this.println("====================");
        }

        private void printHandlerInfo(Handler[] handlerArray) {
            if (handlerArray.length == 0) {
                this.println("Handlers: none");
            } else {
                this.println("Handlers:");
                for (int i = 0; i < handlerArray.length; ++i) {
                    this.printHandlerInfo(handlerArray[i], i == 0);
                }
            }
        }

        private void printHandlerInfo(Handler handler, boolean bl) {
            if (!bl) {
                this.println("    ----------------");
            }
            this.println("    Class:    " + handler.getClass().getName());
            this.println("    Level:    " + (handler.getLevel() != null ? handler.getLevel().toString() : "null"));
            this.println("    Filter:   " + (handler.getFilter() != null ? handler.getFilter().getClass().getName() : "none"));
            this.println("   Formatter: " + (handler.getFormatter() != null ? handler.getFormatter().getClass().getName() : "none"));
        }
    }
}

