/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIShowArpAction
extends CLIAction {
    private static String COMMAND = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Exec>show arp</Exec></CLI></Request>";
    private KDebug db;

    public CLIShowArpAction(ITTYSession iTTYSession, KDebug kDebug) {
        this(iTTYSession.getHostname(), kDebug);
    }

    public CLIShowArpAction(String string, KDebug kDebug) {
        super(string);
        this.db = kDebug;
        this.cliCmd = new CLICmdRsp[1];
    }

    public List<ArpInfo> get() {
        this.cliCmd[0] = new CLICmdRsp(COMMAND, true);
        try {
            if (super.performAction(this.cliCmd[0])) {
                if (this.db.on()) {
                    this.db.println("failed to send XML command");
                }
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (TTYException tTYException) {
            return null;
        }
        return this.parseResponse();
    }

    private List<ArpInfo> parseResponse() {
        Object object;
        Object object2;
        Document document;
        block13: {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            document = null;
            try {
                object2 = documentBuilderFactory.newDocumentBuilder();
                object = this.cliCmd[0].getResponse();
                if (object == null) {
                    if (this.db.on) {
                        this.db.println("response==null");
                    }
                    return null;
                }
                document = ((DocumentBuilder)object2).parse(new ByteArrayInputStream(((String)object).getBytes()));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (this.db.on) {
                    this.db.println("ParseConfigurationException while parsing ARP");
                }
            }
            catch (SAXException sAXException) {
                if (this.db.on) {
                    this.db.println("SAXException while parsing ARP");
                }
            }
            catch (IOException iOException) {
                if (!this.db.on) break block13;
                this.db.println("IOException while parsing ARP");
            }
        }
        if (document == null) {
            if (this.db.on) {
                this.db.println("Error while parsing ARP: dom==null");
            }
            return null;
        }
        object2 = document.getDocumentElement();
        object = object2.getElementsByTagName("Exec");
        if (object == null || object.getLength() == 0) {
            if (this.db.on) {
                this.db.println("Error while parsing ARP: <Exec> not found");
            }
            return null;
        }
        String string = ((Element)object.item(0)).getTextContent();
        String[] stringArray = string.split("\\n");
        ArrayList<ArpInfo> arrayList = new ArrayList<ArpInfo>();
        for (int i = 4; i < stringArray.length; ++i) {
            String string2 = stringArray[i].replaceAll("\\s+", " ");
            String[] stringArray2 = string2.split("\\s");
            if (stringArray2.length != 6) continue;
            arrayList.add(new ArpInfo(stringArray2[0], stringArray2[2], stringArray2[5]));
        }
        return arrayList;
    }

    public class ArpInfo {
        private String ip;
        private String mac;
        private String mgmt;

        ArpInfo(String string, String string2, String string3) {
            this.ip = string;
            this.mac = string2;
            this.mgmt = string3;
        }

        public String getIp() {
            return this.ip;
        }

        public String getMacAddress() {
            return this.mac;
        }

        public String getMgmtInterface() {
            return this.mgmt;
        }
    }
}

