/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.IObserver;
import cerent.util.IPAddressTranslator;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYSessionsPool;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public class TTYSessionFactory {
    private final int poolSize = 1;
    private ConcurrentHashMap<HostType, TTYSessionsPool> poolMap = new ConcurrentHashMap();
    private static final TTYSessionFactory mInstance = new TTYSessionFactory();

    private TTYSessionFactory() {
    }

    public static TTYSessionFactory instance() {
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITTYSession getSession(String string, String string2, String string3, SessionType sessionType) throws IOException {
        string = IPAddressTranslator.instance().getActualAddressDisplay(string);
        TTYSessionFactory tTYSessionFactory = this;
        synchronized (tTYSessionFactory) {
            if (!this.poolMap.containsKey(new HostType(string, sessionType.name()))) {
                TTYSessionsPool tTYSessionsPool = new TTYSessionsPool(string, string2, string3, TTYSessionsPool.SessionType.CLI, 1);
                this.poolMap.put(new HostType(string, SessionType.CLI.name()), tTYSessionsPool);
                TTYSessionsPool tTYSessionsPool2 = new TTYSessionsPool(string, string2, string3, TTYSessionsPool.SessionType.XML, 1);
                this.poolMap.put(new HostType(string, SessionType.XML.name()), tTYSessionsPool2);
            }
        }
        return this.getSession(string, sessionType);
    }

    public ITTYSession getSession(IObserver iObserver, String string, SessionType sessionType) throws IOException {
        string = IPAddressTranslator.instance().getActualAddressDisplay(string);
        TTYSessionsPool tTYSessionsPool = this.poolMap.get(new HostType(string, sessionType.name()));
        return tTYSessionsPool.getSession(iObserver);
    }

    public ITTYSession getSession(String string, SessionType sessionType) throws IOException {
        string = IPAddressTranslator.instance().getActualAddressDisplay(string);
        TTYSessionsPool tTYSessionsPool = this.poolMap.get(new HostType(string, sessionType.name()));
        return tTYSessionsPool.getSession();
    }

    public ITTYSession getSession(String string) throws IOException {
        string = IPAddressTranslator.instance().getActualAddressDisplay(string);
        TTYSessionsPool tTYSessionsPool = this.poolMap.get(new HostType(string, "CLI"));
        return tTYSessionsPool.getSession();
    }

    public void destroySessions(String string) {
        string = IPAddressTranslator.instance().getActualAddressDisplay(string);
        TTYSessionsPool tTYSessionsPool = this.poolMap.get(new HostType(string, "CLI"));
        if (tTYSessionsPool != null) {
            tTYSessionsPool.destroy();
            this.poolMap.remove(new HostType(string, "CLI"));
        }
        if ((tTYSessionsPool = this.poolMap.get(new HostType(string, "XML"))) != null) {
            tTYSessionsPool.destroy();
            this.poolMap.remove(new HostType(string, "XML"));
        }
    }

    private class HostType {
        public String hostName;
        public String sessionType;

        public HostType(String string, String string2) {
            this.hostName = string;
            this.sessionType = string2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof HostType)) {
                return false;
            }
            return ((HostType)object).hostName.equals(this.hostName) && ((HostType)object).sessionType.equals(this.sessionType);
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this.hostName.hashCode();
            n = 31 * n + this.sessionType.hashCode();
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionType {
        CLI,
        XML;

    }
}

