/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.IObserver;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.UObservable;
import cerent.util.tty.CLITTYSession;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYLogFactory;
import cerent.util.tty.XMLTTYSession;
import de.mud.jta.CliSessionFactory;
import de.mud.jta.HostUnreachableException;
import de.mud.jta.ICliSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class TTYSessionsPool
extends UObservable {
    private static final KDebug db = new KDebug("TTYSessionsPool");
    private static final String LOG_FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static int SESSION_TIMEOUT;
    public static int KEEPALIVE_TIMEOUT;
    private List<ITTYSession> activeSessions;
    private ArrayBlockingQueue<ITTYSession> idleSessions;
    private SessionType currentType;
    private int maxSessions;
    private String hostname;
    private String username;
    private String password;
    private AtomicBoolean generating = new AtomicBoolean(false);
    private SSHSessionGenerator genThread = null;

    public TTYSessionsPool(String string, String string2, String string3, SessionType sessionType, int n) {
        this.maxSessions = n;
        this.hostname = string;
        this.username = string2;
        this.password = string3;
        this.currentType = sessionType;
        this.activeSessions = Collections.synchronizedList(new ArrayList(n));
        this.idleSessions = new ArrayBlockingQueue(n, true);
    }

    public ITTYSession getSession(IObserver iObserver) throws IOException {
        this.addObserver(iObserver);
        return this.getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITTYSession getSession() throws IOException {
        if (db.on()) {
            db.println("getSession called on " + this.hostname);
        }
        try {
            Object object = this;
            synchronized (object) {
                if (!this.generating.get() && this.idleSessions.isEmpty() && this.activeSessions.size() < this.maxSessions) {
                    ITTYSession iTTYSession = null;
                    while (iTTYSession == null) {
                        try {
                            iTTYSession = this.createTTYSession();
                        }
                        catch (HostUnreachableException hostUnreachableException) {
                            this.setChanged();
                            this.notifyObservers("HOST_UNREACHABLE");
                            this.spawnSessionGenerator();
                            throw hostUnreachableException;
                        }
                    }
                    if (!this.idleSessions.offer(iTTYSession)) {
                        iTTYSession.destroy();
                    }
                }
            }
            object = this.idleSessions.take();
            if (!object.isClosed()) {
                this.activeSessions.add((ITTYSession)object);
            } else {
                object = null;
                while (object == null) {
                    try {
                        object = this.createTTYSession();
                    }
                    catch (HostUnreachableException hostUnreachableException) {
                        this.setChanged();
                        this.notifyObservers("HOST_UNREACHABLE");
                        this.spawnSessionGenerator();
                        throw hostUnreachableException;
                    }
                }
                this.activeSessions.add((ITTYSession)object);
            }
            return object;
        }
        catch (InterruptedException interruptedException) {
            if (db.on()) {
                db.println("getSession() interrupted while doing take() in idleSessions");
            }
            throw new IOException("Interrupted while accessing the idle TTY sessions queue");
        }
    }

    public void releaseSession(IObserver iObserver, ITTYSession iTTYSession, boolean bl) {
        this.releaseSession(iTTYSession, bl);
        this.deleteObserver(iObserver);
    }

    public void releaseSession(ITTYSession iTTYSession, boolean bl) {
        if (db.on()) {
            db.println("releaseSession called on " + this.hostname);
        }
        if (!bl && !iTTYSession.isClosed()) {
            if (!this.idleSessions.offer(iTTYSession)) {
                iTTYSession.destroy();
            }
        } else {
            iTTYSession.destroy();
            this.spawnSessionGenerator();
        }
        this.activeSessions.remove(iTTYSession);
    }

    public int getNumActive() {
        return this.activeSessions.size();
    }

    public int getNumIdle() {
        return this.idleSessions.size();
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public String getHostName() {
        return this.hostname;
    }

    private ITTYSession createTTYSession() throws HostUnreachableException {
        if (db.on()) {
            db.println("createTTYSession called. New TTY session required for " + this.hostname);
        }
        ICliSession iCliSession = CliSessionFactory.getCliSession((String)this.hostname, (String)this.username, (String)this.password, null, (int)0);
        iCliSession.setSessionTimeout(SESSION_TIMEOUT);
        if (this.currentType == SessionType.XML) {
            return new XMLTTYSession(iCliSession, this);
        }
        return new CLITTYSession(iCliSession, this);
    }

    private void offerSession(ITTYSession iTTYSession) {
        if (!this.idleSessions.offer(iTTYSession)) {
            iTTYSession.destroy();
        }
    }

    private void spawnSessionGenerator() {
        if (this.generating.compareAndSet(false, true)) {
            this.genThread = new SSHSessionGenerator("SSHSessionGenerator for " + this.hostname + "[" + (Object)((Object)this.currentType) + "]");
            this.genThread.start();
            if (db.on()) {
                db.println("Session Generator Started for " + this.hostname);
            }
        }
    }

    public void destroy() {
        for (ITTYSession iTTYSession : this.activeSessions) {
            iTTYSession.destroy();
        }
        this.activeSessions.clear();
        for (ITTYSession iTTYSession : this.idleSessions) {
            iTTYSession.destroy();
        }
        this.idleSessions.clear();
        if (this.generating.compareAndSet(true, true)) {
            this.genThread.stopGeneration();
        }
    }

    public KDebug getDb() {
        return db;
    }

    static {
        System.setProperty(LOG_FACTORY_PROPERTY, TTYLogFactory.class.getName());
        SESSION_TIMEOUT = 45000;
        KEEPALIVE_TIMEOUT = 3000;
    }

    private class SSHSessionGenerator
    extends Thread {
        private boolean running;

        public SSHSessionGenerator(String string) {
            super(string);
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ITTYSession iTTYSession = null;
            boolean bl = true;
            try {
                while (iTTYSession == null && this.running) {
                    try {
                        Thread.sleep(4000L);
                        iTTYSession = TTYSessionsPool.this.createTTYSession();
                        TTYSessionsPool.this.offerSession(iTTYSession);
                        TTYSessionsPool.this.generating.set(false);
                    }
                    catch (HostUnreachableException hostUnreachableException) {
                        if (!bl) continue;
                        bl = false;
                        String string = KErrorMsg.getString((EID)KEMC.EID_CRS_CONNECTION_FAILED_PARAM_1, (Object)TTYSessionsPool.this.hostname) + ": " + hostUnreachableException.getMessage();
                        DetailedLog detailedLog = new DetailedLog(3, string);
                        EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Object var7_8 = null;
                TTYSessionsPool.this.generating.set(false);
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                TTYSessionsPool.this.generating.set(false);
                throw throwable;
            }
        }

        public void stopGeneration() {
            this.running = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionType {
        CLI,
        XML;

    }
}

