/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.util.view.fv.GrapherViewCommand;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.TreeViewCommand;
import cerent.util.view.fv.ViewCommand;
import cerent.util.view.fv.ViewManager;

public class ViewCommandHandler {
    public void doCommand(ViewCommand viewCommand) {
        try {
            if (viewCommand instanceof TreeViewCommand) {
                this.doCommand((TreeViewCommand)viewCommand);
            } else if (viewCommand instanceof GrapherViewCommand) {
                this.doCommand((GrapherViewCommand)viewCommand);
            } else if (viewCommand instanceof MouseViewCommand) {
                this.doCommand((MouseViewCommand)viewCommand);
            }
        }
        catch (Exception exception) {
            ViewManager.addToLog(this, "Command handler exception" + exception);
        }
    }

    public void doCommand(TreeViewCommand treeViewCommand) {
        treeViewCommand.getDestNodeManager().doTreeClick(treeViewCommand);
    }

    public void doCommand(GrapherViewCommand grapherViewCommand) {
        switch (grapherViewCommand.getKeyIntValue()) {
            case 1: {
                grapherViewCommand.getDestGrapher().doAdd(grapherViewCommand);
                break;
            }
            case 2: {
                grapherViewCommand.getDestGrapher().doDelete(grapherViewCommand);
                break;
            }
            case 3: {
                grapherViewCommand.getDestGrapher().doChange(grapherViewCommand);
            }
        }
    }

    public void doCommand(MouseViewCommand mouseViewCommand) {
        switch (mouseViewCommand.getKeyIntValue()) {
            case 3: {
                mouseViewCommand.getDestGrapher().doMouseClick(mouseViewCommand);
                break;
            }
            case 4: {
                mouseViewCommand.getDestGrapher().doMouseDoubleClick(mouseViewCommand);
                break;
            }
            case 5: 
            case 8: {
                mouseViewCommand.getDestGrapher().doMousePopup(mouseViewCommand);
                break;
            }
            case 6: {
                mouseViewCommand.getDestGrapher().doMouseDrag(mouseViewCommand);
                break;
            }
            case 7: {
                mouseViewCommand.getDestGrapher().doMouseUpdate(mouseViewCommand);
            }
        }
    }
}

