/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvPortModel;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.IViewShapeInfo;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewGraphic;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewLabel;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPin;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewPureGraphicalLink;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.ViewSvgParamInfo;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import ilog.views.IlvApplyObject;
import ilog.views.IlvDefaultManagerFrame;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvAttachmentLayout;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.linkconnector.IlvPinLinkConnector;
import ilog.views.sdm.graphic.IlvSDMCompositeNode;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewCompositeGraphic
extends IlvSDMCompositeNode
implements IViewGraph {
    private final IlvPinLinkConnector connector = new IlvPinLinkConnector((IlvGraphic)this);
    protected ISvgParams params = null;
    protected HashMap<String, IViewGraph> children = new HashMap();
    protected HashMap<String, ViewPin> pins = new HashMap();
    protected HashMap<Integer, IViewLink> graphLinks = new HashMap();
    protected HashMap<Integer, ViewPureGraphicalLink> mpoLinks = new HashMap();
    protected HashMap<Integer, IViewLink> sideGraphLinks = new HashMap();
    protected ViewLabel graphlabel_hf = null;
    protected ViewLabel graphlabel_vf = null;
    protected IlvGraphic background = null;
    protected ViewGraphic extraIcon = null;
    protected IlvAttachmentLayout layout = null;

    @Override
    public void dispose() {
        IlvGraphicEnumeration ilvGraphicEnumeration;
        this.params = null;
        if (this.children != null) {
            ilvGraphicEnumeration = this.children.values();
            for (IViewGraph iViewGraph : ilvGraphicEnumeration) {
                iViewGraph.dispose();
            }
            this.children.clear();
        }
        this.children = null;
        ilvGraphicEnumeration = this.getObjects();
        if (this.graphLinks != null) {
            this.graphLinks.clear();
            this.graphLinks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPinPosition(String string, IlvPoint ilvPoint) {
        IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)this.pins.get(string);
        if (ilvGrapherPin != null) {
            IlvManager ilvManager;
            IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
            IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            if (ilvGraphicBag == null) {
                ilvGrapherPin.setPosition(ilvPoint, null);
                return;
            }
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(true, true);
            }
            try {
                ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new SetPinPosition(string, ilvPoint), null, true);
            }
            finally {
                if (ilvManager != null) {
                    ilvManager.setContentsAdjusting(false, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String string, String string2) {
        if (this.getObject(string) != null) {
            IlvManager ilvManager;
            IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
            IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            if (ilvGraphicBag == null) {
                IlvGraphic ilvGraphic = this.getObject(string);
                if (ilvGraphic instanceof IlvZoomableLabel) {
                    ((IlvZoomableLabel)ilvGraphic).setLabel(string2);
                }
                return;
            }
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(true, true);
            }
            try {
                ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new SetLabel(string, string2), null, true);
            }
            finally {
                if (ilvManager != null) {
                    ilvManager.setContentsAdjusting(false, true);
                }
            }
        }
    }

    public ISvgParams getParams() {
        return this.params;
    }

    public IlvPinLinkConnector getConnector() {
        return this.connector;
    }

    private HashMap getPinsPoints() {
        this.getGraphPins();
        HashMap<ViewPin, IlvPoint> hashMap = new HashMap<ViewPin, IlvPoint>();
        if (this.getGraphicBag() instanceof IlvGrapher) {
            IlvGrapher ilvGrapher = (IlvGrapher)this.getGraphicBag();
            Collection<ViewPin> collection = this.getGraphPins().values();
            for (ViewPin viewPin : collection) {
                hashMap.put(viewPin, viewPin.getPosition(null));
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void graphicScale(double d, double d2) {
        HashMap hashMap = this.getPinsPoints();
        if (d == -1.0 || d2 == -1.0) {
            IlvManager ilvManager;
            IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
            IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(true, true);
            }
            try {
                if (ilvGraphicBag != null) {
                    ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new ScalePins(hashMap, d, d2), null, true);
                } else {
                    System.out.println("flipH didn't work for bag=null");
                }
            }
            finally {
                if (ilvManager != null) {
                    ilvManager.setContentsAdjusting(false, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void graphicMove(float f, float f2) {
        IlvManager ilvManager;
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
        if (ilvManager != null) {
            ilvManager.setContentsAdjusting(true, true);
        }
        try {
            ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvPoint ilvPoint = (IlvPoint)object;
                    ilvGraphic.move(ilvPoint.x, ilvPoint.y);
                }
            }, (Object)new IlvPoint(f, f2), true);
        }
        finally {
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void graphicFlipPortsLabel(double d, double d2) {
        IlvManager ilvManager;
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
        if (ilvManager != null) {
            ilvManager.setContentsAdjusting(true, true);
        }
        try {
            if (ilvGraphicBag != null) {
                ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new ScaleLabels(d, d2), null, true);
            } else {
                System.out.println("graphicFlipPortsLabel didn't work for bag=null");
            }
        }
        finally {
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void graphicRotate(Point point, double d) {
        IlvManager ilvManager;
        HashMap hashMap = this.getPinsPoints();
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
        if (ilvManager != null) {
            ilvManager.setContentsAdjusting(true, true);
        }
        try {
            IlvPoint ilvPoint = new IlvPoint((float)point.x, (float)point.y);
            ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new RotatePins(hashMap, ilvPoint, d), null, true);
        }
        finally {
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(false, true);
            }
        }
    }

    public HashMap<String, ViewPin> getGraphPins() {
        return (HashMap)this.pins.clone();
    }

    @Override
    public HashMap<String, IViewGraph> getGraphChildren() {
        return (HashMap)this.children.clone();
    }

    public HashMap<String, IViewGraph> getGraphChildren(String string) {
        HashMap<String, IViewGraph> hashMap = new HashMap<String, IViewGraph>();
        Collection<IViewGraph> collection = this.getGraphChildren().values();
        for (IViewGraph iViewGraph : collection) {
            String string2 = iViewGraph.getGraphKey();
            if (!string2.contains(string)) continue;
            hashMap.put(string2, iViewGraph);
        }
        return hashMap;
    }

    public HashMap<Integer, IViewLink> getGraphLinks() {
        return (HashMap)this.graphLinks.clone();
    }

    public HashMap<Integer, ViewPureGraphicalLink> getMpoLinks() {
        return (HashMap)this.mpoLinks.clone();
    }

    public HashMap<Integer, IViewLink> getSideGraphLinks() {
        return (HashMap)this.sideGraphLinks.clone();
    }

    public ViewCompositeGraphic(ISvgParams iSvgParams, ViewGraphicSet viewGraphicSet) {
        this.setChildren(0, (IlvGraphic)viewGraphicSet);
        this.params = iSvgParams;
        this.layout = new IlvAttachmentLayout();
        this.setLayout((IlvLayoutManager)this.layout);
    }

    public IViewGraph getOwner() {
        return this.params.getOwner();
    }

    public ViewManager getViewManager() {
        return this.params.getViewManager();
    }

    public IFvNodeModel getNode() {
        return this.getViewManager().getNode();
    }

    public ViewManagerToolKit getTk() {
        return this.getViewManager().getViewTk();
    }

    public int compareTo(IViewGraph iViewGraph) {
        return iViewGraph.getGraphKey().compareTo(this.getGraphKey());
    }

    private ViewAttribute<IViewSvgParamInfo, Object, Object> getViewAttr(IlvGraphic ilvGraphic) {
        try {
            ViewSvgParamInfo viewSvgParamInfo = ViewSvgDecoderHelper.getSvgParamInfo(ilvGraphic.getName());
            return new ViewAttribute(viewSvgParamInfo, ilvGraphic);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace(functException);
            return null;
        }
    }

    protected void initViewGraphic(IlvGraphicSet ilvGraphicSet) {
        if (ilvGraphicSet instanceof ViewGraphicSet) {
            IlvGraphic[] ilvGraphicArray;
            ViewGraphicSet viewGraphicSet = (ViewGraphicSet)ilvGraphicSet;
            HashMap<Integer, IFvPortModel> hashMap = this.getModels();
            IlvGraphicEnumeration ilvGraphicEnumeration = viewGraphicSet.getObjects();
            LinkedList<IlvGraphic> linkedList = new LinkedList<IlvGraphic>();
            ArrayList<IlvGraphic[]> arrayList = new ArrayList<IlvGraphic[]>();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvGraphicArray = ilvGraphicEnumeration.nextElement();
                if (!Character.isUpperCase(ilvGraphicArray.getName().charAt(0)) || ilvGraphicArray.getName().length() < 9) continue;
                arrayList.add(ilvGraphicArray);
            }
            ilvGraphicArray = arrayList.toArray(new IlvGraphic[0]);
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                IlvGraphic ilvGraphic = ilvGraphicArray[i];
                boolean bl = false;
                ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute = this.getViewAttr(ilvGraphic);
                ViewSvgDecoderHelper.SvgTypeEnum svgTypeEnum = viewAttribute.getKey().getSvgTyp();
                if (svgTypeEnum == ViewSvgDecoderHelper.SvgTypeEnum.UNK) continue;
                try {
                    switch (viewAttribute.getKey().getSvgTyp()) {
                        case CARD_BCKG: {
                            this.updateCardBckgInfo(viewAttribute);
                            break;
                        }
                        case CARD_PORT: {
                            this.setInfoPos(viewAttribute);
                            viewAttribute.setBag(hashMap);
                            IViewGraph iViewGraph = this.createCardPort(viewAttribute);
                            if (iViewGraph != null) {
                                this.addPort(iViewGraph, viewAttribute.getKey());
                            }
                            bl = true;
                            break;
                        }
                        case MPO_PORT: {
                            this.setInfoPos(viewAttribute);
                            viewAttribute.setBag(hashMap);
                            ilvGraphic.setVisible(this.addPort(this.createMpoPort(viewAttribute), viewAttribute.getKey()));
                            bl = true;
                            break;
                        }
                        case SIDE_PORT: {
                            this.setInfoPos(viewAttribute);
                            viewAttribute.setBag(hashMap);
                            this.addPort(this.createSidePort(viewAttribute), viewAttribute.getKey());
                            bl = true;
                            break;
                        }
                        case SIDE_LABEL: {
                            this.createSideLabel(viewAttribute);
                            break;
                        }
                        case WORK_SELECT_LINE: 
                        case PROT_SELECT_LINE: {
                            this.createSelectorLine(viewAttribute);
                            break;
                        }
                        case ICON_LABEL: {
                            this.createIconLabel(viewAttribute);
                            break;
                        }
                        case PORT_LABEL: {
                            this.createPortLabel(viewAttribute);
                            break;
                        }
                        case ALARM_LABEL: {
                            this.createAlarmLabel(viewAttribute);
                            break;
                        }
                        case CARD_NAME_LABEL: {
                            this.createCardNameLabel(viewAttribute);
                            break;
                        }
                        case CARD_EXTRA_LABEL: {
                            this.createCardExtraLabel(viewAttribute);
                            break;
                        }
                        case EXTRA_ICON: {
                            this.createExtraIcon(viewAttribute);
                            break;
                        }
                        case PIN: {
                            this.setInfoPos(viewAttribute);
                            String string = "";
                            if (this instanceof ViewCardGrapher) {
                                string = String.valueOf(((ViewCardGrapher)this).getShelfId()) + "-" + String.valueOf(((ViewCardGrapher)this).getSlotId() + "-");
                            }
                            string = string + viewAttribute.getKey().getSvgPortTyp().toString() + "-" + viewAttribute.getKey().getSvgNumId() + "-" + viewAttribute.getKey().getSvgDir().toString();
                            ViewPin viewPin = new ViewPin(this.connector, ilvGraphic.getCenter(new IlvTransformer()), new IlvTransformer());
                            viewPin.key = string;
                            if (viewPin != null && !this.pins.containsKey(string)) {
                                this.pins.put(string, viewPin);
                                viewPin.pinCompo = new IlvCompositeGraphic();
                                IlvAttachmentLayout ilvAttachmentLayout = new IlvAttachmentLayout();
                                viewPin.pinCompo.setLayout((IlvLayoutManager)ilvAttachmentLayout);
                                viewPin.pinCompo.setChildren(0, ilvGraphic);
                                this.setChildren(this.getChildren().length, (IlvGraphic)viewPin.pinCompo);
                                this.addPinToGrapher(viewAttribute, viewPin);
                                viewPin.grapher = (ViewDomainGrapher)this.getGraphParent();
                            }
                            bl = true;
                            break;
                        }
                        case ALARM_BALLOON: {
                            break;
                        }
                    }
                    if (!bl) continue;
                    linkedList.add((IlvGraphic)viewAttribute.getValue());
                    continue;
                }
                catch (FunctException functException) {
                    FunctDebug.printStackTrace(functException);
                    continue;
                }
                catch (Exception exception) {
                    FunctDebug.printStackTrace(exception);
                }
            }
            for (IlvGraphic ilvGraphic : linkedList) {
                if (this.getGraphicBag() == null) continue;
                viewGraphicSet.removeObject(ilvGraphic, false);
            }
            viewGraphicSet.setName(this.getName());
        }
    }

    protected void addPinToGrapher(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute, ViewPin viewPin) {
    }

    public void setLabelVisible(ViewSvgDecoderHelper.SvgTypeEnum svgTypeEnum) {
        if (this.graphlabel_hf == null || this.graphlabel_vf == null) {
            return;
        }
        switch (svgTypeEnum) {
            case CARD_NAME_LABEL: {
                this.graphlabel_hf.setVisible(false);
                this.graphlabel_vf.setVisible(false);
                break;
            }
            case CARD_LABEL_HF: {
                this.graphlabel_hf.setVisible(true);
                this.graphlabel_vf.setVisible(false);
                break;
            }
            case CARD_LABEL_VF: {
                this.graphlabel_hf.setVisible(false);
                this.graphlabel_vf.setVisible(true);
                break;
            }
        }
    }

    public abstract String getShortName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlarmColor(Color color) {
        IlvGraphic ilvGraphic = this.getObject("CARD_BCKG");
        if (ilvGraphic != null) {
            IlvManager ilvManager;
            IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
            IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            if (ilvGraphicBag == null) {
                ilvGraphic.setBackground(color);
                return;
            }
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(true, true);
            }
            try {
                ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new SetBkgColor(ilvGraphic, color), null, true);
            }
            finally {
                if (ilvManager != null) {
                    ilvManager.setContentsAdjusting(false, true);
                }
            }
        }
    }

    public abstract void paintParent(Color var1);

    protected void initDefaultDomain(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) {
    }

    protected HashMap<Integer, IFvPortModel> getModels() {
        return null;
    }

    private void setInfoPos(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) {
        viewAttribute.getKey().setPos((Rectangle2D)((IlvGraphic)viewAttribute.getValue()).boundingBox());
    }

    protected void createPortLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createCardNameLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createCardExtraLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createExtraIcon(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createAlarmLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createSideLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createSelectorLine(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createIconLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected IViewGraph createSidePort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected IViewGraph createMpoPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected IViewGraph createCardPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception, FunctException {
        ViewSvgDecoderHelper.SvgTypePortEnum svgTypePortEnum = viewAttribute.getKey().getSvgPortTyp();
        if (svgTypePortEnum == null) {
            throw new FunctException("Error in port Creation");
        }
        if (svgTypePortEnum == ViewSvgDecoderHelper.SvgTypePortEnum.BAND_PORT) {
            return this.createBandPort(viewAttribute);
        }
        return this.createGenericPort(viewAttribute);
    }

    protected IViewGraph createBandPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected IViewGraph createBandPin(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected IViewGraph createGenericPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected ViewLabel createCardLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected boolean addPort(IViewGraph iViewGraph, IViewSvgParamInfo iViewSvgParamInfo) {
        return false;
    }

    protected void updateCardBckgInfo(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    public abstract IViewShapeInfo getInfo();

    protected abstract void onInitPopupMenu(UPopupMenu var1);

    public boolean isObjectsIntersected(Object object, Object object2) {
        if (object instanceof IlvGrapher && object2 instanceof IlvGrapher) {
            IlvGrapher ilvGrapher = (IlvGrapher)object;
            IlvGrapher ilvGrapher2 = (IlvGrapher)object2;
            IlvRect ilvRect = ilvGrapher.boundingBox();
            IlvRect ilvRect2 = ilvGrapher2.boundingBox();
            return ilvRect.intersects((Rectangle2D)ilvRect2);
        }
        return false;
    }

    @Override
    public void addGraph(IViewGraph iViewGraph, boolean bl, IViewGraph.Layers layers) {
    }

    @Override
    public void addGraphNode(IViewGraph iViewGraph, boolean bl, IViewGraph.Layers layers) {
        if (iViewGraph != null && !this.children.containsKey(iViewGraph.getGraphKey())) {
            this.children.put(iViewGraph.getGraphKey(), iViewGraph);
            ViewManager.addToLog(this, "ViewCompositeGraphic> addGraphNode name:" + iViewGraph.getGraphKey() + " layer:" + (Object)((Object)layers));
        }
    }

    @Override
    public void delGraphNode(IViewGraph iViewGraph) {
        if (iViewGraph != null && this.children.containsKey(iViewGraph.getGraphKey())) {
            this.removeObject((IlvGraphic)iViewGraph, false);
            this.children.remove(iViewGraph.getGraphKey());
        }
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public IViewGraph getGraphParent() {
        return null;
    }

    public Rectangle2D getGraphBound() {
        return this.boundingBox().getBounds2D();
    }

    @Override
    public IViewGraph.Layers getLayer() {
        return this.params.getLayer();
    }

    public String toString() {
        return "ViewCompositeGraphic";
    }

    public ViewPortGraphic getPortGraph(int n) {
        return (ViewPortGraphic)this.getGraphChildren().get(ViewManager.idToString(n));
    }

    public int getLinksCount(ViewPortGraphic viewPortGraphic) {
        Collection<IViewLink> collection = this.graphLinks.values();
        int n = 0;
        for (IViewLink iViewLink : collection) {
            if (iViewLink.getLinkModel().getLink().getFrom() == Integer.valueOf(viewPortGraphic.getGraphKey()).intValue()) {
                ++n;
            }
            if (iViewLink.getLinkModel().getLink().getTo() != Integer.valueOf(viewPortGraphic.getGraphKey()).intValue()) continue;
            ++n;
        }
        collection = this.sideGraphLinks.values();
        for (IViewLink iViewLink : collection) {
            if (iViewLink.getFromName() == viewPortGraphic.getGraphKey()) {
                ++n;
            }
            if (iViewLink.getToName() != viewPortGraphic.getGraphKey()) continue;
            ++n;
        }
        Collection<ViewPureGraphicalLink> collection2 = this.mpoLinks.values();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            ViewPureGraphicalLink viewPureGraphicalLink = (ViewPureGraphicalLink)iterator.next();
            if (viewPureGraphicalLink.getFromName() == viewPortGraphic.getGraphKey()) {
                ++n;
            }
            if (viewPureGraphicalLink.getToName() != viewPortGraphic.getGraphKey()) continue;
            ++n;
        }
        return n;
    }

    public Boolean linkIsVisible(int n) {
        if (this.graphLinks.get(n) != null) {
            return true;
        }
        if (this.sideGraphLinks.get(n) != null) {
            return true;
        }
        if (this.mpoLinks.get(n) != null) {
            return true;
        }
        return false;
    }

    List<IViewLink> getLinks(ViewPortGraphic viewPortGraphic) {
        ArrayList<IViewLink> arrayList = new ArrayList<IViewLink>();
        Collection<IViewLink> collection = this.graphLinks.values();
        int n = 0;
        Iterator<IViewLink> iterator = collection.iterator();
        while (iterator.hasNext()) {
            IViewLink iViewLink = iterator.next();
            if (iViewLink.getFromName() == viewPortGraphic.getGraphKey()) {
                arrayList.add(iViewLink);
                ++n;
            }
            if (iterator.next().getToName() != viewPortGraphic.getGraphKey()) continue;
            arrayList.add(iViewLink);
            ++n;
        }
        collection = this.sideGraphLinks.values();
        for (IViewLink iViewLink : collection) {
            if (iViewLink.getFromName() == viewPortGraphic.getGraphKey()) {
                arrayList.add(iViewLink);
                ++n;
            }
            if (iViewLink.getToName() != viewPortGraphic.getGraphKey()) continue;
            arrayList.add(iViewLink);
            ++n;
        }
        return arrayList;
    }

    public void addLink(int n, IViewLink iViewLink) {
        this.graphLinks.put(n, iViewLink);
    }

    public void removeSourceOrDestionation(ViewPin viewPin) {
        viewPin.pinCompo.setChildren(1, null);
    }

    static class SetBkgColor
    implements IlvApplyObject {
        Color color;
        IlvGraphic bckg;

        SetBkgColor(IlvGraphic ilvGraphic, Color color) {
            this.color = color;
            this.bckg = ilvGraphic;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            if (ilvGraphic instanceof ViewCompositeGraphic) {
                this.bckg.setBackground(this.color);
            }
        }
    }

    static class SetPinPosition
    implements IlvApplyObject {
        String pinName;
        IlvPoint pinPosition;

        SetPinPosition(String string, IlvPoint ilvPoint) {
            this.pinName = string;
            this.pinPosition = ilvPoint;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            IlvGrapherPin ilvGrapherPin;
            if (ilvGraphic instanceof ViewCompositeGraphic && (ilvGrapherPin = (IlvGrapherPin)((ViewCompositeGraphic)ilvGraphic).pins.get(this.pinName)) != null) {
                ilvGrapherPin.setPosition(this.pinPosition, null);
            }
        }
    }

    static class SetLabel
    implements IlvApplyObject {
        String labelName;
        String labelValue;

        SetLabel(String string, String string2) {
            this.labelName = string;
            this.labelValue = string2;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            IlvGraphic ilvGraphic2;
            if (ilvGraphic instanceof ViewCompositeGraphic && (ilvGraphic2 = ((IlvGraphicSet)ilvGraphic).getObject(this.labelName)) instanceof IlvZoomableLabel) {
                ((IlvZoomableLabel)ilvGraphic2).setLabel(this.labelValue);
            }
        }
    }

    static class RotatePins
    implements IlvApplyObject {
        HashMap map;
        IlvPoint center;
        double angle;

        RotatePins(HashMap hashMap, IlvPoint ilvPoint, double d) {
            this.map = hashMap;
            this.center = ilvPoint;
            this.angle = d;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            ilvGraphic.rotate(this.center, this.angle);
            double d = IlvUtil.degreesToRadians((double)this.angle);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            IlvTransformer ilvTransformer = new IlvTransformer(d2, -d3, d3, d2, (double)this.center.x * (1.0 - d2) + d3 * (double)this.center.y, -((double)this.center.x * d3) + (double)this.center.y * (1.0 - d2));
            for (Map.Entry entry : this.map.entrySet()) {
                IlvGrapherPin ilvGrapherPin = (IlvGrapherPin)entry.getKey();
                IlvPoint ilvPoint = (IlvPoint)entry.getValue();
                ilvTransformer.apply(ilvPoint);
                ilvGrapherPin.setPosition(ilvPoint, null);
            }
        }
    }

    static class ScalePins
    implements IlvApplyObject {
        double scalex;
        double scaley;
        HashMap map;

        ScalePins(HashMap hashMap, double d, double d2) {
            this.map = hashMap;
            this.scalex = d;
            this.scaley = d2;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            IlvGrapherPin ilvGrapherPin;
            IlvPoint ilvPoint = ilvGraphic.getCenter(new IlvTransformer());
            IlvTransformer ilvTransformer = new IlvTransformer();
            ilvTransformer.scale((double)ilvPoint.x, (double)ilvPoint.y, this.scalex, this.scaley);
            ilvGraphic.applyTransform(ilvTransformer);
            IlvRect ilvRect = ilvGraphic.boundingBox();
            double d = (1.0 - this.scalex) * (double)(ilvRect.x + 0.5f * ilvRect.width);
            double d2 = (1.0 - this.scaley) * (double)(ilvRect.y + 0.5f * ilvRect.height);
            IlvTransformer ilvTransformer2 = new IlvTransformer(this.scalex, 0.0, 0.0, this.scaley, d, d2);
            for (Map.Entry ilvGraphicEnumeration2 : this.map.entrySet()) {
                ilvGrapherPin = (IlvGrapherPin)ilvGraphicEnumeration2.getKey();
                IlvPoint ilvPoint2 = (IlvPoint)ilvGraphicEnumeration2.getValue();
                ilvTransformer2.apply(ilvPoint2);
                ilvGrapherPin.setPosition(ilvPoint2, null);
            }
            IlvGraphicEnumeration ilvGraphicEnumeration = ((IlvGraphicSet)ilvGraphic).getObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvGrapherPin = ilvGraphicEnumeration.nextElement();
                if (!(ilvGrapherPin instanceof IlvCompositeGraphic)) continue;
                ilvGrapherPin.applyTransform(ilvTransformer);
            }
        }
    }

    static class ScaleLabels
    implements IlvApplyObject {
        double scalex;
        double scaley;

        ScaleLabels(double d, double d2) {
            this.scalex = d;
            this.scaley = d2;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            if (ilvGraphic instanceof ViewCompositeGraphic) {
                IlvGraphicEnumeration ilvGraphicEnumeration = ((IlvSDMCompositeNode)ilvGraphic).getObjects();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    IlvGraphic ilvGraphic2 = ilvGraphicEnumeration.nextElement();
                    if (!(ilvGraphic2 instanceof IlvGraphicSet)) continue;
                    IlvGraphicEnumeration ilvGraphicEnumeration2 = ((IlvGraphicSet)ilvGraphic2).getObjects();
                    while (ilvGraphicEnumeration2.hasMoreElements()) {
                        IlvGraphic ilvGraphic3 = ilvGraphicEnumeration2.nextElement();
                        if (!(ilvGraphic3 instanceof IlvZoomableLabel)) continue;
                        IlvPoint ilvPoint = ilvGraphic3.getCenter(new IlvTransformer());
                        IlvTransformer ilvTransformer = new IlvTransformer();
                        ilvTransformer.scale((double)ilvPoint.x, (double)ilvPoint.y, this.scalex, this.scaley);
                        ilvGraphic3.applyTransform(ilvTransformer);
                    }
                }
            }
        }
    }

    public class ViewTrasparentFrame
    extends IlvDefaultManagerFrame {
        public ViewTrasparentFrame() {
            super.setOpaque(false);
            Color color = new Color(1.0f, 0.0f, 0.0f, 0.0f);
            super.setForeground(color);
        }

        public boolean contains(IlvManager ilvManager, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
            return super.contains(ilvManager, ilvPoint, ilvPoint2, ilvTransformer);
        }
    }
}

