/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

public class ViewDwdmSide {
    public static final int UNKNOWN_SIDE_ID = 0;
    public static final String UNKNOWN_SIDE_LABEL = "Unknown";
    private static final String ERROR_ON_SIDE_ID = "N/A";
    private static final int SIDE_LABEL_MASK = 255;
    private static final int SIDE_ROLE_MASK = 65280;
    private static final int SIDE_ROLE_SHIFT = 14;
    private static final int SIDE_WORKING_VALUE = 16384;
    private static final int SIDE_PROTECT_VALUE = 32768;
    public static final int WORKING_SIDE_ROLE = 1;
    public static final int PROTECTED_SIDE_ROLE = 2;
    public static final int NO_SIDE_ROLE = 0;
    public static final String SIDE_WORKING_STR = "(w)";
    public static final String SIDE_PROTECT_STR = "(p)";
    public static final int WXCNE = 8;
    public static final int MAXSIDE = 8;
    private static final String[] sideStr = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};

    public static int getSideLabelFromId(int n) {
        return n & 0xFF;
    }

    public static int getSideRole(int n) {
        return (n & 0xFF00) >> 14;
    }

    public static String getSideFromOffset(int n) {
        int n2 = ViewDwdmSide.getSideLabelFromId(n);
        if (n2 > 0 && n2 <= sideStr.length) {
            return sideStr[n2 - 1] + ViewDwdmSide.getSideRoleString(n);
        }
        if (n2 == 0) {
            return UNKNOWN_SIDE_LABEL;
        }
        return ERROR_ON_SIDE_ID;
    }

    private static String getSideRoleString(int n) {
        switch (n & 0xFF00) {
            case 16384: {
                return SIDE_WORKING_STR;
            }
            case 32768: {
                return SIDE_PROTECT_STR;
            }
        }
        return "";
    }
}

