/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.util.view.fv.AbstractView;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewGrapherLayout;
import cerent.util.view.fv.ViewAlarmGrapher;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewGeneralCompositeGraphic;
import cerent.util.view.fv.ViewGeneralGrapher;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewManagerFlipHelper;
import cerent.util.view.fv.ViewMultipleLayout;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.hierarchical.IlvExtremityConstraint;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalConstraint;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.graphlayout.hierarchical.IlvRelativePositionConstraint;
import ilog.views.graphlayout.link.longlink.IlvLongLinkLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewGrapherLayout
extends ViewMultipleLayout
implements IViewGrapherLayout {
    public static GraphPos[] domStandardPos = new GraphPos[]{GraphPos.CENTER, GraphPos.CENTER_1, GraphPos.RIGHT_1, GraphPos.RIGHT_2, GraphPos.RIGHT_3, GraphPos.CENTER_3, GraphPos.LEFT_3, GraphPos.LEFT_2, GraphPos.LEFT_1};
    public GraphPos[] domPos = new GraphPos[]{GraphPos.CENTER, GraphPos.CENTER_1_NODE, GraphPos.RIGHT_1, GraphPos.RIGHT_2, GraphPos.RIGHT_3, GraphPos.CENTER_3_NODE, GraphPos.LEFT_3, GraphPos.LEFT_2, GraphPos.LEFT_1};
    protected IViewGraph[][] sideConstraints = new IViewGraph[3][3];
    protected IViewGraph rootGraph;
    public static final int LEFT_POS = 0;
    public static final int CENTER_POS = 1;
    public static final int RIGHT_POS = 2;
    public static final int UP_POS = 0;
    public static final int DOWN_POS = 2;

    public ViewGrapherLayout(IViewGraph iViewGraph) {
        super((IlvGraphLayout)new IlvLongLinkLayout(), new IlvHierarchicalLayout());
        ((IlvLongLinkLayout)this.getLinkLayout()).setGlobalLinkStyle(2);
        ((IlvLongLinkLayout)this.getLinkLayout()).setHorizontalGridOffset(5.0f);
        ((IlvLongLinkLayout)this.getLinkLayout()).setVerticalGridOffset(5.0f);
        ((IlvLongLinkLayout)this.getLinkLayout()).setHorizontalMinOffset(10.0f);
        ((IlvLongLinkLayout)this.getLinkLayout()).setVerticalMinOffset(10.0f);
        ((IlvLongLinkLayout)this.getLinkLayout()).setInterGraphLinksMode(true);
        ((IlvLongLinkLayout)this.getLinkLayout()).setMinNodeCornerOffset(10.0f);
        ((IlvLongLinkLayout)this.getLinkLayout()).setNodeObstacleEnabled(true);
        this.rootGraph = iViewGraph;
        if (iViewGraph instanceof AbstractView) {
            this.attach((ViewGeneralGrapher)((AbstractView)((Object)iViewGraph)).getManager());
        }
    }

    public ViewGrapherLayout(IViewGraph iViewGraph, IlvGraphLayout ilvGraphLayout, IlvHierarchicalLayout ilvHierarchicalLayout) {
        super(ilvGraphLayout, ilvHierarchicalLayout);
        this.rootGraph = iViewGraph;
        if (iViewGraph instanceof AbstractView) {
            this.attach((ViewGeneralGrapher)((AbstractView)((Object)iViewGraph)).getManager());
        }
    }

    @Override
    public void updatePosition(int[] nArray, int n) {
        int n2;
        GraphPos[] graphPosArray = new GraphPos[9];
        for (n2 = 0; n2 <= 8; ++n2) {
            graphPosArray[n2] = domStandardPos[n2];
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.domPos[nArray[n2]] = graphPosArray[n2 + 1];
        }
    }

    @Override
    public abstract void doAutoLayout();

    public void ViewGraphMove(IViewGraph iViewGraph, GraphPos graphPos) {
        if (iViewGraph instanceof ViewDomainGrapher) {
            ViewDomainGrapher viewDomainGrapher = (ViewDomainGrapher)iViewGraph;
            if (graphPos.scalex == -1 && graphPos.scaley == -1) {
                viewDomainGrapher.setLabelflipped(true);
                ViewManagerFlipHelper.flipLabels(iViewGraph, -1, -1);
                ViewManagerFlipHelper.flipAlarms(iViewGraph);
                ViewManagerFlipHelper.flipPatchPanel(iViewGraph);
                ViewManagerFlipHelper.flipSideName(iViewGraph);
                ViewManagerFlipHelper.flipCardPortsLabel(iViewGraph, -1, -1);
                ViewManagerFlipHelper.flipBalloons((ViewGrapher)iViewGraph);
                ViewManagerFlipHelper.flipSourceDestinationLabel(iViewGraph);
                viewDomainGrapher.setMustFlip(false);
            }
            if (graphPos.angle != 0) {
                viewDomainGrapher.rotate(viewDomainGrapher.getCenter(null), graphPos.angle);
            }
            if (graphPos.scalex != 0 && graphPos.scaley != 0) {
                viewDomainGrapher.scale(graphPos.scalex, graphPos.scaley);
            }
            this.sideConstraints[graphPos.posLR][graphPos.posUD] = viewDomainGrapher;
            try {
                viewDomainGrapher.getLayout().performLayout(true, true, false);
            }
            catch (IlvGraphLayoutException ilvGraphLayoutException) {
                ilvGraphLayoutException.printStackTrace();
            }
        } else if (iViewGraph instanceof ViewCardGrapher) {
            ViewCardGrapher viewCardGrapher = (ViewCardGrapher)iViewGraph;
            if (graphPos.scalex != 0 && graphPos.scaley != 0) {
                viewCardGrapher.scale(graphPos.scalex, graphPos.scaley);
            }
            this.sideConstraints[graphPos.posLR][graphPos.posUD] = viewCardGrapher;
        } else if (iViewGraph instanceof ViewGeneralCompositeGraphic) {
            ViewGeneralCompositeGraphic viewGeneralCompositeGraphic = (ViewGeneralCompositeGraphic)iViewGraph;
            if (graphPos.scalex != 0 && graphPos.scaley != 0) {
                viewGeneralCompositeGraphic.scale(graphPos.scalex, graphPos.scaley);
            }
            this.sideConstraints[graphPos.posLR][graphPos.posUD] = viewGeneralCompositeGraphic;
        }
        this.getNodeLayout().setSpecNodeLevelIndex((Object)iViewGraph, graphPos.posLR);
    }

    @Override
    public void addNodeNameConstraint(IViewGraph iViewGraph, int n) {
        this.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvExtremityConstraint((Object)iViewGraph, 7));
    }

    public void moveAlarms(GraphPos graphPos, ArrayList<ViewAlarmGrapher> arrayList) {
        float f = 0.0f;
        float f2 = 0.0f;
        Rectangle2D rectangle2D = ViewDomainGrapher.getDefaultDomainRect2D();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (graphPos.scalex == -1 && graphPos.scaley == -1) {
                f = (float)(rectangle2D.getMaxX() - arrayList.get(i).getGraphBound().getWidth());
                f2 = (float)rectangle2D.getMaxY();
            } else {
                f = (float)rectangle2D.getMinX();
                f2 = (float)rectangle2D.getMinY();
            }
            if (i > 0) {
                f = (float)((double)f + (arrayList.get(0).getGraphBound().getWidth() + 20.0));
            }
            arrayList.get(i).move(f, f2);
        }
    }

    @Override
    public void adjustPatchPanelGrapher(IViewGraph iViewGraph) {
        ViewGrapher viewGrapher = (ViewGrapher)iViewGraph;
        viewGrapher.doFlipH();
        viewGrapher.doFlipV();
    }

    @Override
    public void doUpdateAngle(boolean bl) {
        this.updateAngle(this.rootGraph.getGraphChildren(), bl);
    }

    protected void updateAngle(HashMap<String, IViewGraph> hashMap, boolean bl) {
        for (IViewGraph iViewGraph : hashMap.values()) {
            if (!(iViewGraph instanceof ViewDomainGrapher)) continue;
            ViewDomainGrapher viewDomainGrapher = (ViewDomainGrapher)iViewGraph;
            int n = 0;
            n = bl ? -this.domPos[viewDomainGrapher.getSideLabelValue()].angle : this.domPos[viewDomainGrapher.getSideLabelValue()].angle;
            if (n == 0) continue;
            viewDomainGrapher.rotate(viewDomainGrapher.getCenter(null), n);
        }
        try {
            this.performLayout(true, true, false);
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            ilvGraphLayoutException.printStackTrace();
        }
    }

    protected void addConstraints(ViewGeneralCompositeGraphic viewGeneralCompositeGraphic) {
        int n = 5;
        int n2 = -1;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.sideConstraints[i][j] == null) continue;
                if (n2 == -1) {
                    n2 = i;
                }
                for (int k = j + 1; k < 3; ++k) {
                    if (this.sideConstraints[i][k] == null) continue;
                    this.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)this.sideConstraints[i][k], (Object)this.sideConstraints[i][j], (float)n));
                }
            }
        }
        if (viewGeneralCompositeGraphic != null) {
            this.addNodeNameConstraint(viewGeneralCompositeGraphic, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GraphPos {
        CENTER(1, 1),
        CENTER_1(1, 0, 1, 1, 90),
        CENTER_3(1, 2, 1, 1, -90),
        CENTER_1_NODE(1, 0),
        CENTER_3_NODE(1, 2),
        LEFT_1(0, 0),
        LEFT_2(0, 1),
        LEFT_3(0, 2),
        LEFT_3_NODE(0, 2),
        RIGHT_1(2, 0, -1, -1, 0),
        RIGHT_2(2, 1, -1, -1, 0),
        RIGHT_3(2, 2, -1, -1, 0),
        THREE_WAY_CENTER(1, 1);

        public int posLR = 0;
        public int posUD = 0;
        public int scalex = 0;
        public int scaley = 0;
        public int angle = 0;

        private GraphPos(int n2, int n3) {
            this.posLR = n2;
            this.posUD = n3;
        }

        private GraphPos(int n2, int n3, int n4, int n5, int n6) {
            this.posLR = n2;
            this.posUD = n3;
            this.scalex = n4;
            this.scaley = n5;
            this.angle = n6;
        }
    }
}

