/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv.helper;

import cerent.util.IFvDebug;
import cerent.util.view.fv.helper.FunctDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class PopupDialog {
    private static final LinkedList _visibleDialogs = new LinkedList();
    private static IFvDebug db = FunctDebug.instance();
    private static final String QUESTION_ICON_STR = "/images/icons/question32.gif";
    public static ImageIcon QUESTION_ICON = new ImageIcon(PopupDialog.class.getResource("/images/icons/question32.gif"));
    public static final int CANCEL_OPTION = 2;
    private static final String YES = "Yes";
    private static final String NO = "No";
    private static Object[] yesNoOptions = new Object[]{"Yes", "No"};

    public static boolean yesNoDialog(Component component, String string, String string2) {
        return PopupDialog.questionDialog(component, string, string2) == 0;
    }

    public static int questionDialog(Component component, String string, String string2) {
        return PopupDialog.showConfirmDialog(component, string, string2, 0, 3, QUESTION_ICON, yesNoOptions, 2);
    }

    private static synchronized int showConfirmDialog(Component component, String string, String string2, int n, int n2, Icon icon, Object[] objectArray, int n3) {
        if (n3 >= 0 && n3 < objectArray.length) {
            return PopupDialog.showOptionDialog(component, string, string2, n, n2, icon, objectArray, objectArray[n3]);
        }
        return PopupDialog.showOptionDialog(component, string, string2, n, n2, icon, objectArray, objectArray[objectArray.length - 1]);
    }

    private static synchronized int showOptionDialog(Component component, String string, String string2, int n, int n2, Icon icon, Object[] objectArray, Object object) {
        OptionDialog optionDialog = new OptionDialog(component, String.valueOf(string), string2, n, n2, icon, objectArray, object);
        optionDialog.show();
        return optionDialog.getResult();
    }

    private static void execute(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                db.println(interruptedException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                db.println(invocationTargetException.getMessage());
            }
        }
    }

    public static void toFront() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    db.println("Error" + interruptedException.getMessage());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        LinkedList linkedList = _visibleDialogs;
                        synchronized (linkedList) {
                            Iterator iterator = _visibleDialogs.iterator();
                            while (iterator.hasNext()) {
                                ((BaseDialog)iterator.next()).toFront();
                            }
                        }
                    }
                });
            }
        }).start();
    }

    static class BaseDialog
    extends WindowAdapter {
        private JOptionPane _pane;
        protected JDialog _dialog;

        BaseDialog() {
        }

        BaseDialog(Component component, String string, String string2, int n, int n2, Icon icon, Object[] objectArray, Object object) {
            int n3 = 0;
            int n4 = 0;
            while ((n3 = string.indexOf(10, n3)) != -1) {
                ++n3;
                ++n4;
            }
            int n5 = string.length();
            if (n4 > 10 || n4 == 0 && n5 >= 80) {
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setEditable(false);
                jTextArea.setText(string);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jScrollPane.setVerticalScrollBarPolicy(22);
                jScrollPane.setPreferredSize(new Dimension(200, 150));
                this._pane = new JOptionPane(jScrollPane, n2, n, icon, objectArray, object);
            } else {
                this._pane = new JOptionPane(string, n2, n, icon, objectArray, object);
            }
            this._pane.setInitialValue(object);
            this._dialog = this._pane.createDialog(component, string2);
            this._pane.selectInitialValue();
        }

        BaseDialog(Component component, String string, String string2, int n, Icon icon, Object[] objectArray, Object object) {
            this._pane = new JOptionPane(string, n, 2, icon, null, null);
            this._pane.setWantsInput(true);
            this._pane.setSelectionValues(objectArray);
            this._pane.setInitialSelectionValue(object);
            this._dialog = this._pane.createDialog(component, string2);
            this._pane.selectInitialValue();
        }

        public BaseDialog(Component component, JLabel jLabel, String string, int n, int n2, ImageIcon imageIcon, Object[] objectArray, Object object) {
            this._pane = new JOptionPane(jLabel, n2, n, imageIcon, objectArray, object);
            this._pane.setInitialValue(object);
            this._dialog = this._pane.createDialog(component, string);
            this._pane.selectInitialValue();
        }

        void show() {
            PopupDialog.execute(new Runnable(){

                public void run() {
                    BaseDialog.this.doShow();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void showDialog() {
            LinkedList linkedList = _visibleDialogs;
            synchronized (linkedList) {
                _visibleDialogs.addLast(this);
                this._dialog.addWindowListener(this);
                this._dialog.show();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void displayDialog() {
            LinkedList linkedList = _visibleDialogs;
            synchronized (linkedList) {
                _visibleDialogs.addLast(this);
                this._dialog.addWindowListener(this);
                this._dialog.pack();
                this._dialog.setModal(false);
                this._dialog.setVisible(true);
            }
        }

        protected Object getPaneValue() {
            return this._pane.getValue();
        }

        protected Object getPaneInputValue() {
            return this._pane.getInputValue();
        }

        protected void doShow() {
            this.showDialog();
        }

        protected void toFront() {
            this._dialog.toFront();
        }

        public void windowOpened(WindowEvent windowEvent) {
            PopupDialog.toFront();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosed(WindowEvent windowEvent) {
            LinkedList linkedList = _visibleDialogs;
            synchronized (linkedList) {
                this._dialog.removeWindowListener(this);
                _visibleDialogs.remove(this);
            }
        }
    }

    static class OptionDialog
    extends BaseDialog {
        private int _result = -1;
        private Object[] _options;

        OptionDialog(Component component, String string, String string2, int n, int n2, Icon icon, Object[] objectArray, Object object) {
            super(component, string, string2, n, n2, icon, objectArray, object);
            this._options = objectArray;
        }

        public OptionDialog(Component component, JLabel jLabel, String string, int n, int n2, ImageIcon imageIcon, Object[] objectArray, Object object) {
            super(component, jLabel, string, n, n2, imageIcon, objectArray, object);
            this._options = objectArray;
        }

        protected void doShow() {
            block1: {
                Object object;
                block2: {
                    this.showDialog();
                    object = this.getPaneValue();
                    this._result = -1;
                    if (object == null) break block1;
                    if (this._options != null) break block2;
                    if (!(object instanceof Integer)) break block1;
                    this._result = (Integer)object;
                    break block1;
                }
                for (int i = 0; i < this._options.length; ++i) {
                    if (!this._options[i].equals(object)) continue;
                    this._result = i;
                    break;
                }
            }
        }

        int getResult() {
            return this._result;
        }
    }
}

