/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlimPortId
implements Comparable<PlimPortId> {
    private int iValue;
    private String sValue;
    private PlimType type = PlimType.Unknown;

    public PlimPortId(int n) {
        this.iValue = n;
        int n2 = -16777216;
        this.sValue = Integer.toString(((this.iValue & n2) >>> 24) - 1);
        for (int i = 2; i >= 0; --i) {
            this.sValue = this.sValue + "/" + Integer.toString(((this.iValue & (n2 >>>= 8)) >>> i * 8) - 1);
        }
    }

    public PlimPortId(int n, PlimType plimType) {
        this(n);
        this.type = plimType;
    }

    public PlimPortId(String string) {
        this.sValue = string;
        PlimType[] objectArray = PlimType.values();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            PlimType plimType = objectArray[i];
            if (plimType == PlimType.Unknown || !this.sValue.startsWith(plimType.toString())) continue;
            this.type = plimType;
            this.sValue = this.sValue.substring(plimType.toString().length()).trim();
            break;
        }
        String[] stringArray = this.sValue.split("/");
        for (n = 0; n < 4; ++n) {
            this.iValue += Integer.parseInt(stringArray[3 - n]) << 8 * n;
        }
    }

    public int getPortId() {
        return this.iValue;
    }

    public PlimType getType() {
        return this.type;
    }

    public String getShortString() {
        return this.sValue;
    }

    public String toString() {
        return this.type == PlimType.Unknown ? this.sValue : this.type.toString() + " " + this.sValue;
    }

    @Override
    public int compareTo(PlimPortId plimPortId) {
        if (this.iValue < plimPortId.iValue) {
            return -1;
        }
        if (this.iValue > plimPortId.iValue) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PlimPortId)) {
            return false;
        }
        return ((PlimPortId)object).iValue == this.iValue;
    }

    public int hashCode() {
        return 17 + 37 * this.iValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlimType {
        TenGigE,
        POS,
        Unknown;

    }
}

