/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.CachedJar;
import cerent.launcher.NoMainClassAttributeException;
import cerent.util.EventBus;
import cerent.util.FileDeleteListener;
import cerent.util.FileDeleteMonitor;
import cerent.util.IDebugDiag;
import cerent.util.JarFileDeleteEvent;
import cerent.util.KDebug;
import cerent.version.AbstractInterfaceVersion;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderKey;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.NETypeEnum;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsClassLoader
extends URLClassLoader
implements FileDeleteListener,
Comparable {
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private static final Class[] URL_CLASS_ARG_TYPES = new Class[]{URL.class};
    private static final ClassLoaderEnum sclEnum = ClassLoaderEnum.SYSTEM;
    private static final String[] STATIC_DEBUG_NAME = new String[]{"CCL", CmsClassLoader.sclEnum.jarPrefix};
    private static Throwable sclWarning;
    private static FileDeleteListener SystemFileDeleteListener;
    private ClassLoaderKey clKey;
    private HashSet<String> myClasses;
    private CachedJar myJar = new CachedJar(this);
    private KDebug db;
    private AbstractInterfaceVersion interfaceVersion;
    private Throwable warning;
    private String manifestFullSwVersion;
    private String mainClass;
    private static KDebug staticDb;

    public CmsClassLoader(ClassLoaderEnum classLoaderEnum, Comparable comparable, URL[] uRLArray, ClassLoader classLoader, String string, String string2) {
        this(classLoaderEnum, comparable, null, uRLArray, classLoader, string, string2);
    }

    public CmsClassLoader(ClassLoaderEnum classLoaderEnum, Comparable comparable, NETypeEnum nETypeEnum, URL[] uRLArray, ClassLoader classLoader, String string, String string2) {
        super(uRLArray, classLoader);
        this.clKey = new ClassLoaderKey(classLoaderEnum, comparable, nETypeEnum);
        this.mainClass = string2;
        this.manifestFullSwVersion = string == null ? cvu.getCTCBootstrapManifestFullVersion(this, classLoaderEnum) : string;
        this.init();
    }

    public CmsClassLoader(ClassLoaderEnum classLoaderEnum, Comparable comparable, URL[] uRLArray, ClassLoader classLoader) {
        this(classLoaderEnum, comparable, null, uRLArray, classLoader, null, null);
    }

    public CmsClassLoader(ClassLoaderEnum classLoaderEnum, Comparable comparable, NETypeEnum nETypeEnum, URL[] uRLArray, ClassLoader classLoader) {
        this(classLoaderEnum, comparable, nETypeEnum, uRLArray, classLoader, null, null);
    }

    private void init() {
        this.myClasses = new HashSet();
        this.db = new CclDebug();
        if (this.db.on()) {
            this.db.println("<init>");
            this.logURLs(this.getURLs());
        }
        this.monitorJarFiles();
    }

    private void logURLs(URL[] uRLArray) {
        int n = uRLArray.length;
        this.db.println("# classpaths: " + n);
        for (int i = 0; i < n; ++i) {
            this.db.println("classpath[" + i + "]: " + uRLArray[i]);
        }
    }

    private void monitorJarFiles() {
        CmsClassLoader.monitorJarFiles(this, this.getURLs(), this.db);
    }

    private static void monitorJarFiles(FileDeleteListener fileDeleteListener, URL[] uRLArray, KDebug kDebug) {
        int n = uRLArray == null ? 0 : uRLArray.length;
        for (int i = 0; i < n; ++i) {
            CmsClassLoader.monitorJarFile(fileDeleteListener, uRLArray[i], kDebug);
        }
    }

    private static void monitorJarFiles(FileDeleteListener fileDeleteListener, URL[] uRLArray) {
        CmsClassLoader.monitorJarFiles(fileDeleteListener, uRLArray, staticDb);
    }

    public static void monitorSystemJarFiles() {
        CmsClassLoader.monitorJarFiles(SystemFileDeleteListener, CoreConstants.scl.getURLs());
    }

    public static void monitorSystemJarFile(URL uRL) {
        CmsClassLoader.monitorJarFile(SystemFileDeleteListener, uRL, staticDb);
    }

    private void monitorJarFile(URL uRL) {
        CmsClassLoader.monitorJarFile(this, uRL, this.db);
    }

    public static void monitorJarFile(FileDeleteListener fileDeleteListener, URL uRL, KDebug kDebug) {
        if (uRL.getProtocol().equals("file")) {
            File file = new File(uRL.getFile());
            if (file.isFile()) {
                FileDeleteMonitor.instance().addListener(fileDeleteListener, file);
                kDebug.fine("Listening for delete of " + uRL);
            } else {
                kDebug.fine(file + " directory deletion monitoring is not supported");
            }
        } else {
            kDebug.fine("Ignoring deletes for " + uRL);
        }
    }

    private static void monitorJarFile(FileDeleteListener fileDeleteListener, URL uRL) {
        CmsClassLoader.monitorJarFile(fileDeleteListener, uRL, staticDb);
    }

    private void unmonitorJarFile(File file) {
        CmsClassLoader.unmonitorJarFile(this, file, this.db);
    }

    private static void unmonitorJarFile(FileDeleteListener fileDeleteListener, File file, KDebug kDebug) {
        FileDeleteMonitor.instance().removeListener(fileDeleteListener, file);
        kDebug.fine("Deleting listener for " + file.getPath());
    }

    private static void unmonitorJarFile(FileDeleteListener fileDeleteListener, File file) {
        CmsClassLoader.unmonitorJarFile(fileDeleteListener, file, staticDb);
    }

    public static void unmonitorSystemJarFile(File file) {
        CmsClassLoader.unmonitorJarFile(SystemFileDeleteListener, file, staticDb);
    }

    @Override
    public void fileDeleted(File file) {
        CmsClassLoader.fileDeleted(file.getName(), this.getSwVersion(), null, file, this, this, this.clKey.getClassLoaderEnum(), this.db);
        this.db.fine("Notifying of missing Jar file -- " + file.getPath());
    }

    private static void fileDeleted(String string, String string2, String string3, File file, FileDeleteListener fileDeleteListener, ClassLoader classLoader, ClassLoaderEnum classLoaderEnum, KDebug kDebug) {
        CmsClassLoader.unmonitorJarFile(fileDeleteListener, file);
        EventBus.instance().notifyEvent("JAR_DELETED", new JarFileDeleteEvent(string, string2, string3, file, classLoader, classLoaderEnum));
        kDebug.fine("Notifying of missing Jar file -- " + file.getPath());
    }

    public String toString() {
        return "CmsClassLoader " + this.clKey;
    }

    public String getDebugString() {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        stringBuilder.append(" - URLs: ");
        URL[] uRLArray = this.getURLs();
        if (uRLArray != null && uRLArray.length > 0) {
            stringBuilder.append(uRLArray[0]);
            for (int i = 1; i < uRLArray.length; ++i) {
                stringBuilder.append(";");
                stringBuilder.append(uRLArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public static String getDebugString(URLClassLoader uRLClassLoader) {
        StringBuilder stringBuilder = new StringBuilder("URLs: ");
        URL[] uRLArray = uRLClassLoader.getURLs();
        if (uRLArray != null && uRLArray.length > 0) {
            stringBuilder.append(uRLArray[0]);
            for (int i = 1; i < uRLArray.length; ++i) {
                stringBuilder.append(";");
                stringBuilder.append(uRLArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public AbstractInterfaceVersion getInterfaceVersion() {
        return this.interfaceVersion;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = super.findClass(string);
        if (this.db.on()) {
            this.db.println("<<<(" + this.clKey + ").findClass(" + string + ") got: " + clazz);
        }
        this.myClasses.add(clazz.getName());
        return clazz;
    }

    protected void invokeMain(String[] stringArray) throws NoMainClassAttributeException, NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        String[] stringArray2 = this.getMainClassNameAndArgs();
        if (stringArray2 == null) {
            String string = ClassLoaderEnum.NET.jarPrefix;
            throw new IllegalArgumentException("main class not specified for " + string);
        }
        int n = stringArray2.length - 1;
        String[] stringArray3 = new String[n];
        if (stringArray3 == null || stringArray3.length == 0) {
            stringArray3 = stringArray;
        }
        System.arraycopy(stringArray2, 1, stringArray3, 0, n);
        this.invokeClass(stringArray2[0], stringArray3);
    }

    private String[] getTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private String[] getMainClassNameAndArgs() throws NoMainClassAttributeException {
        String string = null;
        URL[] uRLArray = this.getURLs();
        String string2 = ClassLoaderEnum.NET.jarPrefix;
        String string3 = System.getProperty("ctc.mainclass" + string2);
        if (string3 != null) {
            if (this.db.on()) {
                this.db.println("!(" + string2 + ") Main class configured to " + string3);
            }
            return this.getTokens(string3);
        }
        if (this.mainClass != null) {
            return new String[]{this.mainClass};
        }
        for (int i = 0; string == null && i < uRLArray.length; ++i) {
            try {
                URL uRL = new URL("jar", "", uRLArray[i].toString() + "!/");
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                Attributes attributes = jarURLConnection.getMainAttributes();
                if (attributes == null) continue;
                string = attributes.getValue(Attributes.Name.MAIN_CLASS);
                continue;
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                this.db.println("Exception in getMainClassName() " + exception);
            }
        }
        if (this.db.on()) {
            this.db.println("getMainClassNameAndArgs result is " + string);
        }
        if (string == null) {
            throw new NoMainClassAttributeException();
        }
        return new String[]{string};
    }

    private boolean methodOk(Method method) {
        int n = method.getModifiers();
        return method.getReturnType() == Void.TYPE && Modifier.isStatic(n) && Modifier.isPublic(n);
    }

    private void invokeClass(String string, String[] stringArray) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> clazz = this.loadClass(string);
        Method method = clazz.getMethod("main", String[].class);
        method.setAccessible(true);
        if (this.methodOk(method)) {
            if (this.db.isFinerEnabled()) {
                this.db.finer("invoking " + string + "." + method.getName() + " with...");
                for (String string2 : stringArray) {
                    this.db.finer("  " + string2);
                }
            }
            if (stringArray == null) {
                method.invoke(null, new Object[0]);
            } else {
                method.invoke(null, new Object[]{stringArray});
            }
        } else {
            throw new NoSuchMethodException("main");
        }
    }

    public ClassLoaderEnum getClassLoaderEnum() {
        return this.clKey.getClassLoaderEnum();
    }

    public ClassLoaderKey getClassLoaderKey() {
        return this.clKey;
    }

    public String getSwVersion() {
        return this.manifestFullSwVersion;
    }

    public void destroy() {
        this.db.dispose();
    }

    public CachedJar getCachedJar() {
        return this.myJar;
    }

    public String jarName() {
        return "NOT COMPAT.jar";
    }

    @Override
    public void addURL(URL uRL) {
        this.db.fine("adding URL: " + uRL + " to: " + this);
        super.addURL(uRL);
        this.monitorJarFile(uRL);
    }

    public static void addURL(URLClassLoader uRLClassLoader, URL uRL) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (uRL == null) {
            throw new IllegalArgumentException("cannot add null URL");
        }
        if (uRLClassLoader instanceof CmsClassLoader) {
            ((CmsClassLoader)uRLClassLoader).addURL(uRL);
        } else {
            staticDb.finer("adding URL: " + uRL + " to: " + uRLClassLoader);
            Class<URLClassLoader> clazz = URLClassLoader.class;
            Method method = clazz.getDeclaredMethod("addURL", URL_CLASS_ARG_TYPES);
            method.setAccessible(true);
            method.invoke((Object)uRLClassLoader, uRL);
            if (uRLClassLoader.equals(CoreConstants.scl)) {
                CmsClassLoader.monitorSystemJarFile(uRL);
            }
        }
    }

    public static void addURLToSystemClassLoader(URL uRL) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        CmsClassLoader.addURL(CoreConstants.scl, uRL);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.clKey.hashCode();
    }

    public int compareTo(Object object) {
        int n;
        int n2 = n = this == object ? 0 : -1;
        if (n != 0 && object instanceof ClassLoaderKey) {
            CmsClassLoader cmsClassLoader = (CmsClassLoader)object;
            n = this.clKey.compareTo(cmsClassLoader.clKey);
        }
        return n;
    }

    public Throwable getWarning() {
        return this.warning;
    }

    public void setWarning(Throwable throwable) {
        this.warning = throwable;
    }

    public static Throwable getSystemWarning() {
        return sclWarning;
    }

    public static void setSystemWarning(Throwable throwable) {
        sclWarning = throwable;
    }

    static {
        SystemFileDeleteListener = new FileDeleteListener(){

            public void fileDeleted(File file) {
                CmsClassLoader.fileDeleted("LAUNCHER/ORB/3rd party libr", null, null, file, this, CoreConstants.scl, sclEnum, staticDb);
            }
        };
        staticDb = new SclDebug();
    }

    public class CclDebug
    extends KDebug
    implements IDebugDiag {
        CclDebug() {
            super(new String[]{"CCL", CmsClassLoader.this.clKey.getClassLoaderEnum() == ClassLoaderEnum.ELE ? "ELE-" + cvu.prettyDottedString(CmsClassLoader.this.clKey.getNeSwVersion()) : CmsClassLoader.this.clKey.getClassLoaderEnum().toString()});
        }

        public final void loadClass(String string) throws ClassNotFoundException {
            Class.forName(string, true, CmsClassLoader.this);
        }

        public final void dumpDiag() {
            this.println("CMS " + (Object)((Object)CmsClassLoader.this.getClassLoaderEnum()) + " ClassLoader");
            this.println("parent CL: " + CmsClassLoader.this.getParent() + " ClassLoader");
            this.println("key: " + CmsClassLoader.this.clKey);
            if (CmsClassLoader.this.manifestFullSwVersion != null) {
                this.println("manifestFullSwVersion=" + CmsClassLoader.this.manifestFullSwVersion);
            }
            this.println("URLs:");
            URL[] uRLArray = CmsClassLoader.this.getURLs();
            if (uRLArray != null) {
                for (int i = 0; i < uRLArray.length; ++i) {
                    this.println("   " + uRLArray[i].toExternalForm());
                }
            }
            this.println("# of classes loaded: " + CmsClassLoader.this.myClasses.size());
            if (CmsClassLoader.this.warning != null) {
                this.println("WARNING:");
                CclDebug.printStackTrace(CmsClassLoader.this.warning);
            }
        }

        public final void addURL(String string) throws Exception {
            if (!string.startsWith("file:/") && !string.startsWith("http:/")) {
                string = "file://" + string;
            }
            URL uRL = new URL(string);
            CmsClassLoader.this.addURL(uRL);
        }
    }

    public static class SclDebug
    extends KDebug
    implements IDebugDiag {
        SclDebug() {
            super(STATIC_DEBUG_NAME);
        }

        public final void addURL(String string) throws Exception {
            if (!string.startsWith("file:/") && !string.startsWith("http:/")) {
                string = "file://" + string;
            }
            URL uRL = new URL(string);
            CmsClassLoader.addURLToSystemClassLoader(uRL);
        }

        public final void dumpDiag() {
            this.println("SYSTEM ClassLoader: " + CoreConstants.scl.getClass().getName());
            this.println("URLs:");
            URL[] uRLArray = CoreConstants.scl.getURLs();
            if (uRLArray != null) {
                for (int i = 0; i < uRLArray.length; ++i) {
                    this.println("   " + uRLArray[i].toExternalForm());
                }
            }
            if (sclWarning != null) {
                this.println("WARNING:");
                SclDebug.printStackTrace(sclWarning);
            }
        }
    }
}

