/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.util.CtcRuntime;
import cerent.util.DebugManager;
import cerent.util.EID;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.PolicyTool;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.IClassLoaderManager;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.JreVersion;
import com.cisco.ctc.core.launcher.JreProperties;
import com.cisco.ctc.core.launcher.Launcher;
import com.cisco.ctc.core.launcher.LauncherSettingsDialog;
import com.cisco.ctc.core.launcher.LocalLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class CtcLauncherApplet
extends JApplet
implements Runnable {
    private static final IClassLoaderManager clm;
    private static final String CISCO_GIF = "/images/cisco-small.gif";
    private static KDebug dbg;
    private String nodeName;
    private Process launcherProc = null;
    private AppletPanel ctcAppPanel = null;
    private static final String CTC_STARTED = "CTC Started (Refresh or reload the browser page to relaunch CTC)";

    public void init() {
        try {
            Launcher.init();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.errorDialog("Error Initializing the Launcher:" + iOException.getMessage());
            return;
        }
        dbg = new KDebug("Applet");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.ctcAppPanel = new AppletPanel();
        container.add(this.ctcAppPanel);
        container.setBackground(Color.white);
        if (dbg.on()) {
            dbg.println("-> init( )");
        }
        this.nodeName = this.getParameter("ctc.loginhost");
        if (this.nodeName == null) {
            this.nodeName = this.getDocumentBase().getHost();
        }
        if (dbg.on()) {
            dbg.println("nodeName     = " + this.nodeName);
            dbg.println("Parameter    = " + this.getParameter("NodeName"));
            dbg.println("CodeBase     = " + this.getCodeBase());
            dbg.println("DocumentBase = " + this.getDocumentBase());
        }
    }

    public void start() {
        if (dbg.on()) {
            dbg.println("-> start( )");
        }
        if (!this.ctcAppPanel.appletProblem()) {
            new Thread(this).start();
            this.ctcAppPanel.setStatus("Applet started");
        }
    }

    public void run() {
        DebugManager.displayDebugWindow();
        PolicyTool.run();
        this.launch();
    }

    public void stop() {
        if (dbg.on()) {
            dbg.println("-> stop( )");
        }
    }

    public void destroy() {
        try {
            Launcher.dispose();
        }
        catch (IOException iOException) {
            dbg.println("Launcher.dispose() failed");
            KDebug.printStackTrace(iOException);
        }
        if (dbg.on()) {
            dbg.println("-> destroy( )");
        }
        if (CtcRuntime.isWin9x) {
            if (dbg.on()) {
                dbg.println("destroy( ): destroying CTC process");
            }
            this.launcherProc.destroy();
        }
        if (dbg.on()) {
            dbg.println("Exiting void destroy( )");
        }
        dbg.dispose();
    }

    public void errorDialog(String string) {
        if (dbg.on()) {
            dbg.println("Error: " + string);
        }
        this.ctcAppPanel.setStatus(string);
    }

    private void errorDialog(EID eID) {
        KErrorMsg.displayError(null, eID);
    }

    public void launch() {
        if (dbg.on()) {
            dbg.println("-> launch( )");
        }
        this.ctcAppPanel.setLaunchedCTCInfo(null, null, null);
        this.ctcAppPanel.setStatus("Launching CTC...");
        try {
            Launcher launcher = Launcher.instance();
            this.launcherProc = launcher.launchCtc(null, Launcher.CtcVersionSelection.LATEST_VERSION, this.nodeName, null, null);
            Comparable comparable = launcher.getLastCtcVersion();
            JreProperties jreProperties = JreProperties.instance();
            JreVersion jreVersion = jreProperties.getCtcJreVersion(comparable);
            if (jreVersion == null) {
                this.errorDialog("No suitable JRE version was found or chosen. Exiting CTC.");
                return;
            }
            this.ctcAppPanel.setLaunchedCTCInfo(CoreVersionUtil.instance().prettyDottedString(comparable), jreVersion.toString(), jreProperties.getJrePath(jreVersion));
            this.ctcAppPanel.setStatus(CTC_STARTED);
            return;
        }
        catch (SecurityException securityException) {
            KDebug.printStackTrace(securityException);
            this.errorDialog(KEMC.EID_UNABLE_TO_LAUNCH_CTC);
        }
        catch (NoRouteToHostException noRouteToHostException) {
            KDebug.printStackTrace(noRouteToHostException);
            this.errorDialog(KEMC.EID_NO_ROUTE);
        }
        catch (UnknownHostException unknownHostException) {
            KDebug.printStackTrace(unknownHostException);
            this.errorDialog(KEMC.EID_CANT_RESOLVE_HOSTNAME);
        }
        catch (Exception exception) {
            KDebug.printStackTrace(exception);
            this.errorDialog(exception.getMessage() == null ? KErrorMsg.getString(KEMC.EID_ERROR_LAUNCHING_CTC_PARAM_1, exception.toString()) : exception.getMessage());
        }
        this.ctcAppPanel.setStatus("Error Launching CTC");
    }

    static {
        URL uRL;
        ClassLoader classLoader = CtcLauncherApplet.class.getClassLoader();
        if (classLoader instanceof URLClassLoader && (uRL = ((URLClassLoader)classLoader).findResource("META-INF/MANIFEST.MF")) != null) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDefaultUseCaches(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        clm = ClassLoaderManager.instance();
        dbg = null;
    }

    protected class AppletPanel
    extends JPanel
    implements ActionListener {
        private String _ctcVersion;
        private String _javaVersion;
        private String _javaHome;
        private String _javaVmName;
        private String _javaVmVersion;
        private String _javaVmVendor;
        private String _osName;
        private String _osVersion;
        private String _version;
        private JTextArea textArea;
        private JButton settingsButton;
        private JLabel statusLabel;
        private boolean _appletProblem;

        public AppletPanel() {
            Object object;
            Object object2;
            super(new BorderLayout());
            this.statusLabel = new JLabel();
            this._appletProblem = false;
            this.setBackground(Color.white);
            ICoreVersionUtil iCoreVersionUtil = CoreVersionUtil.instance();
            Color color = new Color(107, 116, 133);
            Color color2 = new Color(248, 248, 248);
            URL uRL = LocalLauncher.class.getResource(CtcLauncherApplet.CISCO_GIF);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            try {
                object2 = clm.getSystemSwVersion();
                dbg.println("scl version=" + (String)object2);
                object = iCoreVersionUtil.createManifestFullVersionOrdinal((String)object2);
                this._version = iCoreVersionUtil.prettyDottedString((Comparable)object);
            }
            catch (Exception exception) {
                dbg;
                KDebug.printStackTrace(exception);
            }
            object2 = new JLabel("CTC Launcher Applet v" + this._version, new ImageIcon(image), 2);
            ((JComponent)object2).setFont(((Component)object2).getFont().deriveFont(16.0f));
            this.add((Component)object2, "North");
            object = new JPanel(new BorderLayout());
            this.textArea = new JTextArea(15, 35);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setTabSize(4);
            this.textArea.setEditable(false);
            this.textArea.setBackground(color2);
            ((Container)object).add(this.textArea);
            ((JComponent)object).setOpaque(true);
            ((JComponent)object).setBackground(color2);
            JPanel jPanel = new JPanel();
            this.settingsButton = new JButton("Settings...");
            this.settingsButton.addActionListener(this);
            jPanel.add(this.settingsButton);
            jPanel.setOpaque(true);
            jPanel.setBackground(color2);
            ((Container)object).add((Component)jPanel, "South");
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(10, 5, 15, 5));
            this.add((Component)object);
            this.add((Component)this.statusLabel, "South");
            this.statusLabel.setBackground(color);
            this.statusLabel.setForeground(Color.white);
            this.statusLabel.setOpaque(true);
            this._javaVersion = "";
            this._javaHome = "";
            try {
                this._javaVmName = System.getProperty("java.vm.name");
                this._javaVmVersion = System.getProperty("java.vm.version");
                this._javaVmVendor = System.getProperty("java.vm.vendor");
                this._osName = System.getProperty("os.name");
                this._osVersion = System.getProperty("os.version");
                this.refreshTextArea();
            }
            catch (AccessControlException accessControlException) {
                accessControlException.printStackTrace(System.err);
                this.setStatus("Access Control Exception while initializing the applet");
                this._appletProblem = true;
            }
            this.setBorder(BorderFactory.createLineBorder(color));
        }

        public boolean appletProblem() {
            return this._appletProblem;
        }

        public void setLaunchedCTCInfo(String string, String string2, String string3) {
            this._ctcVersion = string;
            this._javaVersion = string2;
            this._javaHome = string3;
            this.refreshTextArea();
        }

        public void setStatus(String string) {
            this.statusLabel.setText(string);
            this.revalidate();
        }

        public void refreshTextArea() {
            this.textArea.setText("\nLogin Node: " + CtcLauncherApplet.this.nodeName + "\n");
            if (this._ctcVersion != null) {
                this.textArea.append("CTC Version: " + this._ctcVersion + "\n");
                this.textArea.append("\nCTC Java Environment:\n");
                this.textArea.append("\tJava VM Version: " + this._javaVersion + "\n");
                this.textArea.append("\tJava VM Home: " + this._javaHome + "\n");
            }
            this.textArea.append("\nBrowser Java Environment:\n");
            this.textArea.append("\tJava VM Name: " + this._javaVmName + "\n");
            this.textArea.append("\tJava VM Version: " + this._javaVmVersion + "\n");
            this.textArea.append("\tJava VM Vendor: " + this._javaVmVendor + "\n");
            this.textArea.append("\nSystem Environment:\n");
            this.textArea.append("\tOS Name: " + this._osName + "\n");
            this.textArea.append("\tOS Version: " + this._osVersion + "\n");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LauncherSettingsDialog launcherSettingsDialog = new LauncherSettingsDialog(new JFrame());
            launcherSettingsDialog.setVisible(true);
        }
    }
}

