/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.ExecArgs;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.Preferences;
import cerent.util.ReturnResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtcRuntime {
    private static final String CTC = "ctc";
    private static final String CONSOLE_AVAILABLE = "ctc.console.available";
    private static final String USE_TERMINAL = "use.terminal";
    private static final String lineSep = System.getProperty("line.separator");
    private static final String os = System.getProperty("os.name");
    public static final boolean isWindows = ExecArgs.isWindows;
    public static final String OS_KEY = isWindows ? "win32" : os.replaceAll(" ", "");
    public static final String osEnvName = "OS";
    public static final String envos = System.getenv("OS");
    public static final String winNtArch = "Windows_NT";
    public static final boolean isNtArch;
    public static final boolean hasWindowsSocketCreateLimit;
    public static final boolean isWin9x;
    public static final String PREF_PATH = "ctc.launcher";
    private static final Preferences prefs;
    private static final ExecArgs eargs;
    private static final CtcRuntime instance;
    protected static final Debug db;

    public static File getDefaultCacheDir() {
        String string;
        String string2 = System.getProperty("user.home");
        File file = isWindows ? ((string = System.getenv("AppData")) != null ? new File(string + "\\Cisco\\CTC") : new File(string2 + "\\Application Data\\Cisco\\CTC")) : new File(string2 + "/.ctc");
        return file;
    }

    public static boolean isCiscoHost() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            if (string.endsWith(".cisco.com")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private CtcRuntime() {
    }

    public static CtcRuntime instance() {
        return instance;
    }

    public static boolean isConsoleEnabled() {
        return prefs.getBoolean(CTC, USE_TERMINAL, false) && !isWin9x;
    }

    public Process exec(String string, ArrayList<String> arrayList, String string2) throws SecurityException, IOException {
        boolean bl = CtcRuntime.isConsoleEnabled();
        Properties properties = null;
        if (bl) {
            properties = new Properties();
            properties.put(CONSOLE_AVAILABLE, "true");
        }
        Properties properties2 = System.getProperties();
        ExecArgs.addPertinentEnvVariables(properties2);
        ArrayList arrayList2 = eargs.execArgs(arrayList, string2, bl, properties2, properties);
        if (string != null) {
            arrayList2.add(string);
        }
        this.checkExecArgs(arrayList2);
        return this.exec(arrayList2);
    }

    public Process exec(ArrayList<String> arrayList) throws IOException {
        if (db.on()) {
            db.println("exec:");
            for (String object2 : arrayList) {
                db.print(object2 + " ");
            }
            db.println("");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList.toArray(new String[0]));
        Process process = processBuilder.start();
        return process;
    }

    public Process execByClassPath(ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3) throws SecurityException, IOException {
        return this.execByClassPath(arrayList, arrayList2, arrayList3, false);
    }

    private static ArrayList<String> addXtermArgs(ArrayList<String> arrayList, boolean bl) {
        ExecArgs.addXtermArgs(arrayList, bl);
        return arrayList;
    }

    public Process execByClassPath(ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, boolean bl) throws SecurityException, IOException {
        CharSequence charSequence;
        boolean bl2 = CtcRuntime.isConsoleEnabled();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (isWindows) {
            charSequence = arrayList2.get(0);
            charSequence = bl2 ? (String)charSequence + ".exe" : (String)charSequence + "w.exe";
            arrayList2.set(0, (String)charSequence);
        } else if (bl2) {
            CtcRuntime.addXtermArgs(arrayList4, true);
        }
        arrayList4.addAll(arrayList2);
        if (bl2) {
            arrayList4.add("-Dctc.console.available=true");
        }
        arrayList4.add("-classpath");
        charSequence = new StringBuilder(arrayList3.get(0));
        int n = arrayList3.size();
        for (int i = 1; i < n; ++i) {
            ((StringBuilder)charSequence).append(File.pathSeparator);
            ((StringBuilder)charSequence).append(arrayList3.get(i));
        }
        String string = ((StringBuilder)charSequence).toString();
        arrayList4.add(string);
        arrayList4.addAll(arrayList);
        Process process = null;
        ArrayList<String> arrayList5 = isWindows ? this.getWindowsArgs(arrayList4, bl) : arrayList4;
        if (db.on()) {
            db.println("exec:");
            for (String string2 : arrayList5) {
                db.print(string2 + " ");
            }
            db.println("");
        }
        this.checkExecArgs(arrayList5);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList5.toArray(new String[0]));
        process = processBuilder.start();
        return process;
    }

    public Process execScript(ArrayList<String> arrayList, boolean bl) throws SecurityException, IOException {
        Object object2;
        ArrayList<Object> arrayList2;
        if (isWin9x) {
            throw new IOException("Windows 9x OS is not supported");
        }
        if (isWindows) {
            if (!bl) {
                arrayList2 = new ArrayList<String>();
            } else {
                arrayList2 = new ArrayList();
                ExecArgs.addAll(arrayList2, ExecArgs.ASYNC_SHELL_ONE);
            }
        } else {
            arrayList2 = !bl ? new ArrayList() : CtcRuntime.addXtermArgs(new ArrayList<String>(), false);
        }
        arrayList2.addAll(arrayList);
        if (db.on()) {
            db.println("script exec:");
            for (Object object2 : arrayList2) {
                db.print((String)object2 + " ");
            }
            db.println("");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList2.toArray(new String[0]));
        object2 = processBuilder.start();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ReturnResult manageExecedProcess(Process var1_1, File var2_2) throws InterruptedException {
        var3_3 = -1;
        var4_4 = null;
        try {
            var3_3 = var1_1.waitFor();
            if (CtcRuntime.db.on() || var3_3 != 0) {
                CtcRuntime.db.println("process exit status: " + var3_3);
            }
        }
        catch (InterruptedException var5_5) {
            CtcRuntime.db.println("manageExecedProcess() was interrupted!");
            var1_1.destroy();
            throw var5_5;
        }
        if (CtcRuntime.db.isFinerEnabled()) {
            CtcRuntime.db.println("return result file: " + var2_2);
        }
        if (var3_3 != 0) {
            var4_4 = new ReturnResult();
            var4_4.exitStatus = var3_3;
        } else if (var2_2.exists()) {
            block28: {
                var5_6 /* !! */  = null;
                var6_7 = null;
                try {
                    var6_7 = new ObjectInputStream(new FileInputStream(var2_2));
                    var4_4 = (ReturnResult)var6_7.readObject();
                    var9_8 = null;
                    ** if (var6_7 == null) goto lbl-1000
                }
                catch (Throwable var8_24) {
                    var9_13 = null;
                    if (var6_7 != null) {
                        try {
                            var6_7.close();
                        }
                        catch (IOException var10_19) {
                            Debug.printStackTrace(var10_19);
                        }
                    }
                    throw var8_24;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var6_7.close();
                    }
                    catch (IOException var10_14) {
                        Debug.printStackTrace(var10_14);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block28;
                    catch (ClassNotFoundException var7_20) {
                        var5_6 /* !! */  = var7_20;
                        var9_9 = null;
                        if (var6_7 != null) {
                            try {
                                var6_7.close();
                            }
                            catch (IOException var10_15) {
                                Debug.printStackTrace(var10_15);
                            }
                        }
                        break block28;
                    }
                    catch (ClassCastException var7_21) {
                        var5_6 /* !! */  = var7_21;
                        var9_10 = null;
                        if (var6_7 != null) {
                            try {
                                var6_7.close();
                            }
                            catch (IOException var10_16) {
                                Debug.printStackTrace(var10_16);
                            }
                        }
                        break block28;
                    }
                    catch (IOException var7_22) {
                        var5_6 /* !! */  = var7_22;
                        var9_11 = null;
                        if (var6_7 != null) {
                            try {
                                var6_7.close();
                            }
                            catch (IOException var10_17) {
                                Debug.printStackTrace(var10_17);
                            }
                        }
                        break block28;
                    }
                    catch (RuntimeException var7_23) {
                        var5_6 /* !! */  = var7_23;
                        var9_12 = null;
                        if (var6_7 != null) {
                            try {
                                var6_7.close();
                            }
                            catch (IOException var10_18) {
                                Debug.printStackTrace(var10_18);
                            }
                        }
                    }
                }
            }
            if (var5_6 /* !! */  != null) {
                var4_4 = new ReturnResult();
                var4_4.decodeException = var5_6 /* !! */ ;
            }
        }
        return var4_4;
    }

    private void checkExecArgs(ArrayList<String> arrayList) {
        for (String string : arrayList) {
            if (string.startsWith(" ") || string.endsWith(" ")) {
                throw new IllegalArgumentException("syntax error (cannot have leading/trailing spaces)in exec arg: '" + string + "'");
            }
            if (!string.startsWith("\"") && !string.endsWith("\"")) continue;
            throw new IllegalArgumentException("syntax error (shouldn't have leading/trailing quotes)in exec arg: '" + string + "'");
        }
    }

    public void deleteBatchFiles() {
        if (isWindows) {
            this.deleteFiles(new BatchFilter());
        }
    }

    private boolean deleteFiles(FilenameFilter filenameFilter) {
        int n = 0;
        boolean bl = true;
        String string = null;
        String string2 = System.getProperty("java.io.tmpdir");
        File file = new File(string2);
        File[] fileArray = file.listFiles(filenameFilter);
        for (n = 0; fileArray != null && n < fileArray.length; ++n) {
            try {
                fileArray[n].delete();
                continue;
            }
            catch (Exception exception) {
                bl = false;
                string = exception.getMessage();
            }
        }
        if (!bl) {
            String string3 = KErrorMsg.getString(KEMC.EID_PROBLEM_DELETING_CTC_CACHE_PARAM_2, string2, string);
            this.errorDialog(string3);
        }
        return bl;
    }

    private ArrayList<String> getWindowsArgs(ArrayList<String> arrayList, boolean bl) {
        return this.getWindowsArgs(arrayList, bl, CtcRuntime.isConsoleEnabled());
    }

    private ArrayList<String> getWindowsArgs(ArrayList<String> arrayList, boolean bl, boolean bl2) {
        ArrayList arrayList2 = null;
        try {
            arrayList2 = eargs.getWindowsArgs(arrayList, bl, bl2, System.getProperties());
        }
        catch (IOException iOException) {
            this.errorDialog(KErrorMsg.getString(KEMC.EID_CANT_WRITE_TO_FILE_PARAM_1, "CTC batch"));
        }
        return arrayList2;
    }

    private void errorDialog(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    static {
        hasWindowsSocketCreateLimit = isNtArch = ExecArgs.isNtArch(envos);
        isWin9x = isWindows && !isNtArch;
        prefs = Preferences.instance();
        eargs = new ExecArgs();
        instance = new CtcRuntime();
        db = new Debug("CtcRuntime");
    }

    private class BatchFilter
    implements FilenameFilter {
        private BatchFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".bat") && string.startsWith("ctc-");
        }
    }

    public static class Debug
    extends KDebug {
        public Debug(String string) {
            super(string);
        }

        public final void script(String[] stringArray) throws IOException {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                arrayList.add(string);
            }
            Process process = instance.execScript(arrayList, false);
            this.println("Process created: " + process);
        }

        public final void wscript(String[] stringArray) throws IOException {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                arrayList.add(string);
            }
            Process process = instance.execScript(arrayList, true);
            this.println("Process created: " + process);
        }
    }
}

