/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.FileDeleteListener;
import cerent.util.Preferences;
import java.io.File;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

public class FileDeleteMonitor {
    private static int DEFAULT_INTERVAL = 5;
    private static FileDeleteMonitor fdm = new FileDeleteMonitor();
    private Timer timer;
    private int timerInterval = Preferences.instance().getInt("ctc", "deleteMonitorInterval", DEFAULT_INTERVAL);
    private Hashtable tasks;

    public static FileDeleteMonitor instance() {
        return fdm;
    }

    private FileDeleteMonitor() {
        this.timerInterval *= 1000;
        if (this.timerInterval > 0) {
            this.timer = new Timer(true);
            this.tasks = new Hashtable();
        }
    }

    public synchronized void addListener(FileDeleteListener fileDeleteListener, File file) {
        if (this.timerInterval > 0) {
            this.removeListener(fileDeleteListener, file);
            FileDeleteMonitorTask fileDeleteMonitorTask = new FileDeleteMonitorTask(fileDeleteListener, file);
            this.tasks.put(file.getPath() + fileDeleteListener.hashCode(), fileDeleteMonitorTask);
            this.timer.schedule((TimerTask)fileDeleteMonitorTask, this.timerInterval, (long)this.timerInterval);
        }
    }

    public synchronized void removeListener(FileDeleteListener fileDeleteListener, File file) {
        TimerTask timerTask;
        if (this.timerInterval > 0 && (timerTask = (TimerTask)this.tasks.remove(file.getPath() + fileDeleteListener.hashCode())) != null) {
            timerTask.cancel();
        }
    }

    protected void fireDeleteEvent(FileDeleteListener fileDeleteListener, File file) {
        fileDeleteListener.fileDeleted(file);
    }

    private class FileDeleteMonitorTask
    extends TimerTask {
        private FileDeleteListener fdl;
        private File file;

        public FileDeleteMonitorTask(FileDeleteListener fileDeleteListener, File file) {
            this.fdl = fileDeleteListener;
            this.file = file;
        }

        public void run() {
            if (!this.file.exists()) {
                FileDeleteMonitor.this.fireDeleteEvent(this.fdl, this.file);
            }
        }
    }
}

