/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.KDebug;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URLConnection;
import java.util.Map;
import java.util.TreeMap;

public class MimeHeader {
    private static final KDebug db = new KDebug("MimeHeader");
    private static final String _protocolVersion = "HTTP/1.";
    private static final String _contentTypeTag = "Content-Type";
    private static final String _contentLengthTag = "Content-Length";
    private String _requestMethod;
    private String _host;
    private String _file;
    private String _contentType;
    private long _contentLength;
    private int _responseCode;
    private TreeMap _properties;

    public MimeHeader() {
        this("GET", "", "", "text/html", 0L);
    }

    public MimeHeader(String string, String string2, String string3, String string4, long l) {
        this._requestMethod = string;
        this._host = string2;
        this._file = string3;
        this._contentType = string4;
        this._contentLength = l;
        this._responseCode = 500;
        this._properties = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    public void reset() {
        this._requestMethod = "GET";
        this._host = "";
        this._file = "";
        this._contentType = "text/html";
        this._contentLength = -1L;
        this._responseCode = 500;
        this._properties.clear();
    }

    private boolean startsWith(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public void read(InputStream inputStream) throws IOException {
        this.read(inputStream, this.getResponseCode());
    }

    public void read(InputStream inputStream, int n) throws IOException {
        String string = this.readLine(inputStream);
        this.reset();
        this._responseCode = n;
        if (db.on()) {
            db.println("=> '" + string + "'");
        }
        if (string.length() == 0) {
            this._responseCode = 0;
            return;
        }
        if (this.startsWith(string, _protocolVersion)) {
            this.parseStatusLine(string);
        } else if (this.startsWith(string, "GET")) {
            this._requestMethod = "GET";
            this.parseRequest(string);
        } else if (this.startsWith(string, "POST")) {
            this._requestMethod = "POST";
            this.parseRequest(string);
        } else {
            return;
        }
        while (true) {
            string = this.readLine(inputStream);
            if (db.on()) {
                db.println("=> '" + string + "'");
            }
            if (this.startsWith(string, _contentTypeTag)) {
                this.parseContentType(string);
                continue;
            }
            if (this.startsWith(string, _contentLengthTag)) {
                this.parseContentLength(string);
                continue;
            }
            if (string.length() <= 0) break;
            this.parseProperty(string);
        }
    }

    public void generateResponse(PrintStream printStream) throws IOException {
        printStream.print("HTTP/1.0 " + this._responseCode + " " + this.getResponseText() + "\r\n");
        this.generateTags(printStream);
        printStream.print("\r\n");
        printStream.flush();
    }

    public void generateRequest(PrintStream printStream) throws IOException {
        printStream.print(this._requestMethod + " " + this._file + " HTTP/1.1\r\n");
        this.generateTags(printStream);
        printStream.print("Host: " + this._host + "\r\n");
        printStream.print("Connection: Keep-Alive\r\n");
        printStream.print("\r\n");
        printStream.flush();
    }

    private void generateTags(PrintStream printStream) throws IOException {
        for (Map.Entry entry : this._properties.entrySet()) {
            printStream.print(entry.getKey() + ": " + entry.getValue() + "\r\n");
        }
        printStream.print("Content-Type: " + this._contentType + "\r\n");
        printStream.print("Content-Length: " + this._contentLength + "\r\n");
    }

    private String getResponseText() {
        switch (this._responseCode) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Time-out";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Large";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Time-out";
            }
            case 505: {
                return "HTTP Version not supported";
            }
        }
        return "N/A";
    }

    public String getRequestMethod() {
        return this._requestMethod;
    }

    public void setRequestMethod(String string) {
        this._requestMethod = string;
    }

    public String getFile() {
        return this._file;
    }

    public void setFile(String string) {
        this._file = string;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public void setResponseCode(int n) {
        this._responseCode = n;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String string) {
        this._contentType = string;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public void setContentLength(int n) {
        this._contentLength = n;
    }

    public String getProperty(String string) {
        if (_contentLengthTag.equalsIgnoreCase(string)) {
            return Long.toString(this._contentLength);
        }
        if (_contentTypeTag.equalsIgnoreCase(string)) {
            return this._contentType;
        }
        return (String)this._properties.get(string);
    }

    public void setProperty(String string, String string2) {
        if (_contentLengthTag.equalsIgnoreCase(string)) {
            this._contentLength = Long.parseLong(string2);
        } else if (_contentTypeTag.equalsIgnoreCase(string)) {
            this._contentType = string2;
        } else {
            this._properties.put(string, string2);
        }
    }

    public void setProperties(URLConnection uRLConnection) {
        for (Map.Entry entry : this._properties.entrySet()) {
            uRLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        uRLConnection.setRequestProperty(_contentTypeTag, this._contentType);
        uRLConnection.setRequestProperty(_contentLengthTag, Long.toString(this._contentLength));
    }

    public String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (true) {
            int n;
            if ((n = inputStream.read()) == -1) {
                if (db.on()) {
                    db.println("read returned -1, line.length() => " + stringBuffer.length());
                }
                return stringBuffer.toString();
            }
            if (!bl) {
                if (n == 13) {
                    bl = true;
                    continue;
                }
                if (n == 10) {
                    return stringBuffer.toString();
                }
                stringBuffer.append((char)n);
                continue;
            }
            if (n == 10) break;
        }
        return stringBuffer.toString();
    }

    public void parseStatusLine(String string) {
        int n;
        int n2;
        int n3 = string.length();
        for (n2 = n = "HTTP/1.x ".length(); n2 < n3 && Character.isDigit(string.charAt(n2)); ++n2) {
        }
        this._responseCode = Integer.parseInt(string.substring(n, n2));
    }

    public void parseContentType(String string) {
        int n;
        int n2 = string.length();
        for (n = "Content-Type: ".length(); n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        this._contentType = string.substring(n);
    }

    public void parseContentLength(String string) {
        int n;
        int n2 = string.length();
        for (n = "Content-Length: ".length(); n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        int n3 = n;
        if (n3 < n2 && string.charAt(n3) == '-') {
            ++n3;
        }
        while (n3 < n2 && Character.isDigit(string.charAt(n3))) {
            ++n3;
        }
        this._contentLength = n3 > n ? Long.parseLong(string.substring(n, n3)) : 0L;
    }

    public void parseProperty(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            this._properties.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
        }
    }

    public void parseRequest(String string) {
        int n = string.indexOf(32);
        int n2 = string.lastIndexOf(32);
        this._file = string.substring(n + 1, n2);
    }
}

